<?php 
 /*
@File settopbox.php(Controller)
ADMIN SETTOPBOX PAGE
    This class show the customers with the allocated set top boxes with basic details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportSetTopBox extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer detials along with the assigned set top box and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the set top box page
*/
public function index() {
		$this->language->load('report/settopbox');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/settopbox');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){
	if(isset($this->request->post['selected'])){
	    $this->pdf->AddPage();
	    $this->load->model('report/settopbox');
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_settopbox->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(8);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(12);
		$this->pdf->SetX(65);
		$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(20);
		$this->pdf->Cell(190,6,'-: Location wise Set Top Box And CAS :-',1,0,'C',1);
		$this->pdf->SetY(30);

	    $w = array(20,30,40,40,30,30); 
	    
	    $header =  array('Sl.No.','Install Date','Customer Name','Address','STB NO','Status');
	    for($i = 0; $i < count($header); $i++) {
			$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
		}	
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    $count=0;
	    $i=0;
	    if (isset($this->request->post['selected']))
		{
	      foreach ($this->request->post['selected'] as $customer) {
	      	$customer_id=substr($customer,0,strpos($customer,'~'));
	      	$sl_no=substr($customer,strpos($customer,'~')+1);
	           $results = $this->model_report_settopbox->getCustomerAddress($customer_id);
	    foreach($results as $result){
			$data[] = array($sl_no,$result['date_added'],$result['name'],$result['address'],$result['STBNO'],($result['status']==1?'Active':'De Active'));
	     $count++;
        }
        }
       }

	 	$column_width = $w[1];
        for ($i=0; $i < $count ; $i++) {
		
		 if($data[$i][1]=="")
	 	       	$total_string_width=55;
	 	    else
	 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);

	 	       $number_of_lines = ceil( $total_string_width / ($column_width) );
	 	       $line_height = 6;
	 	       $yH = ceil( $number_of_lines * $line_height ); 
	 	     
	 	  for($j=0; $j < count($header) ; $j++){ 
	 	     
	 	      if($j==0)
	 	        $this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               else if($j==2 || $j==3)
               {
               	$this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               }
               else
               {
               	$x = $this->pdf->GetX();
               	$y = $this->pdf->GetY();
	 	       $this->pdf->MultiCell($w[1], 6,$data[$i][$j],1,1,0);
	 	       $this->pdf->SetXY($x + $w[1], $y);
	 	       } 
	 	        
	 	  }

	    $this->pdf->Ln();
	    }               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	    $this->pdf->Output();
		}else{
			$this->language->load('report/settopbox');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/settopbox');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer details with their stb details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the customer details with their stb details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/settopbox', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		//----------
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_settopbox->getTotalStbAddress();
		
		$this->data['printPdf'] = $this->url->link('report/settopbox/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['customers'] = array();
		$results = $this->model_report_settopbox->getaddress($data);
		$i=0;
		foreach ($results as $result) {	
		$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'   => $result['customer_id'],
				'customer_no' 	=>($page-1) * $this->config->get('config_admin_limit')+$i,
				'install_date'	=>$result["date_added"],
				'STBNO'         => $result['STBNO'],
				'name'          => $result['name'],
				'address'       => $result['address'],
				'status'        => ($result['status']?'Active':'Dective'),
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/settopbox', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		
		$this->template = 'report/settopbox.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
?> 