<?php 
 /*
@File pckgwiesesubscribers.php(Controller)
ADMIN PCKGWISESUBSCRIBERS PAGE
    This class show total numbers of subscribers of different packages

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerReportPrdSubsList extends Controller {

public function index() {
		 
		$this->language->load('report/prdsubslist');
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/prdsubslist');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){

	    $this->pdf->AddPage();
	    $this->load->model('report/prdsubslist');
	  $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_prdsubslist->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(15);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(10);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->Cell(195,6,'-: Product Wise Subscriber :-',1,0,'C',1);
		$this->pdf->SetY(35);

	    $w = array(10,40,59,78,97,116,135,157,179);
	    $c = array(30,19,19,19,19,19,22,22,25);
	    $header =  array('Product Name','1 month Price','3 month Price','6 month Price','9 month Price','12 month Price','Start Time','End Time','Total Subscriber');
		
		
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		 
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'C',1);
	    }
		
		$this->load->model('report/prdsubslist');
	    
	     

	     $count=0;
	    if (isset($this->request->post['selected']))
		{
	      foreach ($this->request->post['selected'] as $package_id) {
	      	
	      $results = $this->model_report_prdsubslist->getPackage($package_id);
		foreach ($results as $result) {

			$res = $this->model_report_prdsubslist->getOptions($result['product_id']);
			$m1_price='-- --';
			$m3_price='-- --';
			$m6_price='-- --';
			$m9_price='-- --';
			$m12_price='-- --';
			foreach ($res as $value) {
				if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m1_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m3_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==6 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m6_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==9 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m9_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==12 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m12_price=$value['price'];
				}
			
				$data[] = array($result['name'],$m1_price,$m3_price,$m6_price,$m9_price,$m12_price,"***","***",$result['count']);
				
			// 	'name'       => $result['name'],
			// 	 'month1'		=>$m1_price,
			// 	 'month3'		=> $m3_price,
			// 	 'month6'		=>$m6_price,
			// 	 'month9'		=>$m9_price,
			// 	 'month12'		=>$m12_price,
			// 	 'start'   =>"***",
			// 	 'end'   =>"***",
			// 	'channels'   => $result['count'],
			// 	'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
			// );
				$count++;
		}

        }
       }



         $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
		for ($i=0; $i < $count ; $i++) { 
	 	  for($j=0; $j < count($header) ; $j++)
	 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'C',0);
	          
	    $this->pdf->Ln();
	    }               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	 
	    $this->pdf->Output();
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the package wise subscribers for the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/prdsubslist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		//----------
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_prdsubslist->getTotalpkgSubs();
		//-----------
		$this->data['packages'] = array();
		$results = $this->model_report_prdsubslist->getPackages($data);
		// var_dump($results);
		// exit();
		foreach ($results as $result) {
				$this->data['packages'][] = array(
				'package_id' => $result['product_id'],
				'name'       => $result['name'],
				 'cname'		=>$result['name1'],
				 'stbno'		=>$result['STBNO'],
				 'casno'		=>$result['CASNO'],
				 'area'		=> "*****",
				 'bill'		=>"*****",
				 'type'		=>($result['STBNO']?'Active':'DeActive'),
				 'package'		=>"*****",
				
				 'start'   =>$result['start_date'],
				 'end'     =>$result['expire_date'],
				'month'		=>"****",
				 'day'		=>"****",
				'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
			);
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_pckg'] = $this->language->get('column_pckg');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['column_area'] = $this->language->get('column_area');
		$this->data['column_bill'] = $this->language->get('column_bill');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_package'] = $this->language->get('column_package');
		$this->data['column_start'] = $this->language->get('column_start');
		$this->data['column_end'] = $this->language->get('column_end');
		$this->data['column_month'] = $this->language->get('column_month');
		$this->data['column_day'] = $this->language->get('column_day');
		$this->data['column_subno'] = $this->language->get('column_subno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/prdsubslist/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//----------------------
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/prdsubslist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
	
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'report/prdsubslist.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
?> 