<?php 
 /*
@File pckgwiesesubscribers.php(Controller)
ADMIN PCKGWISESUBSCRIBERS PAGE
    This class show total numbers of subscribers of different packages

@Author Ravi Ranjan 
@date 25th Nov. 2015
*/ 
class ControllerReportPrdGeneral extends Controller {

public function index() {


		$this->language->load('report/prdgeneral');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/prdgeneral');

		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		$this->load->model('report/prdgeneral');
		$this->language->load('report/prdgeneral');
		if(isset($this->request->post['selected']))
		{
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',6,18,60);
		    $this->pdf->SetFillColor(240,240,240);
		    $user = $this->model_report_prdgeneral->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(18);
			$this->pdf->SetX(10);
			$this->pdf->Cell(330,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(22);
			$this->pdf->SetX(10);
			$this->pdf->Cell(333,6,$user['email'],0,0,'C',0);
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->Cell(185,6,'-:General channels:-',1,0,'C',1);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(50);
			$this->pdf->SetX(10);
			$this->pdf->SetFont('times','B',8);
		    $w = array(10, 25,70,120,140,170);
		    $c = array(15, 45,50,20, 30, 25);
		    $header =  array('Cust. ID','Product Name','Cust. Name','Type','Active Subs.','DeActive Sub.');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],8,$header[$i],1,0,'L',1);
		    }
			$this->load->model('report/prdgeneral');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	foreach ($this->request->post['selected'] as $row) {
	      		$customer_id=substr($row,0,strrpos($row,','));
	      		$product_id = substr($row,strrpos($row,',')+1);
	      		$filter_data=array('customer_id' => $customer_id,
	      					'product_id'  => $product_id);
	      		$results = $this->model_report_prdgeneral->getSubscriptions($filter_data);
	      		// $results = $this->model_report_prdgeneral->getCustomerDetails($customer_id);
	      		// $subs = $this->model_report_prdgeneral->getCustSubsPdf($product_id,$customer_id);
	      		// $PrdName = $this->model_report_prdgeneral->getProductName($product_id);
				foreach ($results as $value) {

					$product=$value['name'];
					$name=($value['firstname'].' '.$value['lastname']);
					//$opng_sub=$value["date_added"];
					// $opng_sub=date('d/m/y H:i:s',strtotime($opng_sub));
					$status=(strtotime($value["expire_date"]) > time()) ? 'Active': 'Deactive';
					$actv_sub=date('d/m/y H:i:s',strtotime($value['start_date']));
					$dctv_sub=date('d/m/y H:i:s',strtotime($value["expire_date"]));
					$data[] = array($customer_id,$product,$name,$status,$actv_sub,$dctv_sub);
					$count++;
		     	}
        	
        	} 
			for ($i=0; $i < $count ; $i++) {
				$this->pdf->SetX(10); 
			 	for($j=0; $j < count($header) ; $j++)
			 	{
			 	  	$this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
			    }   
			    $this->pdf->Ln();
		    }            
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . urlencode(html_entity_decode($this->request->get['filter_product'], ENT_QUOTES, 'UTF-8'));
		}
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/prdgeneral', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit'),
		);
		if (isset($this->request->get['filter_product'])) {
			$this->data['filter_product'] = $this->request->get['filter_product'];
			$data['filter_product']=$this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] ='';
		}		
		$total = 1;
		$this->data['channels'] = array();
		$products = $this->model_report_prdgeneral->getProduct(array());
		foreach ($products as $product) {
			$this->data['products'][] = array(
				'product_name' =>$product['name'],
				'product_id' =>$product['product_id'],
				);		
		
		}
		
		// $productlist = $this->model_report_prdgeneral->getProduct($data);
		$subslist = $this->model_report_prdgeneral->getSubscriptions($data);
		$total = $this->model_report_prdgeneral->getTotalSubscriptions($data);

		// foreach ($productlist as $product) {
		// 	$total+= $this->model_report_prdgeneral->getCustomerSubsCount($product['product_id'],0);
		// 	$subscribers = $this->model_report_prdgeneral->getCustomerSubscription($product['product_id'],0);
			// foreach ($subscribers as $value) {
			// 	$customers = $this->model_report_prdgeneral->getCustomerDetails($value["customer_id"]);
		foreach ($subslist as $customer) {
			$this->data['channels'][] = array(
			'customer_id'=> $customer["customer_id"],	
			'product_id'=> $customer['product_id'],
			'product'  	=> $customer['name'],
			'name' 		=> $customer["firstname"].' '.$customer["lastname"],
			'type'      =>(strtotime($customer["expire_date"]) > time()) ? 'Active': 'Deactive',
			'op_subs'   => $customer["date_added"],
			'atv_subs'  => $customer["start_date"],
			'dctv_subs' => $customer["expire_date"],
			'cls_subs' 	=> $customer["expire_date"],
			'atv_stb'	=> $customer["date_added"],
		    'dctv_stb'  => $customer["date_added"],
			'clsg_stb' 	=> $customer["expire_date"],
			'avg_stb' 	=> '-----',				
			'month' 	=> '----',
			'selected'  => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);										

		}
			//}
		//}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');			
		$this->data['column_product'] = $this->language->get('column_product');	
		$this->data['column_ch_name'] = $this->language->get('column_ch_name');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_osubs'] = $this->language->get('column_osubs');
		$this->data['column_asubs'] = $this->language->get('column_asubs');
		$this->data['column_dsubs'] = $this->language->get('column_dsubs');
		$this->data['column_csubs'] = $this->language->get('column_csubs');
		$this->data['column_ocas'] = $this->language->get('column_ocas');
		$this->data['column_acas'] = $this->language->get('column_acas');
		$this->data['column_dcas'] = $this->language->get('column_dcas');
		$this->data['column_ccas'] = $this->language->get('column_ccas');
		$this->data['column_avcas'] = $this->language->get('column_avcas');
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');
		$this->data['column_day'] = $this->language->get('column_day');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/prdgeneral/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/prdgeneral', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/prdgeneral.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
