<?php 
  /*
@File pckgwisechannel.php(Controller)
ADMIN PCKGWISECHANNEL PAGE
    This class show all the packages with the channels added to it.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportPckgWiseChannels extends Controller {

public function index() {
		$this->language->load('report/pckgwisechannels');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/pckgwisechannels');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	

	public function printPdf(){
		if (isset($this->request->post['selected']))
	 	{
	 		$this->load->model('report/channel_list');
	    	$this->pdf->AddPage();
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
			$user = $this->model_report_channel_list->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);
			$this->pdf->SetY(40);
			$this->pdf->Cell(190,6,'-: Package Wise Channels :-',1,0,'C',1);
			$this->pdf->SetY(55);
		    $w = array(10,40, 55,70);
		    $c = array(30,15,15,130);
		    $header =  array('Package Name','Price','Status','Channels');
			
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->load->model('report/pckgwisechannels');
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);		   
	        $count=0;
		    if (isset($this->request->post['selected']))
			{
		     	foreach ($this->request->post['selected'] as $package_id) {
		      		$results = $this->model_report_pckgwisechannels->getPackage($package_id);
			    	foreach($results as $result){
						$data[] = array($result['name'],$result['price'],($result['status']==1)?'Enabled':'Disabled',$result['channel_list']);
			     		$count++;
		        	}
		        }
	        }
	        $rowheight=6;
	        $rows[]=array();
	        for($i=0; $i < $count ; $i++)
	        {
	        	for($j=0; $j < count($header) ; $j++)
		 	  	{
		 	  		$reqspace=0;
		 	  		$len=strlen($data[$i][$j]);
		 	  		$uppercase=$this->countUppercase($data[$i][$j]);
		 	  		$lower=$len-$uppercase;
		 	  		if($lower)
		 	  			$reqspace=$lower/0.82;
		 	  		if($uppercase)
		 	  			$reqspace=$reqspace+$uppercase/0.55;
	        		if($reqspace <= $c[$j]-5){
	        			$rows[$i][$j]=1;
	        		}
	        		else{
	        			$rows[$i][$j]=ceil($reqspace/($c[$j]-4));
	        		}
	        	}
	        }
			for ($i=0; $i < $count ; $i++) {
				$this->pdf->SetX(10); 
				$lastx=0;
		 	  	for($j=0; $j < count($header) ; $j++)
		 	  	{
		 	  		$max=max($rows[$i]);
		 	  		$height=($max/$rows[$i][$j])*$rowheight;
					$this->pdf->MultiCell($c[$j],$height,$data[$i][$j],1,'L');
					$x=$this->pdf->GetX();
					$y=$this->pdf->GetY();
					$lastx=$lastx+$c[$j];
					if($j!=count($header)-1)
		 	  		$this->pdf->SetXY($x+$lastx,$y-($height*$rows[$i][$j]));					
		      	} 
				$this->pdf->SetXY($x,$y-$height);					
			    $this->pdf->Ln();
		    }            
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(140,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(140,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/pckgwisechannels');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/pckgwisechannels');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }

   	public function countUppercase($string) {
      return strlen(preg_replace('![^A-Z]+!', '', $string));
	}	

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the packages along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/pckgwisechannels', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_pckgwisechannels->getTotalPkgWiseChannel();
		$this->data['packages'] = array();	
		$results = $this->model_report_pckgwisechannels->getPackages($data);
		foreach ($results as $result) {			
			$this->data['packages'][] = array(
				'package_id' => $result['product_id'],
				'name'     	 => $result['name'],
				'channels'   => $result['channel_list'],
				'price'      => $result['price'],
				'status'     => ($result['status']==1)?'Enabled':'Disabled',
				'selected'   => isset($this->request->post['selected']) && in_array($result['package_id'], $this->request->post['selected']),
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_pckg'] = $this->language->get('column_pckg');
		$this->data['column_channels'] = $this->language->get('column_channels');
		$this->data['column_price'] = $this->language->get('column_price');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/pckgwisechannels/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/pckgwisechannels', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/pckgwisechannels.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);				
		$this->response->setOutput($this->render());
  	}
 }
?> 
