<?php 
 /*
@File particulardate.php(Controller)
ADMIN PARTICULARDATE PAGE
    This class show all the package wise subscribers at particular date.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportParticularDate extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the package wise subscribers and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the package wise subscriber page
*/	
public function index() {
		$this->language->load('report/particulardate');
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('report/particulardate');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf(){
		$this->load->model('report/particulardate');
		$this->language->load('report/particulardate');
		if (isset($this->request->post['selected']))
		{
			if (isset($this->request->post['filter_date_start'])) {
				$filter_date_start = $this->request->post['filter_date_start'];
			}
			if (isset($this->request->post['filter_date_end'])) {
				$filter_date_end = $this->request->post['filter_date_end'];
			}
			$this->pdf->AddPage();
		    $this->load->model('report/casnetworkreport');
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);		    
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_casnetworkreport->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(65);
			$this->pdf->Cell(193,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(25);
			$this->pdf->Cell(165,6,'-: Package-Wise Subscribers Between '.$filter_date_start . " and " . $filter_date_end .' :-',1,0,'C',1);
			$this->pdf->SetY(35);
		    $w = array(25,75,105);
		    $c = array(50,30,85);
		    $header =  array('Package ID','Package Name','Total Subscribers');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'C',1);
		    }
			$this->load->model('report/particulardate');
	        $count=0;
		    foreach ($this->request->post['selected'] as $product_id) {
		        $results = $this->model_report_particulardate->getPackage($product_id);
			    foreach($results as $result){
					$data[] = array($result['product_id'],$result['name'],$result['count']);
			     	$count++;
		        }
	        }
	        $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
			for ($i=0; $i < $count ; $i++) { 
				$this->pdf->SetX(25);
		 	  	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'C',0);  
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output(); 
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the package wise subscriber details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
		if(isset($this->data['error_start']))
			$this->data['error_filter_date_start']=$this->data['error_start'];
		else
			$this->data['error_filter_date_start']='';
		if(isset($this->data['error_end']))
			$this->data['error_filter_date_end']=$this->data['error_end'];
		else
			$this->data['error_filter_date_end']='';
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		if (isset($this->request->get['filter_date_start']) && isset($this->request->get['filter_date_end'])){
   			$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('report/particulardate', 'token=' . $this->session->data['token'], 'SSL'),
	      		'separator' => ' :: '
	   		);
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_filter'),
				'href'      => $this->url->link('report/particulardate', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
   		}
   		else{
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('report/particulardate', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
	   	}
		$this->data['heading_title'] = $this->language->get('heading_title');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['text_act'] = $this->language->get('text_act');		
		$this->data['text_deact'] = $this->language->get('text_deact');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_pckg'] = $this->language->get('column_pckg');
		$this->data['column_subno'] = $this->language->get('column_subno');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['button_print'] = $this->language->get('button_print');
		$this->data['token'] = $this->session->data['token'];
        $this->data['printPdf'] = $this->url->link('report/particulardate/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['customers'] = array();
        $data = array(
        	'filter_date_start' => $filter_date_start,
            'filter_date_end'   => $filter_date_end,
            'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit') 
        	);

        $total = $this->model_report_particulardate->getTotalpkgSubs();
		if (isset($this->request->get['filter_date_start']) && isset($this->request->get['filter_date_end']))
		{
		   if($data['filter_date_start'] <= $data['filter_date_end']){
				$results = $this->model_report_particulardate->getFilter($data);
				foreach ($results as $result) {			
					$this->data['customers'][] = array(
						'product_id' => $result['product_id'],
						'name'    => $result['name'],
						'count'=> $result['count'],
						'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
					);	
				}
			}			
		}
		else{
			$results = $this->model_report_particulardate->getStatus($data);
				foreach ($results as $result) {			
					$this->data['customers'][] = array(
						'product_id' => $result['product_id'],
						'name'    => $result['name'],
						'count'=> $result['count'],
						'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
					);	
				}
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/particulardate', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		$this->data['filter_date_start'] = $filter_date_start;
		$this->data['filter_date_end'] = $filter_date_end;
		$this->template = 'report/particulardate.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Filter the list according to the start and end date.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retrieves the list that matches the filter condition
*/

public function filter(){
	$this->language->load('report/particulardate');
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('report/particulardate');
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){
			
			
		 }
    	$this->getList();

}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	
*/

public function validateDate(){
	if(!isset($this->request->get['filter_date_start']))
		$this->data['error_start'] = $this->language->get('error_startdate_req');
	else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_start']))
	{
    		$this->data['error_start'] = $this->language->get('error_date_format');
    }
	if(!isset($this->request->get['filter_date_end']))
		$this->data['error_end'] = $this->language->get('error_enddate_req');
	else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_end']))
	{
    		$this->data['error_end'] = $this->language->get('error_date_format');
    }
        
	return true;

}

 }
?> 
