<?php 
 /*
@File pckgwiesesubscribers.php(Controller)
ADMIN PCKGWISESUBSCRIBERS PAGE
    This class show total numbers of subscribers of different packages

@Author Ravi Ranjan 
@date 23th Nov. 2015
*/ 
class ControllerReportPackageReport extends Controller {

public function index() {
		 
		$this->language->load('report/packagerepot');
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/packagereport');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf(){
		if (isset($this->request->post['selected']))	
		{
		    $this->pdf->AddPage('P',array(250,250));
		    $this->load->model('report/packagereport');
		  	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_packagereport->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(9);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(65);
			$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->Cell(210,6,'-: Package List Report :-',1,0,'C',1);
			$this->pdf->SetY(35);

		    $w = array(10,40,60,80,100,120,140,160,180,200,220);
		    $c = array(30,20,20,20,20,20,20,20,20,20,15);
		    $header =  array('Package ID','Package Name','1 month Price','3 month Price','6 month Price','9 month Price','12 month Price','Start Time','End Time','Total Subs');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],8,$header[$i],1,0,'C',1);
		    }
			$this->load->model('report/prdwisesubscribers');
		    $count=0;
		    foreach ($this->request->post['selected'] as $package_id) {
	      		$results = $this->model_report_packagereport->getPackage($package_id);
				foreach ($results as $result) {
				$res = $this->model_report_packagereport->getOptions($result['product_id']);
				$m1_price='-- --';
				$m3_price='-- --';
				$m6_price='-- --';
				$m9_price='-- --';
				$m12_price='-- --';
				foreach ($res as $value) {
					if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m1_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m3_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==6 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m6_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==9 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m9_price=$value['price'];
					if((substr($value['name'],0,strpos($value['name'],' '))==12 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m12_price=$value['price'];
					}
					$data[] = array($result['product_id'],$result['name'],$m1_price,$m3_price,$m6_price,$m9_price,$m12_price,"-- --","-- --",$result['count']);
					$count++;
	        	}
	        }
	        $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
			for ($i=0; $i < $count ; $i++) { 
		 	  	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'C',0);
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/packagerepot');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/packagereport');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the package wise subscribers for the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/packagereport', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_packagereport->getTotalpkgSubs();
		$this->data['packages'] = array();
		$results = $this->model_report_packagereport->getPackages($data);
		foreach ($results as $result) {
			$res = $this->model_report_packagereport->getOptions($result['product_id']);
			$m1_price='-- --';
			$m3_price='-- --';
			$m6_price='-- --';
			$m9_price='-- --';
			$m12_price='-- --';
			foreach ($res as $value) {
				if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m1_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m3_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==6 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m6_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==9 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m9_price=$value['price'];
				if((substr($value['name'],0,strpos($value['name'],' '))==12 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
					$m12_price=$value['price'];
				}
			
				$this->data['packages'][] = array(
				'package_id' 	=> $result['product_id'],
				'name'       	=> $result['name'],
				'month1'		=>$m1_price,
				'month3'		=> $m3_price,
				'month6'		=>$m6_price,
				'month9'		=>$m9_price,
				'month12'		=>$m12_price,
				'start'         =>"-- --",
				'end'   		=>"-- --",
				'channels'   	=> $result['count'],
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
			);
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_pckg'] = $this->language->get('column_pckg');
		$this->data['column_m1'] = $this->language->get('column_m1');
		$this->data['column_m3'] = $this->language->get('column_m3');
		$this->data['column_m6'] = $this->language->get('column_m6');
		$this->data['column_m9'] = $this->language->get('column_m9');
		$this->data['column_m12'] = $this->language->get('column_m12');
		$this->data['column_start'] = $this->language->get('column_start');
		$this->data['column_end'] = $this->language->get('column_end');
		$this->data['column_subno'] = $this->language->get('column_subno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/packagereport/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/packagereport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();	
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/packagereport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);		
		$this->response->setOutput($this->render());
  	}
 }
?> 
