<?php
/*
@File historical_subscription_summary.php(Controller)
ADMIN historical_subscription_summary PAGE
    This class show Subscription made by the customer date wise.

@Author Mahesh Yallure 
@date 23rd Nov. 2015
*/
class ControllerReportHistoricalSubscriptionSummary extends Controller { 
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
public function index() {

		$this->language->load('report/historical_subscription_summary');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/historical_subscription_summary');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		
		$this->load->model('report/historical_subscription_summary');
	    $this->pdf->AddPage();
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_historical_subscription_summary->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(70);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(30);
		$this->pdf->SetX(70);
		$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);
		
		$this->pdf->SetY(40);
		$this->pdf->SetX(5);
		$this->pdf->Cell(200,6,'-: Historical Subscription Summary :-',1,0,'C',1);
		$this->pdf->SetY(55);

	     $w = array(5,25,40,60,120,180);//,140,155,170,185);
	    $c = array(20,15,20,60,60, 25);//, 15, 15, 15 ,15);
	    $header =  array('Particulars','Type','Opening Sub','DeActive Sub','Active Sub','Closing Sub');//,'OpeningVC','ActiveVC','DeActiveVC','ClosingVC');
		for( $i = 0; $i < count($header) ; $i++){
				if($i==0)
			    	$this->pdf->SetX($w[0]);
			    else
					$this->pdf->SetX($w[$i-1]+$c[$i-1]);
					$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}
        $count=0;
	    if (isset($this->request->post['selected']))
		{
	      	foreach ($this->request->post['selected'] as $customer) {
	      		$cust=explode('~',$customer);
	      		$customer_id=$cust[0];
	      		$customer_name=$cust[1];
				$opening_order = $this->model_report_historical_subscription_summary->getOrderDetails($customer_id);
				//var_dump($opening_order);

				$closing_order = $this->model_report_historical_subscription_summary->getOrderDetails($customer_id,'DESC');
				//var_dump($closing_order);
				$deactive_sub = $this->model_report_historical_subscription_summary->getDeActiveSub($customer_id);
   				
   				$active_sub = $this->model_report_historical_subscription_summary->getActiveSub($customer_id);
				
				$data[] = array($customer_name,'NA',$opening_order['name'],trim($deactive_sub,','),trim($active_sub,','),$closing_order['name'],'NA','NA','NA','NA');
		     	$count++;
	    
        	}
        }  
        $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	
		for ($i=0; $i < $count ; $i++) { 
		  	$this->pdf->SetX(5);
	 	 	for($j=0; $j < count($header) ; $j++)
	 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
	    	$this->pdf->Ln();
	    }               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	    $this->pdf->Output();
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/historical_subscription_summary', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$customers = $this->model_report_historical_subscription_summary->getSubscribedCustomers();
		$total=count($customers);
		$this->data['subscriptions'] = array();
		foreach ($customers as $customer) {

			$opening_order = $this->model_report_historical_subscription_summary->getOrderDetails($customer['customer_id']);
			//var_dump($opening_order);

			$closing_order = $this->model_report_historical_subscription_summary->getOrderDetails($customer['customer_id'],'DESC');
			//var_dump($closing_order);
			$deactive_sub = $this->model_report_historical_subscription_summary->getDeActiveSub($customer['customer_id']);
		
			$active_sub = $this->model_report_historical_subscription_summary->getActiveSub($customer['customer_id']);


			$this->data['subscriptions'][] = array(
			'customer_id'  	=> $customer['customer_id'],
			'name' 			=> $customer['firstname'].' '.$customer['lastname'],
			'type' 		    => 'NA',
			'opening_subscription' => $opening_order['name'],
			'active_subscription' => trim($active_sub,','),//$opening_order['name'],
			'deactive_subscription'=> trim($deactive_sub,','),
			'closing_subscription' => $closing_order['name'],
			'opening_vc' => 'NA',
			'active_vc' => 'NA',
			'deactive_vc' => 'NA',
			'closing_vc' => 'NA',
			'total'        	=> $total,
			'selected'      => isset($this->request->post['selected']) && in_array($customer['customer_id'], $this->request->post['selected']),
			);					
			
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_particulars'] = $this->language->get('column_particulars');
		$this->data['column_type'] = $this->language->get('column_type');
    	$this->data['column_opening_subscription'] = $this->language->get('column_opening_subscription');
		$this->data['column_active_subscription'] = $this->language->get('column_active_subscription');
		$this->data['column_deactive_subscription'] = $this->language->get('column_deactive_subscription');
		$this->data['column_closing_subscription'] = $this->language->get('column_closing_subscription');
		$this->data['column_opening_vc'] = $this->language->get('column_opening_vc');
		$this->data['column_active_vc'] = $this->language->get('column_active_vc');
		$this->data['column_deactive_vc'] = $this->language->get('column_deactive_vc');
		$this->data['column_closing_vc'] = $this->language->get('column_closing_vc');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/historical_subscription_summary/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/historical_subscription_summary', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/historical_subscription_summary.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
}
?>