<?php 
 /*
@File subscriberno.php(Controller)
ADMIN SUBSCRIBERNO PAGE
    This class show total number of subscribers in the store

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerReportCasNetworkReport extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the count of number of subscriber on the network
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the subscriber count page
*/
public function index() {
		$this->language->load('report/casnetworkreport ');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/casnetworkreport');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
public function printPdf(){

	    $this->pdf->AddPage();
	    $this->load->model('report/casnetworkreport');
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_casnetworkreport->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(8);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(12);
		$this->pdf->SetX(65);
		$this->pdf->Cell(193,6,$user['email'],0,0,'C',0);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(20);
		$this->pdf->Cell(165,6,'-: Total No Of CAS On The Network :- ',1,0,'C',1);
		$this->pdf->SetY(30);

				
		
	    $result = $this->model_report_casnetworkreport->getTotalCAS();
		$active = $this->model_report_casnetworkreport->getActiveCas();
		$deactive = $this->model_report_casnetworkreport->getDeactiveCas();
	    
	 	$this->pdf->Cell(110,6,'Total No Of CAS On The Network :-',1,0,'C',0);
        
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$result['count'],1,1,'L',0);
	 	$this->pdf->Cell(110,6,'Total No Of Active CAS On The Network :-',1,0,'C',0);
        
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$active['count'],1,1,'L',0);
	 	$this->pdf->Cell(110,6,'Total No Of DeActive CAS On The Network :-',1,0,'C',0);
        
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$deactive['count'],1,1,'L',0);
	                         
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	 
	    $this->pdf->Output();
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets the total number of subscribers in the network
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the count of the subscribers.
*/
public function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/casnetworkreport ', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['subscribers'] = array();

		
		$result = $this->model_report_casnetworkreport->getTotalCAS();
		$active = $this->model_report_casnetworkreport->getActiveCas();
		$deactive = $this->model_report_casnetworkreport->getDeactiveCas();
		// foreach ($results as $result) {			
			$this->data['subscribers'][] = array(
				'count'       => $result['count'],
				'active'       => $active['count'],
				'deactive'       => $deactive['count']
			);	
		// }			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_active'] = $this->language->get('column_active');
		$this->data['column_deactive'] = $this->language->get('column_deactive');
		$this->data['column_subno'] = $this->language->get('column_subno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['invoice'] = $this->url->link('report/casnetworkreport/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'report/casnetworkreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
?> 