<?php 
 /*
@File settopbox.php(Controller)
ADMIN SETTOPBOX PAGE
    This class show the customers with the allocated set top boxes with basic details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportBroadPayment extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer detials along with the assigned set top box and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the set top box page
*/
public function index() {

		$this->language->load('report/broad_payment');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/broad_payment');

    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){
	if(isset($this->request->post['selected'])){
	    $this->pdf->AddPage();
	    $this->load->model('report/broad_payment');
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_broad_payment->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(8);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(12);
		$this->pdf->SetX(65);
		$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(20);
		$this->pdf->Cell(190,6,'-: Location wise Set Top Box And CAS :-',1,0,'C',1);
		$this->pdf->SetY(30);

	    $w = array(20,30,40,40,30,30); 
	    
	    $header =  array('Sl.No.','Install Date','Customer Name','Address','STB NO','Status');
	    for($i = 0; $i < count($header); $i++) {
			$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
		}	
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    $count=0;
	    $i=0;
	    if (isset($this->request->post['selected']))
		{
	      foreach ($this->request->post['selected'] as $customer) {
	      	$customer_id=substr($customer,0,strpos($customer,'~'));
	      	$sl_no=substr($customer,strpos($customer,'~')+1);
	           $results = $this->model_report_broad_payment->getCustomerAddress($customer_id);
	    foreach($results as $result){
			$data[] = array($sl_no,$result['date_added'],$result['name'],$result['address'],$result['STBNO'],($result['status']==1?'Active':'De Active'));
	     $count++;
        }
        }
       }

	 	$column_width = $w[1];
        for ($i=0; $i < $count ; $i++) {
		
		 if($data[$i][1]=="")
	 	       	$total_string_width=55;
	 	    else
	 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);

	 	       $number_of_lines = ceil( $total_string_width / ($column_width) );
	 	       $line_height = 6;
	 	       $yH = ceil( $number_of_lines * $line_height ); 
	 	     
	 	  for($j=0; $j < count($header) ; $j++){ 
	 	     
	 	      if($j==0)
	 	        $this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               else if($j==2 || $j==3)
               {
               	$this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               }
               else
               {
               	$x = $this->pdf->GetX();
               	$y = $this->pdf->GetY();
	 	       $this->pdf->MultiCell($w[1], 6,$data[$i][$j],1,1,0);
	 	       $this->pdf->SetXY($x + $w[1], $y);
	 	       } 
	 	        
	 	  }

	    $this->pdf->Ln();
	    }               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	    $this->pdf->Output();
		}else{
			$this->language->load('report/broad_payment');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/broad_payment');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer details with their stb details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the customer details with their stb details as a list.
*/
public function getList() {	

		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/broad_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		//----------
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		$total = $this->model_report_broad_payment->getTotalStbAddress();
		
		$this->data['invoice'] = $this->url->link('report/broad_payment/invoice', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['broadcasters'] = array();
		$results = $this->model_report_broad_payment->getBroadcasterDetails($data);
		$i=0;
		// var_dump($results);exit();
		foreach ($results as $result) {	

			$channel_count = $this->model_report_broad_payment->getBroadcasterChannelCount($result['broadcaster_id']);

			$this->data['broadcasters'][] = array(
				'broadcaster_id'=>$result['broadcaster_id'],
				'name'   		=> $result['name'],
				'email' 		=>$result['broadcaster_email'],
				'mobile'		=>$result["broadcaster_mobile"],
				'count'        	=>$channel_count,
				
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['broadcaster_id'], $this->request->post['selected']),
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['column_mobile'] = $this->language->get('column_mobile');
		$this->data['column_city'] = $this->language->get('column_city');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_channel'] = $this->language->get('column_channel');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;

		
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/broad_payment', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		
		$this->template = 'report/broad_payment.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	invoice
DESCRIPTION 		-	Generates the invoice for the order with all the details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates a pdf of the invoice.
*/			
  	public function invoice() {
  	
		$this->language->load('report/broad_payment');

		$this->data['title'] = $this->language->get('heading_title');
					// var_dump($this->request->get['order_id']);exit();
		if(isset($this->request->post['selected']) || $this->request->get['broadcaster_id'])
		{
			if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
				$this->data['base'] = HTTPS_SERVER;
			} else {
				$this->data['base'] = HTTP_SERVER;
			}

			$this->data['direction'] = $this->language->get('direction');
			$this->data['language'] = $this->language->get('code');

			$this->data['text_invoice'] = $this->language->get('text_invoice');

			$this->data['text_broacaster_id'] = $this->language->get('text_broacaster_id');
			$this->data['text_invoice_no'] = $this->language->get('text_invoice_no');
			$this->data['text_invoice_date'] = $this->language->get('text_invoice_date');
			$this->data['text_date_added'] = $this->language->get('text_date_added');
			$this->data['text_telephone'] = $this->language->get('text_telephone');
			$this->data['text_fax'] = $this->language->get('text_fax');
			$this->data['text_broacaster'] = $this->language->get('text_broacaster');
			$this->data['text_company_id'] = $this->language->get('text_company_id');
			$this->data['text_tax_id'] = $this->language->get('text_tax_id');		
			$this->data['text_ship_to'] = $this->language->get('text_ship_to');
			$this->data['text_payment_method'] = $this->language->get('text_payment_method');
			$this->data['text_shipping_method'] = $this->language->get('text_shipping_method');

			$this->data['column_product'] = $this->language->get('column_product');
			$this->data['column_model'] = $this->language->get('column_model');
			$this->data['column_quantity'] = $this->language->get('column_quantity');
			$this->data['column_price'] = $this->language->get('column_price');
			$this->data['column_total'] = $this->language->get('column_total');
			$this->data['column_comment'] = $this->language->get('column_comment');

			$this->load->model('report/broad_payment');

			$this->load->model('setting/setting');

			$this->data['broadcasters'] = array();

			$broadcasters = array();

			if (isset($this->request->post['selected'])) {
				$broadcasters = $this->request->post['selected'];
			} elseif (isset($this->request->get['broadcaster_id'])) {
				$broadcasters[] = $this->request->get['broadcaster_id'];
			}

			foreach ($broadcasters as $broadcaster_id) {
			
				$broadcaster_info = $this->model_report_broad_payment->getBroadcaster($broadcaster_id);
				// var_dump($broadcaster_info);
				if ($broadcaster_info) {
					$store_info = $this->model_setting_setting->getSetting('config', $broadcaster_info['store_id']);
					
					if ($store_info) {
						$store_address = $store_info['config_address'];
						$store_email = $store_info['config_email'];
						$store_telephone = $store_info['config_telephone'];
						$store_fax = $store_info['config_fax'];
					} else {
						$store_address = $this->config->get('config_address');
						$store_email = $this->config->get('config_email');
						$store_telephone = $this->config->get('config_telephone');
						$store_fax = $this->config->get('config_fax');
					}
					
					if ($broadcaster_info['invoice_no']) {
						$invoice_no = $broadcaster_info['invoice_prefix'] . $broadcaster_info['invoice_no'];
					} else {
						$invoice_no = '';
					}
					
					if ($broadcaster_info['shipping_address_format']) {
						$format = $broadcaster_info['shipping_address_format'];
					} else {
						$format = '{name}' . "\n" . '{email}' . "\n" . '{mobile}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
					}
					

					$find = array(
						'{firstname}',
						'{lastname}',
						'{company}',
						'{address_1}',
						'{address_2}',
						'{city}',
						'{postcode}',
						'{zone}',
						'{zone_code}',
						'{country}'
					);

					$replace = array(
						'name' => $broadcaster_info['name'],
						'telephone'  => $broadcaster_info['telephone'],
						'email'  => $broadcaster_info['email'],
						'city'      => $broadcaster_info['city'],
						'postcode'  => $broadcaster_info['post'],
						// 'zone'      => $broadcaster_info['shipping_zone'],
						// 'zone_code' => $broadcaster_info['shipping_zone_code'],
						// 'country'   => $broadcaster_info['shipping_country']
					);

					$shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

					if ($broadcaster_info['payment_address_format']) {
						$format = $broadcaster_info['payment_address_format'];
					} else {
						$format = '{firstname}' . "\n" .'{lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
					}

					$find = array(
						'{firstname}',
						'{lastname}',
						'{company}',
						'{address_1}',
						'{address_2}',
						'{city}',
						'{postcode}',
						'{zone}',
						'{zone_code}',
						'{country}'
					);

					// $replace = array(
					// 	'firstname' => $order_info['payment_firstname'],
					// 	'lastname'  => $order_info['payment_lastname'],
					// 	'company'   => $order_info['payment_company'],
					// 	'address_1' => $order_info['payment_address_1'],
					// 	'address_2' => $order_info['payment_address_2'],
					// 	'city'      => $order_info['payment_city'],
					// 	'postcode'  => $order_info['payment_postcode'],
					// 	'zone'      => $order_info['payment_zone'],
					// 	'zone_code' => $order_info['payment_zone_code'],
					// 	'country'   => $order_info['payment_country']
					// );

					$payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
					$shipping_address = str_replace(array("\r\n", "\r", "\n"),'<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))).'<br />';
				$shipping_address .= $broadcaster_info['email'].'<br />'.$broadcaster_info['telephone'];

					$product_data = array();

					$products = $this->model_report_broad_payment->getBroadcasterProducts($broadcaster_id);
							// var_dump($products);
					foreach ($products as $product) {
						$option_data = array();

					// 	$options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

					// 	foreach ($options as $option) {
					// 		if ($option['type'] != 'file') {
					// 			$value = $option['value'];
					// 		} else {
					// 			$value = utf8_substr($option['value'], 0, utf8_strrpos($option['value'], '.'));
					// 		}
							
					// 		$option_data[] = array(
					// 			'name'  => $option['name'],
					// 			'value' => $value
					// 		);								
					// 	}

						$product_data[] = array(
							'name'     => $product['channel_name'],
							'model'    => $product['subscription'],
					// 		'option'   => $option_data,
					// 		// 'quantity' => $product['quantity'],
							'price'    => $this->currency->format($product['price']) ,
							// 'total'    => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * 1) : 0))
						);
					}
					
					$voucher_data = array();
					$this->load->model('sale/order');
					$vouchers = $this->model_sale_order->getOrderVouchers($broadcaster_id);

					foreach ($vouchers as $voucher) {
						$voucher_data[] = array(
							'description' => $voucher['description'],
							'amount'      => $this->currency->format($voucher['amount'], $broadcaster_info['currency_code'], $broadcaster_info['currency_value'])			
						);
					}
						
					$total_data = $this->model_report_broad_payment->getChannelTotals($broadcaster_id);

					foreach ($total_data as $total) {
						$x[]=(int)$total['price'];
						$sum=array_sum($x);
						
	
					}

					// $total=((int)$total['price']);
					$date= date('Y-m-d H:i:s');
					// var_dump($broadcaster_id);echo "asfd";exit();
					$this->data['orders'][] = array(
						'order_id'	         => $broadcaster_id,
						'invoice_no'         => $invoice_no,
						'date_added'         => $date,
						'store_name'         => $broadcaster_info['store_name'],
						'store_url'          => rtrim($broadcaster_info['store_url'], '/'),
						'store_address'      => nl2br($store_address),
						'store_email'        => $store_email,
						'store_telephone'    => $store_telephone,
						'store_fax'          => $store_fax,
						// 'email'              => $broadcaster_info['broad_email'],
						// 'telephone'          => $broadcaster_info['broad_mobile'],
						'shipping_address'   => $shipping_address,
						// 'shipping_method'    => $broadcaster_info['shipping_method'],
						'payment_address'    => $payment_address,
						// 'payment_company_id' => $broadcaster_info['payment_company_id'],
						// 'payment_tax_id'     => $broadcaster_info['payment_tax_id'],
						// 'payment_method'     => $broadcaster_info['payment_method'],
						'product'            => $product_data,
						'voucher'            => $voucher_data,
						'total'              => $sum,
						'comment'            => Null
					);
				}
			}

			$this->template = 'report/broacaster_invoice.tpl';

			$this->response->setOutput($this->render());
			
		}
		else{
			$this->session->data['warning']="Please select Item to print Invoice";
			$this->redirect($this->url->link('report/broad_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
	}

 }
?> 