<?php 
 /*
@File settopbox.php(Controller)
ADMIN SETTOPBOX PAGE
    This class show the customers with the allocated set top boxes with basic details.

@Author Ravi Ranjan 
@date 25th Nov. 2015
*/
class ControllerReportBlackList extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer detials along with the assigned set top box and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the set top box page
*/
public function index() {
		$this->language->load('report/blacklist');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/blacklist');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf(){
		$this->load->model('report/blacklist');
		$this->language->load('report/blacklist');
		if(isset($this->request->post['selected']))
	    {
		    $this->pdf->AddPage();
		    $this->load->model('report/blacklist');
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_blacklist->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(11);
			$this->pdf->SetX(65);
			$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(20);
			$this->pdf->Cell(184,6,'-: Black List Report :-',1,0,'C',1);
			$this->pdf->SetY(30);
		    $w = array(35,33,36,37,33); 	
		    $header =  array('STB No','Black Listed Date','CAS Provider','Serial No.','Type');

		    for($i = 0; $i < count($header); $i++) {
				$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
			}
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    $count=0;
		    foreach ($this->request->post['selected'] as $customer_id) {
		       	$results = $this->model_report_blacklist->getCustomerAddress($customer_id);
			    foreach($results as $result){
					$data[] = array($result["stb_no"],$result["black_list_date"],"ByDesign India","****","****");
			    	$count++;
		        }
	        }
		 	$column_width = $w[1];
	        for ($i=0; $i < $count ; $i++) {
			 	if($data[$i][1]=="")
		 	       	$total_string_width=55;
		 	    else
		 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);
	 	       	$number_of_lines = ceil( $total_string_width / ($column_width) );
	 	       	$line_height = 6;
	 	       	$yH = ceil( $number_of_lines * $line_height );  
		 	  	for($j=0; $j < count($header) ; $j++){ 
		 	      	if($j==0)
		 	        	$this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
	               	else if($j==2 || $j==3)
	               	{
	               		$this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
	               	}
	               	else{
		               	$x = $this->pdf->GetX();
		               	$y = $this->pdf->GetY();
			 	       	$this->pdf->MultiCell($w[1], 6,$data[$i][$j],1,1,0);
			 	       	$this->pdf->SetXY($x + $w[1], $y);
		 	       	}      
		 	  	}
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer details with their stb details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the customer details with their stb details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}			
		$url = '';
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/blacklist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_blacklist->getTotalStbAddress();
		
		$this->data['printPdf'] = $this->url->link('report/blacklist/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['customers'] = array();
		$results = $this->model_report_blacklist->getaddress($data);
		foreach ($results as $result) {			
			$this->data['customers'][] = array(
				'customer_id'    => $result['customer_id'],
				'STBNO'          => $result["stb_no"],
				'blacklist_date' => $result["black_list_date"],
				'CAS'          	 => "ByDesign India",
				'serial_no'      => "-- --",
				'type'        	 => "-- --",
				'selected'   	 => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['column_serial'] = $this->language->get('column_serial');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/blacklist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'report/blacklist.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 