<?php 
  /*
@File alacartewise_activeconnection.php(Controller)
ADMIN alacartewise_activeconnection PAGE
    This class show all the A la carte wise Active Conn to it.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ControllerReportAlaCartewiseActiveconnection extends Controller {

public function index() {

		$this->language->load('report/alacartewise_activeconnection');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/alacartewise_activeconnection');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		if (isset($this->request->post['selected']))
		{
			$this->load->model('report/alacartewise_activeconnection');
		    $this->pdf->AddPage();
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_alacartewise_activeconnection->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);			
			$this->pdf->SetY(40);
			$this->pdf->SetX(10);
			$this->pdf->Cell(190,6,'-: Ala Carte Wise Active Connection :-',1,0,'C',1);
			$this->pdf->SetY(55);
		    $w = array(10,40,70);
		    $c = array(40,30,150);
		    $header =  array('Channel ID','Channels','Total Connection');
			
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->load->model('report/alacartewise_activeconnection');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	foreach ($this->request->post['selected'] as $product_id) {
	        $results = $this->model_report_alacartewise_activeconnection->getAlacarte($product_id);
		    	foreach($results as $result){
					$data[] = array($result['product_id'],$result['name'],$result['total']);
			     	$count++;
	        	}
        	}
	        $this->pdf->SetX(10);
			for ($i=0; $i < $count ; $i++) {
				$this->pdf->SetX(10); 
		 	  	for($j=0; $j < count($header) ; $j++)
		 	  	{
			 	  	$this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
			    }   
		    	$this->pdf->Ln();
		    }            
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/alacartewise_activeconnection');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/alacartewise_activeconnection');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/alacartewise_activeconnection', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_alacartewise_activeconnection->getTotalAlaCarteWiseActiveConn($data);
		$this->data['channels'] = array();
		$results = $this->model_report_alacartewise_activeconnection->getAlacarteWiseActiveConn($data);
		foreach ($results as $result) {			
			$this->data['channels'][] = array(
				'product_id' 	=> $result['product_id'],
				'name'    		=> $result['name'],
				'total'        	=> $result['total'],
				'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_total_conn'] = $this->language->get('column_total_conn');
		$this->data['column_channel'] = $this->language->get('column_channel');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/alacartewise_activeconnection/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/alacartewise_activeconnection', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/alacartewise_activeconnection.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
