<?php 
  /*
@File ageing.php(Controller)
ADMIN AGEING PAGE
    This class show the ageing of the subscriber on the particular channel or package

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportAgeing extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the ageing of the subscriber on the particular channel or package and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the ageing data page
*/
public function index() {
		$this->language->load('report/ageing');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/ageing');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf(){
		$this->load->model('report/ageing');
		$this->language->load('report/ageing');
		if (isset($this->request->post['selected']))
		{
		    $this->pdf->AddPage('P',array(250,250));
		    $this->load->model('report/casnetworkreport');
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_casnetworkreport->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(65);
			$this->pdf->Cell(193,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(20);
			$this->pdf->Cell(190,6,'-: Ageing Of The Subscriber On The Particular Channel Or Package :-',1,0,'C',1);
			$this->pdf->SetY(35);
		    $w = array(20,55,100, 170);
		    $c = array(35,45,70, 40);
		    $header =  array('Customer ID','Customer Name','Product Name','Due Times in Days');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
	        $count=0;
		    if (isset($this->request->post['selected']))
			{
		      	foreach ($this->request->post['selected'] as $customer_id) {
		      	   $arr= explode(" ",$customer_id);
		      	   $results = $this->model_report_ageing->getAgeingCustomer($arr[0],$arr[1]);
		    		foreach($results as $result){
						$data[] = array($result['customer_id'],$result['name'],$result['product_name'],$result['time']);
		     			$count++;
	        		}
	        	}
	       	}
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
			for ($i=0; $i < $count ; $i++) { 
				$this->pdf->SetX(20);
		 	  	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the ageing customer details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/ageing', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_report_ageing->getTotalageing();		
		$this->data['ageings'] = array();
		$results = $this->model_report_ageing->getAgeing($data);
		foreach ($results as $result) {			
			$this->data['ageings'][] = array(
				'customer_id' => $result['customer_id'],
				'product_id' => $result['product_id'],
				'name'       => $result['name'],
				'time'       => $result['time'],
				'product_name'=>$result['product_name'],
				'selected'   => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_product'] = $this->language->get('column_product');
		$this->data['column_time'] = $this->language->get('column_time');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('report/ageing/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/ageing', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/ageing.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
