<?php 
 /*
@File active_deactive.php(Controller)
ADMIN ACTIVE_DEACTIVE PAGE
    This class show the historic data for the activation and deactivation of the customer 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportActiveDeactiveHistory extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the acitvated or deactivated customer details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the historic data page
*/
public function index() {
		$this->language->load('report/active_deactive_history');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/active_deactive_history');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
	public function printPdf()
	{
		if (isset($this->request->post['selected']))
		{
		    $this->pdf->AddPage('P',array(250,250));
	  	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $this->load->model('report/casnetworkreport');
		    $user = $this->model_report_casnetworkreport->getUserDetails($this->session->data['user_id']);
			
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(12);
			$this->pdf->SetX(65);
			$this->pdf->Cell(195,6,$user['email'],0,0,'C',0);

			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(20);
			$this->pdf->Cell(225,6,'-: Historical data in terms of the activations and deactivations :-',1,0,'C',1);
			$this->pdf->SetY(30);

		    $w = array(10,40,70,110,140,162,184,199,214);
		    $c = array(30,30,40,30,22, 22, 15, 15,21);
		    $header =  array('Customer ID','Customer Name','Product Name','STB NO','Start Time','End Time','Service Id','Status','Total Subs. Day');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->load->model('report/active_deactive_history');
		    $count=0;
		    foreach ($this->request->post['selected'] as $customer_id) {
		  	   	$arr= explode(" ",$customer_id);
		       	$results = $this->model_report_active_deactive_history->getCustomerStatus($arr[0],$arr[1]);
			    foreach($results as $result){
			    	$service = $this->model_report_active_deactive_history->getServiceid($result['product_id']);		
			        $temp =($result['status']? "Active" : "Deactive" );
			        $service_id=(isset($service['service_id'])?$service['service_id']:'-- --');
			        $start_time=date('d-m-Y H:i', strtotime($result['start_date']));
			        $end_time=date('d-m-Y H:i', strtotime($result['expire_date']));
					$data[] = array($result['customer_id'],$result['name'],$result['product_name'],$result['STBNO'],$start_time,$end_time,$service_id,$temp,$result['due']);
			     	$count++;
		        }
	        }
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
			for ($i=0; $i < $count ; $i++) { 
		 	  	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);  
		    $this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
	       	$this->language->load('report/active_deactive_history');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/active_deactive_history');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the acitvated or deactivated customer details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/active_deactive_history', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_act'] = $this->language->get('text_act');		
		$this->data['text_deact'] = $this->language->get('text_deact');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_cas'] = $this->language->get('column_cas');
		$this->data['column_start'] = $this->language->get('column_start');
		$this->data['column_end'] = $this->language->get('column_end');
		$this->data['column_send'] = $this->language->get('column_send');
		$this->data['column_service'] = $this->language->get('column_service');
		
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_due'] = $this->language->get('column_due');
		$this->data['column_product_name'] = $this->language->get('column_product_name');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['printPdf'] = $this->url->link('report/active_deactive_history/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['customers'] = array();

		$data = array(
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$order_total = $this->model_report_active_deactive_history->getStatusTotal();
		$results = $this->model_report_active_deactive_history->getStatus($data);
		
		foreach ($results as $result) {	
			$service = $this->model_report_active_deactive_history->getServiceid($result['product_id']);		
			$this->data['customers'][] = array(
				'customer_id' 	=> $result['customer_id'],
				'product_id' 	=> $result['product_id'],
				'name'    		=> $result['name'],
				'status'        => (($result['status'] AND strtotime($result['expire_date']) > time()) ? $this->language->get('text_act') : $this->language->get('text_deact')),
				'due'           => $result['due'],
				'stbno'   		=> $result['STBNO'],
				'product_name'  => $result['product_name'],
				// 'casno'   	=> $result['CASNO'],
				'start_date'   	=> date('d-m-Y H:i',strtotime($result['start_date'])),
				'end_date'   	=> date('d-m-Y H:i',strtotime($result['expire_date'])),
				'date_added'   	=> date('d-m-Y H:i',strtotime($result['date_added'])),
				'service_id'   	=> (isset($service['service_id'])?$service['service_id']:'-- --'),
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}			
		
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/active_deactive_history', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();
		
		$this->template = 'report/active_deactive_history.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
?> 
