<?php 
  /*
@File a_la_carte.php(Controller)
ADMIN A_LA_CARTE PAGE
    This class show the a la carte for the channels/packages

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportAlaCarte extends Controller { 
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the a la carte details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the a la carte page
*/  
  	public function index() {
		$this->language->load('report/a_la_carte');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/a_la_carte');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){
  		if (isset($this->request->post['selected']))
		{
		  	$this->pdf->AddPage('P',array(250,250));
		    $this->load->model('report/channel_list');
		    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
			$user = $this->model_report_channel_list->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(25);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(30);
			$this->pdf->SetX(70);
			$this->pdf->Cell(190,6,$user['email'],0,0,'C',0);
			$this->pdf->SetY(40);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->Cell(225,6,'-: Packages/Channels :-',1,0,'C',1);
			$this->pdf->SetY(55);
			$this->pdf->SetFont('times','B',8);
		    $w = array(10,40,70, 80,93,105,160,175,190,205,220);
		    $c = array(30,30,10, 13,12,55, 15, 15, 15, 15, 15);
		    $header =  array('Package/Channel ID','Package/Channel Name','No.','Price','Type','Particulars','0 > 30','30 > 60','60 > 90','90 > 120','120 Above');			
			$images = array();			
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],8,$header[$i],1,0,'L',1);
		    }
			$this->pdf->SetY(63);
			$this->load->model('report/a_la_carte');
		    $this->pdf->SetFont('times','',8);
	        $count=0;
	      	
	      	foreach ($this->request->post['selected'] as $product_id) {
	      		$res = $this->model_report_a_la_carte->getOptions($product_id);
				$m1_price='-- --';
				$m2_price='-- --';
				$m3_price='-- --';
				$m4_price='-- --';
				$m4above_price='-- --';
				$category='';

				foreach ($res as $value) {
					if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m1_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==2 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m2_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m3_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==4 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m4_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))>=5 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m4above_price=$value['price'];
					}
				$catres = $this->model_report_a_la_carte->getCategories($product_id);
				foreach ($catres as $value) {
					$category=$category.','.$value['category'];
				}
		        $results = $this->model_report_a_la_carte->getProduct($product_id);			    
			    foreach($results as $result){
					$data[] = array($result['product_id'],$result['name'],$result['model'],$result['price'], ($result['is_package']==1)?'Package':'Product',trim($category,', '),$m1_price,$m2_price,$m3_price,$m4_price,$m4above_price);
			     	$count++;
	        	}
        	}
			for ($i=0; $i < $count ; $i++) { 
				$this->pdf->SetX(10);
		 	  	for($j=0; $j < count($header) ; $j++)
		 	        $this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);  
		    	$this->pdf->Ln();
		    }               
		    $this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
		    $this->pdf->Output();
		}else{
			$this->language->load('report/a_la_carte');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('report/a_la_carte');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the a la carte for channels/packages .
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
  	protected function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/a_la_carte', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
   		//----------
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
	
		
		$this->data['products'] = array();
		$this->load->model('tool/image');
		$this->load->model('report/a_la_carte');
		$total = $this->model_report_a_la_carte->getTotal_a_la_carte($data);
		// var_dump($total);exit();
		$results = $this->model_report_a_la_carte->getProducts($data);
    	foreach ($results as $result) {
    		if($result['is_ppv']!=1){
	    		if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
					$image = $this->model_tool_image->resize($result['image'], 40, 40);
				} else {
					$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
				}
				$res = $this->model_report_a_la_carte->getOptions($result['product_id']);

				$m1_price='-- --';
				$m2_price='-- --';
				$m3_price='-- --';
				$m4_price='-- --';
				$m4above_price='-- --';
				$category='';
				foreach ($res as $value) {
					if((substr($value['name'],0,strpos($value['name'],' '))==1 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m1_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==2 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m2_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==3 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m3_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))==4 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m4_price=$value['price'];
					else if((substr($value['name'],0,strpos($value['name'],' '))>=5 AND (substr($value['name'],strpos($value['name'],' ')+1,3))=='mon'))
						$m4above_price=$value['price'];
					}
				$catres = $this->model_report_a_la_carte->getCategories($result['product_id']);
				foreach ($catres as $value) {
					$category=$category.','.$value['category'];
				}
				$this->data['products'][] = array(
					'product_id'    => $result['product_id'],
					'image'         => $image,
	 				'name'          => $result['name'],
					'model'         => $result['model'],
					'price'         => $result['price'],
					// 'type'          => ($result['is_package']==1)?'Package':'Product',
					'M1 Price'		=> $m1_price,
				    'M2 Price' 		=> $m2_price,
					'M3 Price' 		=> $m3_price,
					'M4 Price' 		=> $m4_price,				
					'M4> Price' 	=> $m4above_price,
					'particular'    =>trim($category,','),
					'quantity'      => $result['quantity'],
					'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);
			}
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
								
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
	        $this->data['column_image'] = $this->language->get('column_image');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_no'] = $this->language->get('column_no');			
		$this->data['column_model'] = $this->language->get('column_model');
		$this->data['column_price'] = $this->language->get('column_price');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_particular'] = $this->language->get('column_particular');
		$this->data['column_0_30'] = $this->language->get('column_0_30');
		$this->data['column_30_60'] = $this->language->get('column_30_60');
		$this->data['column_60_90'] = $this->language->get('column_60_90');
		$this->data['column_90_120'] = $this->language->get('column_90_120');
		$this->data['column_120above'] = $this->language->get('column_120above');
		$this->data['column_quantity'] = $this->language->get('column_quantity');
		$this->data['printPdf'] = $this->url->link('report/a_la_carte/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/a_la_carte', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();	
		$this->template = 'report/a_la_carte.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
}
?>
