<?php 
 /*
@File PeoplePDF.php(Controller)
ADMIN PEOPLEPDF PAGE
    This class creates a dummy table for the pdf to display data.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class PeoplePDF extends FPDF {
/*
FUNCTION NAME       -   CreateTable
DESCRIPTION         -   Creates a basic table for the pdf.
INPUT PARAMETER     -   void
OUTPUT PARAMETER    -   Renders the table.
*/    
    // Create basic table
    public function CreateTable($header, $data)
    {
        // Header
        $this->SetFillColor(0);
        $this->SetTextColor(255);
        $this->SetFont('','B');
        foreach ($header as $col) {
            //Cell(float w [, float h [, string txt [, mixed border [, int ln [, string align [, boolean fill [, mixed link]]]]]]])
            $this->Cell($col[1], 10, $col[0], 1, 0, 'L', true);
        }
        $this->Ln();
        // Data
        $this->SetFillColor(255);
        $this->SetTextColor(0);
        $this->SetFont('');
        foreach ($data as $row)
        {
            $i = 0;
            foreach ($row as $field) {
                $this->Cell($header[$i][1], 6, $field, 1, 0, 'L', true);
                $i++;
            }
            $this->Ln();
        }
    }
}
?>