<?php
/*
@File order.php(Controller)
ADMIN ORDER PAGE
    This class manages the customer's order by inserting/updating or by 
    printing the invoice for the selected order.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerQuickSearch extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the order option in the dopdown list.
						It get all the order list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the order page showing all the order in a list.
*/
  	public function index() {
		$this->language->load('quick/search');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('quick/search');
    	$this->getList();
  	}

  	  public function exportCsvtOperatorData(){
    	$this->load->model('quick/search');
    	if(isset($this->request->get['filter_operator'])){
    		$operator_id = $this->request->get['filter_operator'];
    	}
    	/*********************** Export TO CSV ****************************************/
    	$results = $this->model_quick_search->getOperatorIdWithSTB($operator_id);
    	if($results){
	    	$operatorDetails = $this->model_quick_search->getOperatorDetails($operator_id); 
	    	date_default_timezone_set('Asia/Kolkata');
			$currentTime = date('d-m-Y H:i:s');
	    	$FileName = $operatorDetails['user_id'].'-'.$operatorDetails['username'].'-'.$currentTime.".csv"; 
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename='.$FileName);
			$output = fopen('php://output', 'w');
			fputcsv($output, array('Operator ID', 'STBNO'));
			foreach($results as $row) {
				fputcsv($output, $row);
			}
		}
    }

	public function getList() {
				
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

	
		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option'] = $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']='';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
			$this->data['filter_value'] = $this->request->get['filter_value'];
		} else {
			$filter_value = '';
			$this->data['filter_value'] = '';
		}

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator'] = $this->request->get['filter_operator'];
		} else {
			$filter_operator = '';
			$this->data['filter_operator'] = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
				
		$url = '';

        $this->data['options']=array('customer_unique_id' => 'Customer No',
        						'firstname'  => 'Name',
        						'telephone'  => 'Mobile',
        						'stbno'      => 'STBNO',
        						'address_1'  => 'Address',
        						'operator'	 =>	'Operator',
        						'passcode'	 =>	'Passcode');
        						// );

        $this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('quick/search', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}
		
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		
   		   		
		//$this->data['invoice'] = $this->url->link('quick/order/invoice', 'token=' . $this->session->data['token'], 'SSL');
		$order_total=null;
		$this->data['orders'] = array();
		$this->load->model('tool/image');
		$this->load->model('quick/search');
		$data = array(
			'filter_option' => $filter_option,
			'filter_value'  => $filter_value,
			'filter_operator'   => $filter_operator,
			'start'         => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'         => $this->config->get('config_admin_limit')
		);
	 
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && (isset($this->request->get['filter_option'])) && (strlen($this->request->get['filter_value']))&&$this->validateValue() || (isset($this->request->get['filter_operator'])) ){

		    $order_total = $this->model_quick_search->getTotalOrders($data);
		    $results = $this->model_quick_search->getOrders($data);
	      	foreach ($results as $result) {
		    	$action = array();
		    	 $this->data['orders'][] = array(
			  	  	'customer_unique_id'  => $result['customer_unique_id'],
			  	  	'operator_id'         => $result['operator_id'],
		    	 	'name'         		  => $result['name'],
		    	 	'STBNO'        		  => $result['STBNO'],
		    	 	'mobile'       		  => $result['telephone'],
		     		'address'      		  => $result['address_1'],
		     	 	'email' 	   		  => $result['email'],
		     	 	'selected'     		  => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
		     	);
		    }
		}

		$operatorList = $this->model_quick_search->getOperatorList();
		foreach ($operatorList as  $operator) {
			$this->data['operators'][] = array(
					'user_id' => $operator['user_id'],
					'username'=> $operator['username']
				);
		}
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_missing'] = $this->language->get('text_missing');
		$this->data['error_value'] = $this->language->get('error_value');
		$this->data['column_customer_id'] = $this->language->get('column_customer_id');
    	$this->data['column_customer'] = $this->language->get('column_customer');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('Get Details');
		$this->data['printPdf'] = $this->url->link('quick/search/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->session->error['warning'])) {
			$this->data['error_warning'] = $this->session->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('quick/search', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'quick/search_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		//var_dump($this->render());exit();
		$this->response->setOutput($this->render());
  	}
  		
	

	public function validateValue(){
		if(!isset($this->request->get['filter_value']))
		{
			$this->data['error_value'] = $this->language->get('error_value');

		}
		return true;
	}


	public function printPdf(){

		$this->language->load('quick/search');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('quick/search');
		
		if (!isset($this->request->post['selected'])) {

			$this->session->error['warning'] = 'Please select the record to print!';
			$this->getList();	

		}
		else {

		$this->pdf->AddPage();
	    
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(20);
		$this->pdf->Cell(165,6,'-: Customer Details :-',1,0,'C',1);
		$this->pdf->SetY(30);

	    $w = array(10,30,50,70,100,130);
	    $c = array(20,20,20,30,30,40);
	    $header =  array('Customer Id','Name','Address','Mobile','STBNO','Email');
		
		$images = array();
		
	     for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	     	$this->pdf->SetX($w[0]);
	       else
		    $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		 
		    $this->pdf->Cell($c[$i],8,$header[$i],1,0,'L',1);
	    }
		
		$this->load->model('quick/search');
	    
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	 	
         
         $count=0;

	    if (isset($this->request->post['selected']))
		{

	      foreach ($this->request->post['selected'] as $customer_id) {

	         $results = $this->model_quick_search->getDetails($customer_id);
	    foreach($results as $result){

			$data[] = array($result['customer_id'],$result['firstname'],$result['address_1'],$result['telephone'],$result['STBNO'],$result['email']);
	     $count++;

        }
        }
       }


		for ($i=0; $i < $count ; $i++) { 
	 	  for($j=0; $j < count($header) ; $j++)
	 	        $this->pdf->Cell($c[$j],8,$data[$i][$j],1,0,'L',0);
	       
	    $this->pdf->Ln();
	    }               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	 
	    $this->pdf->Output();
    }
}

	
}
?>