<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiRegion extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/region');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/region');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		//$this->data['regins'][]=array();
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/region/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('kmsapi/region/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');


		$this->data['stbs'] = array();

		
		$results = $this->model_kmsapi_region->getDetail();
		foreach ($results as $result) {	
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('kmsapi/region/update', 'token=' . $this->session->data['token'] . '&region_id=' . $result['region_id'] . $url, 'SSL')
			);



			$this->data['regions'][] = array(
				'region_id'    => $result['region_id'],
				'region_name'          => $result['region_name'],
				'selected'           => isset($this->request->post['selected']) && in_array($result['region_id'], $this->request->post['selected']),
				'action'             => $action
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/region.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
			$obj = new restapi();

		$this->language->load('kmsapi/region');

    	$this->document->setTitle($this->language->get('heading_title'));
					
		$this->load->model('kmsapi/region');

  			 
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {    	 	
      	  	$temp=$this->request->post;
       	  	$data="region_name=".$temp['region'];
       	  	$z ="78fef98a91761cf1b171451b49289000";
	 		$method ="POST";
	 		$url="http://localhost/sasapi-4/v1/enableRegion";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$response=json_decode($apiresult);
    		$error=true;
    		$respId="";
    		foreach ($response as $key => $value) {
    			if($key=='id')
    			{
    				$respId=$value;
    				break;
    			}
    		}
    		if($respId!="")
    		{
    			$this->model_kmsapi_region->addRegion($this->request->post);
    			$result = $this->model_kmsapi_region->getRegionId($temp['region']);
				$sms_region_id=$result['region_id'];
    			$this->model_kmsapi_region->addApiResponceId($respId,$sms_region_id);
        		$this->session->data['success'] = "Region added success fully !";
        	
				$url = '';				
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}

				$this->redirect($this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				$this->error['warning'] = "Region failed to Add !";
        		$this->getForm();
        	}
		}
    	
    	$this->getForm();
  	} 
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('kmsapi/region');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/region');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_kmsapi_region->editSTB($this->request->get['stb_no'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success');
	  
			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('kmsapi/region');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/region');
		$notDeleted="";
    	if (isset($this->request->post['selected']) && $this->validateDelete()) 
    	{
			foreach ($this->request->post['selected'] as $region_id) 
			{
				$data = $this->model_kmsapi_region->getApiResponceId($region_id);
				$respId="";		 
				if(isset($data['kms_region_id']))
				{
			 		$data="region_id=".$data['kms_region_id'];
		       	  	$z ="78fef98a91761cf1b171451b49289000";
			 		$method ="POST";
			 		$url="http://localhost/sasapi-4/v1/disableRegion";
			 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		        	$response=json_decode($apiresult);
		        	$error=true;
					foreach ($response as $key) 
					{
						$error=$key;
		  				break;
	    			}
	    			if(!$error)
	    			{
						$this->model_kmsapi_region->deleteRegion($region_id);
		        		$this->session->data['success'] = $this->language->get('text_success');
		        	}else{
		        		$notDeleted="". $region_id.",";
		        	}
	        	}
			}

			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    		
    	}
    	
    	$this->error['warning'] = $this->language->get('error_checkbox');
    	$this->getList();
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['region'])) {
			$this->data['error_region'] = $this->error['region'];
		} else {
			$this->data['error_region'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		
		$url = '';
		
		// if (isset($this->request->get['sort'])) {
		// 	$url .= '&sort=' . $this->request->get['sort'];
		// }

		// if (isset($this->request->get['order'])) {
		// 	$url .= '&order=' . $this->request->get['order'];
		// }
						
		// if (isset($this->request->get['page'])) {
		// 	$url .= '&page=' . $this->request->get['page'];
		// }
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('kmsapi/region/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('kmsapi/region/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	// if (isset($this->request->get['stb_no']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
     //  		$stb_info = $this->model_kmsapi_region->getSTB($this->request->get['stb_no']);
    	// }
			
  //   	if (isset($this->request->post['stb'])) {
  //     		$this->data['stb'] = $this->request->post['stb'];
		// } elseif (!empty($stb_info)) { 
		// 	$this->data['stb'] = $stb_info['stb_no'];
		// } else {
  //     		$this->data['stb'] = '';
  //   	}

  //   	if (isset($this->request->post['sc'])) {
  //     		$this->data['sc'] = $this->request->post['sc'];
		// }elseif (!empty($stb_info)) { 
		// 	$this->data['sc'] = $stb_info['is_smart_card'];
		// } else {
  //     		$this->data['sc'] = '';
  //   	}
		
		$this->template = 'kmsapi/region_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	if (!$this->user->hasPermission('modify', 'kmsapi/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
    	if ((utf8_strlen($this->request->post['region']) <1) || (utf8_strlen($this->request->post['region']) > 100)) {
      		$this->error['region'] = "Length should be between 1-100!";
    	}elseif(preg_match('/[^a-f0-9 A-Z]/i', $this->request->post['region'])){
    		$this->error['region'] = "Accepts only 0-9, A-F!";
    	}

    	$this->load->model('kmsapi/region');
    	$flag = $this->model_kmsapi_region->isRegionExist($this->request->post['region']);
    	if($flag)
    		$this->error['region'] = "Region name already exist!";
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
		
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
    	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
  	private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
			
				return $value;
			 }
			 return;
	} 
 }
?> 