<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiPackagedeletesubs extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/packagedeletesubs');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/packagedeletesubs');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
			
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		//$this->data['regions'][]=array();
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/packagedeletesubs', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/packagedeletesubs/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('kmsapi/packagedeletesubs/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');


		$this->data['stbs'] = array();

		
		$results = $this->model_kmsapi_packagedeletesubs->getDetail();
		foreach ($results as $result) {	
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('kmsapi/packagedeletesubs/update', 'token=' . $this->session->data['token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL')
			);



			$this->data['regions'][] = array(
				'customer_id'    => $result['customer_id'],
				'product_id'	=> $result['product_id'],
				'name'          => $result['name'],
				'pname'          => $result['pname'],
				'expire_date'          => $result['expire_date'],
				'selected'           => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
				'action'             => $action
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = "Package deletion UnSuccessfull";
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = "Package deletion Successfull";
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/packagedeletesubs.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

 
// FUNCTION NAME 		-	update
// DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
// 						added/uploaded earlier. 
// INPUT PARAMETER 	-	void
// OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
// */
   
  	public function update() {
		$this->language->load('kmsapi/region');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/region');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_kmsapi_region->editSTB($this->request->get['stb_no'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success');
	  
			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('kmsapi/packagedeletesubs');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/packagedeletesubs');

			
    	if (isset($this->request->post['selected'])) {
    		//check if the stb is paired with any customer or not. write code
			foreach ($this->request->post['selected'] as $vals) 
			{

				//print_r($vals);
				$data=split('~', $vals);
				$customer_id=$data[0];
				$product_id=$data[1];
				$data = $this->model_kmsapi_packagedeletesubs->getSubApiResponceId($customer_id,$product_id);				 
				$sub_id=$data['kms_product_id'];	
				$data1 = $this->model_kmsapi_packagedeletesubs->getCustomerApiResponceId($customer_id);

						
				$this->model_kmsapi_packagedeletesubs->deleteProductSubscription($customer_id,$product_id);

				
				/*var_dump($data1['api_user_id']);
				exit(0);*/


			if(isset($data['kms_product_id'])&&isset($data1['api_user_id']))
			{
	 		$method ="DELETE";
	 		$url="http://localhost/kmsapi/v1/deletePackageSubscription/".$data1['api_user_id']."&".$data['kms_product_id'];
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	 		var_dump($url);
        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
        	}
        	
			}
			
			
			

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/packagedeletesubs', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
    	
    	$this->error['warning'] = $this->language->get('error_checkbox');
    	$this->getList();
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb'])) {
			$this->data['error_stb'] = $this->error['stb'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/packagedeletesubs', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('kmsapi/packagedeletesubs/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('kmsapi/packagedeletesubs/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/packagedeletesubs', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->template = 'kmsapi/packagedeletesubs_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	/*if (!$this->user->hasPermission('modify', 'kmsapi/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('kmsapi/region');
    	
    		$x = $this->model_kmsapi_region->getSTB($this->request->post['stb']);
    	
    	 if ((strlen($this->request->post['stb'])!=12)){
            $this->error['stb'] = "length error";
       		 }
        elseif($x['stb_no'])
    		{
    	 		$this->error['stb'] = "Duplicate";	
    		}
      

		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}*/
		return true;
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	 
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
  	private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
			
				return $value;
			 }
			 return;
	} 
 }
?> 