<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerKmsapiFingerprintecm extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('kmsapi/fingerprintecm');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/fingerprintecm');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/fingerprintecm', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		

   		$this->data['insert'] = $this->url->link('kmsapi/fingerprintecm/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');

		$this->data['fingerprintecm_details'] = array();

		
		$results = $this->model_kmsapi_fingerprintecm->getFingerPrintECMDetail();
		foreach ($results as $result) {	
			$this->data['fingerprintecm_details'][] = array(
				// 'type'    => $result['type'],
				// 'customer_id'          => $result['customer_id'],
				'is_covert'          => ($result['is_covert'] ? $this->language->get('text_avail') : $this->language->get('text_not_avail')),
				'product_id'           => $result['product_id'],
				'start_time'    => $result['start_time'],
				'end_time'          => $result['end_time'],
				'view_duration'    => $result['view_duration'],
				'display_duration'          => $result['display_duration'],
				'location_x'    => $result['location_x'],
				'location_y'          => $result['location_y'],
				'text_color'    => $result['text_color'],
				'background_color'          => $result['background_color'],
				'data_bits'             => $result['data_bits'],
				'kms_reply'             => $result['kms_reply']
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		// $this->data['column_type'] = $this->language->get('column_type');
		// $this->data['column_user_id'] = $this->language->get('column_user_id');
		$this->data['column_is_covert'] = $this->language->get('column_is_covert');
		$this->data['column_channel_id'] = $this->language->get('column_channel_id');
		$this->data['column_starttime'] = $this->language->get('column_starttime');

		$this->data['column_endtime'] = $this->language->get('column_endtime');
		$this->data['column_view_duration'] = $this->language->get('column_view_duration');
		$this->data['column_display_duration'] = $this->language->get('column_display_duration');
		$this->data['column_locationx'] = $this->language->get('column_locationx');
		$this->data['column_locationy'] = $this->language->get('column_locationy');
		$this->data['column_textcolor'] = $this->language->get('column_textcolor');
		$this->data['column_backgroundcolor'] = $this->language->get('column_backgroundcolor');
		$this->data['column_databits'] = $this->language->get('column_databits');
		$this->data['column_kms_reply'] = $this->language->get('column_kms_reply');
		

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'kmsapi/fingerprintecm.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
		$this->language->load('kmsapi/fingerprintecm');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('kmsapi/fingerprintecm');
		$this->load->model('catalog/product');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
      	  	$this->model_kmsapi_fingerprintecm->addFingerPrintECM($this->request->post);
			
      	  	//-------------------------------------------------------------------------------- 	
 				
      	  	$p = $this->model_catalog_product->getApiResponceId($this->request->post['product_id']);
      	  	$start_timestamp = strtotime($this->request->post['start_time']);
 		$end_timestamp = strtotime($this->request->post['end_time']);


    		$obj = new restapi();
     	 $data="iscovert=".$this->request->post['is_covert']."&channel_id=".$p['api_product_id']
      	  	."&start_time=".$start_timestamp."&end_time=".$end_timestamp
      	  	."&view_duration=".$this->request->post['view_duration']."&display_duration=".$this->request->post['display_duration']
      	  	."&location_x=".$this->request->post['location_x']."&location_y=".$this->request->post['location_y']
      	  	."&text_color=".$this->request->post['text_color']."&background_color=".$this->request->post['background_color']
      	  	."&data_bits=".$this->request->post['data_bits'];
     	 $z ="78fef98a91761cf1b171451b49289000";
	 	 $method ="POST";
	 		$url="http://localhost/kmsapi/v1/FingerPrintEcm";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
     	 $apiresult = $obj->callAPI($method,$hdr,$url,$data);
    	  $res=json_decode($apiresult,true);
    	  // var_dump($res);exit(0);
     	   	$this->model_kmsapi_fingerprintecm->updateFingerprintecm($res['curlresponse']);
    	
        //-----------------------------------------------------------------------------------


			$this->session->data['success'] = $this->language->get('text_success');
		  
			$url = '';
							
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('kmsapi/fingerprintecm', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    	
    	$this->getForm();
  	} 

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	
    	$this->data['entry_is_covert'] = $this->language->get('entry_is_covert');
    	$this->data['entry_product_id'] = $this->language->get('entry_product_id');
    	$this->data['entry_start_time'] = $this->language->get('entry_start_time');
    	$this->data['entry_end_time'] = $this->language->get('entry_end_time');
    	$this->data['entry_view_duration'] = $this->language->get('entry_view_duration');
    	$this->data['entry_display_duration'] = $this->language->get('entry_display_duration');
    	$this->data['entry_location_x'] = $this->language->get('entry_location_x');
    	$this->data['entry_location_y'] = $this->language->get('entry_location_y');
    	$this->data['entry_text_color'] = $this->language->get('entry_text_color');
    	$this->data['entry_background_color'] = $this->language->get('entry_background_color');
    	$this->data['entry_data_bits'] = $this->language->get('entry_data_bits');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
	

		if (isset($this->error['is_covert'])) {
			$this->data['error_is_covert'] = $this->error['is_covert'];
		} else {
			$this->data['error_is_covert'] = '';
		}

		if (isset($this->error['product_id'])) {
			$this->data['error_product_id'] = $this->error['product_id'];
		} else {
			$this->data['error_product_id'] = '';
		}

		if (isset($this->error['start_time'])) {
			$this->data['error_start_time'] = $this->error['start_time'];
		} else {
			$this->data['error_start_time'] = '';
		}

		if (isset($this->error['end_time'])) {
			$this->data['error_end_time'] = $this->error['end_time'];
		} else {
			$this->data['error_end_time'] = '';
		}

		if (isset($this->error['view_duration'])) {
			$this->data['error_view_duration'] = $this->error['view_duration'];
		} else {
			$this->data['error_view_duration'] = '';
		}

		if (isset($this->error['display_duration'])) {
			$this->data['error_display_duration'] = $this->error['display_duration'];
		} else {
			$this->data['error_display_duration'] = '';
		}

		if (isset($this->error['location_x'])) {
			$this->data['error_location_x'] = $this->error['location_x'];
		} else {
			$this->data['error_location_x'] = '';
		}

		if (isset($this->error['location_y'])) {
			$this->data['error_location_y'] = $this->error['location_y'];
		} else {
			$this->data['error_location_y'] = '';
		}

		if (isset($this->error['text_color'])) {
			$this->data['error_text_color'] = $this->error['text_color'];
		} else {
			$this->data['error_text_color'] = '';
		}

		if (isset($this->error['background_color'])) {
			$this->data['error_background_color'] = $this->error['background_color'];
		} else {
			$this->data['error_background_color'] = '';
		}

		if (isset($this->error['data_bits'])) {
			$this->data['error_data_bits'] = $this->error['data_bits'];
		} else {
			$this->data['error_data_bits'] = '';
		}
				
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('kmsapi/fingerprintecm', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('kmsapi/fingerprintecm/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		  
    	$this->data['cancel'] = $this->url->link('kmsapi/fingerprintecm', 'token=' . $this->session->data['token'] . $url, 'SSL');


    	if (isset($this->request->post['is_covert'])) {
      		$this->data['is_covert'] = $this->request->post['is_covert'];
		} else {
      		$this->data['is_covert'] = '';
    	}

    	if (isset($this->request->post['product_id'])) {
      		$this->data['product_id'] = $this->request->post['product_id'];
		} else {
      		$this->data['product_id'] = '';
    	}

    	if (isset($this->request->post['start_time'])) {
      		$this->data['start_time'] = $this->request->post['start_time'];
		} else {
      		$this->data['start_time'] = '';
    	}

    	if (isset($this->request->post['end_time'])) {
      		$this->data['end_time'] = $this->request->post['end_time'];
		} else {
      		$this->data['end_time'] = '';
    	}

    	if (isset($this->request->post['view_duration'])) {
      		$this->data['view_duration'] = $this->request->post['view_duration'];
		} else {
      		$this->data['view_duration'] = '';
    	}

    	if (isset($this->request->post['display_duration'])) {
      		$this->data['display_duration'] = $this->request->post['display_duration'];
		}  else {
      		$this->data['display_duration'] = '';
    	}

    	if (isset($this->request->post['location_x'])) {
      		$this->data['location_x'] = $this->request->post['location_x'];
		}else {
      		$this->data['location_x'] = '';
    	}

    	if (isset($this->request->post['location_y'])) {
      		$this->data['location_y'] = $this->request->post['location_y'];
		}  else {
      		$this->data['location_y'] = '';
    	}

    	if (isset($this->request->post['text_color'])) {
      		$this->data['text_color'] = $this->request->post['text_color'];
		} else {
      		$this->data['text_color'] = '';
    	}

    	if (isset($this->request->post['background_color'])) {
      		$this->data['background_color'] = $this->request->post['background_color'];
		}  else {
      		$this->data['background_color'] = '';
    	}

    	if (isset($this->request->post['data_bits'])) {
      		$this->data['data_bits'] = $this->request->post['data_bits'];
		}else {
      		$this->data['data_bits'] = '';
    	}
		
		$this->template = 'kmsapi/fingerprintecm_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'kmsapi/fingerprintecm')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	if ((utf8_strlen($this->request->post['is_covert']) <1) || (utf8_strlen($this->request->post['is_covert']) > 1)) {
      		$this->error['is_covert'] = "Length should be one digit!";
    	}elseif(($this->request->post['is_covert'] <0) || ($this->request->post['is_covert'] >1)){
    		$this->error['is_covert'] = "value should be between 0-1";
    	}

    	$this->load->model('catalog/product');
    	$this->load->model('catalog/package');
    	if(!preg_match('/[^0-9]/i', $this->request->post['product_id'])){
    	 	$product_info = $this->model_catalog_product->getProduct($this->request->post['product_id']);
    	 	if(!$product_info){
    			$this->error['product_id']	 = "invalid product id!";
    	 	}	
    	}else{
    		$this->error['product_id']	 = "accept only integer!";
    	}

    	if($this->request->post['start_time']){
	    	if(new DateTime() >= new DateTime($this->request->post['start_time'])){
	    			$this->error['start_time'] = "Start time is less than current date!";
			}
		}else{
			$this->error['start_time']="Start time missing!"	;
		}

		if($this->request->post['end_time']){
	    	if(new DateTime() >= new DateTime($this->request->post['end_time'])){
	    			$this->error['end_time'] = "End time is less than current date!";
			}
		}else{
			$this->error['end_time']="Expiry time missing!"	;
		}
		
		if ((utf8_strlen($this->request->post['view_duration']) <1) || (utf8_strlen($this->request->post['view_duration']) > 3)) {
      		$this->error['view_duration'] = "Length should be between 1-3!";
    	}elseif(($this->request->post['view_duration'] <1) || ($this->request->post['view_duration'] >255)){
    		$this->error['view_duration'] = "value should be between 1-255";
    	}

    	if ((utf8_strlen($this->request->post['display_duration']) <1) || (utf8_strlen($this->request->post['display_duration']) > 3)) {
      		$this->error['display_duration'] = "Length should be between 1-3!";
    	}elseif(($this->request->post['display_duration'] <1) || ($this->request->post['display_duration'] >255)){
    		$this->error['display_duration'] = "value should be between 1-255";
    	}

    	if ((utf8_strlen($this->request->post['location_x']) <1) || (utf8_strlen($this->request->post['location_x']) > 3)) {
      		$this->error['location_x'] = "Length should between 1-3!";
    	}elseif(($this->request->post['location_x'] <1) || ($this->request->post['location_x'] >255)){
    		$this->error['location_x'] = "value should be between 1-255";
    	}

    	if ((utf8_strlen($this->request->post['location_y']) <1) || (utf8_strlen($this->request->post['location_y']) > 3)) {
      		$this->error['location_y'] = "Length should be between 1-3!";
    	}elseif(($this->request->post['location_y'] <1) || ($this->request->post['location_y'] >255)){
    		$this->error['location_y'] = "value should be between 1-255";
    	}

    	if ((utf8_strlen($this->request->post['text_color']) <1) || (utf8_strlen($this->request->post['text_color']) > 6)) {
      		$this->error['text_color'] = "Length should be between 1-6!";
    	}elseif(preg_match('/[^a-f0-9]/i', $this->request->post['text_color'])){
    		$this->error['text_color'] = "Accepts only 0-9, A-F!";
    	}

    	if ((utf8_strlen($this->request->post['background_color']) <1) || (utf8_strlen($this->request->post['background_color']) > 6)) {
      		$this->error['background_color'] = "Length should be between 1-6!";
    	}elseif(preg_match('/[^a-f0-9]/i', $this->request->post['background_color'])){
    		$this->error['background_color'] = "Accepts only 0-9, A-F!";
    	}

    	if ((utf8_strlen($this->request->post['data_bits']) <1) || (utf8_strlen($this->request->post['data_bits']) > 8)) {
      		$this->error['data_bits'] = "Length should be between 1-8!";
    	}elseif(preg_match('/[^0-1]/i', $this->request->post['data_bits'])){
    		$this->error['data_bits'] = "Accepts only 0&1!";
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    

 }
?> 