<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerInventrySTB extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('inventry/stb');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb');
    	$this->getList();
  	}

public function exportFormat(){  
	/*********************** Export STB Inventory CSV Format *****************************/
	$results = array('SDA40000000001,'.'1,'.'5,'.'-1');
	if($results){
		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename=StbInventorySampleFormat.csv');
		$output = fopen('php://output', 'w'); ob_clean();
		fputcsv($output, array('STB NO', 's/w version', 'h/w version', 'sc no'));
		foreach ( $results as $line ) {
			$val = explode(",", $line);
			fputcsv($output, $val);
		}
	}
}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	

		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  		if (isset($this->request->get['filter_passcode'])) {
			$url .= '&filter_passcode=' . urlencode(html_entity_decode($this->request->get['filter_passcode'], ENT_QUOTES, 'UTF-8'));
		}
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
   		if(isset($this->request->get['download']))
   		{
   			$this->data['download'] = $this->url->link('inventry/stb/download', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		}
   		$this->data['sync'] = $this->url->link('inventry/stb/sync', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['insert'] = $this->url->link('inventry/stb/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('inventry/stb/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['blacklist'] = $this->url->link('inventry/stb/blacklist', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_sync'] = $this->language->get('button_sync');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_black_list'] = $this->language->get('button_black_list');

		$this->data['stbs'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		if (isset($this->request->get['filter_passcode'])) {
			$this->data['filter_passcode'] = $this->request->get['filter_passcode'];
			$data['filter_passcode']=$this->request->get['filter_passcode'];
		} else {
			$this->data['filter_passcode'] ='';
		}
		$total = $this->model_inventry_stb->getTotalStb($data);

		$results = $this->model_inventry_stb->getDetail($data);
		// var_dump($data);exit();
		foreach ($results as $result) {	
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('inventry/stb/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $result['stb_no'] . $url, 'SSL')
			);

			$this->data['stbs'][] = array(
				// 'customer_id'    => $result['customer_id'],
				'STBNO'          => $result['stb_no'],
				'pass_code'      => $result['pass_code'],
				'avail'          => ($result['is_avail'] ? $this->language->get('text_not_avail') : $this->language->get('text_avail')),
				'name'           => $result['name'],
				'smart_card'     => ($result['sc_no']!=-1 ? $result['sc_no'] : $this->language->get('text_not_sc')),
				'blacklist'      => ($result['is_black_list'] ? $this->language->get('text_blacklist') : $this->language->get('text_not_blacklist')),
				'hw_version'	 =>$result['hw_version_no'],
				'sw_version'	 =>$result['sw_version_no'],
				'selected'       => isset($this->request->post['selected']) && in_array($result['stb_no'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_paired'] = $this->language->get('column_paired');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['column_pass_code'] = $this->language->get('column_pass_code');
		$this->data['column_blacklist'] = $this->language->get('column_blacklist');
		$this->data['column_hw_version'] = $this->language->get('column_hw_version');
		$this->data['column_sw_version'] = $this->language->get('column_sw_version');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//----------------------
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'inventry/stb.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}

  	// ============================================

  	public function sync(){
  		
  		$this->load->model('inventry/stb');
  		$stbs_without_passcode = $this->model_inventry_stb->getSTBWithoutPasscode();
  		$count = 0;

  		foreach ($stbs_without_passcode as $key => $value) {  			
  			if($count==0){
  				$list = $value["stb_no"];
  			}else{
  				$list = $list.",".$value["stb_no"];
  			}
  			$count++;
  		}
  		
  		if (sizeof($stbs_without_passcode)>0) {
  			$obj = new restapi();
  			$data="stb_list=".$list;
		 	$method ="POST";
		 	$url=KMS_API."/getPasscode";
		 	
		 	$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.' : '.API_AUTH);
	        $apiresult = $obj->callAPI($method,$hdr,$url,$data);
	        // var_dump($data);exit();
	        $response=json_decode($apiresult,true);	  
	        // var_dump($response);exit();
	        if(sizeof($response)>0){
	        	$this->model_inventry_stb->addPasscode($response);
	        	$this->session->data['success'] = 'Records Synced';
	        	$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
	        }else{
	        	$this->session->data['success'] = "Required Chip ID's missing for few STB's!!";
  				$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
	        }
  		} else {
  			$this->session->data['success'] = 'Records Already Synced';
  			$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
  		}

  	}


  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
		$stb_list=array();
		$stb_sw_hw=array();

		if (($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) && $this->validateFile()) {

			$apimessage='';
    		$errorMsg="KMS Failed! ";
    		$error=true;	
    		$flag=false;
    		$stb_input=array();
		 // if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
		        // readfile($_FILES['filename']['tmp_name']);
			  	$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			  	$error_encounter=0;
			  	if($ext=='csv'){
				    $handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name'], "r");
				    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				    	if(strlen(trim($data[0]))!=14)
				    		continue;
				    	$sw_hw=array();
					    $stb_input['stb']=trim($data[0]);
					    $stb_input['sc_no']=trim($data[3],"'");
					    array_push($sw_hw, trim($data[1]));
					    array_push($sw_hw, trim($data[2]));
				        array_push($stb_sw_hw,$sw_hw);
				        array_push($stb_list,$stb_input);
				    }			    
				    fclose($handle);
				}else{
					$error_encounter=1;
					$errorMsg='Invalid file format, Only .CSV files are accepted';
				/*}
		    }else{*/
		    	$error_encounter=0;
		    	$sw_hw=array();
		    	$stb_input['stb']=$this->request->post['stb'];
		    	array_push($sw_hw, $this->request->post['sw']);
			    array_push($sw_hw, $this->request->post['hw']);
			    if($this->request->post['sc']==1){
			    	$stb_input['sc_no']=$this->request->post['smart_card'];
			    }
			    else{
			    	$stb_input['sc_no']='-1';
			    }
			    array_push($stb_list,$stb_input);
			    array_push($stb_sw_hw,$sw_hw);
		    }

		    if(count($stb_list)==0)
		    {
				$error_encounter=1;
				$errorMsg='Invalid data trying to send!';
			}
			$json_stb=json_encode($stb_list,JSON_FORCE_OBJECT);
		    if(!$error_encounter){
			    $data="stb_list=".$json_stb;
		 		$method ="POST";
		 		$url=KMS_API."/enableStb";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.' : '.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	      		$kms_stb_id="";
	    		$response=json_decode($apiresult,true);
				foreach ($response as $key => $value) {
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'stb_list':
	    					$kms_stb_list=$value;	
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
			 	}
				$count=0;
				$myfile = fopen("stblog.txt", "a+") or die("Unable to open file!");
				$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
				$today = $currDate->format('d-m-Y H:i:s');	
				// $today = date("Y-m-d H:i:s");
				fwrite($myfile,"-----------------------------------------------------------------------------------------------\n");
				foreach ($kms_stb_list as $stb) {
				 	if(strcmp($stb['resp'], 'ACK')==0)
				 	{
						$sms_stb_id=$this->model_inventry_stb->addSTB($stb,$stb_sw_hw[$count],$stb_input['sc_no']);
			        	$this->model_inventry_stb->addApiResponceId($stb['id'],$sms_stb_id);
			        	// fwrite($myfile, $stb['stb_no']." KMS response ==> ".$stb['resp']."  Message ==> ".$stb['message']."  ".$today."\n");
			        	fwrite($myfile, "SUCCESS"."\t\t".$today."\t\t".str_pad($stb['stb_no'],24," ")."addSTB"."\n");
				 	}else {
				 		// fwrite($myfile, $stb['stb_no']." KMS response ==> ".$stb['resp']."  Message ==> ".$stb['message']."  ".$today."\n");
				 		fwrite($myfile, "ERROR"."\t\t".$today."\t\t".str_pad($stb['stb_no'],24," ")."addSTB"."\n");
	        			$flag=true;	
				 	}
				 	$count=$count+1;	
				 		
				}
				fclose($myfile);
			}else{
				$error=1;				
			}

    		if(!$error)	{ 
				$url = '';
								
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				if(!$flag){
					$this->session->data['success'] = $this->language->get('success');
					$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url."&download=1", 'SSL'));
				}else{
					$this->session->data['success'] = $this->language->get('partial_success');
					$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url."&download=1", 'SSL'));
				}

			}else{
				$this->error['warning']=$errorMsg;
		 		$this->getForm();
			}
		}
    	
    	$this->getForm();	
  	} 

 public function validateFile(){
	  	if(!sizeof($_FILES )){
  			$this->error['warning']	= "Warning: Please select .csv file for stb creation.!";
  			return false;
  		}else{
				
		  		$newloc = DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name']; 
		  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
		  		$lines = count(file($newloc)); 

		  		$count = 0;
		  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name'], "r");
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					if($count==0){
						if($data[0]!="STB NO" || $data[1]!="s/w version" || $data[2]!="h/w version" || $data[3]!="sc no"){
								$this->error['warning'] = "Warning: Invalid file!";
								unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name']);
								return false;
						}
						$count++;
					}
				}
				
		  		if( $lines > 1001){
					$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
					unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Creation/'.$_FILES['filename']['name']); 
					return false;
				}else 
				return true;
		}
	} 	
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('inventry/stb');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_inventry_stb->editSTB($this->request->get['stb_no'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success');
	  
			$url = '';
						
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
    	if ($this->validateDelete() && isset($this->request->post['selected'])) {
    		//check if the stb is paired with any customer or not. write code
    		$error_encounter=0;
    		$flag=false;
    		$errorMsg='';
			foreach ($this->request->post['selected'] as $stb_no) {
				$delete_flag=false;
				$x = $this->model_inventry_stb->getSTB($stb_no);
				$p = $this->model_inventry_stb->getApiResponceId($x['id']);
				$data="stb_id=".$p['kms_stb_id'];	
		 		$method ="POST";
		 		$url=KMS_API."/disableStb";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		       	$response=json_decode($apiresult);
		       	$error=true;
		
	        	foreach ($response as $key => $value) {
	        		switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
	    			}
				}
    			if($error){
    				$error_encounter=1;
    				$errorMsg=$errorMsg." :".$apimessage;
    			}else{
    				$flag=true;
    				$this->model_inventry_stb->deleteSTB($stb_no);
    			}
	  		}
	  		if($error_encounter)
	  		{		
				if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$errorMsg.')';
		  		else
		  			$this->session->data['warning'] =$errorMsg;
			  	$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->session->data['success'] = $this->language->get('text_success_deleted');
				$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
			}
    	}else
    		// $this->error['warning'] = $this->language->get('error_checkbox');
    		$this->getList();
  	}  
/*
FUNCTION NAME 		-	blacklist
DESCRIPTION 		-	Black list the selected stb listed on the page. Admin selects the 
						checkbox against the stb in the list to be black listed and it gets black list 
						after clicking the black list button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the stb list page after black listing the stb from the list.
*/
  	public function blacklist() {
		$this->language->load('inventry/stb');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb');
    	if($this->validateBlacklist() && isset($this->request->post['selected'])) {
    		$obj = new restapi();
			foreach ($this->request->post['selected'] as $stb_no) {
				$getId = $this->model_inventry_stb->getStbidByStbno($stb_no);
				if((int)$getId["customer_id"]){
				$kmsstbId = $this->model_inventry_stb->getApiResponceId($getId['id']);
				$kms_user_Id = $this->model_inventry_stb->getApiCustomerId($getId["customer_id"]);				
				//========
				$data="stb_id=".$kmsstbId['kms_stb_id']."&user_id=".$kms_user_Id['api_user_id'];
		 		$method ="POST";
		 		$url=KMS_API."/blackListSTB";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	    		$temp=json_decode($apiresult);
	    		$error=true;
	    		foreach ($temp as $key => $value) {
	    		 	if($key=='error')
	    		 	{	
	    		 		if($value==false)
	 	   		 		$error =false;
	    		 		break;
	    		 	}
	    		}
	    		if(!$error)
	    		{
					$temp=$this->model_inventry_stb->blacklistSTB($stb_no);
				}else{
					$this->error['warning'] = "Error: Unable to blacklist STB!".$apiresult.$kms_user_Id;
					$this->getList();
					return;
				}
				}
				else{
					$this->error['warning'] = "Error:customer id missing Unable to blacklist !";
					$this->getList();
					return;
				}
			}
			$this->session->data['success'] = $this->language->get('text_success_blacklisted');
			$url = '';
			$this->redirect($this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL'));
    	}
    	$this->getList();
  	}  
  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
  		$this->language->load('inventry/stb');
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
    	$this->data['entry_sw'] = $this->language->get('entry_sw');
    	$this->data['entry_hw'] = $this->language->get('entry_hw');
    	$this->data['entry_smart_card'] = $this->language->get('entry_smart_card');

    	$this->data['text_sc'] = $this->language->get('text_sc');
    	$this->data['text_not_sc'] = $this->language->get('text_not_sc');
	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    	$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		//--------------
		if (isset($this->error['sw'])) {
			$this->data['error_sw'] = $this->error['sw'];
		} else {
			$this->data['error_sw'] = '';
		}
		if (isset($this->error['hw'])) {
			$this->data['error_hw'] = $this->error['hw'];
		} else {
			$this->data['error_hw'] = '';
		}
		//--------------
 		if (isset($this->error['stb'])) {
			$this->data['error_stb'] = $this->error['stb'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['sc'])) {
			$this->data['error_sc'] = $this->error['sc'];
		} else {
			$this->data['error_sc'] = '';
		}
		if (isset($this->error['smart_card'])) {
			$this->data['error_smart_card'] = $this->error['smart_card'];
		} else {
			$this->data['error_smart_card'] = '';
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('inventry/stb/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('inventry/stb/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['stb_no']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$stb_info = $this->model_inventry_stb->getSTB($this->request->get['stb_no']);
    	}
			
    	if (isset($this->request->post['stb'])) {
      		$this->data['stb'] = $this->request->post['stb'];
		} elseif (!empty($stb_info)) { 
			$this->data['stb'] = $stb_info['stb_no'];
		} else {
      		$this->data['stb'] = '';
    	}

    	if (isset($this->request->post['sc'])) {
      		$this->data['sc'] = $this->request->post['sc'];
		}elseif (!empty($stb_info)) { 
			$this->data['sc'] = $stb_info['is_smart_card'];
		} else {
      		$this->data['sc'] = '';
    	}
    	if (isset($this->request->post['smart_card'])) {
      		$this->data['smart_card'] = $this->request->post['smart_card'];
		} elseif (!empty($cas_info)) { 
			$this->data['smart_card'] = $cas_info['smart_card'];
		} else {
      		$this->data['smart_card'] = '';
    	}

    	if (isset($this->request->post['sw'])) {
      		$this->data['sw_ver'] = $this->request->post['sw'];
		} elseif (!empty($stb_info)) { 
			$this->data['sw_ver'] = $stb_info['sw'];
		} else {
      		$this->data['sw_ver'] = '';
    	}

    	if (isset($this->request->post['hw'])) {
      		$this->data['hw_ver'] = $this->request->post['hw'];
		} elseif (!empty($stb_info)) { 
			$this->data['hw_ver'] = $stb_info['hw'];
		} else {
      		$this->data['hw_ver'] = '';
    	}
		
		$this->template = 'inventry/stb_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('inventry/stb');

		if(!sizeof($_FILES )){
  			$this->error['warning']	= "Warning: Please select .csv file for stb creation.!";
  			return false;
  		}else{
			$ext = pathinfo(HTTP_SERVER.$_FILES['filename']['name'], PATHINFO_EXTENSION);
	        if($ext!='' && $ext!='csv'){
	        	$this->error['warning'] = 'Invalid file format, Only .CSV files are accepted';
	        }

	    	if(is_uploaded_file($_FILES['filename']['tmp_name']))
	    	{

	    	}else{
		    	if(!isset($this->request->get['stb_no'])){
		    		$result = $this->model_inventry_stb->isSTBExist($this->request->post['stb']);
		    		$isSCNOExit = $this->model_inventry_stb->isSCNoExist($this->request->post['smart_card']);
			    	if ((strlen($this->request->post['stb'])!=14)){
			            $this->error['stb'] = $this->language->get('error_length');
			       	}
			        elseif($result)
			    	{
			    		$this->error['stb'] = $this->language->get('error_duplicate');
			    	}
		      	}

		      	if(!preg_match('/^[\d.]+$/',$this->request->post['sw']) || $this->request->post['sw']=='' ){
		      		$this->error['sw'] = $this->language->get('error_sw');
		      	}
		      	if(!preg_match('/^[\d.]+$/',$this->request->post['hw']) || $this->request->post['hw']==''){
		    		$this->error['hw'] = $this->language->get('error_hw');
		    	}

		     //  	if (!is_numeric($this->request->post['sw']) || $this->request->post['sw']=='' ) {
		     //  		$this->error['sw'] = $this->language->get('error_sw');
		    	// }
		    	// if(!is_numeric($this->request->post['hw']) || $this->request->post['hw']==''){
		    	// 	$this->error['hw'] = $this->language->get('error_hw');
		    	// }
		    	if($this->request->post['sc']==1)
		    		if ((strlen($this->request->post['smart_card'])!=16)){
		            	$this->error['smart_card'] = "Smart card no is mandatory, Length should be 16!";
		       		 }
		       		elseif($isSCNOExit!='')
			    	{
			    		$this->error['smart_card'] = "Duplicate smart card number!";
			    	}elseif (preg_match('/[^a-z0-9]/i', $this->request->post['smart_card'])) {
			    		$this->error['smart_card'] = "Special Characters not allowed!";
			    	}
		    }
		}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}    
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	
	  	if(!isset($this->request->post['selected']))
    		$this->error['warning'] =  $this->language->get('error_checkbox');

    	if(isset($this->request->post['selected'])){ 
    	foreach ($this->request->post['selected'] as $stb_no) { 
  			$stb_pair_info = $this->model_inventry_stb->checkSTBPairedBySTBNO($stb_no);
  			if ($stb_pair_info!=NULL) { 
	  			$this->error['warning'] = "STB is paired with user!";
  				}
  			}
  		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateBlacklist() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('inventry/stb');
    	if (isset($this->request->post['selected'])) {
    		foreach ($this->request->post['selected'] as $stb_no) {
    			$flag = $this->model_inventry_stb->CheckBlackList($stb_no);
    			if($flag)
    			{
    				$this->error['warning'] = $this->language->get('error_blacklist');
    			}
    		}
    	}
    	else{
    		// $this->error['warning'] =  $this->language->get('error_checkbox');
    	}
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
  	private function getSTBIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {

			 if($value['error']==false)
					
				return $value;
			 }
			 return 'id';
	}


	public function download()
	{
		$file='stblog.txt';
		header('Content-Description: File Transfer');
      	header('Content-Type: application/pdf');
      	header('Content-Disposition: attachment; filename='.basename($file));
      	header('Content-Transfer-Encoding: binary');
      	header('Expires: 0');
      	header('Cache-Control: must-revalidate');
      	header('Pragma: public');
      	header('Content-Length: ' . filesize($file));
      	ob_clean();
      	flush();
      	readfile($file);
	         
	} 
 }
?> 
