<?php 
 /*
@File stb_cas.php(Controller)
ADMIN STB_CAS PAGE
    This class displays the connection between stb number, cas number and the customer 
    to whom these numbers are issued.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerInventrySTBCAS extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb & cas pairing option in the dopdown list.
						It get all the stb & cas number list with the pairing detials and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb & cas pairing page showing all the stb & cas pairing number in a list.
*/
public function index() {
		$this->language->load('inventry/stb_cas');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb_cas');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Checks whether the stb_cas file has permission to access or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
 protected function validateApprove() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb_cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}

    	if (isset($this->request->post['selected'])) {
    		foreach ($this->request->post['selected'] as $customer_id) {
    			
    			$flag = $this->model_inventry_stb_cas->CheckApprove($customer_id);
    			if($flag)
    			{
    				$this->error['message']="Already Approved";
    				break;			
    			}
    		}
    		

    	}
		

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Checks whether the stb_cas file has permission to access or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
 protected function validateUnpair() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb_cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}

		if (isset($this->request->post['selected'])) {
    		foreach ($this->request->post['selected'] as $customer_id) {
    			$flag = $this->model_inventry_stb_cas->CheckUnpair($customer_id);
    			if($flag)
    			{
    				$this->error['message']="Already Unpaired";
    				break;			
    			}
    			if($this->model_inventry_stb_cas->isSTBActive($customer_id))
    			{
    				$this->error['message']="Please de-activate STB before you unpair!";
    				break;			
    			}
    		}
       	}		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected row listed on the page. Admin selects the 
						checkbox against the row in the list to be deleted and it gets unlinked 
						and respective cas & stb numbers availability status is changed 
						after clicking the delete button. 
						After deleting it add the deletion detail to a log file for future use.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the review list page after deleting the review from the list.
*/

public function approve() {
    	$this->language->load('inventry/stb_cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb_cas');
		
		if (isset($this->request->post['selected']) && $this->validateApprove()) {
			// $file = DIR_LOGFILE.'admin.log';
			// $handle =  fopen($file, 'a');
			// date_default_timezone_set('Asia/Calcutta');
			foreach ($this->request->post['selected'] as $cwarningustomer_id) {
			 	$this->model_inventry_stb_cas->approve($customer_id);
			 	// $logs = $this->model_inventry_stb_cas->getData($customer_id);
			 	// foreach ($logs as $log) {
 				// 	fwrite($handle, "\n".$log['customer_id'] ." ".$log['stbno'] ." ".$log['casno'] ." ". date("m/d/y G.i:s", time())." ".$this->user->getUserName());
			 	// }
	  		}
	  		//fclose($handle);
			$this->session->data['success'] = $this->language->get('text_success_activate');
			$url = '';
			$this->redirect($this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->error['warning'] =$this->language->get('text_select_warning');

    	$this->getList();
  	}


/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected row listed on the page. Admin selects the 
						checkbox against the row in the list to be deleted and it gets unlinked 
						and respective cas & stb numbers availability status is changed 
						after clicking the delete button. 
						After deleting it add the deletion detail to a log file for future use.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the review list page after deleting the review from the list.
*/

public function unpair() {

  			 $obj = new restapi();
    	$this->language->load('inventry/stb_cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb_cas');
		// var_dump($this->request->post);exit();
		if (isset($this->request->post['selected'])) {
			if($this->validateUnpair()){

				foreach ($this->request->post['selected'] as $customer_id) {
					$stb_no= $this->model_inventry_stb_cas->getSTB($customer_id);
					$data= $this->model_inventry_stb_cas->getApiResponceId($customer_id);
					$method ="POST";
					$data = "user_id=".$data["api_user_id"];
			 		$url=KMS_API."/unpairUser";
			 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        		$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        		$response=json_decode($apiresult);
	        		$error=true;
	        		$apimessage="";
	        		$errorMsg='';
	        		 foreach ($response as $key => $value) {
	        		 	switch ($key) {
		    				case 'error':
		    					$error=	$value;
		    					break;
		    				case 'message':
		    					$apimessage=$value;				
		    					break;
		    				default:
		    					$errorMsg=$errorMsg." ".$key.":".$value;	
		    					break;
		    			}
					}
	        		if(!$error){
				 		$this->model_inventry_stb_cas->unpair($customer_id);
				 		$this->session->data['success'] = $apimessage;
	        		}else{
	        			$this->session->data['warning']=$errorMsg.' '.$apimessage;
	        		}

	        		$myfile = fopen("stbunpairlog.txt", "a+") or die("Unable to open file!");
					$today = date("Y-m-d H:i:s");
					fwrite($myfile,"\n------------------------------------------------------\n");
					fwrite($myfile, "STB NO:". $stb_no['STBNO']." Customer No: ".$stb_no['customer_unique_id']." Message ==> ".$this->session->data['success']." DATE-TIME = ".$today."\n");
					fclose($myfile);
		  		}
		  		
				$url = '';
				$this->redirect($this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				$this->getList();
			}
		}else{
			$this->error['warning'] = $this->language->get('text_select_warning');
	    	$this->getList();
	    }
  	}  	
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb & cas number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb & cas number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
		
		$this->data['approve'] = $this->url->link('inventry/stb_cas/approve', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['unpair'] = $this->url->link('inventry/stb_cas/unpair', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['customers'] = array();

		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_value']) && preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		$totals = $this->model_inventry_stb_cas->getTotalDetails($data);
		$results = $this->model_inventry_stb_cas->getDetail($data);
		// var_dump($results);exit(0);
		foreach ($results as $result) {	
			$action = array();
			$actionUnapir = array();
		
			$action[] = array(
				'text' => $this->language->get('text_assign'),
				'href' => $this->url->link('inventry/stb_cas/pairSmartcard', 'token=' . $this->session->data['token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL')
			);
			$actionUnapir[] = array(
				'text' => $this->language->get('text_deactvate'),
				'href' => $this->url->link('inventry/stb_cas/unPairSmartcard', 'token=' . $this->session->data['token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL')
			);
		
			$this->data['customers'][] = array(
				'customer_no'    => $result['customer_no'],
				'customer_id'    => $result['customer_id'],
				'STBNO'          => ($result['stb_id']!='')?$result['stb_id']:'NA',
				// 'smart_card'     => ($result['sc_no']!=-1)?$result['sc_no']:'NA',
				'prev_STBNO'     => ($result['prev_stb_id']!='0')?$result['prev_stb_id']:'NA',
				'name'           => $result['name'],
				'selected'       => isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
				'action'         => $action,
				'action_unpair'  => $actionUnapir
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_casno'] = $this->language->get('column_casno');
		$this->data['column_smart_card'] = $this->language->get('column_smart_card');
		$this->data['column_stbno_prev'] = $this->language->get('column_stbno_prev');
		$this->data['column_casno_prev'] = $this->language->get('column_casno_prev');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_approve'] = $this->language->get('button_approve');
		$this->data['button_unpair'] = $this->language->get('button_unpair');
		//$this->data['invoice'] = $this->url->link('inventry/stb/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		}else 
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['message'])) {
			$this->data['error_message'] = $this->error['message'];
		} else {
			$this->data['error_message'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		}else if (isset($this->error['success'])) {
			$this->data['success'] = $this->error['success'];
		}else {
			$this->data['success'] = '';
		}
		//-----------
		$pagination = new Pagination();
		$pagination->total = $totals;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//-----------
		
		$url = '';

		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'inventry/stb_cas.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 
 /*
FUNCTION NAME 		-	pairSmartcard
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function pairSmartcard() {
  		$obj = new restapi();
		$this->language->load('inventry/stb_cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb_cas');

    	if($this->validatePairing($this->request->get['customer_id']))
		{	
			
  			$user_id = $this->model_inventry_stb_cas->getApiResponceId($this->request->get['customer_id']);
  			$method ="POST";
			$data = "user_id=".$user_id['api_user_id'];
	 		$url=KMS_API."/BoxPairing";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
    		// $apiresult=$obj->callAPI($method,$hdr,$url,$data);
    		
    		// $response=json_decode($apiresult);			
		    // $error=true;
		    // $apimessage=" Kms fail to enable STB";
		 //    foreach ($response as $key => $value) {
			// 	if($key=='error'&&$value==false)
			// 	{
			// 		$error=false;
			// 	}if($key=='error'&&$value==true)
			// 	{
			// 		$error=true;	
			// 	}
			// 	if($key=='message')
			// 	{
			// 		$apimessage=$value;			
			// 	}
			// 	if($key=='id')
			// 	{
			// 		$id=$value;
			// 	}
			// 	if($key=='mq_response')
			// 	{
			// 		$curlresponse=$value;
			// 	}
			// }
			
			// $ack_is=-1;$nack_is=-1;
			// if(!$error)
			// {
			// 	$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
			// 	if($ack=='ACK')
			// 	{
			// 		$ack_is=1;
			// 	}elseif($ack=='NACK'){
			// 		$nack_is=-1;
			// 	}

			// 	$this->model_inventry_stb_cas->updateCasStatus($this->request->get['customer_id'],"SC Paired");
				//$this->model_inventry_stb_cas->addToTransanction($this->request->get['customer_id'],13,$id,$ack_is,$nack_is);
				$this->error['success']=$data;
			// }else{
			// 	$this->error['warning']=$apimessage;
			// }
			
		}
  		$this->getList();
  	}   

/*FUNCTION NAME 	-	unPairSmartcard
DESCRIPTION 		-	Unpair the smart card and stb cas 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	KMS response of unpairing.
*/
   
  	public function unPairSmartcard() {
  		$obj = new restapi();
		$this->language->load('inventry/stb_cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stb_cas');

		if($this->validatePairing($this->request->get['customer_id']))
		{
			$row=$this->model_inventry_stb_cas->getCasFronCustomerId($this->request->get['customer_id']);
	  		if(isset($row['kms_cas_id']))
	  		{
	  			$user_id = $this->model_inventry_stb_cas->getApiResponceId($this->request->get['customer_id']);
	  			$method ="POST";
				$data = "user_id=".$user_id['api_user_id']."&cas_id=".$row['kms_cas_id'];
		 		$url=KMS_API."/BoxUnPairing";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	    		$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	    		
	    		$response=json_decode($apiresult);			
			    $error=true;
			    $apimessage=" Kms fail to enable STB";
			    foreach ($response as $key => $value) {
					if($key=='error'&&$value==false)
					{
						$error=false;
					}if($key=='error'&&$value==true)
					{
						$error=true;	
					}
					if($key=='message')
					{
						$apimessage=$value;			
					}if($key=='id')
					{
						$id=$value;
					}
					if($key=='mq_response')
					{
						$curlresponse=$value;
					}

				}
				// $error=false;
				// $apimessage="Success: Paired successfully";
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}

					$this->model_inventry_stb_cas->updateCasStatus($this->request->get['customer_id'],"SC Unpaired");
					$this->model_inventry_stb_cas->addToTransanction($this->request->get['customer_id'],14,$id,$ack_is,$nack_is);
					$this->error['success']=$apimessage;
				}else{
					$this->error['warning']=$apimessage;
				}
	  		}
	  	}
  		$this->getList();
  	} 
  	
  	/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
		$this->language->load('inventry/stb_cas');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('inventry/stb_cas');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_inventry_stb_cas->editCustomerInfo($this->request->get['customer_id'], $this->request->post);
	  		
			$this->session->data['success'] = $this->language->get('text_success_assigned');
	  
			$url = '';
						
			// if (isset($this->request->get['sort'])) {
			// 	$url .= '&sort=' . $this->request->get['sort'];
			// }

			// if (isset($this->request->get['order'])) {
			// 	$url .= '&order=' . $this->request->get['order'];
			// }

			// if (isset($this->request->get['page'])) {
			// 	$url .= '&page=' . $this->request->get['page'];
			// }
			
			$this->redirect($this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
    
    	$this->getForm();
  	}


  	function validatePairing($customer_id)
  	{
  		$this->load->model('inventry/stb_cas');
  		if($this->model_inventry_stb_cas->checkStbCasPairing($customer_id))
  		{
			if(!$this->model_inventry_stb_cas->checkSmartCardExists($customer_id))
			{
				$this->error['warning']="The customer paired with STB does't have Smart Card!";
				return false;
			}
		}else{
			$this->error['warning']="Customer does not paired with any STB CAS";
			return false;
		}
		return true;
  	}   
  	


  	  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
 		$this->data['entry_customer'] = $this->language->get('entry_customer');
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_cas'] = $this->language->get('entry_cas');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb'])) {
			$this->data['error_stb'] = $this->error['stb'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['cas'])) {
			$this->data['error_cas'] = $this->error['cas'];
		} else {
			$this->data['error_cas'] = '';
		}
		
		$url = '';
		
		// if (isset($this->request->get['sort'])) {
		// 	$url .= '&sort=' . $this->request->get['sort'];
		// }

		// if (isset($this->request->get['order'])) {
		// 	$url .= '&order=' . $this->request->get['order'];
		// }
						
		// if (isset($this->request->get['page'])) {
		// 	$url .= '&page=' . $this->request->get['page'];
		// }
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('inventry/stb_cas/update', 'token=' . $this->session->data['token'] . '&customer_id=' . $this->request->get['customer_id'] . $url, 'SSL');
		  
    	$this->data['cancel'] = $this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['customer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$customer_info = $this->model_inventry_stb_cas->getCustomerInfo($this->request->get['customer_id']);
    		if($customer_info['STBNO']!=0)
    			$this->data['disable']=1;
    		else
    			$this->data['disable']=0;
    	}
    	else
    		$this->data['disable']=0;	
		
    	if (isset($this->request->post['customer'])) {
      		$this->data['customer'] = $this->request->post['customer'];
		} elseif (!empty($customer_info)) { 
			$this->data['customer'] = $customer_info['firstname']." ".$customer_info['lastname'];
		} else {
      		$this->data['customer'] = '';
    	}


    	if (isset($this->request->post['stb'])) {
      		$this->data['stb'] = $this->request->post['stb'];
		} elseif (!empty($customer_info)) { 
			$this->data['stb'] = $customer_info['STBNO'];
		} else {
      		$this->data['stb'] = '';
    	}

    	if (isset($this->request->post['cas'])) {
      		$this->data['cas'] = $this->request->post['cas'];
		}elseif (!empty($customer_info)) { 
			$this->data['cas'] = $customer_info['CASNO'];
		} else {
      		$this->data['cas'] = '';
    	}
		
		$this->template = 'inventry/stb_cas_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'inventry/stb_cas')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

     	if ((utf8_strlen($this->request->post['stb']) != 12)) {
       		$this->error['stb'] = $this->language->get('error_stb');
     	}
     	else {
		  	$stb_check = $this->model_inventry_stb_cas->CheckSTB($this->request->post['stb']);
		  	if($stb_check ){
		  		if($stb_check['is_avail']==0)
		  			$this->error['stb'] = $this->language->get('error_stb_assigned');   
		  	}else{
		  		$this->error['stb'] = $this->language->get('error_stb_not_exist');   
		  	}
		}
		if ((utf8_strlen($this->request->post['cas']) != 16)) {
       		$this->error['cas'] = $this->language->get('error_cas');
     	}
     	else {
		  	$cas_check = $this->model_inventry_stb_cas->CheckCAS($this->request->post['cas']);
			if($cas_check ){
				if($cas_check['is_avail']==0)
		  			$this->error['cas'] = $this->language->get('error_cas_assigned');   		  	
			}else{
		  		$this->error['cas'] = $this->language->get('error_cas_not_exist');   
		  	}
		}

		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
  	private function getUserIdFromApiResponce($obj1)
	{
		//var_dump($obj1);
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
				//return $value['package_id'];
				/*var_dump($value);
				exit(0);*/return $value;
			 }
			 var_dump($obj1);
			 //exit(0);
			 return;
	}

 }?> 
