<?php    
class ControllerInventryStbMove extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('inventry/stbMove');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('inventry/stbMove');
		$this->getUploadForm();
	}

	public function exportFormat(){  
    	/*********************** Export STB Move CSV Format *****************************/
    	$results = array( '1,'."SDA40000000001");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=StbMoveSampleFormat.csv');
			$output = fopen('php://output', 'w');
			fputcsv($output, array('Operator ID', 'STBNO'));
			foreach ( $results as $line ) {
    			$val = explode(",", $line);
    			fputcsv($output, $val);
			}
		}
    }

	public function stb_bulk_activation(){ 
    	$this->load->model('inventry/stbMove');
    	$obj = new restapi();
    	$this->language->load('sale/customer');

    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');
		$this->load->model('sale/customer');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {	
		  	$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
		  	if($ext=='csv'){
		  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name'], "r");
		  		$log_separator = "-------------------------------------\n";
				$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
				$current_date = $currDate->format('d-m-Y H:i:s');	
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {  #echo "<pre>"; print_r($data);die;
			    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt",$log_separator, FILE_APPEND);
			    	if( (sizeof($data)==2 || sizeof($data)==3)  && $data[0]!='Operator ID' && $data[1]!= 'STBNO'   ){
			    		if($data[0]=='' && $data[1]!=''){ 
			    			$msg = 'Operator Id required!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
			    		}else if($data[0]!='' && $data[1]==''){
			    			$msg = 'STBNO required!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", "Operator ID: ".$data[0]." : ".$msg, FILE_APPEND);
			    		}else{
				    		$is_avail_operatorID = $this->model_inventry_stbMove->isAvailOperatorID($data[0]);
				    		$is_avail_stb  = $this->model_inventry_stbMove->validateSTB(trim($data[1])); 
				    		$is_paired_stb = $this->model_inventry_stbMove->isStbPairedCustomer(trim($data[1]));
				    		$is_blacklist  = $this->model_inventry_stbMove->isBlacklist(trim($data[1]));
				    		$is_RMA 	   = $this->model_inventry_stbMove->isStbRMA(trim($data[1]));
				    		$lcoId  	   = $this->model_inventry_stbMove->getOperatorIdFromStbno(trim($data[1]));
				    		$is_suspended  = $this->model_inventry_stbMove->isSuspended(trim($data[1]));
				    		$is_lco_suspend = $this->model_inventry_stbMove->isLcoSuspend($lcoId);

				    		if(!$is_avail_operatorID){	
				    			$msg = 'Operator id does not exist!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}elseif (!$is_avail_stb) {
								$msg = 'Invalid STBNO!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}elseif ($is_blacklist==1) {
								$msg = 'STB is Blacklisted!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}elseif ($is_suspended==1) {
								$msg = 'STB is suspended, Please resume first.!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}elseif ($is_lco_suspend==1) {
								$msg = 'STB Belongs To LCO Is Suspended, Please Resume LCO First.!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}elseif ($is_RMA==1) {
								$msg = 'STB in RMA state.!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
							}else{		
				    			if($is_avail_stb){
					    			$this->model_inventry_stbMove->updateOperatorIdByStb($data[0],$data[1]);
					    		}
					    		if($is_paired_stb){
					    			 $this->model_inventry_stbMove->updateOperatorIdByCustomer($data[0],$data[1]);
					    			 $custData = $this->model_inventry_stbMove->getCustomerDetails($data[1]);
					    			 $this->model_inventry_stbMove->addCustomerPairUnpair($custData['customer_unique_id'],$data[1],$custData['customer_group_id'],$custData['address_id'],$data[0]);
						    		/*foreach ($is_paired_stb as $value) {
						    			$is_active_stb = $this->model_inventry_stbMove->isStbActivation($value['customer_id']);
						    			foreach ($is_active_stb as $userID) {
						    				$updateOperatorCasOpTrans = $this->model_inventry_stbMove->updateOperatorIdByCasOpTrans($data[0],$userID['user_id']);
						    			}
						    		}*/
					    		}
					    		$msg = 'SUCCESS!'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", $data[1]." : ".$msg, FILE_APPEND);
								/*============================================================*/
								$obj = new restapi();
								$data="lcoId=".$data[0]."&stb_no=".$data[1];
					      	  	$method ="POST";
						 		$url=KMS_API."/stbMove";
						 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
								$error=true;
								$api_user_id="";
								$response=json_decode($apiresult);
								$errorMsg="";
								
								foreach ($response as $key => $value) {
									switch ($key) {
					    				case 'error':
					    					$error=	$value;
					    					break;
					    				case 'message':
					    					$apimessage=$value;				
					    					break;
					    				case 'id':
					    					$api_user_id=$value;	
					    					break;
					    				default:
					    					$errorMsg=$errorMsg." ".$key.":".$value;	
					    					break;
					    			}
					    		}
								/*============================================================*/
				    		}
				    	}
			    	} // End If	
			    	else{
			    		if(sizeof($data)<2){
				    		$msg = 'FAILED: Invalid Record!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
						}
			    	}
			    		// ------------ERROR LOGS---------------------
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt",$log_separator, FILE_APPEND);	
							$user_id = "_".$this->session->data['user_id'];
							$gzfile = DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.$user_id.".gz";
							$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
							gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
							gzclose($fp);
					   // ------------ERROR LOGS---------------------
			    } // End while loop
			    unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$current_date.".txt");
			    unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name']);
			}else{	
				$this->error['warning']= "Warning: INVALID FILE FORMAT";
				unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name']);
			}
		}
    
      $this->getUploadForm();
  	} 

  	public function validateFile(){
  		if(!sizeof($_FILES )){
  			$this->error['warning']	= "Please select .csv file for stb bulk move.!";
  			return false;
  		}else{
  			$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			if($ext!='csv'){
				$this->error['warning']	= "Please select .csv file for stb bulk move.!";
  				return false;
			} else {
		  		$newloc = DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name'];
		  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
		  		$lines = count(file($newloc)); 

		  		$count = 0;
		  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name'], "r");
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					if($count==0){
						if($data[0]!="Operator ID" || $data[1]!="STBNO"){
								$this->error['warning'] = "Warning: Invalid file!";
								unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name']);
								return false;
						}
						$count++;
					}
				}

		  		if( $lines > 1001){
					$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
					unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_Move/'.$_FILES['filename']['name']); 
					return false;
				}else {
						if($lines){
							// $this->session->data['success'] = "File upload successfully.!!";
							return true;
						}else {
							$this->error['warning']	= "Please select .csv file for stb move process!";
						}
					}
			}
		}
  	}

  	  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
  		$this->language->load('inventry/stbMove');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('inventry/stbMove', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stbMove'] = $this->url->link('inventry/stbMove/stb_bulk_activation', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_stb_move_log_list'] = array();
   		$total = $this->model_inventry_stbMove->getTotal();
		$results = $this->model_inventry_stbMove->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_stb_move_log_list'][] = array(
							'name'    		=> $result['name'],
							'date'          => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		$total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){
			
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;
			// var_dump($this->data['status_array']);exit();
		}else{
			$this->data['status_array'] = array();
		}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('inventry/stbMove', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('inventry/stbMove', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'inventry/stbMove.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
}
?>