<?php 
 /*
@File active_cas.php(Controller)
ADMIN ACTIVE_CAS PAGE
    This class manages the active cas numbers that are not linked with the customers 
    and are available.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerInventryActiveCAS extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the cas availability option in the dopdown list.
						It get all the unallocated cas number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin acitve_cas page showing all the cas number in a list.
*/
public function index() {
		$this->language->load('inventry/cas');
		 
		$this->document->setTitle($this->language->get('heading_title1'));
		
		$this->load->model('inventry/cas');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the cas number that are unallocated. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the unallocated/available cas number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title1'),
			'href'      => $this->url->link('inventry/active_cas', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['cass'] = array();

		
		$results = $this->model_inventry_cas->getActiveCAS();
		foreach ($results as $result) {			
			$this->data['cass'][] = array(
				'customer_id'    => $result['customer_id'],
				'CASNO'          => $result['cas_id'],
				'avail'          => ($result['is_avail'] ? $this->language->get('text_avail') : $this->language->get('text_not_avail')),
				'name'           => $result['name'],
				'smart_card'        => ($result['is_smart_card'] ? $this->language->get('text_sc') : $this->language->get('text_not_sc')),
			);	
		}				
		$this->data['heading_title'] = $this->language->get('heading_title1');

		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_casno'] = $this->language->get('column_casno');
		$this->data['column_avail'] = $this->language->get('column_avail');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'inventry/active_cas.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
?> 