<?php 
/*
@File header.php(Controller)
ADMIN HEADER PAGE
    This class manages the header of the admin page. This header contains all the menus on the page and the above area.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCommonHeader extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the header for the admin account which conatins the login account name if logged-in, all the menu's
						and sub-menu's to naviagete to different pages.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the header of the admin account.
*/	
	protected function index() {
		$this->data['title'] = $this->document->getTitle(); 
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = $this->data['base'] = HTTPS_SERVER;
		} else {
			$server = $this->data['base'] = HTTP_SERVER;
		}

		//================================= LOGO Change ========================================

		$this->data['name'] = $this->config->get('config_name');
		//Assigning logo		
		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
			$this->data['logo'] = str_replace("/admin","",$server). 'image/' . $this->config->get('config_logo');
			$this->data['icas_logo'] = str_replace("/admin","",$server). 'image/data/channels/icas_logo.png';
		} else {
			$this->data['logo'] = '';
			$this->data['icas_logo'] = str_replace("/admin","",$server). 'image/data/channel/icas_logo.png';
		}	
		//================================= LOGO Change ========================================
		
		$this->data['description'] = $this->document->getDescription();
		$this->data['keywords'] = $this->document->getKeywords();
		$this->data['links'] = $this->document->getLinks();	
		$this->data['styles'] = $this->document->getStyles();
		$this->data['scripts'] = $this->document->getScripts();
		$this->data['lang'] = $this->language->get('code');
		$this->data['direction'] = $this->language->get('direction');
		
		$this->language->load('common/header');

		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_broadcaster'] = $this->language->get('text_broadcaster');
		$this->data['text_affiliate'] = $this->language->get('text_affiliate');
		$this->data['text_attribute'] = $this->language->get('text_attribute');
		$this->data['text_attribute_group'] = $this->language->get('text_attribute_group');
		$this->data['text_backup'] = $this->language->get('text_backup');
		$this->data['text_banner'] = $this->language->get('text_banner');
		$this->data['text_catalog'] = $this->language->get('text_catalog');
		$this->data['text_category'] = $this->language->get('text_category');
		$this->data['text_confirm'] = $this->language->get('text_confirm');
		$this->data['text_country'] = $this->language->get('text_country');
		$this->data['text_coupon'] = $this->language->get('text_coupon');
		$this->data['text_currency'] = $this->language->get('text_currency');			
		$this->data['text_customer'] = $this->language->get('text_customer');
		$this->data['text_customer_group'] = $this->language->get('text_customer_group');
		$this->data['text_customer_field'] = $this->language->get('text_customer_field');
		$this->data['text_customer_ban_ip'] = $this->language->get('text_customer_ban_ip');
		$this->data['text_customer_region'] = $this->language->get('text_customer_region');
		$this->data['text_custom_field'] = $this->language->get('text_custom_field');
		$this->data['text_sale'] = $this->language->get('text_sale');
		$this->data['text_mobile_request'] = $this->language->get('text_mobile_request');
		$this->data['text_design'] = $this->language->get('text_design');
		$this->data['text_documentation'] = $this->language->get('text_documentation');
		$this->data['text_download'] = $this->language->get('text_download');
		$this->data['text_error_log'] = $this->language->get('text_error_log');
		// ----------------------------------------------------------------------
		$this->data['text_activation_log'] = $this->language->get('text_activation_log');
		$this->data['text_packagemodification_log'] = $this->language->get('text_packagemodification_log');
		$this->data['text_subscription_log'] = $this->language->get('text_subscription_log');
		// ----------------------------------------------------------------------
		$this->data['text_extension'] = $this->language->get('text_extension');
		$this->data['text_feed'] = $this->language->get('text_feed');
		$this->data['text_filter'] = $this->language->get('text_filter');
		$this->data['text_front'] = $this->language->get('text_front');
		$this->data['text_geo_zone'] = $this->language->get('text_geo_zone');
		$this->data['text_dashboard'] = $this->language->get('text_dashboard');
		$this->data['text_help'] = $this->language->get('text_help');
		$this->data['text_information'] = $this->language->get('text_information');
		$this->data['text_language'] = $this->language->get('text_language');
		$this->data['text_layout'] = $this->language->get('text_layout');
		$this->data['text_localisation'] = $this->language->get('text_localisation');
		$this->data['text_logout'] = $this->language->get('text_logout');
		$this->data['text_contact'] = $this->language->get('text_contact');
		$this->data['text_pay_activate'] = $this->language->get('text_pay_activate');
		$this->data['text_manager'] = $this->language->get('text_manager');
		$this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
		$this->data['text_broadcastergroup'] = $this->language->get('text_broadcastergroup');
		$this->data['text_module'] = $this->language->get('text_module');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_order'] = $this->language->get('text_order');
		$this->data['text_order_status'] = $this->language->get('text_order_status');
		
		$this->data['text_payment'] = $this->language->get('text_payment');
		$this->data['text_package'] = $this->language->get('text_package');

		$this->data['text_ppv'] = $this->language->get('text_ppv');
		//$this->data['text_product'] = $this->language->get('text_product');
		$this->data['text_channel'] = $this->language->get('text_channel'); 
		$this->data['text_nvod'] = $this->language->get('text_nvod'); 
		$this->data['text_pack_channel'] = $this->language->get('text_pack_channel'); 
		$this->data['text_reports'] = $this->language->get('text_reports');
	
		$this->data['text_broadcaster_wise_payment'] = $this->language->get('text_broadcaster_wise_payment');
		$this->data['text_report_sale_order'] = $this->language->get('text_report_sale_order');
		$this->data['text_report_sale_tax'] = $this->language->get('text_report_sale_tax');
		$this->data['text_report_sale_shipping'] = $this->language->get('text_report_sale_shipping');
		$this->data['text_report_sale_return'] = $this->language->get('text_report_sale_return');
		$this->data['text_report_sale_coupon'] = $this->language->get('text_report_sale_coupon');
		$this->data['text_report_product_viewed'] = $this->language->get('text_report_product_viewed');
		$this->data['text_report_product_purchased'] = $this->language->get('text_report_product_purchased');
		$this->data['text_report_customer_online'] = $this->language->get('text_report_customer_online');
		$this->data['text_report_customer_order'] = $this->language->get('text_report_customer_order');
		$this->data['text_report_customer_reward'] = $this->language->get('text_report_customer_reward');
		$this->data['text_report_customer_credit'] = $this->language->get('text_report_customer_credit');
		$this->data['text_report_affiliate_commission'] = $this->language->get('text_report_affiliate_commission');
		$this->data['text_transaction_status'] = $this->language->get('text_transaction_status');
		$this->data['text_report_sale_return'] = $this->language->get('text_report_sale_return');
		$this->data['text_report_product_viewed'] = $this->language->get('text_report_product_viewed');
		$this->data['text_report_customer_order'] = $this->language->get('text_report_customer_order');
		$this->data['text_as_on_date'] = $this->language->get('text_as_on_date');
		$this->data['text_as_on_date_pkg'] = $this->language->get('text_as_on_date_pkg');
		$this->data['text_as_on_date_prod'] = $this->language->get('text_as_on_date_prod');
		$this->data['text_review'] = $this->language->get('text_review');
		$this->data['text_return'] = $this->language->get('text_return');
		$this->data['text_return_action'] = $this->language->get('text_return_action');
		$this->data['text_return_reason'] = $this->language->get('text_return_reason');
		$this->data['text_return_status'] = $this->language->get('text_return_status');
		$this->data['text_support'] = $this->language->get('text_support'); 
		$this->data['text_shipping'] = $this->language->get('text_shipping');		
		$this->data['text_setting'] = $this->language->get('text_setting');
		$this->data['text_stock_status'] = $this->language->get('text_stock_status');
		$this->data['text_system'] = $this->language->get('text_system');
		$this->data['text_tax'] = $this->language->get('text_tax');
		$this->data['text_tax_class'] = $this->language->get('text_tax_class');
		$this->data['text_tax_rate'] = $this->language->get('text_tax_rate');
		$this->data['text_total'] = $this->language->get('text_total');
		$this->data['text_user'] = $this->language->get('text_user');
		$this->data['text_user_group'] = $this->language->get('text_user_group');

		$this->data['text_user_command_permission'] = $this->language->get('text_user_command_permission');
		$this->data['text_users'] = $this->language->get('text_users');
		$this->data['text_voucher'] = $this->language->get('text_voucher');
		$this->data['text_voucher_theme'] = $this->language->get('text_voucher_theme');
		$this->data['text_weight_class'] = $this->language->get('text_weight_class');
		$this->data['text_length_class'] = $this->language->get('text_length_class');
		$this->data['text_zone'] = $this->language->get('text_zone');
		$this->data['text_historical_subscription'] = $this->language->get('text_historical_subscription');
		$this->data['text_historical_subscription_summary'] = $this->language->get('text_historical_subscription_summary');
		$this->data['text_package_wise_channel_liist'] = $this->language->get('text_package_wise_channel_liist');
		$this->data['text_package_activation_deactivation_history'] = $this->language->get('text_package_activation_deactivation_history');
		$this->data['text_report1'] = $this->language->get('text_report1');
		$this->data['text_report2'] = $this->language->get('text_report2');
		$this->data['text_report3'] = $this->language->get('text_report3');
		$this->data['text_report4'] = $this->language->get('text_report4');
		$this->data['text_report5'] = $this->language->get('text_report5');
		$this->data['text_alacartewise_activeconnection'] = $this->language->get('text_alacartewise_activeconnection');
		$this->data['text_alacartewise_active_conn_summary'] = $this->language->get('text_alacartewise_active_conn_summary');
		$this->data['text_report6'] = $this->language->get('text_report6');
		$this->data['text_pkgwisechannellist'] = $this->language->get('text_pkgwisechannellist');
		$this->data['text_channelsubsageing'] = $this->language->get('text_channelsubsageing');
		$this->data['text_pkgsubsageing'] = $this->language->get('text_pkgsubsageing');
		$this->data['text_channel_list'] = $this->language->get('text_channel_list');
		$this->data['text_broadcasterwisechannellist'] = $this->language->get('text_broadcasterwisechannellist');
		$this->data['text_operator_wise_report'] = $this->language->get('text_operator_wise_report');
		$this->data['text_daily_active_stbvc'] = $this->language->get('text_daily_active_stbvc');
		$this->data['text_servicewise_actv_prod'] = $this->language->get('text_servicewise_actv_prod');
		$this->data['text_report7'] = $this->language->get('text_report7');
		$this->data['text_report8'] = $this->language->get('text_report8');
		$this->data['text_report9'] = $this->language->get('text_report9');
        $this->data['text_report10'] = $this->language->get('text_report10');
        $this->data['text_report11'] = $this->language->get('text_report11');
        $this->data['text_report12'] = $this->language->get('text_report12');
        $this->data['text_report13'] = $this->language->get('text_report13');
        $this->data['text_report14'] = $this->language->get('text_report14');
 		$this->data['text_report15'] = $this->language->get('text_report15');
 		$this->data['text_report16'] = $this->language->get('text_report16');
 		$this->data['text_report17'] = $this->language->get('text_report17');
 		$this->data['text_report18'] = $this->language->get('text_report18');
 		$this->data['text_report19'] = $this->language->get('text_report19');
 		$this->data['text_report20'] = $this->language->get('text_report20');
 		$this->data['text_general_channel'] = $this->language->get('text_general_channel');
 		$this->data['text_channel_summary'] = $this->language->get('text_channel_summary');
 		$this->data['text_report23'] = $this->language->get('text_report23');
        $this->data['text_inventry'] = $this->language->get('text_inventry');
        $this->data['text_stb'] = $this->language->get('text_stb');
        $this->data['text_active_stb'] = $this->language->get('text_active_stb');        
        $this->data['text_cas'] = $this->language->get('text_cas');
        $this->data['text_active_cas'] = $this->language->get('text_active_cas');
        $this->data['text_stb_cas'] = $this->language->get('text_stb_cas');
        $this->data['text_stb_move'] = $this->language->get('text_stb_move');
        $this->data['text_box_activation'] = $this->language->get('text_box_activation');
        $this->data['text_box_suspend'] = $this->language->get('text_box_suspend');

        $this->data['text_FingerPrint_EMM'] = $this->language->get('text_FingerPrint_EMM');
        $this->data['text_FingerPrint_ECM'] = $this->language->get('text_FingerPrint_ECM');        
        $this->data['text_Bmail'] = $this->language->get('text_Bmail');
        $this->data['text_UriConfig'] = $this->language->get('text_UriConfig');



        $this->data['text_pairing_details'] = $this->language->get('text_pairing_details');
        $this->data['text_quick_search'] = $this->language->get('text_quick_search');
        $this->data['text_search'] = $this->language->get('text_search');

        $this->data['text_bulk_report'] = $this->language->get('text_bulk_report');
		$this->data['text_Ala'] = $this->language->get('text_Ala');
		$this->data['text_general_channels'] = $this->language->get('text_general_channels');
		$this->data['text_stb_renewed'] = $this->language->get('text_stb_renewed');
		$this->data['text_subs_list_on_network'] = $this->language->get('text_subs_list_on_network');
		$this->data['text_subs_list_report'] = $this->language->get('text_subs_list_report');

		$this->data['text_subscription_closure'] = $this->language->get('text_subscription_closure');
		$this->data['text_new_log'] = $this->language->get('text_new_log');

		$this->data['text_summary_of_channels'] = $this->language->get('text_summary_of_channels');
		$this->data['text_auth_subs'] = $this->language->get('text_auth_subs');
		$this->data['text_cust_due_reactivation'] = $this->language->get('text_cust_due_reactivation');
		$this->data['text_ageing'] = $this->language->get('text_ageing');
		$this->data['text_location_stb'] = $this->language->get('text_location_stb');
		$this->data['text_active_deactive'] = $this->language->get('text_active_deactive');
		$this->data['text_active_deactive_history'] = $this->language->get('text_active_deactive_history');

		$this->data['text_customer_due_for_reactivation'] = $this->language->get('text_customer_due_for_reactivation');
        $this->data['text_stb_renewed_after_expiry'] = $this->language->get('text_stb_renewed_after_expiry');

        $this->data['text_commands'] = $this->language->get('text_commands');
        $this->data['text_product_subscription'] = $this->language->get('text_product_subscription');
        $this->data['text_package_subscription'] = $this->language->get('text_package_subscription');
        $this->data['text_ppv_subscription'] = $this->language->get('text_ppv_subscription');
        $this->data['text_ota_download'] = $this->language->get('text_ota_download');
        // $this->data['text_box_reset'] = $this->language->get('text_box_reset');
        $this->data['text_special_commands'] = $this->language->get('text_special_commands');
        $this->data['text_bmail'] = $this->language->get('text_bmail');
        $this->data['text_multilanguage_bmail'] = $this->language->get('text_multilanguage_bmail');
        $this->data['text_emm_fingerprint'] = $this->language->get('text_emm_fingerprint');
        $this->data['text_osd'] = $this->language->get('text_osd');
        $this->data['text_ecm_fingerprint'] = $this->language->get('text_ecm_fingerprint');
        $this->data['text_pin_reset'] = $this->language->get('text_pin_reset');
        $this->data['text_black_list'] = $this->language->get('text_black_list');
        $this->data['text_box_pairing'] = $this->language->get('text_box_pairing');

        $this->data['text_emm_command'] = $this->language->get('text_emm_command');
        $this->data['text_ecm_command'] = $this->language->get('text_ecm_command');
        $this->data['text_ecm_fingerprint'] = $this->language->get('text_ecm_fingerprint');
        $this->data['text_parental_ratting'] = $this->language->get('text_parental_ratting');
        $this->data['text_dect_subs_ageing'] = $this->language->get('text_dect_subs_ageing');

        $this->data['text_emm_command'] = $this->language->get('text_emm_command');
        $this->data['text_ecm_command'] = $this->language->get('text_ecm_command');
        $this->data['text_ecm_fingerprint'] = $this->language->get('text_ecm_fingerprint');
        $this->data['text_parental_ratting'] = $this->language->get('text_parental_ratting');

        $this->data['text_bulk_historical'] = $this->language->get('text_bulk_historical');
        $this->data['text_bulk_count'] = $this->language->get('text_bulk_count');        
        $this->data['text_bulk_activation'] = $this->language->get('text_bulk_activation');
        $this->data['text_bulk_deactivation'] = $this->language->get('text_bulk_deactivation');
        $this->data['text_bulk_product_subscription'] = $this->language->get('text_bulk_product_subscription');
        $this->data['text_bulk_package_subscription'] = $this->language->get('text_bulk_package_subscription');

        $this->data['text_bulk_ppv_subscription'] = $this->language->get('text_bulk_ppv_subscription');
        $this->data['text_bulk_product_desubscription'] = $this->language->get('text_bulk_product_desubscription');
        $this->data['text_bulk_package_desubscription'] = $this->language->get('text_bulk_package_desubscription');
        $this->data['text_bulk_ppv_desubscription'] = $this->language->get('text_bulk_ppv_desubscription');

        $this->data['text_subscriber_act_dct'] = $this->language->get('text_subscriber_act_dct');
        $this->data['text_dect_subs_ageing'] = $this->language->get('text_dect_subs_ageing');
		$this->data['text_package_wise_channel_details'] = $this->language->get('text_package_wise_channel_details');

		$this->data['text_broadcaster_wise_channel_list'] = $this->language->get('text_broadcaster_wise_channel_list');

		$this->data['text_package_wise_subscription'] = $this->language->get('text_package_wise_subscription');
		$this->data['text_product_wise_subscription'] = $this->language->get('text_product_wise_subscription');

		$this->data['text_package_wise_channel_count'] = $this->language->get('text_package_wise_channel_count');
		$this->data['text_a_la_carte_details'] = $this->language->get('text_a_la_carte_details');
		$this->data['text_subscription_count'] = $this->language->get('text_subscription_count');
		$this->data['text_locationwise_settopbox'] = $this->language->get('text_locationwise_settopbox');
        $this->data['text_product_subscription_count'] = $this->language->get('text_product_subscription_count');
        $this->data['text_stb_active_count'] = $this->language->get('text_stb_active_count');
        $this->data['text_stb_deactive_count'] = $this->language->get('text_stb_deactive_count');

        $this->data['text_stb_active_list'] = $this->language->get('text_stb_active_list');
        $this->data['text_stb_deactive_list'] = $this->language->get('text_stb_deactive_list');
        $this->data['text_product_desubscription_count'] = $this->language->get('text_product_desubscription_count');
        $this->data['text_package_subscription_count'] = $this->language->get('text_package_subscription_count');
        $this->data['text_package_desubscription_count'] = $this->language->get('text_package_desubscription_count');
        $this->data['text_ppv_subscription_count'] = $this->language->get('text_ppv_subscription_count');
        $this->data['text_locationwise_settopbox_count'] = $this->language->get('text_locationwise_settopbox_count');
        $this->data['text_bulk_activate'] = $this->language->get('text_bulk_activate');
        $this->data['text_bulk_deactivate'] = $this->language->get('text_bulk_deactivate');
        $this->data['text_bulk_subscription'] = $this->language->get('text_bulk_subscription');
        $this->data['text_bulk_subscription_resend'] = $this->language->get('text_bulk_subscription_resend');
        $this->data['text_bulk_stb_unpair'] = $this->language->get('text_bulk_stb_unpair');
        $this->data['text_bulk_desubscription'] = $this->language->get('text_bulk_desubscription');
        $this->data['text_bulk_resend_activate'] = $this->language->get('text_bulk_resend_activate');
        $this->data['text_bulk_commands'] = $this->language->get('text_bulk_commands');

        $this->data['text_report_onnet'] = $this->language->get('text_report_onnet');
        $this->data['text_blacklistrp'] = $this->language->get('text_blacklistrp');
        $this->data['text_report_suspendStbList'] = $this->language->get('text_report_suspendStbList');
        $this->data['text_report_activestblist'] = $this->language->get('text_report_activestblist');
        $this->data['text_pairunpairlistrp'] = $this->language->get('text_pairunpairlistrp');
        $this->data['text_packagewisesubscription'] = $this->language->get('text_packagewisesubscription');
        $this->data['text_report_deactivestblist'] = $this->language->get('text_report_deactivestblist');
        $this->data['text_report_prdsubslistasondate'] = $this->language->get('text_report_prdsubslistasondate');
        $this->data['text_report_pkgsubslistasondate'] = $this->language->get('text_report_pkgsubslistasondate');
        $this->data['text_report_broadcasterreport'] = $this->language->get('text_report_broadcasterreport');
        $this->data['text_report_broadcasterchannelwisereport'] = $this->language->get('text_report_broadcasterchannelwisereport');
        $this->data['text_report_mrpbroadcasterchannelwisereport'] = $this->language->get('text_report_mrpbroadcasterchannelwisereport');
        $this->data['text_report_broadcasteravgactivesubscriber'] = $this->language->get('text_report_broadcasteravgactivesubscriber');
        $this->data['text_stb_history'] = $this->language->get('text_stb_history');
 		$this->data['text_report_register'] = $this->language->get('text_report_register');
 		$this->data['text_account_info'] = $this->language->get('text_account_info');
 		$this->data['text_service_tunning'] = $this->language->get('text_service_tunning');

 		$this->data['text_force_nit_tunning']	= $this->language->get('text_force_nit_tunning');
 		$this->data['text_hdcp_signaling'] 		= $this->language->get('text_hdcp_signaling');
 		//===========Payment =============

 		$this->data['text_operator_balance'] = $this->language->get('text_operator_balance');
		$this->data['text_operator_payment'] = $this->language->get('text_operator_payment');
		$this->data['text_trans_history'] 	 = $this->language->get('text_trans_history');
		$this->data['text_trans_bylco'] 	 = $this->language->get('text_trans_bylco');
 		
 		//================================
		if (!$this->user->isLogged() || !isset($this->request->get['token']) || !isset($this->session->data['token']) || ($this->request->get['token'] != $this->session->data['token'])) {
			$this->data['logged'] = '';
			
			$this->data['home'] = $this->url->link('common/login', '', 'SSL');
		} else {

			$this->data['logged'] = sprintf($this->language->get('text_logged'), $this->user->getUserName());
	
			$this->data['home'] = $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['affiliate'] = $this->url->link('sale/affiliate', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['attribute'] = $this->url->link('catalog/attribute', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['attribute_group'] = $this->url->link('catalog/attribute_group', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['backup'] = $this->url->link('tool/backup', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['banner'] = $this->url->link('design/banner', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['category'] = $this->url->link('catalog/category', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['country'] = $this->url->link('localisation/country', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['coupon'] = $this->url->link('sale/coupon', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['currency'] = $this->url->link('localisation/currency', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['customer'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['customer_fields'] = $this->url->link('sale/customer_field', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['customer_group'] = $this->url->link('sale/customer_group', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['customer_ban_ip'] = $this->url->link('sale/customer_ban_ip', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['region'] = $this->url->link('sale/region', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['custom_field'] = $this->url->link('sale/custom_field', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['download'] = $this->url->link('catalog/download', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['error_log'] = $this->url->link('tool/error_log', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['feed'] = $this->url->link('extension/feed', 'token=' . $this->session->data['token'], 'SSL');	
			$this->data['filter'] = $this->url->link('catalog/filter', 'token=' . $this->session->data['token'], 'SSL');			
			$this->data['geo_zone'] = $this->url->link('localisation/geo_zone', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['information'] = $this->url->link('catalog/information', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['language'] = $this->url->link('localisation/language', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['layout'] = $this->url->link('design/layout', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['contact'] = $this->url->link('sale/contact', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['payActivate'] = $this->url->link('sale/payActivate', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['manager'] = $this->url->link('extension/manager', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['manufacturer'] = $this->url->link('catalog/manufacturer', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['broadcastergroup'] = $this->url->link('catalog/broadcastergroup', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['module'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['option'] = $this->url->link('catalog/option', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['order'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['mobile_request'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['order_status'] = $this->url->link('localisation/order_status', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['payment'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['package'] = $this->url->link('catalog/package', 'token=' . $this->session->data['token'], 'SSL');
			//$this->data['product'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['ppv'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['channel'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['nvod'] = $this->url->link('catalog/nvod', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['report_broad_payment'] = $this->url->link('report/broad_payment', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_sale_order'] = $this->url->link('report/sale_order', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_sale_tax'] = $this->url->link('report/sale_tax', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_sale_shipping'] = $this->url->link('report/sale_shipping', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_sale_return'] = $this->url->link('report/sale_return', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_sale_coupon'] = $this->url->link('report/sale_coupon', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_product_viewed'] = $this->url->link('report/product_viewed', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_customer']      = $this->url->link('report/customer', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_a_la_carte'] = $this->url->link('report/a_la_carte', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_alacartewise_activeconnection'] = $this->url->link('report/alacartewise_activeconnection', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_alacartewise_activeconnection_summary'] = $this->url->link('report/alacartewise_activeconnection_summary', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_historical_subscription_summary'] = $this->url->link('report/historical_subscription_summary', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_package_activation_deactivation_history'] = $this->url->link('report/package_activation_deactivation_history', 'token=' . $this->session->data['token'], 'SSL');
			
			
		    $this->data['report_particulardate'] = $this->url->link('report/particulardate', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_active_deactive'] = $this->url->link('report/active_deactive', 'token=' . $this->session->data['token'], 'SSL');
			//-------
			$this->data['report_active_deactive_history'] = $this->url->link('report/active_deactive_history', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['as_on_date'] = $this->url->link('bulk/asondate', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['as_on_date_pkg'] = $this->url->link('bulk/asondate_pkg', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['as_on_date_prod'] = $this->url->link('bulk/asondate_prod', 'token=' . $this->session->data['token'], 'SSL');
			//-------
			$this->data['report_ageing'] = $this->url->link('report/ageing', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_subscriberno'] = $this->url->link('report/subscriberno', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_pckgwisesubscribers'] = $this->url->link('report/pckgwisesubscribers', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_prdwisesubscribers'] = $this->url->link('report/prdwisesubscribers', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_pckgwisechannels'] = $this->url->link('report/pckgwisechannels', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_channel_list'] = $this->url->link('report/channel_list', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_broadcaster_wisechannellist'] = $this->url->link('report/broadcasterwisechannellist', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_daily_active_stbvc'] = $this->url->link('report/daily_active_stbvc', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_settopbox'] = $this->url->link('report/settopbox', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_prdsubslist'] = $this->url->link('report/prdsubslist', 'token=' . $this->session->data['token'], 'SSL');
			//-----
			$this->data['report_pckgwisechannellist'] = $this->url->link('report/pkgwisechannellist', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_blacklist'] = $this->url->link('report/blacklist', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_subnetwork'] = $this->url->link('report/subsnetworkreport', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_stbnetwork'] = $this->url->link('report/stbnetworkreport', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_casnetwork'] = $this->url->link('report/casnetworkreport', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['package_list_report'] = $this->url->link('report/packagereport', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['package_list'] = $this->url->link('report/packagelist', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['subscriber_list_report'] = $this->url->link('report/subslistreport', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['subs_list_onnet'] = $this->url->link('report/subslistonnet', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['subs_report_product_wise_subscriber_list'] = $this->url->link('report/product_wise_subscriber_list', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_prdgeneral'] = $this->url->link('report/prdgeneral', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_prdsummary'] = $this->url->link('report/prdsummary', 'token=' . $this->session->data['token'], 'SSL');
			//------
			$this->data['report_product_purchased'] = $this->url->link('report/product_purchased', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_customer_online'] = $this->url->link('report/customer_online', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_customer_order'] = $this->url->link('report/customer_order', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_customer_reward'] = $this->url->link('report/customer_reward', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_customer_credit'] = $this->url->link('report/customer_credit', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_affiliate_commission'] = $this->url->link('report/affiliate_commission', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['transaction_status'] = $this->url->link('report/transaction_status', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['inventry_stb'] = $this->url->link('inventry/stb', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['inventry_cas'] = $this->url->link('inventry/cas', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['inventry_stb_cas'] = $this->url->link('inventry/stb_cas', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['inventry_stb_move'] = $this->url->link('inventry/stbMove', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['inventry_active_stb'] = $this->url->link('inventry/active_stb', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['inventry_active_cas'] = $this->url->link('inventry/active_cas', 'token=' . $this->session->data['token'], 'SSL');
            //$this->data['inventry_box_activation'] = $this->url->link('inventry/box_activation', 'token=' . $this->session->data['token'], 'SSL');

      //       $this->data['Ala'] = $this->url->link('bulk/AlaCarteWiseActiveConnectionSummary', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['general_channels'] = $this->url->link('bulk/GeneralChannels', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['stb_renewed'] = $this->url->link('bulk/StbRenewedAfterExpiry', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['subs_list_on_network'] = $this->url->link('bulk/SubscriberListOnNetwork', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['subs_list_report'] = $this->url->link('bulk/SubscriberListReport', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['summary_of_channels'] = $this->url->link('bulk/SummaryOfChannels', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['auth_subs'] = $this->url->link('bulk/TAS', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['cust_due_reactivation'] = $this->url->link('bulk/CustomerReactivation', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['ageing'] = $this->url->link('bulk/SubscriberAgeing', 'token=' . $this->session->data['token'], 'SSL');
		    // $this->data['location_stb'] = $this->url->link('bulk/STB_Location', 'token=' . $this->session->data['token'], 'SSL');
      //       $this->data['active_deactive'] = $this->url->link('bulk/HistoricalData', 'token=' . $this->session->data['token'], 'SSL');
	    	// $this->data['active_deactive_history'] = $this->url->link('bulk/ActivationDeactivationHistory', 'token=' . $this->session->data['token'], 'SSL');

            $this->data['inventry_box_activation'] = $this->url->link('commands/box_activation', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['inventry_box_suspend'] = $this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['product_subscription'] = $this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['package_subscription'] = $this->url->link('commands/package_subscription', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['ppv_subscription'] = $this->url->link('commands/ppv_subscription', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['ota_download'] = $this->url->link('commands/ota_download', 'token=' . $this->session->data['token'], 'SSL');
			//$this->data['box_reset'] = $this->url->link('commands/box_reset', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['special_commands'] = $this->url->link('commands/special_commands', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['bmail'] = $this->url->link('commands/bmail', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['multilanguage_bmail'] = $this->url->link('commands/multilanguage_bmail', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['emm_fingerprint'] = $this->url->link('commands/emm_fingerprint', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['osd'] = $this->url->link('commands/osd', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['ecm_fingerprint'] = $this->url->link('commands/ecm_fingerprint', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['pin_reset'] = $this->url->link('commands/pin_reset', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['black_list'] = $this->url->link('commands/black_list', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['box_pairing'] = $this->url->link('commands/box_pairing', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['ecm_fingerprint'] = $this->url->link('commands/ecm_fingerprint', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['parental_ratting'] = $this->url->link('commands/parental_rating', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['account_info'] = $this->url->link('commands/account_info', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['service_tune'] = $this->url->link('commands/service_tunning', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['force_nit_tunning'] = $this->url->link('commands/force_nit_tunning', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['hdcp_signaling'] = $this->url->link('commands/hdcp_signaling', 'token=' . $this->session->data['token'], 'SSL');




			$this->data['historicalactivation'] = $this->url->link('bulk/historicalactivation', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['bulk_deactivation'] = $this->url->link('bulk/historicaldeactivation', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['bulk_product_subs'] = $this->url->link('bulk/productsubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_package_subs'] = $this->url->link('bulk/packagesubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_ppv_subs'] = $this->url->link('bulk/ppvsubscription', 'token=' . $this->session->data['token'], 'SSL');


	    	$this->data['bulk_product_desubs'] = $this->url->link('bulk/productdesubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_package_desubs'] = $this->url->link('bulk/packagedesubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_ppv_desubs'] = $this->url->link('bulk/ppvdesubscription', 'token=' . $this->session->data['token'], 'SSL');
	
			$this->data['subs_actv_deactv'] = $this->url->link('bulk/actvdeactvsubscount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['deactv_subs_ageing'] = $this->url->link('bulk/deactvsubsageing', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['locationwise_settopbox'] = $this->url->link('bulk/locationwiseSettopbox', 'token=' . $this->session->data['token'], 'SSL');
			
	    	$this->data['report_customer_due_for_reactivation'] = $this->url->link('bulk/customer_due_for_reactivation', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['report_stb_renewed_after_expiry'] = $this->url->link('bulk/stb_renewed_after_expiry', 'token=' . $this->session->data['token'], 'SSL');
			

			$this->data['stb_active_cnt'] = $this->url->link('bulk/stbActiveCount', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['stb_deactive_cnt'] = $this->url->link('bulk/stbDeActiveCount', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['stb_active_list'] = $this->url->link('bulk/stbActiveList', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['stb_deactive_list'] = $this->url->link('bulk/stbDeActiveList', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['stb_wisechangeofpkgprod'] = $this->url->link('bulk/stbwisechangeofpkgprod', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['product_subs_cnt'] = $this->url->link('bulk/productSubscriptionCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['product_desubs_cnt'] = $this->url->link('bulk/productDeSubscriptionCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['package_subs_cnt'] = $this->url->link('bulk/packageSubscriptionCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['package_desubs_cnt'] = $this->url->link('bulk/packageDeSubscriptionCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['ppv_subs_cnt'] = $this->url->link('bulk/ppvSubscriptionCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['stb_loc_cnt'] = $this->url->link('bulk/locationwiseSettopboxCount', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__stb_activation'] = $this->url->link('bulk/stbBulkActivation', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__stb_deactivation'] = $this->url->link('bulk/stbBulkDeactivation', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__stb_subscription'] = $this->url->link('bulk/stbBulkSubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__stb_subscription_resend'] = $this->url->link('bulk/stbBulkSubscriptionResend', 'token=' . $this->session->data['token'], 'SSL');
            $this->data['bulk__stb_unpair'] = $this->url->link('bulk/stbBulkUnpair', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__stb_desubscription'] = $this->url->link('bulk/stbBulkDeSubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__subscriptiononstb'] = $this->url->link('bulk/subsonstb', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk__resend_stb_activation'] = $this->url->link('bulk/stbBulkResendActivation', 'token=' . $this->session->data['token'], 'SSL');


	    	$this->data['bulk_pckgwisechannellist'] = $this->url->link('bulk/pkgwisechannellist', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_channelsubsageing'] = $this->url->link('bulk/channelsubsageing', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_pkgsubsageing'] = $this->url->link('bulk/pkgsubsageing', 'token=' . $this->session->data['token'], 'SSL');
	    	
	    	$this->data['bulk_broadcasterwisechannellist'] = $this->url->link('bulk/broadcasterwisechannellist', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['bulk_pckgwisesubscription'] = $this->url->link('bulk/pkgwisesubscription', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['bulk_productwisesubscription'] = $this->url->link('bulk/productwisesubscription', 'token=' . $this->session->data['token'], 'SSL');


	    	$this->data['bulk_pckgwisechannelcount'] = $this->url->link('bulk/pkgwisechannelcount', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['bulk_a_la_carte_details'] = $this->url->link('bulk/a_la_carte_price', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['subscriber_list_report'] = $this->url->link('bulk/subslistreport', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['package_wise_subscription_report'] = $this->url->link('bulk/packagewisesubscription', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['subscription_closure'] = $this->url->link('bulk/subscriptionclosure', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['new_logs'] = $this->url->link('bulk/nlog', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['new_activation_logs'] = $this->url->link('bulk/nactivationlog', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['new_subscription_logs'] = $this->url->link('bulk/nsubscriptionlog', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['new_pkgmodification_logs'] = $this->url->link('bulk/packageModificationLogs', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['productmodification_logs'] = $this->url->link('bulk/productModificationLogs', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['subs_list_onnet'] = $this->url->link('bulk/subslistonnet', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['blacklist_subs'] = $this->url->link('bulk/blacklist', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['suspendStbList'] = $this->url->link('bulk/suspendStbList', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['pair_unpair_list'] = $this->url->link('bulk/pair_unpair_list', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['active_stb_list'] = $this->url->link('bulk/activestblist', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['deactive_stb_list'] = $this->url->link('bulk/deactivestblist', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['prdsubslistasondate'] = $this->url->link('bulk/prdsubslistasondate', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['pkgsubslistasondate'] = $this->url->link('bulk/pkgsubslistasondate', 'token=' . $this->session->data['token'], 'SSL');

	    	$this->data['broadcasterreport'] = $this->url->link('bulk/broadcasterreport', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['broadcasterchannelwisereport'] = $this->url->link('bulk/broadcasterchannelwisereport', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['mrpbroadcasterchannelwisereport'] = $this->url->link('bulk/mrpbroadcasterchannelwisereport', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['broadcasteravgactivesubscriber'] = $this->url->link('bulk/broadcaster_avg_active_subscriber', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['operator_wise_report'] = $this->url->link('bulk/operator_wise_report', 'token=' . $this->session->data['token'], 'SSL');	

	    	$this->data['stbHistory'] = $this->url->link('bulk/stbHistory', 'token=' . $this->session->data['token'], 'SSL');
	    	
	    	$this->data['bulk_subnetwork'] = $this->url->link('bulk/subsnetworkreport', 'token=' . $this->session->data['token'], 'SSL');	
	    	$this->data['bulk_servicewiseTotActProd'] = $this->url->link('bulk/serviceWiseTotActiveProducts', 'token=' . $this->session->data['token'], 'SSL');	
	    	$this->data['activation_log'] = $this->url->link('bulk/activation_log', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['subscription_log'] = $this->url->link('bulk/subscription_log', 'token=' . $this->session->data['token'], 'SSL');
	    	$this->data['packagemodification_log'] = $this->url->link('bulk/packagemodification_log', 'token=' . $this->session->data['token'], 'SSL');
//$this->data['pairing_details']= $this->url->link('pairing/home','token='.$this->session->data['token'],'SSL');
            $this->data['pairing_assign']= $this->url->link('pairing/create','token='.$this->session->data['token'],'SSL');
            $this->data['pairing_release']= $this->url->link('pairing/release','token='.$this->session->data['token'],'SSL');

			$this->data['review'] = $this->url->link('catalog/review', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['return'] = $this->url->link('sale/return', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['return_action'] = $this->url->link('localisation/return_action', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['return_reason'] = $this->url->link('localisation/return_reason', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['return_status'] = $this->url->link('localisation/return_status', 'token=' . $this->session->data['token'], 'SSL');			
			$this->data['shipping'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['setting'] = $this->url->link('setting/store', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['store'] = HTTP_CATALOG;
			$this->data['stock_status'] = $this->url->link('localisation/stock_status', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['tax_class'] = $this->url->link('localisation/tax_class', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['tax_rate'] = $this->url->link('localisation/tax_rate', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['total'] = $this->url->link('extension/total', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['user'] = $this->url->link('user/user', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['user_group'] = $this->url->link('user/user_permission', 'token=' . $this->session->data['token'], 'SSL');

			$this->data['user_command_permission'] = $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['voucher'] = $this->url->link('sale/voucher', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['voucher_theme'] = $this->url->link('sale/voucher_theme', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['weight_class'] = $this->url->link('localisation/weight_class', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['length_class'] = $this->url->link('localisation/length_class', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['zone'] = $this->url->link('localisation/zone', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['search'] = $this->url->link('quick/search', 'token=' . $this->session->data['token'], 'SSL');


			$this->data['operator_payment'] = $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['transaction_history'] = $this->url->link('bill/transaction', 'token=' . $this->session->data['token'], 'SSL');
			$this->data['bylco_substrans'] = $this->url->link('bill/bylcosubstrans', 'token=' . $this->session->data['token'], 'SSL');
			

			$this->data['stores'] = array();
			
			$this->load->model('setting/store');
			
			$results = $this->model_setting_store->getStores();
			
			foreach ($results as $result) {
				$this->data['stores'][] = array(
					'name' => $result['name'],
					'href' => $result['url']
				);
			}			
		}
		
		$this->template = 'common/header.tpl';
		
		$this->render();
	}
}
?>