<?php
/*
@File footer.php(Controller)
ADMIN FOOTER PAGE
    This class manages the footer of the store. 
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCommonFooter extends Controller {   
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the footer page containing hyperlink to stores information and terms & conditions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin's footer page.
*/	
	protected function index() {
		$this->language->load('common/footer');
		
		$this->data['text_footer'] = sprintf($this->language->get('text_footer'), VERSION);
		
		if (file_exists(DIR_SYSTEM . 'config/svn/svn.ver')) {
			$this->data['text_footer'] .= '.r' . trim(file_get_contents(DIR_SYSTEM . 'config/svn/svn.ver'));
		}
		
		$this->template = 'common/footer.tpl';
	
    	$this->render();
  	}
}
?>