<?php 
 /*
@File product_subscription.php(Controller)
ADMIN Product Subscription PAGE
    This class manages the all the Product Subscription list and status.
    

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ControllerCommandsProductSubscription extends Controller {
	private $error = array();

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
public function index() {
		$this->language->load('commands/product_subscription');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/product_subscription');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the transaction list.
*/
public function getList() {	
	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}  			
		
   		$this->data['insert'] = $this->url->link('commands/product_subscription/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');
		
		$this->data['product_subscriptions'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit'),
		);


		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		
		$total = 0;
		$this->data['product_subscriptions'] = array();
		$total = $this->model_commands_product_subscription->getTotalProductSubscription($data);
		$results = $this->model_commands_product_subscription->getSubscribeProducts($data);
		foreach ($results as $result) 
		{	
			
			$resend = $this->url->link('commands/product_subscription/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			$de_activation = $this->url->link('commands/product_subscription/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			$pname = $this->model_commands_product_subscription->getProductsName($result['product_id']);
			$this->data['product_subscriptions'][] = array(
				'id'  		 	 => $result['id'],
				'tx_id'  		 => $result['tx_id'],
				'name'           => (($pname==NULL)?"No Channel":$pname['name']),
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'type'         	 => (($result['cmd_id']==10)?'Subscription' :'De-subscription'),
				'start'          => $result['modify_date'],
				'expire'         => ($result['exp_date'])?$result['exp_date']:'N/A',
				'cmd_id'         => $result['cmd_id'],
				'stb_no'         => $result['STBNO'],
				'resend'         => $resend,
				'de_activation'  => $de_activation,
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_cust_id'] = $this->language->get('column_cust_id');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_expire'] = $this->language->get('column_expire');
		$this->data['column_type'] = $this->language->get('column_type');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/product_subscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}




	 /*
	FUNCTION NAME 		-	resend
	DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
							added/uploaded earlier. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
	*/
   
  	public function resend() {

		
		$this->language->load('commands/product_subscription');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/product_subscription');
  		$obj = new restapi();
  		
    	if($this->validateResend())	{
     		$transaction_details=$this->model_commands_product_subscription->getTransactionDetails($this->request->get['id']);
     		$existChannel=$this->model_commands_product_subscription->getChannelExist($transaction_details["product_id"]);
     		if($existChannel){
	     		$end_time=$transaction_details["exp_date"];
	     		$product_id=$transaction_details["product_id"];	     		
	     		$product_no=$this->model_commands_product_subscription->getProductNo($product_id);
	     		// -------------------------------------------------------------------------
	     			$is_nvod = $this->model_commands_product_subscription->isNvod($product_no);
	     		// -------------------------------------------------------------------------
	     		$customer_id=$transaction_details['user_id'];
	     		$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
	    		$user_id=$transaction_details['api_user_id'];
	    		$target_lvl=1;
	    		$trans_id=$transaction_details['tx_id']; 
	    		$cmd_id=$transaction_details['cmd_id'];
	    		
			  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl."&product_no=".$product_no."&is_nvod=".$is_nvod['is_nvod'];
			  	$method ="POST";
				$uri=KMS_API."/Resend";		
				$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				// var_dump($data);exit();
				$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
			    //Process API response and add to db 
			    $response=json_decode($apiresult);			
			    $error=true;
			    $errorMsg='';
			    $apimessage="";

			    foreach ($response as $key => $value) {
			    	switch ($key) {
			    		case 'error':
			    			$error=$value;	
			    		break;
			    		case 'id':
			    			$id=$value;	
			    		break;
			    		case 'message':
			    			$apimessage=$value;	
			    		break;
			    		case 'mq_response':
			    			$curlresponse=$value;	
			    		break;
			    		default:
			    			$errorMsg=$errorMsg." ".$key.":".$value;		
			    		break;
			    	}
				}
				$log_target_level = "Individual";
				$log_target = $this->model_commands_product_subscription->getStbno($transaction_details['user_id']);
				$getProdName = $this->model_commands_product_subscription->getProductsName($transaction_details["product_id"]);
				$log_product_name = $getProdName['name'];
				
				$ack_is=-1;$nack_is=-1;
				if(!$error)	{
					$resend_status = 1;
					$commandid =10;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,$product_no,"RESEND PRODUCT SUBS.",$resend_status,$commandid);
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK' )
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$resp=split('`', $curlresponse);
					$payload=$user_id."#".$cmd_id."#".$trans_id;
					$target=1;
					$targetdata=0;
					$results = $this->model_commands_product_subscription->addToCasOpTransanction($target,$customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$product_id,$end_time,$transaction_details['order_id'],$operator_id,$log_target);
					$this->session->data['success']=$apimessage;
				} else {
					$errorMsg=$errorMsg."  ".$apimessage;
					$this->session->data['warning']=$errorMsg;
				}
		}else{
			$this->session->data['warning']=$this->language->get('deleted_product');
			}
			$this->redirect($this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}else{
			$this->session->data['warning'] = $this->error['warning'];
     		$this->redirect($this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL'));
     	}
  	}  

/*
FUNCTION NAME 		-	deActivation
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function deActivation() {
		$this->language->load('commands/product_subscription');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/product_subscription');
  		$obj = new restapi();
  		
    	if($this->validate()) {      		    		    		
     		$transaction_details = $this->model_commands_product_subscription->getTransactionDetails($this->request->get['id']);
     		$expiry_date = $this->model_commands_product_subscription->getMaxExpiry($transaction_details["user_id"],$transaction_details["product_id"]);
     		// var_dump($transaction_details["exp_date"]);exit();
     		/************************* Check Product Expiry **************************/
			
     		/************************* Check Product Expiry **************************/
     		$existChannel=$this->model_commands_product_subscription->getChannelExist($transaction_details["product_id"]);
     		if($existChannel){
	     		$product_id=$transaction_details["product_id"];
	     		$product_no=$this->model_commands_product_subscription->getProductNo($product_id);
	     		$customer_id=$transaction_details['user_id'];
	    		$user_id=$transaction_details['api_user_id'];
				$kms_product_id = $this->model_commands_product_subscription->getKmsProductId($product_id);
    			$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
    			$target_lvl=1;
    		// $trans_id=$transaction_details['tx_id'];
	    		$stb_no = $this->model_commands_product_subscription->getStbno($customer_id);
	    		$cmd_id=$transaction_details['cmd_id'];
    		
			  	$data="stb_no=". $stb_no."&command_id=".$cmd_id."&target=".$kms_product_id."&target_level=".$target_lvl."&product_no=".$product_no;
				
			  	$method ="POST";
				$uri=KMS_API."/Disable";		
				$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				
				$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
			    //Process API response and add to db 
			    $response=json_decode($apiresult);			
			    $error=true;
			    $errorMsg='';
			    $apimessage="";

			    foreach ($response as $key => $value) {
			    	foreach ($response as $key => $value) {
				    	switch ($key) {
				    		case 'error':
				    			$error=$value;	
				    		break;
				    		case 'id':
				    			$id=$value;	
				    		break;
				    		case 'disble_command_id':
				    			$cmd_id=$value;
				    		break;
				    		case 'message':
				    			$apimessage=$value;	
				    		break;
				    		case 'mq_response':
				    			$curlresponse=$value;	
				    		break;
				    		default:
				    			$errorMsg=$errorMsg." ".$key.":".$value;		
				    		break;
				    	}
					}	
					if($key=='error'&&$value==false)
					{
						$error=false;
					}if($key=='error'&&$value==true)
					{
						$error=true;	
					}
					if($key=='id')
					{
						$id=$value;
					}
					if($key=='mq_response')
					{
						$curlresponse=$value;
					}if($key=='message')
					{
						$apimessage=$value;			
					}if($key=='disble_command_id')
					{
						$cmd_id=$value;			
					}if($key!='id' && $key!='error' && $key!='message')
					{
						$errorMsg=$errorMsg." ".$key.":".$value;
					}
				}
				$log_target_level = "Individual";
				$log_target = $this->model_commands_product_subscription->getStbno($transaction_details['user_id']);
				$getProdName = $this->model_commands_product_subscription->getProductsName($transaction_details["product_id"]);
				$log_product_name = $getProdName['name'];
				
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{	
					$resend_status = 0;
					$commandid = 11;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,$product_no,"PRODUCT De-SUBS.",$resend_status,$commandid);
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					$resp=explode('`', $curlresponse);
					$payload=$stb_no."#".$cmd_id."#".$product_id;
					$target=1;
					$targetdata=0;
				
					// -----------For product subs count report-------------------------------
					// $currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
					// $current_date = $currDate->format('Y-m-d H:i:s');
					// if($expiry_date['exp_date'] > $current_date){
					// 	$updateExp = $this->model_commands_product_subscription->updateExpiry($transaction_details["user_id"],$transaction_details["product_id"]);
					// }
					// ----------------------------------------------------------------------

					if($ack_is==1){
						$this->model_commands_product_subscription->updateExpiryFlag($transaction_details['product_id'], $transaction_details['user_id']);
						$this->model_commands_product_subscription->getIdsForExpiryUpdate($transaction_details["user_id"],$transaction_details["product_id"],$this->request->get['id']);
						if($this->model_commands_product_subscription->isDeSubscribed($customer_id,$stb_no,$product_id)==10){
							$this->model_commands_product_subscription->InsertUpdateSubscriptionDesubscriptionExpiryForDesubscription($customer_id,$cmd_id,$id,$ack_is,$operator_id,$stb_no,$product_id);
						}
					}
					$results = $this->model_commands_product_subscription->addToCasOpTransanction($target,$customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$product_id,NULL,0,$operator_id,$log_target);
					$this->session->data['success']=$apimessage;
				}else{
					$errorMsg=$errorMsg."  ".$apimessage;
					$this->session->data['warning']=$errorMsg;
				}
			}else{
				$this->session->data['warning']=$this->language->get('deleted_product');
			}
		}else{
			$this->session->data['warning'] = "Warning: Subscription Expired!.";
		}
		if(isset($this->error['warning'])){
			$this->session->data['warning'] = $this->error['warning'];
		}
     	$this->redirect($this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		
  	}  

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_chip_no'] = $this->language->get('entry_chip_no');
    	$this->data['entry_confirm_chip_no'] = $this->language->get('entry_confirm_chip_no');
 	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['chip_no'])) {
			$this->data['error_chip_no'] = $this->error['chip_no'];
		} else {
			$this->data['error_chip_no'] = '';
		}

		if (isset($this->request->post['chip_no'])) {
      		$this->data['chip_no'] = $this->request->post['chip_no'];
		}else {
      		$this->data['chip_no'] = '';
    	}

    	if (isset($this->request->post['confirm_chip_no'])) {
      		$this->data['confirm_chip_no'] = $this->request->post['confirm_chip_no'];
		}else {
      		$this->data['confirm_chip_no'] = '';
    	}

    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/product_subscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/product_subscription/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/product_subscription/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/product_subscription/', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	$this->data['token'] = $this->session->data['token'];
	
		$this->template = 'commands/product_subscription_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/product_subscription')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('commands/product_subscription');
    	$stb_no=$post['stb_no'];
    	if($stb_no){
    		$result = $this->model_commands_product_subscription->isSTBPaired($stb_no);
	    	if ((strlen($stb_no)!=12)){
	            $this->error['stb_no'] = $this->language->get('error_length');
	       	}
	        elseif(!$result)
	    	{
	    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
	    	}
      	}
		
		if(strcmp($post['chip_no'], $post['confirm_chip_no'])!==0)
		{
			$this->error['chip_no'] = $this->language->get('error_chip_no');
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validates the details of the transaction content . 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/product_subscription')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$user_id = $this->model_commands_product_subscription->getUserId($this->request->get['id']); 
		$product_id = $this->model_commands_product_subscription->getProductId($this->request->get['id']); 
		// var_dump($user_id);var_dump($product_id);exit();
		$result = $this->model_commands_product_subscription->canDeactive($this->request->get['id'],$user_id,$product_id);
		
		if(!$result){
			$this->error['warning'] = 'Warning: Subscription Expired, can not desubscribe!';		
		}
		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		
		$stb_no = $this->model_commands_product_subscription->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_product_subscription->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = 'Warning: STB Blacklisted!!';		
	 		}

	 		$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		}
	 	}
		
		// ---------------------------------------------------------------------------------
		if (!$this->error && $result) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

  	protected function validateResend() {
    	if (!$this->user->hasPermission('modify', 'commands/product_subscription')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	$command_type = explode("/",$this->request->get["route"]);
    	$result = 1;
		if(strcmp("deActivation", $command_type[2])){
			$result = $this->model_commands_product_subscription->canResend($this->request->get['id']);
			if($result==0){
				$this->error['warning'] = "Warning: Can't Resend! Channel/Product subscription completed.";
			}
		}

		// -------------------CHECK IF BOX IS BLACKLISTED------------------------------------
		
		$stb_no = $this->model_commands_product_subscription->getStbNoFromId($this->request->get['id']);
		
		if(strcmp($stb_no,'0')){
	 		$is_blacklist = $this->model_commands_product_subscription->isBlacklist($stb_no);
	 		if($is_blacklist==1){
	 			$this->error['warning'] = 'Warning: STB Blacklisted!!';		
	 		}

	 		$is_suspend = $this->user->isStbSuspend($stb_no);
	 		if($is_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB is suspended, Please resume first.!');		
	 		}

	 		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
	 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
	 		if($is_lco_suspend==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
	 		}

	 		$is_RMA = $this->user->isStbRMA($stb_no);
	 		if($is_RMA==1){
	 			$this->error['warning'] = $this->language->get('Warning: STB in RMA state.!');		
	 		}
	 	}
		
		// ---------------------------------------------------------------------------------

		if (!$this->error && $result) {
	  		return true;
		} else {
	  		return false;
		}
  	} 

  	/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
	
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/product_subscription');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_product_subscription->getSTBs($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'stb_id' 	=> $result['id'], 
					'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		$sort_order = array();
	  
		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['stb_no'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}
	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$product_no,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command."\t\t".$subscription_name);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);
         // ------------------------------only subscription log------------------------------------
        $log_file = fopen(DIR_LOGS."subscription_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status,$product_no);
        // -----------------------------------------------------------------------------------------
    }
 }
?> 