<?php 
 /*
@File hdcp_signaling.php(Controller)
ADMIN HDCP Signaling Print PAGE
    This class manages the all the EmmFingerprint  status.
    

@Author Ravi Ranjan 
@date 13 Dec. 2016
*/
class ControllerCommandsHDCPSignaling extends Controller {
	private $error = array();

	/*
	FUNCTION NAME 		-	index
	DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
							It get all the stb number list and displays it here.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
	*/
	public function index() {
			$this->language->load('commands/hdcp_signaling');
			 
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('commands/hdcp_signaling');
	    	$this->getList();
	  	}


		/*
		FUNCTION NAME 		-	getList
		DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
								database and make a list for it.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Renders the transaction list.
		*/
		public function getList() {	
			
				if (isset($this->request->get['page'])) {
					$page = $this->request->get['page'];
				} else {
					$page = 1;
				}
						
				$url = '';
				if (isset($this->request->get['filter_value'])) {
					$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
				}
		  		$this->data['breadcrumbs'] = array();
		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
		      		'separator' => false
		   		);

		   		$this->data['breadcrumbs'][] = array(
		       		'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('commands/hdcp_signaling', 'token=' . $this->session->data['token'] . $url, 'SSL'),
		      		'separator' => ' :: '
		   		);

		  			
				
		   		$this->data['insert'] = $this->url->link('commands/hdcp_signaling/insert', 'token=' . $this->session->data['token'], 'SSL');
				$this->data['button_insert'] = $this->language->get('button_insert');
		    	$this->data['button_delete'] = $this->language->get('button_delete');
		    	$this->data['button_filter'] = $this->language->get('button_filter');

				$this->data['bmails'] = array();
				$data = array(
					'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
					'limit'           => $this->config->get('config_admin_limit')
				);

				if (isset($this->request->post['target_level'])) {
					$this->data['target_level'] = $this->request->post['target_level'];
				} else if (isset($this->request->get['target_level'])) {
					$this->data['target_level'] = $this->request->get['target_level'];
					$this->session->data['target_level']=$this->data['target_level'];
				}else {
					$this->data['target_level'] =-1;
				}

				if(isset($this->session->data['target_level']))
					$this->data['target_level']=$this->session->data['target_level'];
				
				if (isset($this->request->get['filter_value'])) {
					$this->data['filter_value'] = $this->request->get['filter_value'];
					$data['filter_value']=$this->request->get['filter_value'];
					$data['target_level']=$this->data['target_level'];
				} else if (isset($this->request->post['filter_value'])) {
					$this->data['filter_value'] = $this->request->post['filter_value'];
				} else{
					$this->data['filter_value'] = '';
					
				}
				$total=0;
				if (($this->request->server['REQUEST_METHOD'] == 'GET')&& (isset($this->request->get['target_level']))||(isset($data['target_level']) && $data['target_level']!=-1))
				{
					$total = $this->model_commands_hdcp_signaling->getTotalServiceTunning($data);

					$results = $this->model_commands_hdcp_signaling->getServiceTunning($data);
					// var_dump($results);exit();
					foreach ($results as $result) 
					{	
						$resend = $this->url->link('commands/hdcp_signaling/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
						$de_activation = $this->url->link('commands/hdcp_signaling/deActivation', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
						
						$this->data['service_tunnings'][] = array(
							'id'  		 	 => $result['id'],
							'tx_id'  		 => $result['tx_id'],
							'stb_no'         => ($data['target_level']==1)?$result['STBNO']:(($data['target_level']==2)?'Global':(($data['target_level']==3)?$result['region_name']:$result['name'])),
							'name' 		     => $result['name'],
							'lcn'    		 => $result['payload'],
							'trigger_on'     => $result['modify_date'],
							'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
							'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
						);	
					}
				}

				$this->data['targets']=array(
					'-1' => 'Please select',
					 '1'  => 'Individual',
					 '2'  => 'Global',
					 '3'  => 'Region',
					 '4'  => 'Group');

				$this->data['heading_title'] = $this->language->get('heading_title');
				$this->data['entry_stb'] = $this->language->get('entry_stb');
				$this->data['column_lcn'] = $this->language->get('column_lcn');
				$this->data['column_name'] = $this->language->get('column_name');
				
				$this->data['column_target'] = $this->language->get('column_target');
				$this->data['column_tx_id'] = $this->language->get('column_tx_id');
				$this->data['column_trigger'] = $this->language->get('column_trigger');
				$this->data['column_resp'] = $this->language->get('column_resp');
				$this->data['column_type'] = $this->language->get('column_type');

				$this->data['text_no_results'] = $this->language->get('text_no_results');
				$this->data['token'] = $this->session->data['token'];

				if (isset($this->error['warning'])) {
					$this->data['error_warning'] = $this->error['warning'];
				}else if (isset($this->session->data['warning'])) {
					$this->data['error_warning'] = $this->session->data['warning'];
				
					unset($this->session->data['warning']);
				} else {
					$this->data['error_warning'] = '';
				}

				if (isset($this->error['target_level'])) {
					$this->data['error_target_level'] = $this->error['target_level'];
				}else{
					$this->data['error_target_level'] ='';
				}
				if (isset($this->error['user_data'])) {
					$this->data['error_user_data'] = $this->error['user_data'];
				}else{
					$this->data['error_user_data'] ='';
				}

				if (isset($this->session->data['success'])) {
					$this->data['success'] = $this->session->data['success'];
				
					unset($this->session->data['success']);
				} else {
					$this->data['success'] = '';
				}
				$pagination = new Pagination();
				$pagination->total = $total;
				$pagination->page = $page;
				$pagination->limit = $this->config->get('config_admin_limit');
				$pagination->text = $this->language->get('text_pagination');
				$pagination->url = $this->url->link('commands/hdcp_signaling', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
					
				$this->data['pagination'] = $pagination->render();
				
				$url = '';
			
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}


				$this->template = 'commands/hdcp_signaling.tpl';
				$this->children = array(
					'common/header',
					'common/footer'
				);
						
				$this->response->setOutput($this->render());

		  	}


		  	/*
		FUNCTION NAME 		-	insert
		DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
								details of the new review. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
		*/  
		  	public function save() {
				$this->language->load('commands/hdcp_signaling');
		    	$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('commands/hdcp_signaling');
				if ($this->request->server['REQUEST_METHOD'] == 'POST') {
				 if($this->validateForm($this->request->post)) {
		  			$target_level=$this->request->post['target_level'];
		  		    $target="";
		  		    switch ($target_level) {
		  				case 1:
		  					$log_target_level = "Individual";
		  					$log_target = $this->request->post['target'];
		  				
		  					$customer_id =$this->model_commands_hdcp_signaling->getCustomerId($this->request->post['target']);
		 	  				$target=(int)$customer_id["api_user_id"];
		 	  				$local_target=(int)$customer_id["customer_id"];
		 	  				$operator_id=(int)$customer_id["operator_id"];
		  				break;	
		  				case 2:
		  					$log_target_level = "Global";
		  					$log_target = "n/a";

		  					$target=0;
		  					$local_target=0;
		  					$operator_id=$this->session->data['user_id'];
		  				break;
		  				case 3:
		  					$log_target_level = "Regional";
		  					$log_target = $this->request->post['target'];

		  					$target=$this->request->post['target'];
		  					$local_target=$this->request->post['target'];
		  					$operator_id=$this->session->data['user_id'];
		  				break;
		  				case 4:
		  					$log_target_level = "Group";
		  					$log_target = $this->request->post['target'];
		  					$group_ids=$this->model_commands_hdcp_signaling->getGroupIdByname($this->request->post['target']);
		  					$target= $group_ids['kms_group_id'];
		  					$local_target=$group_ids['sms_group_id'];
		  					$operator_id=$this->session->data['user_id'];
		  				break;
		  				default:
		  				break;
		  			}
						$lcn = ($this->request->post["lcn"]);
						//Call of API
						$obj = new restapi();
					    $method ="POST";
						$data="target_level=".$target_level."&target=".$target."&lcn=".$lcn;

					    $url="".KMS_API."/ServiceTunning";
					    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
					    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
					 //    Process API response and add to db
					    $response=json_decode($apiresult);
					     $error=true;
					     $errorMsg='';
					     $apimessage="KMS API Failed";
					    foreach ($response as $key => $value) {
					    	switch ($key) {
					    		case 'error':
					    			$error=$value;
					    		break;
					    		case 'id':
					    			$id=$value;
					    		break;
					    		case 'message':
					    			$apimessage=$value;
					    		break;
					    		case 'mq_response':
					    			$curlresponse=$value;
					    		break;
					    		default:
					    			$errorMsg=$errorMsg." ".$key. ": ".$value;
					    		break;
					    	}
						}
						$this->WriteMessageLog($curlresponse,$log_target_level,$log_target,"SEND SERVICE TUNNING");
						$ack_is=-1;$nack_is=-1;
						if(!$error)
						{
							$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
							
							if($ack=='ACK')
							{
								$ack_is=1;
							}elseif($ack=='NACK'){
								$nack_is=-1;
							}

							$target=1;
							$payload = $lcn;
							// var_dump();exit();
							$product_id=$this->model_commands_hdcp_signaling->getProductid($lcn);
							$this->model_commands_hdcp_signaling->addToCasOpTransanction($target_level,$local_target,$id,$product_id['product_id'],$payload,$ack_is,$nack_is,$this->session->data['user_id'],$lcn);
				

								$this->session->data['success'] = $apimessage;

								$url = '';
								$this->redirect($this->url->link('commands/hdcp_signaling', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['target'], 'SSL'));
							}else{
								$errorMsg=$errorMsg." ".$apimessage;
								$this->session->data['warning']=$errorMsg;
								
							 }
						}
					else{
						$this->data['service_tune_target']=array('target_level' =>$this->request->post['target_level'],
											'target'         =>$this->request->post["target"]);
						}
					}
					$this->getForm();
				}

		  	/*
			FUNCTION NAME 		-	insert
			DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
									details of the new review. 
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
			*/ 
		public function insert() {
		  		
			$obj = new restapi();
			$this->language->load('commands/hdcp_signaling');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('commands/hdcp_signaling');

			if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validateInsertForm($this->request->post))) {
			$this->data['service_tune_target']=array('target_level' =>$this->request->post['target_level'],
											'target'         =>$this->request->post['filter_value']);
			$this->getForm();
			}else{
			$this->getList();
			}
		}
 

	  	/*
	FUNCTION NAME 		-	getForm
	DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
	*/  
	  	protected function getForm() {
	  		$this->load->model('commands/hdcp_signaling');
	    	$this->data['heading_title'] = $this->language->get('heading_title');
	 		
	    	$this->data['entry_expiry']		    = $this->language->get('entry_expiry');
	    	$this->data['entry_channel']		= $this->language->get('entry_channel');
	    	$this->data['entry_stb']		    = $this->language->get('entry_stb');
	 		
			$this->data['button_save'] = $this->language->get('button_save');
	    	$this->data['button_cancel'] = $this->language->get('button_cancel');

	 		if (isset($this->error['warning'])) {
				$this->data['error_warning'] = $this->error['warning'];
			} else {
				$this->data['error_warning'] = '';
			}
			$this->data['channel_lists'] = $this->model_commands_hdcp_signaling->getChanelList();
	    	if (isset($this->request->post['lcn'])) {
	      		$this->data['lcn'] = $this->request->post['lcn'];
	    	} elseif (!empty($customer_info)) { 
				$this->data['lcn'] = $customer_info['lcn'];
			} else {
	      		$this->data['lcn'] = $this->config->get('lcn');
	    	}

			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
							
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
	  		$this->data['breadcrumbs'] = array();

	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
	      		'separator' => false
	   		);

	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('commands/hdcp_signaling', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);

			if (!isset($this->request->get['stb_no'])) {
				$this->data['action'] = $this->url->link('commands/hdcp_signaling/save', 'token=' . $this->session->data['token'] . $url, 'SSL');
			} else {
				$this->data['action'] = $this->url->link('commands/hdcp_signaling/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
			}
			  
	    	$this->data['cancel'] = $this->url->link('commands/hdcp_signaling/', 'token=' . $this->session->data['token'] . $url, 'SSL');

	    	$this->data['token'] = $this->session->data['token'];
		
			$this->template = 'commands/hdcp_signaling_form.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
					
			$this->response->setOutput($this->render());
		}
		/*
		FUNCTION NAME 		-	validateForm
		DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
		*/
					 
		  	protected function validateForm($post) {
		  			
		    	if (!$this->user->hasPermission('modify', 'commands/hdcp_signaling')) {
		      		$this->error['warning'] = $this->language->get('error_permission');
		    	}

				if (!$this->error) {
			  		return true;
				 } else {
			 		return false;
				 }
		  	}  

			/*
		FUNCTION NAME 		-	validateInsertForm
		DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
		*/
					 
		  	protected function validateInsertForm($post) {
		  			
		    	if (!$this->user->hasPermission('modify', 'commands/hdcp_signaling')) {
		      		$this->error['warning'] = $this->language->get('error_permission');
		    	}
				$this->load->model('commands/ota_download');
				switch ($this->request->post['target_level']) {
					case 1:
						if($this->request->post['filter_value']=='')
						{
							$this->error['user_data']='Please enter STB no ';	
						}else if(strlen($this->request->post['filter_value'])!=14)
						{
							$this->error['user_data']='STB no should be 14 digit ';	
						}else{
							$stb=$this->model_commands_ota_download->isStbExistedAndPaired($this->request->post['filter_value']);
							if(!isset($stb['customer_id']))
							{
								$this->error['user_data']='Invalid STB no';
							}else if (isset($stb['customer_id'])) {
								if(!$stb['customer_id']>0)
									$this->error['user_data']='STB no is not paired with user';
							}
						}
						break;
					case 2:
						
						break;
					case 3:
						if($this->request->post['filter_value']=='')
							$this->error['user_data']='Please enter pin code ';
						else if(strlen($this->request->post['filter_value'])!=6)
							$this->error['user_data']='Pin code must be 6 digits';
						else{
							$pin=$this->model_commands_ota_download->checkPinExist($this->request->post['filter_value']);
							if(!$pin)
								$this->error['user_data']='Invalid PIN code';
						}
						break;
					case 4:
						if($this->request->post['filter_value']=='')
							$this->error['user_data']='Please enter group name';
						else {
							$group=$this->model_commands_ota_download->checkGroupExists($this->request->post['filter_value']);
							if(!$group)
								$this->error['user_data']='Invalid group name';	
						}
						break;    			
					default:
						$this->error['target_level']='Please select target ';
						break;
				}

				if (!$this->error) {
			  		return true;
				 } else {
			 		return false;
				 }
		  	} 
		  	/*
		FUNCTION NAME 		-	validate
		DESCRIPTION 		-	Validates the details of the transaction content . 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
		*/
			
		  	protected function validate() {
		    	if (!$this->user->hasPermission('modify', 'commands/service_tunning')) {
		      		$this->error['warning'] = $this->language->get('error_permission');
		    	}
				
				if (!$this->error) {
			  		return true;
				} else {
			  		return false;
				}
		  	}  

		  	/*
		FUNCTION NAME 		-	autocomplete
		DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
								the form. These auto-fill values are retrieved from the database
								and shown as a drop down list.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Renders the list.
		*/
			
			public function autocomplete() {
				$json = array();
				
				if (isset($this->request->get['filter_no'])) {
					$this->load->model('commands/service_tunning');
					$data = array(
						'filter_no' => $this->request->get['filter_no'],
						'start'       => 0,
						'limit'       => 20
					);
					$results = $this->model_commands_service_tunning->getSTBs($data);
						
					foreach ($results as $result) {
						$json[] = array(
							'stb_id' 	=> $result['id'], 
							'stb_no'=> strip_tags(html_entity_decode($result['stb_no'], ENT_QUOTES, 'UTF-8'))
						);
					}		
				}
				$sort_order = array();
				foreach ($json as $key => $value) {
					$sort_order[$key] = $value['stb_no'];
				}
				array_multisort($sort_order, SORT_ASC, $json);

				$this->response->setOutput(json_encode($json));
			}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
        fclose($log_file);
    }

 }
?> 