<?php 
 /*
@File box_activation.php(Controller)
ADMIN BoxActivation PAGE
    This class manages the all the BoxActivation  status.
    

@Author Mahesh Yallure 
@date 19 Jan. 2016
*/
class ControllerCommandsBoxSuspend extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box suspend transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
	public function index() {
		$this->language->load('commands/box_suspend');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('commands/box_suspend');
    	$this->getList();
  	}


	/*
	FUNCTION NAME 		-	getList
	DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
							database and make a list for it.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the transaction list.
	*/
	public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['target_level'])) {
			$target_level = $this->request->get['target_level'];
		} else {
			$target_level = null;
		}

		if (isset($this->request->get['filter_package'])) {
			$filter_package = $this->request->get['filter_package'];
		} else {
			$filter_package = null;
		}

		if (isset($this->request->get['filter_region'])) {
			$filter_region = $this->request->get['filter_region'];
		} else {
			$filter_region = null;
		}

		if (isset($this->request->get['filter_group'])) {
			$filter_group = $this->request->get['filter_group'];
		} else {
			$filter_group = null;
		}

		if (isset($this->request->get['filter_lco'])) {
			$filter_lco = $this->request->get['filter_lco'];
		} else {
			$filter_lco = null;
		}

		if (isset($this->request->get['filter_suspention'])) {
			$filter_suspention = $this->request->get['filter_suspention'];
		} else {
			$filter_suspention = null;
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = null;
		}

		if(isset($this->request->post['target_level']))
			$this->data['target_level']	= $this->request->post['target_level'];
		else
			$this->data['target_level']='';

		if(isset($this->request->post['filter_package']))
			$this->data['filter_package']	= $this->request->post['filter_package'];
		else
			$this->data['filter_package']='';

		if(isset($this->request->post['filter_region']))
			$this->data['region']	= $this->request->post['filter_region'];
		else
			$this->data['region']='';

		if(isset($this->request->post['filter_group']))
			$this->data['group']	= $this->request->post['filter_group'];
		else
			$this->data['group']='';

		if(isset($this->request->post['filter_lco']))
			$this->data['filter_lco']	= $this->request->post['filter_lco'];
		else
			$this->data['filter_lco']='';

		if(isset($this->request->post['filter_suspention']))
			$this->data['filter_suspention']	= $this->request->post['filter_suspention'];
		else
			$this->data['filter_suspention']='';

		if(isset($this->request->post['filter_value']))
			$this->data['filter_value']	= $this->request->post['filter_value'];
		else
			$this->data['filter_value']='';
						
		$url = '';
		
  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_package'])) {
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		}
		
   		$this->data['insert'] = $this->url->link('commands/box_suspend/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['suspendresumes'] = array();
		$data = array(
			'target_level'	  => $target_level,
			'filter_value'	  => $filter_value,	
			'filter_package'  => $filter_package,
			'filter_region'   => $filter_region,
			'filter_group' 	  => $filter_group,
			'filter_lco'  	  => $filter_lco,
			'filter_suspention'=> $filter_suspention,		
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->post['target_level'])) {
			$this->data['target_level'] = $this->request->post['target_level'];
		} else if (isset($this->request->get['target_level'])) {
			$this->data['target_level'] = $this->request->get['target_level'];
			$this->session->data['target_level']=$this->data['target_level'];
		}else {
			$this->data['target_level'] =-1;
		}

		if (isset($this->request->post['filter_suspention'])) {
			$this->data['filter_suspention'] = $this->request->post['filter_suspention'];
		} else if (isset($this->request->get['filter_suspention'])) {
			$this->data['filter_suspention'] = $this->request->get['filter_suspention'];
			$this->session->data['filter_suspention']=$this->data['filter_suspention'];
		}else {
			$this->data['filter_suspention'] =-1;
		}

		
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$this->data['filter_value']=$this->request->get['filter_value'];
			$this->data['target_level']=$this->data['target_level'];
		} else if (isset($this->request->post['filter_value'])) {
			$this->data['filter_value'] = $this->request->post['filter_value'];
		} else{
			$this->data['filter_value'] = '';
		}

		if (isset($this->request->get['filter_lco'])) {
			$this->data['filter_lco'] = $this->request->get['filter_lco'];
		} else if (isset($this->request->post['filter_lco'])) {
			$this->data['filter_lco'] = $this->request->post['filter_lco'];
		} else{
			$this->data['filter_lco'] = '';
		}

		$this->data['selectsuspention'] = array('-1'=>'Select Suspention', '0'=>'Box'/*, '1'=>'Package'*/);
		$this->data['targets'] = array(
			'-1' => 'Select Target',
			'1'  => 'Individual',
			/*'2'  => 'Global',
			'3'  => 'Region',
			'4'  => 'Group',*/
			'5'	 => 'LCO'	
		);

		$this->load->model('commands/box_suspend');
		$this->data['regions'] = array();
		$regions = $this->model_commands_box_suspend->getAllRegions();
		foreach ($regions as $region) {
			$this->data['regions'][] = array(
				'pin'  	  		=> $region['pin'],
				'region_name' 	=> $region['region_name']
			);
		}
		$this->data['groups'] = array();
		$groups = $this->model_commands_box_suspend->getAllGroups();
		foreach ($groups as $group) {
			$this->data['groups'][] = array(
				'group_id'  	=> $group['customer_group_id'],
				'group_name' 	=> $group['name']
			);
		}
		$this->data['operators'] = array();
		$operators = $this->model_commands_box_suspend->getAllOperators();
		foreach ($operators as $operator) {
			$this->data['operators'][] = array(
				'user_id'  	=> $operator['user_id'],
				'username' 	=> $operator['username']
			);
		}
		$this->data['packages'] = array();
		$packages = $this->model_commands_box_suspend->getAllPackages();
		foreach ($packages as $pacakge) {
			$this->data['packages'][] = array(
				'package_id'  	=> $pacakge['package_id'],
				'package_name' 	=> $pacakge['package_name']
			);
		}

		// $total = $this->model_commands_box_suspend->getTotalSuspendResume($data);
		$results = $this->model_commands_box_suspend->getSuspendResume($data);
		$total = sizeof($results);
		foreach ($results as $result) 
		{	
			$resend = $this->url->link('commands/box_suspend/resend', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');
			$de_activation = $this->url->link('commands/box_suspend/resume', 'token=' . $this->session->data['token'] . $url.'&id='.$result['id'], 'SSL');

			$pieces = explode("#", $result['payload']);
			if($pieces[0]=='suspend'){
				$type = 'SUSPEND';
				// $packageName = "NA";
			}elseif($pieces[0]=='resume'){
				$type = 'RESUME';
				// $packageName = $this->model_commands_box_suspend->getPacakgeNameById($pieces[4]);
			}

			if($result['target_level']==1){
				$target_level ="Individual";
				$target = $this->model_commands_box_suspend->getStbNo($result['user_id']);
			}elseif ($result['target_level']==2){
				$target_level ="Global";
				$target = "NA";
			}elseif ($result['target_level']==3){
				$target_level ="Regional";
				$target = $this->model_commands_box_suspend->getRegionNameByPin($result['user_id']);
			}elseif ($result['target_level']==4){
				$target_level ="Group";
				$target = $this->model_commands_box_suspend->getGroupNameById($result['user_id']);
			}elseif ($result['target_level']==5){
				$target_level ="LCO";
				$target = $this->model_commands_box_suspend->getLcoNameById($result['user_id']);
			}

			
			$this->data['suspendresumes'][] = array(
				'id'  		 	 => $result['id'],
				'tx_id'  		 => $result['tx_id'],
				'target_level'	 => $target_level,
				'trigger_on'     => $result['modify_date'],
				'type'			 => $type,
				// 'packageName'	 => $packageName,
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'cmd_id'         => $result['cmd_id'],
				'target'         => $target,
				'resend'         => $resend,
				'de_activation'  => $de_activation,
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}	

		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}

		if (isset($this->error['filter_suspention'])) {
			$this->data['error_filter_suspention'] = $this->error['filter_suspention'];
		} else {
			$this->data['error_filter_suspention'] = '';
		}

		if (isset($this->error['target_level'])) {
			$this->data['error_target_level'] = $this->error['target_level'];
		}else{
			$this->data['error_target_level'] ='';
		}
		
		if (isset($this->error['filter_lco'])) {
			$this->data['error_filter_lco'] = $this->error['filter_lco'];
		}else{
			$this->data['error_filter_lco'] ='';
		}

		/*if (isset($this->error['user_data'])) {
			$this->data['error_user_data'] = $this->error['user_data'];
		}else{
			$this->data['error_user_data'] ='';
		}*/

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['filter_package'])) {
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		}

		$this->template = 'commands/box_suspend.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


	  	/*
	FUNCTION NAME 		-	insert
	DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
							details of the new review. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
	*/  
  	public function insert() {
		$this->language->load('commands/box_suspend');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_suspend');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' ) {
			if($this->validateForm($this->request->post)) {
		  		$target_level=$this->request->post['target_level'];
		  		$target="";
		  		switch ($target_level) {
		  			case 1:
		  				$log_target_level = "Individual";
		  				$log_target_level_numeric = 1;
		  				$log_target = $this->request->post['filter_value'];
		  				
		  				$customer_id =$this->model_commands_box_suspend->getCustomerId($this->request->post['filter_value']);
		 	  			$target=$this->request->post['filter_value'];
		 	  			$local_target=(int)$customer_id["customer_id"];
		 	  			$operator_id=(int)$customer_id["operator_id"];
		  			break;	
		  			/*case 2:
		  				$log_target_level = "Global";
		  				$log_target_level_numeric = 2;
		  				$log_target = "NA";

		  				$target=0;
		  				$local_target=0;
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 3:
		  				$log_target_level = "Regional";
		  				$log_target_level_numeric = 3;
		  				$log_target = $this->request->post['filter_region'];

		  				$target=$this->request->post['filter_region'];
		  				$local_target=$this->request->post['filter_region'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;
		  			case 4:
		  				$log_target_level = "Group";
		  				$log_target_level_numeric = 4;
		  				$log_target = $this->request->post['filter_group'];

		  				$group_ids=$this->model_commands_box_suspend->getGroupIdById($this->request->post['filter_group']);
		  				$target= $group_ids['kms_group_id'];
		  				$local_target=$group_ids['sms_group_id'];
		  				$operator_id=$this->session->data['user_id'];
		  			break;*/
		  			case 5:
		  				$log_target_level = "Lco";
		  				$log_target_level_numeric = 5;
		  				$log_target = $this->request->post['filter_lco'];

		  				// $group_ids=$this->model_commands_box_suspend->getGroupIdById($this->request->post['filter_lco']);
		  				$target= $this->request->post['filter_lco'];
		  				$local_target=$this->request->post['filter_lco'];
		  				$operator_id=$this->request->post['filter_lco'];//$this->session->data['user_id'];
		  			break;
		  			default:
		  				break;
		  		}
		  		
		 		$type=$this->request->post["filter_suspention"];
		 		// State:[SUSPEND==1/RESUME==2]
		 		$state=1;
		 		// $package_id=($this->request->post["filter_package"]);
				$obj = new restapi();
				$data="target_level=".$target_level."&target=".$target."&type=".$type."&state=".$state;
				// var_dump($data);die;
				$method ="POST";
			    $url="".KMS_API."/SuspendResume";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			    //Process API response and add to db
			    $response=json_decode($apiresult);
	    		$apimessage='';
	    		$errorMsg='';
				$apimessage ="";
				$curlresponse = "";

				foreach ($response as $key => $value) {
					switch ($key) {
						case 'error':
							$error=$value;
							break;
						case 'id':
							$id=$value;
							break;
						case 'mq_response':
							$curlresponse=$value;
							break;
						case 'message':
							$apimessage=$value;
							break;
						default:
							$errorMsg=$errorMsg.' '.$apimessage;
							break;
					}
				}
			
			
				$ack_is=-1;$nack_is=-1;
				if(!$error)
				{	
					$resend_status = 0;
					$commandid = 23;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level_numeric,$log_target,$state,$resend_status,$commandid,$log_target_level_numeric);
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=-1;
					}
					
					$payload='suspend#'.$target_level."#".$target."#".$type."#".$state;
					$this->model_commands_box_suspend->addToCasOpTransanction($log_target,$target_level,$local_target,$id,$payload,$ack_is,$nack_is,$operator_id,$state);
					if($target_level==1){
						$this->model_commands_box_suspend->updateSuspendStatusByStbno(1,$log_target);
					}elseif ($target_level==5) {
						// $this->model_commands_box_suspend->updateSuspendStatusByLcoId(1,$log_target);
						$this->model_commands_box_suspend->updateSuspendStatusOcUser(1,$log_target);
						$this->model_commands_box_suspend->updateLcoStatusByUserId(0,$log_target);
					}
					$this->session->data['success'] = $apimessage;
					$url = '';
					$this->redirect($this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$this->request->post['filter_value'].'&filter_suspention='.$filter_suspention, 'SSL'));
				}else{

					$errorMsg=$errorMsg." ".$apimessage;
					$this->session->data['warning']="In CAS :".$apimessage;//$errorMsg;
					$url = '';
					$this->redirect($this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				 }
			}
			else{
					$this->data['box_suspend_target']=array('target_level' =>$this->request->post['target_level'],
												'target'         =>$this->request->post["filter_value"]);
				}
		}
    	
    	$this->getList();
  	} 

		 /*
		FUNCTION NAME 		-	resend
		DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
								added/uploaded earlier. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
		*/
   
  	public function resend() {

		$this->language->load('commands/box_suspend');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_suspend');
  		$obj = new restapi();
    	
 		$transaction_details=$this->model_commands_box_suspend->getTransactionDetails($this->request->get['id']);
 		$customer_id=$transaction_details['user_id'];
		$target_level=$transaction_details['target_level'];
		$trans_id=$transaction_details['tx_id']; 
		$cmd_id=$transaction_details['cmd_id'];
		$stbno = $transaction_details['stbno'];
		$operator_id=$transaction_details['operator_id'];

		switch ($target_level) {
			case 1:
					$target=$stbno;
					$log_target_level = "Individual";
					$log_target_level_numeric = 1;
					$log_target = $customer_id;
			break;
			/*case 2:
					$target=0;
					$targ_value=0;

					$log_target_level = "Global";
					$log_target_level_numeric = 2;
					$log_target = "NA";
			break;
			case 3:
					$target=$customer_id;
					$targ_value=$target;

					$log_target_level = "Regional";
					$log_target_level_numeric = 3;
					$log_target = $targ_value;
			break;
			case 4:
					$target=$customer_id;//$this->model_commands_box_suspend->getKMSGroupId($transaction_details['user_id']);
					$targ_value=$this->model_commands_box_suspend->getGroupNameById($transaction_details['user_id']);

					$log_target_level = "Group";
					$log_target_level_numeric = 4;
					$log_target = $targ_value;
			break;*/
			case 5:
	  				$target=$transaction_details['user_id'];
					$log_target_level = "Lco";
					$log_target_level_numeric = 5;
					$log_target = $customer_id;
  			break;
  			default:
  				break;
		}
		
	  	$data="transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$target."&target_level=".$target_level;
	  	// var_dump($data); die;
	  	$method ="POST";
		$uri=KMS_API."/Resend";		
		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		$apiresult=$obj->callAPI($method,$hdr,$uri,$data);
	    //Process API response and add to db 
	    $response=json_decode($apiresult);		
	    $error=true;
	    $errorMsg='';
	    $apimessage=" Kms fail to enable STB";
	    $curlresponse="";
	    foreach ($response as $key => $value) {
			switch ($key) {
				case 'error':
					$error=$value;
				break;
				case 'id':
					$id=$value;
				break;
				case 'mq_response':
					$curlresponse=$value;
				break;
				case 'message':
					$apimessage=$value;			
				break;
				default:
					$errorMsg=$errorMsg." ".$key.":".$value;	
					break;
			}
		}

				
		$ack_is=-1;$nack_is=-1;
		if(!$error)
		{	
			$resend_status = 1;
			$commandid = 5;
			$this->WriteMessageLog($id,$curlresponse,$log_target_level,$target,"RESEND BMAIL",$resend_status,$commandid,$log_target_level_numeric);	
			$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
			if($ack=='ACK')
			{
				$ack_is=1;
			}elseif($ack=='NACK'){
				$nack_is=-1;
			}
			$resp=split('`', $curlresponse);
			$payload='suspend#'.$customer_id."#".$cmd_id."#".$trans_id;
			$target=1;
			$targetdata=0;
			$results = $this->model_commands_box_suspend->addToCasOpTransanction($stbno,$target_level,$customer_id,$id,$payload,$ack_is,$nack_is,$operator_id);
			$this->session->data['success']=$apimessage;
		}else{
			$errorMsg=$errorMsg."  ".$apimessage;
			$this->session->data['warning']=$errorMsg;
		}
     	$this->redirect($this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url.'&target_level='.$target_level.'&filter_value='.$targ_value, 'SSL'));
     	
  	}  

		/*
		FUNCTION NAME 		-	resume
		DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
								added/uploaded earlier. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
		*/
   
    public function resume() {
		$this->language->load('commands/box_suspend');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_suspend');
  		$obj = new restapi();
    	
 		$transaction_details=$this->model_commands_box_suspend->getTransactionDetails($this->request->get['id']);
 		$target=$transaction_details['user_id'];
		$user_id=$transaction_details['api_user_id'];
		$target_level=$transaction_details['target_level'];
		$stbno = $transaction_details['stbno'];
		$trans_id=$transaction_details['tx_id'];
		$cmd_id=$transaction_details['cmd_id'];
		$operator_id=$transaction_details['operator_id'];

		// State:[BOX==0/PACKAGE==1]
	  	$type=0;
 		// State:[SUSPEND==1/RESUME==2]
 		$state=2;
		$obj = new restapi();
		$data="target_level=".$target_level."&target=".$stbno."&type=".$type."&state=".$state;
		// var_dump($data);die;
		$method ="POST";
	    $url="".KMS_API."/SuspendResume";
	    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
	    //Process API response and add to db
	    $response=json_decode($apiresult);
		$apimessage='';
		$errorMsg='';
		$apimessage ="";
		$curlresponse = "";

		foreach ($response as $key => $value) {
			switch ($key) {
				case 'error':
					$error=$value;
					break;
				case 'id':
					$id=$value;
					break;
				case 'mq_response':
					$curlresponse=$value;
					break;
				case 'message':
					$apimessage=$value;
					break;
				default:
					$errorMsg=$errorMsg.' '.$apimessage;
					break;
			}
		}
	
	
		$ack_is=-1;$nack_is=-1;
		if(!$error)
		{	
			$resend_status = 0;
			$commandid = 23;
			$cmd_type=2;
			if($target_level==1)
				$logtarget=$stbno;
			elseif($target_level==5)
				$logtarget=$target;

			$this->WriteMessageLog($id,$curlresponse,$target_level,$logtarget,$cmd_type,$resend_status,$commandid,$target_level_numeric);
			$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
			if($ack=='ACK')
			{
				$ack_is=1;
			}elseif($ack=='NACK'){
				$nack_is=-1;
			}
			
			$payload='resume#'.$target_level."#".$target."#".$type."#".$state;
			
			$this->model_commands_box_suspend->addToCasOpTransanction($stbno,$target_level,$target,$id,$payload,$ack_is,$nack_is,$operator_id,$cmd_type);
			if($target_level==1){
				$this->model_commands_box_suspend->updateSuspendStatusByStbno(0,$stbno);
			}elseif ($target_level==5) {
				// $this->model_commands_box_suspend->updateSuspendStatusByLcoId(0,$operator_id);
				$this->model_commands_box_suspend->updateSuspendStatusOcUser(0,$operator_id);
				$this->model_commands_box_suspend->updateLcoStatusByUserId(1,$operator_id);

				// individually suspended box, resume also lco wise resume command triggred.
				$this->model_commands_box_suspend->updateSuspendStatusOcStbLcoWise(0,$operator_id);
			}
			$this->session->data['success'] = $apimessage;
			$url = '';
			$this->redirect($this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

     	$this->redirect($this->url->link('commands/box_suspend', 'token=' . $this->session->data['token'] . $url, 'SSL'));
  	}   

	/*
	FUNCTION NAME 		-	validateForm
	DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
			 
  	protected function validateForm($post) {
    	if (!$this->user->hasPermission('modify', 'commands/box_suspend')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('commands/box_suspend');
		if($this->request->post['target_level']==1){
	    	$stb_no=$this->request->post['filter_value'];
	    	if($stb_no){
	    		$result = $this->model_commands_box_suspend->isSTBPaired($stb_no);
	    		$is_blacklist = $this->model_commands_box_suspend->isBlacklist($stb_no);
	    		$is_RMA = $this->model_commands_box_suspend->isStbRMA($stb_no);
			 	$is_active = $this->model_commands_box_suspend->isActive($stb_no);
			 	$result_paired = $this->model_commands_box_suspend->isSTBPairedValid($stb_no);
			 	$result_enabled = $this->model_commands_box_suspend->isCustomerEnabled($stb_no);

		    	if ((strlen($stb_no)!=14)){
		            $this->error['stb_no'] = $this->language->get('error_length');
		       	}elseif(!$result){
		    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
		    	}elseif($is_blacklist==1){
		 			$this->error['warning'] = $this->language->get('error_stb_blacklist');		
		 		}elseif($is_RMA==1){
		 			$this->error['warning'] = $this->language->get('error_stb_RMA');		
		 		}elseif($result_paired==0){
					$this->error['warning']="Warning: Customer is not paied with STB!";		
				}elseif($result_enabled==0){
					$this->error['warning']="Warning: Customer paired with STB is not enabled!";		
				}elseif($is_active==0){
		 			$this->error['warning'] = $this->language->get('error_stb_active');		
		 		}
	      	}
	      	else
			{
				$this->error['stb_no']="STB Field empty!";
			}
		}

		if($this->request->post['target_level']==5){
	    	$filterlco=$this->request->post['filter_lco'];
	    	if($filterlco=='-1'){
	    		$this->error['filter_lco']="Please select LCO.!";
	    	}
	    }

		if($this->request->post['target_level']==1 || $this->request->post['target_level']==5){
	    	$filtersuspention=$this->request->post['filter_suspention'];
	    	if($filtersuspention=='-1'){
	    		$this->error['filter_suspention']="Please select Suspention.!";
	    	}
	    }

	    if(isset($this->request->post['target_level'])){
	    	if($this->request->post['target_level']=='-1')
	    		$this->error['target_level']="Please select target.!";
	    }
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

	public function WriteMessageLog($id,$status,$target_level,$log_target,$cmd_type,$resend_status,$command_id,$log_target_level_numeric){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	$log_target = (strlen($log_target)<22)?str_pad($log_target,24," "):substr($log_target, 0,22).".";
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").$log_target.$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$target_level,$log_target,$command_id,$resend_status,$cmd_type);
    }
 }
?> 