<?php 
 /*
@File account_info.php(Controller)
ADMIN Account Information PAGE
    This class manages the all the BoxActivation  status.
    

@Author Ravi Ranjan 
@date 21 Nov. 2016
*/
class ControllerCommandsAccountInfo extends Controller {
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the box activation transaction list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the transaction in a list.
*/
	public function index() {
		$this->language->load('commands/account_info');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('commands/account_info');
    	$this->getList();
  	}


	/*
	FUNCTION NAME 		-	getList
	DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
							database and make a list for it.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Renders the transaction list.
	*/
	public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}

		$this->data['bulk_account_info'] = $this->url->link('commands/account_info/bulk_account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['insert'] = $this->url->link('commands/account_info/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['account_info'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		$total = $this->model_commands_account_info->getTotalStbActivations($data);

		$results = $this->model_commands_account_info->getActivationTransactions($data);
		foreach ($results as $result) 
		{	
			
			$this->data['account_info'][] = array(
				'name'           => $result['firstname']." ".$result['lastname'],
				'stb_no'    	 => $result['STBNO'],
				'telephone'  	 => $result['telephone'],
				'trigger'	     => $result['modify_date'],
				'region'	     => $result['postcode'],
				'group'	     	 => $result['name'],
				'response'       => (($result['ack_ctr']==1)?'ACK' :'NACK'),
				'selected'       => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_tx_id'] = $this->language->get('column_tx_id');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_trigger'] = $this->language->get('column_trigger');
		$this->data['column_mobile'] = $this->language->get('column_mobile');
		$this->data['column_region'] = $this->language->get('column_region');
		$this->data['column_group'] = $this->language->get('column_group');
		$this->data['column_resp'] = $this->language->get('column_resp');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'commands/account_info.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


	  	/*
	FUNCTION NAME 		-	insert
	DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
							details of the new review. 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
	*/  
  	public function insert() {
  		
		$obj = new restapi();
		$this->language->load('commands/account_info');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/account_info');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if($this->validateForm($this->request->post)) {

		  		$customer_details = $this->model_commands_account_info->getCustomerId($this->request->post['stb_no']);
		  		$customer_id=$customer_details['customer_id'];

		  		$operator_id=$this->session->data['user_id'];
		  		// var_dump($operator_id);exit();
			    $firstname=$this->request->post['firstname'];
			    $lastname=$this->request->post['lastname'];
			    $target=$this->request->post['stb_no'];
			    $telephone=$this->request->post['telephone'];
			    $postcode=$this->request->post['postcode'];
			    $groupId=$this->request->post['filter_group'];
			    $OperatorId=$this->request->post['filter_operator'];
			    $region = $this->model_commands_account_info->getRegion($postcode);
			    // $group = $this->model_commands_account_info->getCustomergroup($customer_group);
			    
			    $kms_group_id = $this->model_commands_account_info->getKmsGroupid($groupId);
				$data="stb_no=".$target."&first_name=".$firstname."&last_name=".$lastname."&region_pin=".$postcode."&group_id=".$kms_group_id["kms_group_id"]."&telephone=".$telephone."&lco_id=".$OperatorId;
				// var_dump($data); die;
				$method ="POST";
			    $url="".KMS_API."/accountInformation";
			    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
			    // var_dump($data);exit();
			    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
			    //Process API response and add to db
			    $response=json_decode($apiresult);
			    $error=true;
			    $errorMsg='';
			    $apimessage="";

			    foreach ($response as $key => $value) {
			    	switch ($key) {
			    		case 'error':
			    			$error=$value;	
			    		break;
			    		case 'id':
			    			$id=$value;	
			    		break;
			    		case 'message':
			    			$apimessage=$value;	
			    		break;
			    		case 'mq_response':
			    			$curlresponse=$value;	
			    		break;
			    		default:
			    			$errorMsg=$errorMsg." ".$key.":".$value;		
			    		break;
			    	}
				}
				$ack_is=-1;$nack_is=-1;$target_level=1;
				if(!$error)
				{
					$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
					if($ack=='ACK')
					{
						$ack_is=1;
					}elseif($ack=='NACK'){
						$nack_is=1;
					}
					$expiry=strtotime("+1 year",time());
        			$expiry+=19800; 
					$payload = $kms_group_id["kms_group_id"]."~".$postcode."~".$telephone."~".$target."~".$expiry;

					$results = $this->model_commands_account_info->updateCustomer($firstname,$lastname,$telephone,$postcode,$groupId,$OperatorId,$target,$region,$customer_id);
					$this->model_commands_account_info->updateStbOperator($this->request->post['stb_no'],$OperatorId);
					
					// var_dump($customer_id);
					// var_dump($id);
					$results = $this->model_commands_account_info->addToCasOpTransanction($customer_id,$id,$payload,$ack_is,$nack_is,$OperatorId);

					$custData = $this->model_commands_account_info->getCustomerDetails($this->request->post['stb_no']);
					$this->model_commands_account_info->addCustomerPairUnpair($custData['customer_unique_id'],$this->request->post['stb_no'],$groupId,$custData['address_id'],$OperatorId);

					$this->session->data['success']=$apimessage;
					$url = '';
									
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}
					$log_target_level = "Individual";
					$log_target = $target;
					$resend_status = 0;
					$commandid = 12;
					$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"Account Info",$resend_status,$commandid);
					$this->redirect($this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				}else{
					// $this->error['warning']=$errorMsg;
					$apimessage=$this->error['warning']=$errorMsg;
					$this->error['warning']="In CAS :".$apimessage;
							// var_dump($this->session->data); die;
			 		$this->getForm();
				}
			}
		}
    	
    	$this->getForm();
  	} 

	



		  	/*
		FUNCTION NAME 		-	getForm
		DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
		*/  
  	protected function getForm() {
  		// var_dump($this->request->get); die;
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_first'] = $this->language->get('entry_first');
    	$this->data['entry_last'] = $this->language->get('entry_last');
    	$this->data['entry_mobile'] = $this->language->get('entry_mobile');
    	$this->data['entry_region'] = $this->language->get('entry_region');
    	$this->data['entry_group'] = $this->language->get('entry_group');

    	$this->data['entry_expiry'] = $this->language->get('entry_expiry');
 	
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['stb_no'])) {
			$this->data['error_stb'] = $this->error['stb_no'];
		} else {
			$this->data['error_stb'] = '';
		}
		if (isset($this->error['postcode'])) {
			$this->data['error_postcode'] = $this->error['postcode'];
		} else {
			$this->data['error_postcode'] = '';
		}
		if (isset($this->error['customer_group'])) {
			$this->data['error_customer_group'] = $this->error['customer_group'];
		} else {
			$this->data['error_customer_group'] = '';
		}

		if (isset($this->error['filter_operator'])) {
			$this->data['error_filter_operator'] = $this->error['filter_operator'];
		} else {
			$this->data['error_filter_operator'] = '';
		}

		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
    	if (isset($this->request->post['stb_no'])) {
      		$this->data['stb_no'] = $this->request->post['stb_no'];
		}else {
      		$this->data['stb_no'] = '';
    	}

    	if (isset($this->request->post['firstname'])) {
      		$this->data['firstname'] = $this->request->post['firstname'];
		}else {
      		$this->data['firstname'] = '';
    	}

    	if (isset($this->request->post['lastname'])) {
      		$this->data['lastname'] = $this->request->post['lastname'];
		}else {
      		$this->data['lastname'] = '';
    	}

    	if (isset($this->request->post['telephone'])) {
      		$this->data['telephone'] = $this->request->post['telephone'];
		}else {
      		$this->data['telephone'] = '';
    	}
    	if (isset($this->request->post['customer_region_id'])) {
      		$this->data['customer_region_id'] = $this->request->post['customer_region_id'];
		}else {
      		$this->data['customer_region_id'] = '';
    	}

    	$customer_group = $this->model_commands_account_info->getCustomerGroups();
    	$resultCustomerGroups = $this->model_commands_account_info->getAllCustomerGroups();
    	foreach ($resultCustomerGroups as $group) {
			$this->data['groups'][] = array(
				'customer_group_id' =>$group['customer_group_id'],
				'name' =>$group['name']
				);
		}

    	if (isset($this->request->post['customer_group'])) {
      		$this->data['customer_group'] = $this->request->post['customer_group'];
		}else {
      		$this->data['customer_group'] = '';
    	}

    	if (isset($this->request->post['username'])) {
      		$this->data['username'] = $this->request->post['username'];
		}else {
      		$this->data['username'] = '';
    	}

    	if (isset($this->request->post['postcode'])) {
      		$this->data['postcode'] = $this->request->post['postcode'];
		}else {
      		$this->data['postcode'] = '';
    	}

    	$resultOperators = $this->model_commands_account_info->getOperators();
		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
						
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['stb_no'])) {
			$this->data['action'] = $this->url->link('commands/account_info/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('commands/account_info/update', 'token=' . $this->session->data['token'] . '&stb_no=' . $this->request->get['stb_no'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('commands/account_info/', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	$this->data['token'] = $this->session->data['token'];

    	if (isset($this->request->post['filter_group'])) {
      		$this->data['filter_group'] = $this->request->post['filter_group'];
		}/*elseif (!empty($customer_group)) {  
			$this->data['filter_group'] = $customer_group['customer_group_id'];
		}*/ else {
      		$this->data['filter_group'] = '';
    	}

    	if (isset($this->request->post['filter_operator'])) {
      		$this->data['filter_operator'] = $this->request->post['filter_operator'];
		}/*elseif (!empty($stb_info)) {  
			$this->data['filter_operator'] = $stb_info['operator_id'];
		}*/ else {
      		$this->data['filter_operator'] = '';
    	}
	
		$this->template = 'commands/account_info_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	/*
	FUNCTION NAME 		-	validateForm
	DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
			 
    	protected function validateForm($post) {
  			
    	if (!$this->user->hasPermission('modify', 'commands/account_info')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
			$this->load->model('commands/account_info');
			$this->load->model('sale/customer');
    	$stb_no=$this->request->post['stb_no'];
    	
    	if($stb_no){
    		$result = $this->model_commands_account_info->isSTBPaired($stb_no);

	    	if ((strlen($stb_no)!=14)){
	            $this->error['stb_no'] = $this->language->get('error_length');
	            return false;
	       	}
	        elseif(!$result)
	    	{
	    		$this->error['stb_no'] = $this->language->get('error_invalid_stb');
	    		return false;
	    	}
      	} else {
			$this->error['stb_no']="STB Field is empty!";
			return false;
		}

		$result_blacklist = $this->model_commands_account_info->isSTBBlacklisted($stb_no);
		if ($result_blacklist==1) {
			$this->error['stb_no'] = "STB is Blacklisted!";
		}

		$is_suspend = $this->user->isStbSuspend($stb_no);
		if ($is_suspend==1) {
			$this->error['stb_no'] = "STB is suspended, Please resume first.!";
		}	

		$lcoId  = $this->user->getOperatorIdFromStbno($stb_no);
		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
 		if($is_lco_suspend==1){
 			$this->error['stb_no'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');		
 		}	

 		$is_RMA = $this->user->isStbRMA($stb_no);
 		if($is_RMA==1){
 			$this->error['stb_no'] = $this->language->get('STB in RMA state.!');		
 		}
		
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
      		$this->error['firstname'] = $this->language->get('error_firstname');
    	}elseif ( preg_match('/^\s/',$this->request->post['firstname']) ){
			$this->error['firstname'] = $this->language->get('Space not allowed!');
		}

    	if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
      		$this->error['lastname'] = $this->language->get('error_lastname');
    	}elseif ( preg_match('/^\s/',$this->request->post['lastname']) ){
			$this->error['lastname'] = $this->language->get('Space not allowed!');
		}

    	if ( $this->isValid($this->request->post['firstname'])){
  			$this->error['firstname'] = $this->language->get('Special Characters not allowed!');
  		}

  		if ( $this->isValid($this->request->post['lastname'])){
  			$this->error['lastname']= $this->language->get('Special Characters not allowed!');
  		}

  		if($this->request->post['telephone']==''){
  			$this->error['telephone'] = $this->language->get('error_telephone');
  			return false;
  		}

  		$stb_no = $this->model_commands_account_info->getStbNoFromMobile($this->request->post["telephone"]);
  		// var_dump($this->request->post["telephone"]);
  		if ($this->request->post["stb_no"]!=$stb_no) {
  			$this->error['telephone'] = "Duplicate Mobile No!!";
  		}


		if ((utf8_strlen($this->request->post['telephone']) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
      			$this->error['telephone'] = $this->language->get('error_telephone');
    	}
    	elseif(!is_numeric($this->request->post['telephone'])){
    			$this->error['telephone'] = $this->language->get('error_telephone_digits');
    	}
    
  //   	$customer_tel = $this->model_sale_customer->getCustomerByMobile($this->request->post['telephone']);
  //   	if (!isset($this->request->get['customer_id'])) {
		// 	if ($customer_tel) {
		// 		$this->error['warning'] = $this->language->get('error_exist'); 
		// 	}
		// } else {
		// 	if ($customer_tel && ($this->request->get['customer_id'] != $customer_tel['customer_id'])) {
		// 		$this->error['telephone'] = "telephone number is exit";//$this->language->get('error_exists');
		// 	}
		// }
		$group_id = $this->model_commands_account_info->isValidGroup($this->request->post["filter_group"]);
		if(!$group_id)
		{
			$this->error['customer_group'] =$this->language->get('error_invalid_group');
		}

		$operator_id = $this->model_commands_account_info->isValidOperator($this->request->post["filter_operator"]);
		if(!$operator_id)
		{
			$this->error['filter_operator'] =$this->language->get('Invalid Operator Name!');
		}

		$postcode = $this->model_commands_account_info->isValidRegion($this->request->post["postcode"]);
		if(!$postcode)
		{
			$this->error['postcode'] =$this->language->get('error_invalid_postcode');
		}

		$cust_id = $this->model_commands_account_info->getCustomerId($this->request->post["stb_no"]);
		$customer_zone_id = $this->model_commands_account_info->getCustomerZoneId($cust_id["customer_id"]);

		$acct_info_zone_id = $this->model_commands_account_info->getAcctInfoZoneId($this->request->post["postcode"]);

		if(sizeof($acct_info_zone_id)==0){
			$this->error['postcode'] = "Region pin doesnot exist!";			
		}elseif($customer_zone_id["zone_id"] != $acct_info_zone_id["zone_id"] ){
			$this->error['postcode'] = "Region pin belongs to different state!";
		}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  
	  	/*
	FUNCTION NAME 		-	validate
	DESCRIPTION 		-	Validates the details of the transaction content . 
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
	*/
	
  	protected function validate() {
    	if (!$this->user->hasPermission('modify', 'commands/account_info')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}  

	

	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status);
    }

    //-------
    /*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	The filter anme is auto filled as the user type 
						few of the starting letters.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Shows the pattern search list as a drop down.
*/
	

	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_no'])) {
			$this->load->model('commands/account_info');
			
			$data = array(
				'filter_no' => $this->request->get['filter_no'],
				'start'       => 0,
				'limit'       => 20
			);
			
			$results = $this->model_commands_account_info->getSTBdetails($data);
				
			foreach ($results as $result) {
				$json[] = array(
					'firstname' => $result['firstname'],
					'lastname'  => $result['lastname'],
					'telephone' => $result['telephone'],
					'postcode' 	=> $result['postcode'],
					'customer_group_id'	=> $result['customer_group_id'],
					'group' 	=> $result['group_name'],
					'user_id'	=> $result['user_id'],
					'username' 	=> $result['username'], 
					'stb_no'=> strip_tags(html_entity_decode($result['STBNO'], ENT_QUOTES, 'UTF-8'))
				);
			}		
		}

		// $sort_order = array();
	  
		// foreach ($json as $key => $value) {
		// 	$sort_order[$key] = $value['stb_no'];
		// }
		// array_multisort($sort_order, SORT_ASC, $json);

		$this->response->setOutput(json_encode($json));
	}

	public function exportFormat(){  
    	/*********************** Export Bulk Account Info CSV Format *****************************/
    	$results = array( "SDA40000000001", "first", "customer", "22", "560100", "9999999999","11");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=bulk_account_info.csv');
			$output = fopen('php://output', 'w');
			fputcsv($output, array('STBNO', 'FIRST NAME', 'LAST NAME', 'GROUP ID', 'REGION PIN', 'MOBILE','OPERATOR ID'));
			fputcsv($output, $results);
		}
    }

	  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer form page where the admin can give the
						details of the new customer. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer form page.
*/  
  	public function bulk_account_info() {
  		 $this->load->model('commands/account_info');
    	$obj = new restapi();
  			
		$this->language->load('commands/account_info');

    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/account_info');
		$this->load->model('commands/account_info');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			 // if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
			  	$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			  	
			  	if($ext=='csv'){
			  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name'], "r");
				    $i=0;
				    $customer=array();
				    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				    		if($i>0){
				    		$customers[$i-1]['STBNO']=$data[0];
				    		$customers[$i-1]['FIRST NAME']=$data[1];
				    		$customers[$i-1]['LAST NAME']=$data[2];
				    		$customers[$i-1]['GROUP ID']=$data[3];
				    		$customers[$i-1]['REGION PIN']=$data[4];
				    		$customers[$i-1]['MOBILE']=$data[5];
				    		$customers[$i-1]['OPERATOR ID']=$data[6];
				    	}
				    	$i++; 
				    }
				    $warnings=array(array());
				    $j=0;
				    $err_encounter=0;
			    	$log_separator = "-------------------------------------\n";
					$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
					$current_date = $currDate->format('d-m-Y H:i:s');	
					file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);	

				    foreach ($customers as $row) {

				    	// echo "<pre>"; print_r($row); die;
				    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt",$log_separator.$row['STBNO']."\n", FILE_APPEND);
			    		if ($row['FIRST NAME']== '') {
				      		$warnings[$j]['FIRST NAME'] = "Firstname field required!";
				      		$err_encounter=1;
				    	}else if ((utf8_strlen($row['FIRST NAME']) < 1) || (utf8_strlen($row['FIRST NAME']) > 32)) {
				      		$warnings[$j]['FIRST NAME'] = $this->language->get('error_firstname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['FIRST NAME'] = $row['FIRST NAME'];
				    	}

				    	if ($row['LAST NAME']== '') {
				      		$warnings[$j]['LAST NAME'] = "Lastname field required!";
				      		$err_encounter=1;
				    	}else if ((utf8_strlen($row['LAST NAME']) < 1) || (utf8_strlen($row['LAST NAME']) > 32)) {
				      		$warnings[$j]['LAST NAME'] = $this->language->get('error_lastname');
				      		$err_encounter=1;
				    	}else{
				    		$customer['LAST NAME'] = $row['LAST NAME'];
				    	}

				    	if ((strlen(trim($row['STBNO']))<14)||(strlen(trim($row['STBNO']))>14)){

				            $warnings[$j]['STBNO'] = $this->language->get('error_STBNO');
				            $err_encounter=1;
				        }
				        else{
				        	$customer['STBNO'] = $row['STBNO'];
						        $stb_exist = $this->model_commands_account_info->getSTBExist($row['STBNO']);
					        if($stb_exist){
						        $customer_info = $this->model_commands_account_info->getCustomerBySTBNO($row['STBNO']);
								$stb_blackList = $this->model_commands_account_info->getSTBblackList($row['STBNO']);
								$is_suspend = $this->user->isStbSuspend($row['STBNO']);
								if ($is_suspend==1) {
									$warnings[$j]['STBNO'] = "STB is suspended, Please resume first.!";
									$err_encounter=1;
								}

								$lcoId  = $this->user->getOperatorIdFromStbno($row['STBNO']);
								$is_lco_suspend = $this->user->isLcoSuspend($lcoId);
						 		if($is_lco_suspend==1){
						 			$warnings[$j]['STBNO'] = $this->language->get('STB Belongs To LCO Is Suspended, Please Resume LCO First.!');
						 			$err_encounter=1;		
						 		}	

						 		$is_RMA = $this->user->isStbRMA($row['STBNO']);
						 		if($is_RMA==1){
						 			$warnings[$j]['STBNO'] = $this->language->get('STB in RMA state.!');		
						 			$err_encounter=1;
						 		}

								if ((int)$stb_blackList["is_black_list"]) {
					        		$warnings[$j]['STBNO'] = 'STBNO is Black listed!';
					        		$err_encounter=1;
					        	}
					
							}else{
								$warnings[$j]['STB NO'] = 'Warning: STB No. does not exist!';
							}
						}
				    	if ($row['MOBILE']== '') {
				      		$warnings[$j]['MOBILE'] = "Telephone field required!";
				      		$err_encounter=1;
				    	}else if ((utf8_strlen($row['MOBILE']) < 10) || (utf8_strlen($row['MOBILE']) > 10)) {
				      			$warnings[$j]['MOBILE'] = $this->language->get('error_telephone');
				      			$err_encounter=1;
				    	}
				    	else if(!is_numeric($row['MOBILE'])){
				    			$warnings[$j]['MOBILE'] = $this->language->get('error_telephone_digits');
				    			$err_encounter=1;
				    	}else{
				    		$customer['MOBILE'] = $row['MOBILE'];
				    	}
				    
				    	if ($row['GROUP ID']== '') {
				      		$warnings[$j]['GROUP ID'] = "Group field required!";
				      		$err_encounter=1;
				    	}else{
				    		$customer_group = $this->model_commands_account_info->getGroupById($row['GROUP ID']);
				    		if(!isset($customer_group['customer_group_id']))
				    		{
				    			$warnings[$j]['GROUP ID'] = "Group Id '".$row['GROUP ID']."' is not exist !";	
				    			$err_encounter=1;
				    		}else{
				    			$customer['GROUP ID'] = $customer_group['customer_group_id'];
				    		}
				    	}

				    	if ($row['OPERATOR ID']== '') {
				      		$warnings[$j]['OPERATOR ID'] = "Group field required!";
				      		$err_encounter=1;
				    	}else{
				    		$customer_operator = $this->model_commands_account_info->getOperatorById($row['OPERATOR ID']);
				    		if(!isset($customer_operator['user_id']))
				    		{
				    			$warnings[$j]['OPERATOR ID'] = "Operator Id '".$row['OPERATOR ID']."' is not exist !";	
				    			$err_encounter=1;
				    		}else{
				    			$customer['OPERATOR ID'] = $customer_operator['user_id'];
				    		}
				    	}

				    	if ($row['REGION PIN']==''){
				      		$warnings[$j]['REGION PIN'] = "Region field required!";
				      		$err_encounter=1;
				    	}else{
				    		
				    		$customer_region = $this->model_commands_account_info->isRegionpinExist($row['REGION PIN']);
				    		if(!$customer_region)
				    		{
				    			$warnings[$j]['REGION PIN'] = "Region '".$row['REGION PIN']."' is not exist !";	
				    			$err_encounter=1;
				    		}
				    	}
// ------------------------------------------------------------
				    	$cust_id = $this->model_commands_account_info->getCustomerId($row['STBNO']);
				    	
				    	if(sizeof($cust_id)!=0){
							$customer_zone_id = $this->model_commands_account_info->getCustomerZoneId($cust_id["customer_id"]);
							$acct_info_zone_id = $this->model_commands_account_info->getAcctInfoZoneId($row['REGION PIN']);
							if(sizeof($acct_info_zone_id)!=0){
								if($customer_zone_id["zone_id"] != $acct_info_zone_id["zone_id"] ){
									$warnings[$j]['REGION PIN'] = "Region pin belongs to different state!";
						      		$err_encounter=1;
								}
							}elseif(sizeof($acct_info_zone_id)==0){
								$warnings[$j]['REGION PIN'] = "Region pin doesnot exists!";
						      		$err_encounter=1;
							}
						}

// --------------------------------------------------------------

				    	
						if(!$err_encounter)
				    	{
				    	$customer_details = $this->model_commands_account_info->getCustomerId($row['STBNO']);
				    		if (!empty($customer_details)) {
				    		$customer_id=$customer_details['customer_id'];
				  			$cust_groupid=$this->model_commands_account_info->getApigroupid((int)$row['GROUP ID']);
							$data="stb_no=".$row['STBNO']."&first_name=".$row['FIRST NAME']."&last_name=".$row['LAST NAME']."&region_pin=".$row['REGION PIN']."&group_id=".$cust_groupid['kms_group_id']."&telephone=".$row['MOBILE']."&lco_id=".$row['OPERATOR ID'];				
							$method ="POST";
						    $url="".KMS_API."/accountInformation";
						    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
						    $apiresult=$obj->callAPI($method,$hdr,$url,$data);
						    //Process API response and add to db
						    $response=json_decode($apiresult);
							//--------
							$errorMsg="";
							foreach ($response as $key => $value) {
								switch ($key) {
				    				case 'error':
				    					$error=	$value;
				    					break;
				    				case 'message':
				    					$apimessage=$value;				
				    					break;
				    				case 'id':
				    					$api_user_id=$value;	
				    					break;
				    				case 'mq_response':
										$curlresponse=$value;	
				    				default:
				    					$errorMsg=$errorMsg." ".$key.":".$value;	
				    					break;
				    			}
							}
							$log_target_level = "Individual";
							$log_target = $row['STBNO'];
							$resend_status = 0;
							$commandid = 12;
							$this->WriteMessageLog($api_user_id,$curlresponse,$log_target_level,$log_target,"Account Info",$resend_status,$commandid);
							$ack_is=-1;$nack_is=-1;
							if(!$error){
								$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));

								$region = $this->model_commands_account_info->getRegion($row['REGION PIN']);
								$customer_name=$customer['FIRST NAME']." ".$customer['LAST NAME'];
								// $operator_id=$this->session->data['user_id'];
								$results = $this->model_commands_account_info->updateCustomer($customer['FIRST NAME'],$customer['LAST NAME'],$customer['MOBILE'],$row['REGION PIN'],$row['GROUP ID'],$row['OPERATOR ID'],$row['STBNO'],$region,$customer_id);
								if($ack=='ACK')
								{
								$ack_is=1;	
								}elseif($ack=='NACK'){
										$nack_is=-1;
								}
								$results = $this->model_commands_account_info->addToCasOpTransanction($customer_id,$api_user_id,$row['STBNO'],$ack_is,$nack_is,$row['OPERATOR ID']);

								$custData = $this->model_commands_account_info->getCustomerDetails($row['STBNO']);
								$this->model_commands_account_info->addCustomerPairUnpair($custData['customer_unique_id'],$row['STBNO'],$row['GROUP ID'],$custData['address_id'],$row['OPERATOR ID']);

								$this->session->data['success']=$apimessage;
								if($ack=='ACK'){
									$msg = 'SUCCESS!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $msg, FILE_APPEND);
								}else if($ack=='NACK'){
									$msg = 'FAILED: NACK RECEIVED!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $msg, FILE_APPEND);
								}

							}else{
								$this->error['warning']=$errorMsg.$apimessage;
								$msg = 'FAIL'."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $msg, FILE_APPEND);

							}
						}else{
							$msg = 'Not Exist this details!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $msg, FILE_APPEND);
						}
				    	}else{
				    		$msg = 'STB details are not valid!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $msg, FILE_APPEND);
				    		$warnings[$j]['error'] = 1;
				    	}
				    	$err_encounter=0;
				    	// ------------ERROR LOGS---------------------
							if(isset($warnings[$j])){
								foreach ($warnings[$j] as $key => $value) {
									if($key!='error'){
										$line = $key . " : " .$value."\n";
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", $line, FILE_APPEND);
									}
								}
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt",$log_separator, FILE_APPEND);	
							}

							$user_id = "_".$this->session->data['user_id'];
							$gzfile = DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.$user_id.".gz";
							$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
							gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
							gzclose($fp);
					   // ------------ERROR LOGS---------------------
			    		$j++;
			    	}
			    	unlink(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$current_date.".txt");
				}else{
					$this->error['warning']= "Warning: INVALID FILE FORMAT";
					unlink(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name']);
				}
			// }else{

			// }
		}
    
      $this->getUploadForm();
  	}

  	public function validateFile(){
  	
  		$newloc = DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name'];
  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
  		$lines = count(file($newloc)); 

  		$count = 0;
	  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name'], "r");
			while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) { 
				if($count==0){
					if($data[0]!=" STBNO" || $data[1]!="FIRST NAME" || $data[2]!="LAST NAME" || $data[3]!="GROUP ID" || $data[4]!="REGION PIN" || $data[5]!="MOBILE" || $data[6]!="OPERATOR ID"){
							$this->error['warning'] = "Warning: Invalid file!";
							unlink(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name']);
							return false;
					}
					$count++;
				}
			}
  		
  		$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Customer_Registration/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
  		if($ext!='csv'){
  			$this->error['warning'] = "Warning: Invalid file format, Only .CSV files are accepted!";
  			return false;
  		}

  		if( $lines > 1001){
			$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
			unlink(DIR_ADMIN_LOGS.'/Bulk_Account_Info/'.$_FILES['filename']['name']); 
			return false;
		}else {
				if($lines){
					// $this->session->data['success'] = "File upload successfully.!!";
					return true;
				}else {
					$this->error['warning']	= "Please select .csv file of customer registration.!";
				}
			}
  	} 


  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
  		$this->language->load('commands/account_info');
    	$this->data['heading_title_bulk'] = $this->language->get('heading_title_bulk');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title_bulk'),
			'href'      => $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$this->data['bulk_account_info'] = $this->url->link('commands/account_info/bulk_account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_account_info_log_list'] = array();
   		$total = $this->model_commands_account_info->getTotal();
		$results = $this->model_commands_account_info->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_account_info_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		$total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){
			
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;
		}else{
			$this->data['status_array'] = array();
		}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('commands/account_info', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkActivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'commands/bulk_account_info.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9 ]/', $str);
	}
 }
?> 