<?php 
/*
@File product.php(Controller)
ADMIN PRODUCT PAGE
    This class manages the channel in the store. Creating/ updating/ deleting of channels 
    can be done with the notification of success or failure.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCatalogPpv extends Controller {
	private $error = array(); 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the channel option in the dopdown list.
						It get all the channel list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin channel page.
*/
     
  	public function index() {
		$this->language->load('catalog/ppv');
    	
		$this->document->setTitle($this->language->get('heading_title')); 
		
		$this->load->model('catalog/ppv');
		
		$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert channel form page where the admin can give the
						details of the new channel which can be inserted.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin channel form page.
*/
  
  	public function insert() {
  		$obj = new restapi();
    	$this->language->load('catalog/ppv');

    	$this->document->setTitle($this->language->get('heading_title')); 
		
		$this->load->model('catalog/ppv');
// var_dump($this->request->post);//exit();
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			// var_dump($this->request->post);exit();
			$x=$this->request->post["product_description"];

			$duration=$this->request->post['ppv_duration'];
			$date_start=strtotime($duration[0]["date_start"]);
			$date_end=strtotime($duration[0]["date_end"]);
			$channel=$this->model_catalog_ppv->getProdList($this->request->post['product_id']);
// // var_dump($this->request->post);exit();
// 			if(isset($channel['name'])){
// 				$PPV_time=$this->model_catalog_ppv->getPPVList($channel["name"]);
				
// 				$Start=$this->model_catalog_ppv->getPPVListS($duration[0]["date_start"],$channel["name"]);
// 				$End=$this->model_catalog_ppv->getPPVListE($duration[0]["date_end"],$channel["name"]);
// 				for ($i=0; $i <count($PPV_time) ; $i++) { 
// 					$time_check1=strtotime($PPV_time[$i]["date_added"]);
// 					$time_check2=strtotime($PPV_time[$i]["date_modified"]);
// 				}
// 				if(($Start)||($End))
// 				{
// 					$this->error['warning'] ="Check Duration Of PPV!1";
// 					$this->getForm();
// 				}
// 				elseif(($date_start<$time_check1)&&($date_end>$time_check2))
// 				{
// 					$this->error['warning'] ="Check Duration Of PPV!2";
// 					$this->getForm();
// 				}
				// else{
					$date_start=$date_start-19800;
					$date_end=$date_end-19800;
					// var_dump((int)$this->request->post['product_id']);
					$api_prod_id=$this->model_catalog_ppv->getApiResponceId((int)$this->request->post['product_id']);
					// var_dump($api_prod_id);exit();
					$data="ppv_name=".$x[1]["name"]."&is_enabled=".(int)$this->request->post['status']."&product_id=".(int)$api_prod_id["api_product_id"]."&start_time=".$date_start."&end_time=".$date_end;
			 		$method ="POST";
					$url=KMS_API."/enablePPV";	
			 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
					$response=json_decode($apiresult);
		    		$error=true;
		    		$respId="";
		    		$apimessage='';
		    		$errorMsg='';
		    		foreach ($response as $key => $value) {
		    			switch ($key) {
		    				case 'error':
		    					$error=	$value;
		    					break;
		    				case 'message':
		    					$apimessage=$value;				
		    					break;
		    				case 'id':
		    					$respId=$value;	
		    					break;
		    				default:
		    					$errorMsg=$errorMsg." ".$key.":".$value;	
		    					break;
		    			}
	    			}
					if(!$error)
		        	{
		        		$this->model_catalog_ppv->addProduct($this->request->post);
		        		$result=$this->model_catalog_ppv->getPPVIdByName($x[1]["name"]);
			        	$product_id=$result[0]["product_id"];
		        		$y=$this->model_catalog_ppv->addApiResponceId($respId,$product_id);
		        		$this->session->data['success'] = $this->language->get('text_add_success');	
				  		$url = '';
		        	
						if (isset($this->request->get['filter_name'])) {
							$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
						}
						if (isset($this->request->get['filter_model'])) {
							$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
						}
						if (isset($this->request->get['filter_service_id'])) {
							$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
						}
						
						if (isset($this->request->get['filter_price'])) {
							$url .= '&filter_price=' . $this->request->get['filter_price'];
						}
						
						if (isset($this->request->get['filter_quantity'])) {
							$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
						}
						
						if (isset($this->request->get['filter_status'])) {
							$url .= '&filter_status=' . $this->request->get['filter_status'];
						}
								
						if (isset($this->request->get['sort'])) {
							$url .= '&sort=' . $this->request->get['sort'];
						}

						if (isset($this->request->get['order'])) {
							$url .= '&order=' . $this->request->get['order'];
						}

						if (isset($this->request->get['page'])) {
							$url .= '&page=' . $this->request->get['page'];
						}
						

						$this->load->model('json/feed');
						$this->model_json_feed->CreateChannelFeed();
						// $this->model_json_feed->CreatePackageFeed();
						// $this->model_json_feed->CreatePackChannelFeed();
						// -------------------------------------------------------------------------
							$this->WriteMessageLog("SUCCESS:","NA",$x[1]["name"],"addPPV");
						// -------------------------------------------------------------------------
						$this->redirect($this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL'));
					}else{
						// -------------------------------------------------------------------------
							$this->WriteMessageLog("ERROR:","NA",$x[1]["name"],"addPPV");
						// -------------------------------------------------------------------------
					 	$this->error['warning'] ="Cannot add PPV!";
					 	$this->getForm();
					}
				// }
			// }else{
		 // 		$this->error['warning'] =$this->language->get('text_insert_warning');
		 // 		$this->getForm();
			// }
    	}
		
    	$this->getForm();
  	}

/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected product/channel listed on the page. Admin selects the 
						checkbox against the product/channel in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the product/channel list page after deleting the product/channel from the list.
*/

  	public function delete() {
  		$obj = new restapi();
    	$this->language->load('catalog/ppv');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('catalog/ppv');
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $event_details) {
				$data= $this->model_catalog_ppv->getApiResponceId((int)$event_details);
	      		$data="ppv_id=".$data['api_product_id'];	
		 		$method ="POST";
		 		$url=KMS_API."/disablePPV";
		 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
	        	$response=json_decode($apiresult);
	        	$resp=true;
	        	$apimessage='';
	        	$error='';
	        	$errorMsg='';
	        	foreach ($response as $key=>$value) {
	        		switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'id':
	    					$resp=$value;	
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
		    		}
	        	}
	        	if(!$error)
	        	{
	        		$this->model_catalog_ppv->deleteProduct($event_details);
	        		$this->session->data['success'] =$this->language->get('text_success_delete');		
	        	}else{
	        		$this->session->data['warning'] =$errorMsg=$errorMsg." ".$message;		
	        	}
	  		}
	    	$this->getList();
		}
		else{
		$this->error['warning'] =$this->language->get('text_delete_select_warning');
    	$this->getList();
   	 }
  	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the product/channel added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the product/channel list.
*/
	
  	protected function getList() {	

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = null;
		}

		if (isset($this->request->get['filter_service_id'])) {
			$filter_service_id = $this->request->get['filter_service_id'];
		} else {
			$filter_service_id = null;
		}
		
		if (isset($this->request->get['filter_price'])) {
			$filter_price = $this->request->get['filter_price'];
		} else {
			$filter_price = null;
		}

		if (isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = null;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';	
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
						
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		if (isset($this->request->get['filter_end_time'])) {
			$url .= '&filter_end_time=' . $this->request->get['filter_end_time'];
		}
		if (isset($this->request->get['filter_start_time'])) {
			$url .= '&filter_start_time=' . $this->request->get['filter_start_time'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}		

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
						
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		if(isset($this->request->get['filter_name'])||isset($this->request->get['filter_model'])||isset($this->request->get['filter_service_id'])||isset($this->request->get['filter_name'])||isset($this->request->get['filter_price'])||isset($this->request->get['filter_quantity'])||isset($this->request->get['filter_status'])){
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'], 'SSL'),
	      		'separator' => ' :: '
	   		);
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_filter'),
				'href'      => $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
   		}
   		else{
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL'),       		
	      		'separator' => ' :: '
	   		);
	   	}

		$this->data['insert'] = $this->url->link('catalog/ppv/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['copy'] = $this->url->link('catalog/ppv/copy', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['delete'] = $this->url->link('catalog/ppv/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
    	
		$this->data['products'] = array();



		$data = array(
			'filter_name'	  => $filter_name, 
			'filter_model'	  => $filter_model,
			'filter_service_id'	  => $filter_service_id,
			'filter_price'	  => $filter_price,
			// 'start_time'	  => $filter_start_time,
			// 'end_time'	 	  => $filter_end_time,
			'filter_quantity' => $filter_quantity,
			'filter_status'   => $filter_status,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		$this->load->model('tool/image');
		
		$product_total = $this->model_catalog_ppv->getTotalProducts($data);
			
		$results = $this->model_catalog_ppv->getProducts($data);
		
		
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/ppv/update', 'token=' . $this->session->data['token'] . '&product_id=' . $result['product_id'] . $url, 'SSL')
			);
			$productName = $this->model_catalog_ppv->getProductName($result['product_id']);
			$productDetails = $this->model_catalog_ppv->getProductDetails($result['product_id']);
      		$start_time=strtotime($result["date_added"]);
      		$end_time=strtotime($result["date_modified"]);
      		
      		$t=time();
      		$this->data['products'][] = array(
      				'product_id'=>$result["product_id"],
				'name'       => $result['name'],
				'model'      => $result["channel_list"],
				'service_id' => $result["service_id"],
				'price'      => number_format($result['price'],2,'.',''),
				'start_time' =>$result["date_added"],
				'end_time'   =>$result["date_modified"],
				 'isppv'		=>$result["is_ppv"],
				'image'      => $productDetails['image'],
				'status'     => ($productDetails['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'selected'   => isset($this->request->post['selected']) && in_array($productDetails['service_id'], $this->request->post['selected']),
				'action'     => $action
			);
    	}
    
		$this->data['heading_title'] = $this->language->get('heading_title');		
				
		$this->data['text_enabled'] = $this->language->get('text_enabled');		
		$this->data['text_disabled'] = $this->language->get('text_disabled');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');		
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');		
			
		$this->data['column_image'] = $this->language->get('column_image');		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_no'] = $this->language->get('column_no');		
		$this->data['column_model'] = $this->language->get('column_model');
		$this->data['column_service_id'] = $this->language->get('column_service_id');		
		$this->data['column_price'] = $this->language->get('column_price');		
		$this->data['column_quantity'] = $this->language->get('column_quantity');

		$this->data['column_start_date'] = $this->language->get('column_start_date');		
		$this->data['column_end_date'] = $this->language->get('column_end_date');

		$this->data['column_status'] = $this->language->get('column_status');		
		$this->data['column_action'] = $this->language->get('column_action');		
				
		$this->data['button_copy'] = $this->language->get('button_copy');		
		$this->data['button_insert'] = $this->language->get('button_insert');		
		$this->data['button_delete'] = $this->language->get('button_delete');		
		$this->data['button_filter'] = $this->language->get('button_filter');
		 
 		$this->data['token'] = $this->session->data['token'];
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			if(isset($this->request->get['error'])){
				$this->data['error_warning'] = "Warning: PPV start time is less thean current time!";
			}else{
				$this->data['error_warning'] = '';
			}
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
					
		$this->data['sort_name'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=pd.name' . $url, 'SSL');
		$this->data['sort_model'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.model' . $url, 'SSL');
		$this->data['sort_service_id'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.service_id' . $url, 'SSL');
		$this->data['sort_price'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.price' . $url, 'SSL');
		$this->data['sort_quantity'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.quantity' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.status' . $url, 'SSL');
		$this->data['sort_order'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . '&sort=p.sort_order' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		if (isset($this->request->get['filter_start_time'])) {
			$url .= '&filter_start_time=' . $this->request->get['filter_start_time'];
		}
		if (isset($this->request->get['filter_end_time'])) {
			$url .= '&filter_end_time=' . $this->request->get['filter_end_time'];
		}
		
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'catalog/ppv_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the package details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/

  	public function update() {
		$obj = new restapi();
    	$this->language->load('catalog/ppv');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/ppv');
		// var_dump($this->request->get["product_id"]);exit();
		$status = $this->model_catalog_ppv->gettime($this->request->get["product_id"]);
		if($status==0){
			// $this->error['warning'] = "Warning: PPV start time is less thean current time!";
			$this->redirect($this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url.'&error=1', 'SSL'));
		}

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    		// var_dump($this->request->get);
    		// var_dump($this->request->get['date_start']);
    		// var_dump($this->request->get['date_end']);exit();
			$x=$this->request->post["product_description"];
			$duration=$this->request->post['ppv_duration'];
			$date_start=strtotime($duration[0]["date_start"]);
			$date_end=strtotime($duration[0]["date_end"]);
			// $channel="";
			$channel_list=$this->model_catalog_ppv->getPpvByChannel($x[1]["name"]);
			$channel=$this->model_catalog_ppv->getProdList($channel_list["product_id"]);
			$PPV_time=$this->model_catalog_ppv->getPPVList($channel["name"]);
			
			// $time_check1="";
			// $Start=$this->model_catalog_ppv->getPPVListS($duration[0]["date_start"],$channel["name"]);
			// $End=$this->model_catalog_ppv->getPPVListE($duration[0]["date_end"],$channel["name"]);
			// for ($i=0; $i <count($PPV_time) ; $i++) { 
			// 	$time_check1=strtotime($PPV_time[$i]["date_added"]);
			// 	$time_check2=strtotime($PPV_time[$i]["date_modified"]);
			// }
			// if(($Start)||($End))
			// {
			// 	$this->error['warning'] ="Check Duration Of PPV!1";
			// 	$this->getForm();
			// }
			// elseif(($date_start<$time_check1)&&($date_end>$time_check2))
			// {
			// 	$this->error['warning'] ="Check Duration Of PPV!2";
			// 	$this->getForm();
			// }
			// else{
				$date_start=$date_start-19800;
				$date_end=$date_end-19800;

				$channel_id=$this->model_catalog_ppv->getProductApiId($channel_list["channel_list"]);
				$data="ppv_name=".$x[1]["name"]."&is_enabled=".(int)$this->request->post['status']."&product_id=".(int)$channel_id["api_product_id"]."&start_time=".$date_start."&end_time=".$date_end."&update_id=".(int)$channel_id["api_product_id"];

				$method ="POST";
				$uri=KMS_API."/enablePPV";	
	 			$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
				$res=$obj->callAPI($method,$hdr,$uri,$data);
				
				$response=json_decode($res);
				$error=true;
				$apimessage='';
				$errorMsg='';
				foreach ($response as $key=>$value) 
				{
					switch ($key) {
	    				case 'error':
	    					$error=	$value;
	    					break;
	    				case 'message':
	    					$apimessage=$value;				
	    					break;
	    				case 'id':
	    					$resp=$value;	
	    					break;
	    				default:
	    					$errorMsg=$errorMsg." ".$key.":".$value;	
	    					break;
		    		}
    			}
    			
    			if(!$error)
	    		{
					$p=$this->model_catalog_ppv->editProduct($this->request->get['product_id'], $this->request->post);
					$this->session->data['success'] = $this->language->get('text_success');
			
					$url = '';
					
					if (isset($this->request->get['filter_name'])) {
						$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
					}
				
					if (isset($this->request->get['filter_model'])) {
						$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
					}
					
					if (isset($this->request->get['filter_price'])) {
						$url .= '&filter_price=' . $this->request->get['filter_price'];
					}
					
					if (isset($this->request->get['filter_quantity'])) {
						$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
					}	
				
					if (isset($this->request->get['filter_status'])) {
						$url .= '&filter_status=' . $this->request->get['filter_status'];
					}
							
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}

					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}

					if (isset($this->request->get['page'])) {
						$url .= '&page=' . $this->request->get['page'];
					}

					$this->load->model('json/feed');
					$this->model_json_feed->CreateChannelFeed();
					// $this->model_json_feed->CreatePackageFeed();
					// $this->model_json_feed->CreatePackChannelFeed();
					// -------------------------------------------------------------------------
						$this->WriteMessageLog("SUCCESS:","NA",$x[1]["name"],"modifyPPV");
					// -------------------------------------------------------------------------
					$this->redirect($this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL'));
				}else{
					// -------------------------------------------------------------------------
						$this->WriteMessageLog("SUCCESS:","NA",$x[1]["name"],"modifyPPV");
					// -------------------------------------------------------------------------
	    			$this->error['warning'] = $errorMsg=$errorMsg." ".$apimessage;
	    			$this->getForm();
	    		}
			// }
		}
    	$this->getForm();
  	}


/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the product/channel content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the product/channel form page.
*/
  	protected function getForm() {
$this->language->load('catalog/ppv');
    	$this->data['heading_title'] = $this->language->get('heading_title');
 
    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
    	$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_yes'] = $this->language->get('text_yes');
    	$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_plus'] = $this->language->get('text_plus');
		$this->data['text_minus'] = $this->language->get('text_minus');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_option_value'] = $this->language->get('text_option_value');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_percent'] = $this->language->get('text_percent');
		$this->data['text_amount'] = $this->language->get('text_amount');

		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_service_id'] = $this->language->get('entry_service_id');
		$this->data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$this->data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_keyword'] = $this->language->get('entry_keyword');
    	$this->data['entry_model'] = $this->language->get('entry_model');
		$this->data['entry_sku'] = $this->language->get('entry_sku');
		$this->data['entry_upc'] = $this->language->get('entry_upc');
		$this->data['entry_ean'] = $this->language->get('entry_ean');
		$this->data['entry_jan'] = $this->language->get('entry_jan');
		$this->data['entry_isbn'] = $this->language->get('entry_isbn');
		$this->data['entry_mpn'] = $this->language->get('entry_mpn');
		$this->data['entry_location'] = $this->language->get('entry_location');
		$this->data['entry_minimum'] = $this->language->get('entry_minimum');
		$this->data['entry_manufacturer'] = $this->language->get('entry_manufacturer');
    	$this->data['entry_shipping'] = $this->language->get('entry_shipping');
    	$this->data['entry_date_available'] = $this->language->get('entry_date_available');
    	$this->data['entry_quantity'] = $this->language->get('entry_quantity');
		$this->data['entry_stock_status'] = $this->language->get('entry_stock_status');
    	$this->data['entry_price'] = $this->language->get('entry_price');
		$this->data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$this->data['entry_points'] = $this->language->get('entry_points');
		$this->data['entry_option_points'] = $this->language->get('entry_option_points');
		$this->data['entry_subtract'] = $this->language->get('entry_subtract');
    	$this->data['entry_weight_class'] = $this->language->get('entry_weight_class');
    	$this->data['entry_weight'] = $this->language->get('entry_weight');
		$this->data['entry_dimension'] = $this->language->get('entry_dimension');
		$this->data['entry_length'] = $this->language->get('entry_length');
    	$this->data['entry_image'] = $this->language->get('entry_image');
    	$this->data['entry_download'] = $this->language->get('entry_download');
    	$this->data['entry_category'] = $this->language->get('entry_category');
		$this->data['entry_filter'] = $this->language->get('entry_filter');
		$this->data['entry_related'] = $this->language->get('entry_related');
		$this->data['entry_attribute'] = $this->language->get('entry_attribute');
		//-------
		$this->data['entry_duration'] = $this->language->get('entry_duration');
		$this->data['entry_start_time'] = $this->language->get('entry_start_time');
		$this->data['entry_end_time'] = $this->language->get('entry_end_time');
		//---------
		$this->data['entry_text'] = $this->language->get('entry_text');
		$this->data['entry_option'] = $this->language->get('entry_option');
		$this->data['entry_option_value'] = $this->language->get('entry_option_value');
		$this->data['entry_required'] = $this->language->get('entry_required');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_priority'] = $this->language->get('entry_priority');
		$this->data['entry_tag'] = $this->language->get('entry_tag');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_reward'] = $this->language->get('entry_reward');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
				
    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_attribute'] = $this->language->get('button_add_attribute');
		$this->data['button_add_option'] = $this->language->get('button_add_option');
		$this->data['button_add_option_value'] = $this->language->get('button_add_option_value');
		$this->data['button_add_discount'] = $this->language->get('button_add_discount');
		$this->data['button_add_special'] = $this->language->get('button_add_special');
		$this->data['button_add_image'] = $this->language->get('button_add_image');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
    	$this->data['tab_general'] = $this->language->get('tab_general');
    	$this->data['tab_data'] = $this->language->get('tab_data');
		$this->data['tab_attribute'] = $this->language->get('tab_attribute');
		//---------
		$this->data['tab_duration'] = $this->language->get('tab_duration');
		$this->data['button_add_duration'] = $this->language->get('button_add_duration');

		//----------
		$this->data['tab_option'] = $this->language->get('tab_option');		
		$this->data['tab_discount'] = $this->language->get('tab_discount');
		$this->data['tab_special'] = $this->language->get('tab_special');
    	$this->data['tab_image'] = $this->language->get('tab_image');		
		$this->data['tab_links'] = $this->language->get('tab_links');
		$this->data['tab_reward'] = $this->language->get('tab_reward');
		$this->data['tab_design'] = $this->language->get('tab_design');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = array();
		}

		if (isset($this->error['subscription_price'])) {
			$this->data['error_subscription_price'] = $this->error['subscription_price'];
		} else {
			$this->data['error_subscription_price'] = '';
		}		

		if (isset($this->error['category'])) {
			$this->data['error_category'] = $this->error['category'];
		} else {
			$this->data['error_category'] = '';
		}

		if (isset($this->error['option'])) {
			$this->data['error_option'] = $this->error['option'];
		} else {
			$this->data['error_option'] = '';
		}
		if (isset($this->error['duration'])) {
			$this->data['error_duration'] = $this->error['duration'];
		} else {
			$this->data['error_duration'] = '';
		}

 		if (isset($this->error['meta_description'])) {
			$this->data['error_meta_description'] = $this->error['meta_description'];
		} else {
			$this->data['error_meta_description'] = array();
		}		
   
   		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = array();
		}	
		
   		if (isset($this->error['model'])) {
			$this->data['error_model'] = $this->error['model'];
		} else {
			$this->data['error_model'] = '';
		}	
		
		if (isset($this->error['service_id'])) {
			$this->data['error_service_id'] = $this->error['service_id'];
		} else {
			$this->data['error_service_id'] = '';
		}	
     	
		if (isset($this->error['date_available'])) {
			$this->data['error_date_available'] = $this->error['date_available'];
		} else {
			$this->data['error_date_available'] = '';
		}	

		if (isset($this->error['price'])) {
			$this->data['error_price'] = $this->error['price'];
		} else {
			$this->data['error_price'] = '';
		}	

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
		}
		if (isset($this->request->get['filter_service_id'])) {
			$url .= '&filter_service_id=' . urlencode(html_entity_decode($this->request->get['filter_service_id'], ENT_QUOTES, 'UTF-8'));
		}
		
		if (isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}
		//-----------
		if (isset($this->request->get['filter_start_time'])) {
			$url .= '&filter_start_time=' . $this->request->get['filter_start_time'];
		}if (isset($this->request->get['filter_end_time'])) {
			$url .= '&filter_end_time=' . $this->request->get['filter_end_time'];
		}
		//----------
		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}	
		
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
								
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
									
		if (!isset($this->request->get['product_id'])) {
			$this->data['action'] = $this->url->link('catalog/ppv/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('catalog/ppv/update', 'token=' . $this->session->data['token'] . '&product_id=' . $this->request->get['product_id'] . $url, 'SSL');
		}

		
		$this->data['cancel'] = $this->url->link('catalog/ppv', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$product_info = $this->model_catalog_ppv->getProduct($this->request->get['product_id']);
    	}
    	
		$this->data['token'] = $this->session->data['token'];
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['product_description'])) {
			$this->data['product_description'] = $this->request->post['product_description'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_description'] = $this->model_catalog_ppv->getProductDescriptions($this->request->get['product_id']);
		} else {
			$this->data['product_description'] = array();
		}
		
		if (isset($this->request->post['model'])) {
      		$this->data['model'] = $this->request->post['model'];
    	} elseif (!empty($product_info)) {
			$this->data['model'] = $product_info['model'];
		} else {
      		$this->data['model'] = '';
    	}

  //   	//--------------
		$this->load->model('catalog/ppv');
			
		$this->data['ppv_channel'] = $this->model_catalog_ppv->getPpvChannel();
		
    	if (isset($this->request->post['model'])) {
      		$this->data['model'] = $this->request->post['model'];
    	
    	} elseif (!empty($product_info)) { 
			// $this->data['model'] = $product_info['model'];
			$this->data['model'] = $this->config->get('product_id');
		
		} else {
      		$this->data['model'] = $this->config->get('product_id');
    		
    	// 	var_dump($this->data['ppv_channel']);
    	// exit();
    	}
    	if (isset($this->request->post['product_id'])) {
      		$this->data['product_id'] = $this->request->post['product_id'];
      		$this->data['product_name'] = '';
    	} elseif (!empty($product_info)) {

    		$channel_details = $this->model_catalog_ppv->getPpvByChannel($product_info['channel_list']); 
			// var_dump($product_info['channel_list']);
			$this->data['product_id'] = $channel_details['product_id'];
			// var_dump($channel_details['product_id']);exit();
			$this->data['product_name'] = '';
			
		} else {
      		$this->data['product_id'] = $this->config->get('product_id');
      		$this->data['product_name'] = '';
    
    	}

    	if (isset($this->request->post['service_id'])) {
      		$this->data['service_id'] = $this->request->post['service_id'];
    	} elseif (!empty($product_info)) {
			$this->data['service_id'] = $product_info['service_id'];
		} else {
      		$this->data['service_id'] = '';
    	}

		if (isset($this->request->post['sku'])) {
      		$this->data['sku'] = $this->request->post['sku'];
    	} elseif (!empty($product_info)) {
			$this->data['sku'] = $product_info['sku'];
		} else {
      		$this->data['sku'] = '';
    	}
		
		if (isset($this->request->post['upc'])) {
      		$this->data['upc'] = $this->request->post['upc'];
    	} elseif (!empty($product_info)) {
			$this->data['upc'] = $product_info['upc'];
		} else {
      		$this->data['upc'] = '';
    	}
		
		if (isset($this->request->post['ean'])) {
      		$this->data['ean'] = $this->request->post['ean'];
    	} elseif (!empty($product_info)) {
			$this->data['ean'] = $product_info['ean'];
		} else {
      		$this->data['ean'] = '';
    	}
		
		if (isset($this->request->post['jan'])) {
      		$this->data['jan'] = $this->request->post['jan'];
    	} elseif (!empty($product_info)) {
			$this->data['jan'] = $product_info['jan'];
		} else {
      		$this->data['jan'] = '';
    	}
		
		if (isset($this->request->post['isbn'])) {
      		$this->data['isbn'] = $this->request->post['isbn'];
    	} elseif (!empty($product_info)) {
			$this->data['isbn'] = $product_info['isbn'];
		} else {
      		$this->data['isbn'] = '';
    	}
		
		if (isset($this->request->post['mpn'])) {
      		$this->data['mpn'] = $this->request->post['mpn'];
    	} elseif (!empty($product_info)) {
			$this->data['mpn'] = $product_info['mpn'];
		} else {
      		$this->data['mpn'] = '';
    	}
    	
		if (isset($this->request->post['location'])) {
      		$this->data['location'] = $this->request->post['location'];
    	} elseif (!empty($product_info)) {
			$this->data['location'] = $product_info['location'];
		} else {
      		$this->data['location'] = '';
    	}

		$this->load->model('setting/store');
		
		$this->data['stores'] = $this->model_setting_store->getStores();
		
		if (isset($this->request->post['product_store'])) {
			$this->data['product_store'] = $this->request->post['product_store'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_store'] = $this->model_catalog_ppv->getProductStores($this->request->get['product_id']);
		} else {
			$this->data['product_store'] = array(0);
		}	
		
		if (isset($this->request->post['keyword'])) {
			$this->data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($product_info)) {
			$this->data['keyword'] = $product_info['keyword'];
		} else {
			$this->data['keyword'] = '';
		}
		
		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (!empty($product_info)) {
			$this->data['image'] = $product_info['image'];
		} else {
			$this->data['image'] = '';
		}
		
		$this->load->model('tool/image');
		
		if (isset($this->request->post['image']) && file_exists(DIR_IMAGE . $this->request->post['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($product_info) && $product_info['image'] && file_exists(DIR_IMAGE . $product_info['image'])) {
			$this->data['thumb'] = $this->model_tool_image->resize($product_info['image'], 100, 100);
		} else {
			$this->data['thumb'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
  //   	if (isset($this->request->post['shipping'])) {
  //     		$this->data['shipping'] = $this->request->post['shipping'];
  //   	} elseif (!empty($product_info)) {
  //     		$this->data['shipping'] = $product_info['shipping'];
  //   	} else {
		// 	$this->data['shipping'] = 1;
		// }
		
  //   	if (isset($this->request->post['price']) && $this->request->post['price']!='') {
  //     		$this->data['price'] = number_format($this->request->post['price'],2,'.','');
  //   	} elseif (!empty($product_info)) {
		// 	$this->data['price'] = number_format($product_info['price'],2,'.','');
		// } else {
  //     		$this->data['price'] = '';
  //   	}

		if (isset($this->request->post['price'])){
			if(!is_numeric($this->request->post['price'])){
				// var_dump($this->request->post['price']);
				$this->data['price'] = '';
			}else{
				$this->data['price'] = number_format($this->request->post['price'],2,'.','');
			}
		}else{
	    	if (isset($this->request->post['price']) && $this->request->post['price']!='') {
	      		$this->data['price'] = number_format($this->request->post['price'],2,'.','');
	    	} elseif (!empty($product_info)) {
				$this->data['price'] = number_format($product_info['price'],2,'.','');
			} else {
	      		$this->data['price'] = '';
	    	}
		}

		
		$this->load->model('localisation/tax_class');
		
		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
    	
		if (isset($this->request->post['tax_class_id'])) {
      		$this->data['tax_class_id'] = $this->request->post['tax_class_id'];
    	} elseif (!empty($product_info)) {
			$this->data['tax_class_id'] = $product_info['tax_class_id'];
		} else {
      		$this->data['tax_class_id'] = 0;
    	}
		      	
		if (isset($this->request->post['date_available'])) {
       		$this->data['date_available'] = $this->request->post['date_available'];
		} elseif (!empty($product_info)) {
			// $this->data['date_available'] = date('Y-m-d', strtotime($product_info['date_available']));
			$this->data['date_available'] = date('Y-m-d', strtotime($product_info['date_available']));
		} else {
			// $this->data['date_available'] = date('Y-m-d', time() - 86400);
			$this->data['date_available'] = date('Y-m-d', time() );
		}
									
		if (isset($this->request->post['sort_order'])) {
      		$this->data['sort_order'] = $this->request->post['sort_order'];
    	} elseif (!empty($product_info)) {
      		$this->data['sort_order'] = $product_info['sort_order'];
    	} else {
			$this->data['sort_order'] = 1;
		}

		$this->load->model('localisation/stock_status');
		
		$this->data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();
    	
		if (isset($this->request->post['stock_status_id'])) {
      		$this->data['stock_status_id'] = $this->request->post['stock_status_id'];
    	} elseif (!empty($product_info)) {
      		$this->data['stock_status_id'] = $product_info['stock_status_id'];
    	} else {
			$this->data['stock_status_id'] = $this->config->get('config_stock_status_id');
		}
				
    	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (!empty($product_info)) {
			$this->data['status'] = $product_info['status'];
		} else {
      		$this->data['status'] = 1;
    	}


		$this->load->model('catalog/manufacturer');
		
    	if (isset($this->request->post['manufacturer_id'])) {
      		$this->data['manufacturer_id'] = $this->request->post['manufacturer_id'];
		} elseif (!empty($product_info)) {
			// $this->data['manufacturer_id'] = $product_info['manufacturer_id'];
		} else {
      		$this->data['manufacturer_id'] = 0;
    	} 		
		
    	if (isset($this->request->post['manufacturer'])) {
      		$this->data['manufacturer'] = $this->request->post['manufacturer'];
		} elseif (!empty($product_info)) {
			// $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);
			
			// if ($manufacturer_info) {		
				$this->data['manufacturer'] ="";// $manufacturer_info['name'];
			// } else {
			// 	$this->data['manufacturer'] = '';
			// }	
		} else {
      		$this->data['manufacturer'] = '';
    	} 
		
		// Categories
		$this->load->model('catalog/category');
		
		if (isset($this->request->post['product_category'])) {
			$categories = $this->request->post['product_category'];
		} elseif (isset($this->request->get['product_id'])) {		
			$categories = $this->model_catalog_ppv->getProductCategories($this->request->get['product_id']);
		} else {
			$categories = array();
		}
	
		$this->data['product_categories'] = array();
		
		foreach ($categories as $category_id) {
			$category_info = $this->model_catalog_ppv->getCategory($category_id);
			
			if ($category_info) {
				$this->data['product_categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => ($category_info['path'] ? $category_info['path'] . ' &gt; ' : '') . $category_info['name']
				);
			}
		}
			
		// // Filters
		$this->load->model('catalog/filter');
		
		if (isset($this->request->post['product_filter'])) {
			$filters = $this->request->post['product_filter'];
		} elseif (isset($this->request->get['product_id'])) {
			$filters = $this->model_catalog_ppv->getProductFilters($this->request->get['product_id']);
		} else {
			$filters = array();
		}
		
		$this->data['product_filters'] = array();
		
		foreach ($filters as $filter_id) {
			$filter_info = $this->model_catalog_filter->getFilter($filter_id);
			
			if ($filter_info) {
				$this->data['product_filters'][] = array(
					'filter_id' => $filter_info['filter_id'],
					'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
				);
			}
		}		
		
		// Attributes
		$this->load->model('catalog/attribute');
		
		if (isset($this->request->post['product_attribute'])) {
			$product_attributes = $this->request->post['product_attribute'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_attributes = $this->model_catalog_ppv->getProductAttributes($this->request->get['product_id']);
		} else {
			$product_attributes = array();
		}
		
		$this->data['product_attributes'] = array();
		
		foreach ($product_attributes as $product_attribute) {
			$attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);
			
			if ($attribute_info) {
				$this->data['product_attributes'][] = array(
					'attribute_id'                  => $product_attribute['attribute_id'],
					'name'                          => $attribute_info['name'],
					'product_attribute_description' => $product_attribute['product_attribute_description']
				);
			}
		}	

		//-------------------
	
	
		if (isset($this->request->post['product_durations'])) {
			$product_info = $this->request->post['product_durations'];
			} 
			elseif (isset($this->request->get['product_id'])) {
			$product_info = $this->model_catalog_ppv->getProduct($this->request->get['product_id']);
			$this->data['is_edit']=0;
		} 
		else {
			$product_info = array();
				}
			$this->data['product_durations'] = array();
			 if ($product_info) {
				$this->data['product_durations'][] = array(
					'date_start'                  => $product_info['date_added'],
					'date_end'                    => $product_info['date_modified']
					
				);
				$this->data['is_edit']=1;
		 }
		 	
		//---------------------
		// $this->load->model('catalog/ppv');
		// // var_dump($this->request->post['start_time']);
		// // 	exit(0);
		
		// if (isset($this->request->post['ppv_duration'])) {
		// 	$ppv_durations = $this->request->post['ppv_duration'];
		// } 
		// elseif (isset($this->request->get['product_id'])) {

		// 	$ppv_durations = $this->model_catalog_ppv->getProductppv($this->request->get['product_id']);
		// } else {
		// 	$ppv_durations = array();
		// }
		// echo "Raviii";
		// $this->data['ppv_durations'] = array();
		
		// // foreach ($ppv_durations as $ppv_duration) {
		// // 	 $ppv_duration_info = $this->model_catalog_ppv->getPpvDuration($this->request->get['product_id']);
			
		// // 	if ($ppv_duration_info) {
		// // 		$this->data['ppv_durations'][] = array(
		// // 			'start_time'                  => $ppv_duration['start_time'],
		// // 			'end_time'                          => $ppv_duration['end_time']
					
		// // 		);
		// // 	}
		// // }			
			
		// // Options
		// $this->load->model('catalog/option');
		
		// if (isset($this->request->post['product_option'])) {
		// 	$product_options = $this->request->post['product_option'];
		// } elseif (isset($this->request->get['product_id'])) {
		// 	$product_options = $this->model_catalog_ppv->getProductOptions($this->request->get['product_id']);			
		// } else {
		// 	$product_options = array();
		// }
		
		// $this->data['product_options'] = array();
			
		// foreach ($product_options as $product_option) {
		// 	$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
				
		// 	if ($option_info) {
		// 		if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
		// 			$product_option_value_data = array();
		// 			if(isset($product_option['product_option_value']))
		// 			{
		// 				foreach ($product_option['product_option_value'] as $product_option_value) {
							
		// 					$product_option_value_data[] = array(
		// 						'product_option_value_id' => $product_option_value['product_option_value_id'],
		// 						'option_value_id'         => $product_option_value['option_value_id'],
		// 						'price'                   => $product_option_value['price'],
		// 						'price_prefix'            => $product_option_value['price_prefix'],
		// 						'points'                  => $product_option_value['points'],
		// 						'points_prefix'           => $product_option_value['points_prefix'],						
		// 					);
		// 				}
		// 			}					
					
		// 			$this->data['product_options'][] = array(
		// 				'product_option_id'    => $product_option['product_option_id'],
		// 				'product_option_value' => $product_option_value_data,
		// 				'option_id'            => $product_option['option_id'],
		// 				'name'                 => $option_info['name'],
		// 				'type'                 => $option_info['type'],
		// 				'required'             => $product_option['required']
		// 			);				
		// 		} else {
		// 			$this->data['product_options'][] = array(
		// 				'product_option_id' => $product_option['product_option_id'],
		// 				'option_id'         => $product_option['option_id'],
		// 				'name'              => $option_info['name'],
		// 				'type'              => $option_info['type'],
		// 				'option_value'      => $product_option['option_value'],
		// 				'required'          => $product_option['required']
		// 			);				
		// 		}
		// 	}
		// }
		
		// $this->data['option_values'] = array();
		// foreach ($this->data['product_options'] as $product_option) {
		// 	if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
		// 		if (!isset($this->data['option_values'][$product_option['option_id']])) {
		// 			$this->data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getOptionValues($product_option['option_id']);
				
					
				
		// 		}

		// 	}
		// }
		
		$this->load->model('sale/customer_group');
		
		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		
		if (isset($this->request->post['product_discount'])) {
			$this->data['product_discounts'] = $this->request->post['product_discount'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_discounts'] = $this->model_catalog_ppv->getProductDiscounts($this->request->get['product_id']);
		} else {
			$this->data['product_discounts'] = array();
		}

		if (isset($this->request->post['product_special'])) {
			$this->data['product_specials'] = $this->request->post['product_special'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_specials'] = $this->model_catalog_ppv->getProductSpecials($this->request->get['product_id']);
		} else {
			$this->data['product_specials'] = array();
		}
		
		// Images
		if (isset($this->request->post['product_image'])) {
			$product_images = $this->request->post['product_image'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_images = $this->model_catalog_ppv->getProductImages($this->request->get['product_id']);
		} else {
			$product_images = array();
		}
		
		$this->data['product_images'] = array();
		
		foreach ($product_images as $product_image) {
			if ($product_image['image'] && file_exists(DIR_IMAGE . $product_image['image'])) {
				$image = $product_image['image'];
			} else {
				$image = 'no_image.jpg';
			}
			
			$this->data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($image, 100, 100),
				'sort_order' => $product_image['sort_order']
			);
		}

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		// Downloads
		$this->load->model('catalog/download');
		
		if (isset($this->request->post['product_download'])) {
			$product_downloads = $this->request->post['product_download'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_downloads = $this->model_catalog_ppv->getProductDownloads($this->request->get['product_id']);
		} else {
			$product_downloads = array();
		}
			
		$this->data['product_downloads'] = array();
		
		foreach ($product_downloads as $download_id) {
			$download_info = $this->model_catalog_download->getDownload($download_id);
			
			if ($download_info) {
				$this->data['product_downloads'][] = array(
					'download_id' => $download_info['download_id'],
					'name'        => $download_info['name']
				);
			}

		}
		//----------------
	
    	$this->load->model('catalog/ppv');

		
			
		//-----------------
		if (isset($this->request->post['product_related'])) {
					
			 $products = $this->request->post['product_related'];
		} elseif (isset($this->request->get['product_id'])) {	

			$this->data['ppv_products']=$products = $this->model_catalog_ppv->getProductRelated($this->request->get['product_id']);
		} else {
			$products = array();
		}
		//----
		$this->data['ppv_products'] = $this->model_catalog_ppv->getProductRelated($products);
		//------
		$this->data['product_related'] = array();
		
		foreach ($products as $product_id) {
			$related_info = $this->model_catalog_ppv->getProduct($product_id);
			
			if ($related_info) {
				$this->data['product_related'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
				);
			}
		}

    	if (isset($this->request->post['points'])) {
      		$this->data['points'] = $this->request->post['points'];
    	} elseif (!empty($product_info)) {
			$this->data['points'] = $product_info['points'];
		} else {
      		$this->data['points'] = '';
    	}
						
		if (isset($this->request->post['product_reward'])) {
			$this->data['product_reward'] = $this->request->post['product_reward'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_reward'] = $this->model_catalog_ppv->getProductRewards($this->request->get['product_id']);
		} else {
			$this->data['product_reward'] = array();
		}
		
		if (isset($this->request->post['product_layout'])) {
			$this->data['product_layout'] = $this->request->post['product_layout'];
		} elseif (isset($this->request->get['product_id'])) {
			$this->data['product_layout'] = $this->model_catalog_ppv->getProductLayouts($this->request->get['product_id']);
		} else {
			$this->data['product_layout'] = array();
		}

		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
										
		$this->template = 'catalog/ppv_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	} 
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the product/channel details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

	
  	protected function validateForm() { 
  		// var_dump($this->request->post);exit();
    	if (!$this->user->hasPermission('modify', 'catalog/ppv')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	$is_edit = 0;
    	foreach ($this->request->post['product_description'] as $language_id => $value) {
    		$value['name'] = preg_replace('!\s+!', ' ', $value['name']);
    		if (isset($this->request->get['product_id'])) {
      			$is_edit = 1;
      			$ppvname = $this->model_catalog_ppv->isProductNameExists($this->request->get['product_id']);
      		}
      		if (!strlen(trim($value['name'])) || (utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 255)) {
        		$this->error['name'][$language_id] = $this->language->get('error_name');
      		}elseif(preg_match('/[^a-z0-9 _]+/i', trim($value['name']))) {
      			$this->error['name'][$language_id] = 'Special Characters not allowed.';
      		}
      		$cnt = $this->model_catalog_ppv->isProductNameExists($value['name']);
      		if($cnt >= 1 ){
      			if(!isset($ppvname)){
      				$this->error['name'][$language_id] = $this->language->get('Duplicate name!!');	
      			}elseif($ppvname!=$value['name']){
      				$this->error['name'][$language_id] = $this->language->get('Duplicate name!!');	
      			}
      		}
    	}
		//---------------
		// var_dump($this->request->post['ppv_duration']);exit();
		if(isset($this->request->post['ppv_duration'])){		
    		$duration=$this->request->post['ppv_duration'];
    		// var_dump($duration[0]["date_start"]);exit();
    		if($duration[0]["date_start"]!="" && $duration[0]["date_end"]!=""){
			$date_start=strtotime($duration[0]["date_start"]);
			$date_end=strtotime($duration[0]["date_end"]);
			$channel=$this->model_catalog_ppv->getProdList($this->request->post['product_id']);
			if(isset($channel['name'])){
				$PPV_time=$this->model_catalog_ppv->getPPVList($channel["name"]);
				$Start=$this->model_catalog_ppv->getPPVListS($duration[0]["date_start"],$channel["name"]);
				$End=$this->model_catalog_ppv->getPPVListE($duration[0]["date_end"],$channel["name"]);
				for ($i=0; $i <count($PPV_time) ; $i++) { 
					$time_check1=strtotime($PPV_time[$i]["date_added"]);
					$time_check2=strtotime($PPV_time[$i]["date_modified"]);
				}
				if(($Start)||($End))
				{
					$this->error['warning'] ="Warning: Check Duration Of ppv already created with same start/end time!";
				}elseif(isset($time_check1)){
					if(($date_start<$time_check1)&&($date_end>$time_check2))
					{
						$this->error['warning'] ="Check Duration Of PPV!!!";
					}
				}	
			}
    	//-------------------
    	if (!isset($this->request->post["ppv_duration"])) {
				$this->error['duration']="Select the Time Duration!";// $this->language->get('error_category_mismatch');
			}
		else{
			$str1=(strtotime($this->request->post["ppv_duration"][0]["date_start"]));
			$str2=(strtotime($this->request->post["ppv_duration"][0]["date_end"]));
			$t=time();
		if (($str1=='')||($str2=='')||($str1>=$str2)) {
			$this->error['duration']="Check the selected time duration!";
		}elseif(($str1<$t)||($str2<$t)){
			//var_dump("expression");
			$this->error['duration']="Start/End time is less than current time";
			}
		
		}
	}else{
		$this->error['warning'] = $this->language->get('error_warning_time');
	}

	}else{
		$this->error['warning'] = $this->language->get('error_warning_time');
	}
    	//------------------
    	if(!is_numeric($this->request->post['price'])){
    		$this->error['price'] = $this->language->get('error_price');
    	}else if($this->request->post['price'] < 0){
    		$this->error['price'] = "Invalid price, price should be positive.!";
    	}
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
     	if (!$this->error) {
			return true;
     	} else {
       		return false;
     	}

  	}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the product/channel content when deleted. 
						Checks if the deteled product/channel is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'catalog/ppv')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}

		
		if (!$this->error) {
	  		return true;
		 } else {
	  		return false;
	 }
  	}

/*
FUNCTION NAME 		-	validateCopy
DESCRIPTION 		-	Validates the permisssion of modifying the product/channel or not.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	
  	protected function validateCopy() {
    	if (!$this->user->hasPermission('modify', 'catalog/ppv')) {
      		$this->error['warning'] = $this->language->get('error_permission');  
    	}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
/*
FUNCTION NAME 		-	autocomplete
DESCRIPTION 		-	This function gives the auto-fill values if the admin fills 
						the form. These auto-fill values are retrieved from the database
						and shown as a drop down list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the list.
*/
		
	public function autocomplete() {
		$json = array();
		
		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_service_id']) || isset($this->request->get['filter_model']) || isset($this->request->get['filter_category_id'])) {
			$this->load->model('catalog/ppv');
			$this->load->model('catalog/option');
			
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}
			
			if (isset($this->request->get['filter_model'])) {
				$filter_model = $this->request->get['filter_model'];
			} else {
				$filter_model = '';
			}

			if (isset($this->request->get['filter_service_id'])) {
				$filter_service_id = $this->request->get['filter_service_id'];
			} else {
				$filter_service_id = '';
			}
			
			if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];	
			} else {
				$limit = 20;	
			}			
						
			$data = array(
				'filter_name'  => $filter_name,
				'filter_model' => $filter_model,
				'filter_service_id' => $filter_service_id,
				'start'        => 0,
				'limit'        => $limit
			);
			
			$results = $this->model_catalog_product->getProductAndPackages($data);
			
			foreach ($results as $result) {
				$option_data = array();
				
				$product_options = $this->model_catalog_product->getProductOptions($result['product_id']);	
				
				foreach ($product_options as $product_option) {
					$option_info = $this->model_catalog_option->getOption($product_option['option_id']);
					
					if ($option_info) {				
						if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
							$option_value_data = array();
							
							foreach ($product_option['product_option_value'] as $product_option_value) {
								$option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);
						
								if ($option_value_info) {
									$option_value_data[] = array(
										'product_option_value_id' => $product_option_value['product_option_value_id'],
										'option_value_id'         => $product_option_value['option_value_id'],
										'name'                    => $option_value_info['name'],
										'price'                   => (float)$product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
										'price_prefix'            => $product_option_value['price_prefix']
									);
								}
							}
						
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $option_value_data,
								'required'          => $product_option['required']
							);	
						} else {
							$option_data[] = array(
								'product_option_id' => $product_option['product_option_id'],
								'option_id'         => $product_option['option_id'],
								'name'              => $option_info['name'],
								'type'              => $option_info['type'],
								'option_value'      => $product_option['option_value'],
								'required'          => $product_option['required']
							);				
						}
					}
				}
					
				$json[] = array(
					'product_id' => $result['product_id'],
					'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),	
					'model'      => $result['model'],
					'service_id'      => $result['service_id'],
					'option'     => $option_data,
					'price'      => $result['price']
				);	
			}

		}

		$this->response->setOutput(json_encode($json));
	}
	private function getProductIdFromApiResponce($obj1)	{
		$res=json_decode($obj1,true);
		foreach ($res as $value) 
			 {
			 	if($value['error']==false)
				return $value;
			 }
			 return;
	}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
    }
}
?>
