<?php 

class ControllerBulkSubsonStb extends Controller {
	private $error = array();

public function index() {
	$this->language->load('bulk/subsonstb');
	$this->document->setTitle($this->language->get('heading_title'));
	$this->load->model('bulk/subsonstb');
    $this->getList();
}

public function getList() {	
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/subsonstb', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}
  		if (isset($this->request->get['filter_passcode'])) {
			$url .= '&filter_passcode=' . urlencode(html_entity_decode($this->request->get['filter_passcode'], ENT_QUOTES, 'UTF-8'));
		}
		   		   				
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_sync'] = $this->language->get('button_sync');
    	$this->data['button_delete'] = $this->language->get('button_delete');
    	$this->data['button_black_list'] = $this->language->get('button_black_list');

		$this->data['stbs'] = array();
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		if (isset($this->request->get['filter_passcode'])) {
			$this->data['filter_passcode'] = $this->request->get['filter_passcode'];
			$data['filter_passcode']=$this->request->get['filter_passcode'];
		} else {
			$this->data['filter_passcode'] ='';
		}

		$total=0;

		if (isset($this->request->get['filter_value'])) {
			$total = $this->model_bulk_subsonstb->getTotalStb($data);
			$results = $this->model_bulk_subsonstb->getDetail($data);
			$this->data['stbs'][] = array(				
				'STBNO'          => $this->request->get['filter_value'],				
				'smart_card'     => $results,				
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_sc'] = $this->language->get('column_sc');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//----------------------
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/subsonstb', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		$url = '';
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$this->template = 'bulk/subsonstb.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());

  	}


 }
?> 
