<?php 
class ControllerBulkSubscriptionClosure extends Controller { 
	private $error = array();

  	public function index() {
		$this->language->load('bulk/subscriptionclosure');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/subscriptionclosure');
		
    	$this->getList();
  	}

  	public function printPdf(){

	    if(isset($this->request->post['selected']))
	    {
	    	$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);

			$this->pdf->Cell(180,6,'-: Customer Due for Re-Subscription :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,35,70,105,135,170);
		    $c = array(15,35,35,30,35,30);
		    $this->pdf->SetY(40);
		    $header =  array('Sl.No.','Region Name','Operator Name','STB No.','Product/Pckage Id.','Expiry Date');
			
			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}		
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $this->load->model('bulk/subscriptionclosure');
	        $data=array();
	        if(isset($this->request->get['filter_expiry'])){
	        	$data['filter_expiry'] = $this->request->get['filter_expiry'];
	        }else{
	        	$data['filter_expiry']=null;
	        }
	        $data['filter_region'] = $this->request->get['filter_region'];
	        $data['filter_operator'] = $this->request->get['filter_operator']; 
	        $results = $this->model_bulk_subscriptionclosure->getSubscriptionClosure($data);
			    foreach($results as $result){
			    	$this->pdf->SetX(20);
			    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$result['region_name'],1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$result['username'],1,0,'L',0);
			    	$this->pdf->Cell($c[3],6,$result["stbno"],1,0,'L',0);
			    	$this->pdf->Cell($c[4],6,$result['product_id'],1,0,'L',0);
			    	$this->pdf->Cell($c[5],6,$result["exp_date"],1,0,'L',0);
			    	$this->pdf->Ln();
			 		$count++;
		        } 
		        
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/subscriptionclosure');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] ="Please Select item to print PDF";
	       	$this->getList();
		}
    }
   
  	protected function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/subscriptionclosure', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		if (isset($this->request->get['filter_expiry'])) {
			$filter_expiry = $this->request->get['filter_expiry'];
		} else {
			$filter_expiry = null;
		}

		if (isset($this->request->get['filter_region'])) {
			$filter_region = $this->request->get['filter_region'];
			$this->data['filter_region']	= $this->request->get['filter_region'];
		} else { 
			$filter_region = '';
			$this->data['filter_region'] = '';
		}

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator']	= $this->request->get['filter_operator'];
		} else { 
			$filter_operator = '';
			$this->data['filter_operator'] = '';
		}


		if (isset($this->request->get['filter_expiry'])) {
			$url .= '&filter_expiry=' . $this->request->get['filter_expiry'];
		}

		if (isset($this->request->get['filter_region'])) {
			$url .= '&filter_region=' . $this->request->get['filter_region'];
		}  

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}		
   		
		$this->data['customers'] = array();
		$this->data['regions'] 	 = $this->model_bulk_subscriptionclosure->getRegions();
		$this->data['operators'] = $this->model_bulk_subscriptionclosure->getOperators();
		
		$this->load->model('bulk/subscriptionclosure');
		$data = array(
			'filter_expiry'     	=> $filter_expiry,
			'filter_region'			=> $this->data['filter_region'],
			'filter_operator'		=> $this->data['filter_operator'],
			'start'           		=> ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           		=> $this->config->get('config_admin_limit')
		);

		$results = $this->model_bulk_subscriptionclosure->getSubscriptionClosure($data);
		$total =$this->model_bulk_subscriptionclosure->getTotalSubscriptionClosure($data);
 			$i=0;
 			
    	foreach ($results as $result) {			
			$this->data['customers'][] = array(
				'region_name'		=> $result['region_name'],
				'username'			=> $result['username'],
				'stbno'    			=> $result['stbno'],				
				'product_id'      	=> $result["product_id"],
				'exp_date'          => $result['exp_date'],				
				'selected'       	=> isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');	
		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_default'] = $this->language->get('text_default');		
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_type'] = $this->language->get('column_type');
		$this->data['column_status'] = "STB Status";
		$this->data['column_pay'] = $this->language->get('column_pay');
		$this->data['column_balance'] = $this->language->get('column_balance');

		$this->data['printPdf'] = $this->url->link('bulk/subscriptionclosure/printPdf', 'token=' . $this->session->data['token'].'&filter_region='.$this->data['filter_region'].'&filter_operator='.$this->data['filter_operator'].$url, 'SSL');

		$this->data['token'] 			= $this->session->data['token'];
		$this->data['button_filter'] 	= $this->language->get('button_filter');
		$this->data['filter_expiry'] 	= $filter_expiry;
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['filter_expiry'])) {
			$url .= '&filter_expiry=' . $this->request->get['filter_expiry'];
		}

		if (isset($this->request->get['filter_region'])) {
			$url .= '&filter_region=' . $this->request->get['filter_region'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/subscriptionclosure', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'bulk/subscriptionclosure.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>