<?php 
class ControllerBulkStbwisechangeofpkgprod extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/stbwisechangeofpkgprod');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/stbwisechangeofpkgprod');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){  
	if(isset($this->request->post['selected'])){ 
	    $this->pdf->AddPage();
	    $this->load->model('bulk/stbwisechangeofpkgprod');
	    $this->pdf->SetFillColor(232,232,232);
		$this->pdf->SetFont('times','B',10);
		$this->pdf->SetY(32);
		$this->pdf->SetX(20);

		if($_REQUEST['option']==1 && $_REQUEST['filter_option']==''){
			$this->pdf->Cell(170,6,'-: STB wise change of Package/Product :-',1,0,'C',1);
		}
		elseif($_REQUEST['filter_option']==1){
			$this->pdf->Cell(170,6,'-: STB wise change of Package/Product :-   Result between:  '.$this->request->post['filter_date_start'].' TO '.$this->request->post['filter_date_end'] ,1,0,'C',1);
		}

		$this->pdf->SetFont('times','B',8);
	    $w = array(20,35,70,110,130,160);
	    $c = array(15,35,40,20,30,30);	
	    $this->pdf->SetY(40);
	    $header =  array('Sl No.','STB No','Command Triggered','Pkg/Prod No.','Activation Date','Expiry Date');
	    for( $i = 0; $i < count($header) ; $i++){
		  	if($i==0)
	    		$this->pdf->SetX($w[0]);
	      	else
		   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		}		
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
        $count=1;
	    
	    $results = $this->model_bulk_stbwisechangeofpkgprod->getSTBDetailsForPDF($product_id,$this->request->get);
		 foreach($results as $result){		
		 	if($result['is_nvod']==1)
				$nvod = "[NVOD]";
			else
				$nvod = "";

		 	switch ($result['cmd_id']) {
				case 6:
					$command = "Package Subscription";
					break;
				case 7:
					$command = "Package De-Subscription";
					break;
				case 10:
					$command = "Product Subscription";
					break;
				case 11:
					$command = "Product De-Subscription";
					break;
				
			}

		    	$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],6,$result["STBNO"],1,0,'L',0);
		    	$this->pdf->Cell($c[2],6,$command." ".$nvod,1,0,'L',0);
		    	$this->pdf->Cell($c[3],6,$result["model"],1,0,'L',0);
		    	$this->pdf->Cell($c[4],6,$result["modify_date"],1,0,'L',0);
		    	$this->pdf->Cell($c[5],6,$result["exp_date"],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;
	     }
              
	    /*$this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
	    ob_clean();
	    $this->pdf->Output();
		}else{
			$this->language->load('bulk/stbwisechangeofpkgprod');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/stbwisechangeofpkgprod');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }  	
  
public function getList() {	
		$this->load->model('bulk/stbwisechangeofpkgprod');
			
		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option']	= $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']	= '';
		}
		if (isset($this->request->get['filter_stbno'])) {
			$filter_stbno = $this->request->get['filter_stbno'];
			$this->data['filter_stbno']	= $this->request->get['filter_stbno'];
		} else {
			$filter_stbno = '';
			$this->data['filter_stbno']	= '';
		}

		if (isset($this->request->get['filter_date_start'])) {
			$data['filter_date_start']=$this->request->get['filter_date_start'];
			$this->data['filter_date_start'] = $this->request->get['filter_date_start'];
		} else {
			$this->data['filter_date_start'] = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$data['filter_date_end']=$this->request->get['filter_date_end'];
			$this->data['filter_date_end'] = $this->request->get['filter_date_end'];
		} else {
			$this->data['filter_date_end'] = '';
		}
		
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}
		if (isset($this->request->get['filter_year'])) {
			$filter_year = $this->request->get['filter_year'];
			$this->data['filter_year']	= $this->request->get['filter_year'];
		} else {
			$filter_year = '';
			$this->data['filter_year']	= '';
		}

		if (isset($this->request->get['filterType'])) {
			$filterType = $this->request->get['filterType'];
			$this->data['filterType']	= $this->request->get['filterType'];
		} else {
			$filterType = '';
			$this->data['filterType']	= '';
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['filter_year'])) {
			$url .= '&filter_year=' . $this->request->get['filter_year'];
		}

		if (isset($this->request->get['filter_stbno'])) {
			$url .= '&filter_stbno=' . $this->request->get['filter_stbno'];
		}

		if (isset($this->request->get['filterType'])) {
			$url .= '&filterType=' . $this->request->get['filterType'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/stbwisechangeofpkgprod/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		
   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/stbwisechangeofpkgprod', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbwisechangeofpkgprod', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['filterTypes'] = array('0'=> 'ALL','1'=>'Package', '2'=>'Product');

		$data = array(
			'filter_option'			 => $filter_option,	
			'filter_stbno'			 => $filter_stbno,	
			'filterType'			 => $filterType,
			'filter_date_start'	     => $this->data['filter_date_start'], 
			'filter_date_end'	     => $this->data['filter_date_end'], 
			'filter_month'           => $filter_month,
			'filter_year' 			 => $filter_year,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total = $this->model_bulk_stbwisechangeofpkgprod->getTotalSTBList($data);
		$this->data['stb_active_list'] = array();
		$results = $this->model_bulk_stbwisechangeofpkgprod->getSTBDetails($data);
		foreach ($results as $result) {			
			if($result['is_nvod']==1)
				$nvod = "[NVOD]";
			else
				$nvod = "";

			switch ($result['cmd_id']) {
				case 6:
					$command = "Package Subscription";
					break;
				case 7:
					$command = "Package De-Subscription";
					break;
				case 10:
					$command = "Product Subscription";
					break;
				case 11:
					$command = "Product De-Subscription";
					break;
				
			}
			$this->data['stb_active_list'][] = array(
				'stbno'          => $result['STBNO'],
				'modify_date'    => $result['modify_date'],
				'exp_date'       => $result['exp_date'],
				'command'        => $command." ".$nvod,
				'p_no'           => $result['model'],
				'selected'   	 => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
			);	
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_modifydate'] = $this->language->get('column_modifydate');
		$this->data['column_expdate'] = $this->language->get('column_expdate');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbwisechangeofpkgprod', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/stbwisechangeofpkgprod.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/stbwisechangeofpkgprod');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
