<?php 
 /*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class show total authorized subscribers in the store

@Author Ravi Ranjan 
@date 26th Nov. 2015
*/ 
class ControllerBulkStbRenewedAfterExpiry extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('bulk/stb_renewed_after_expiry');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stb_renewed_after_expiry');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){
  		$this->language->load('bulk/stb_renewed_after_expiry');
  		if(isset($this->request->post['selected']))
  		{	$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(28);
			$this->pdf->SetX(20);

			$this->pdf->Cell(170,6,'-: STB Renewed After Expiry (Within '.$this->request->post['dalay_period'].' days) :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,30,50,95,120,147,175);
		    $c = array(10,20,45,25,27,28,15);
		    $this->pdf->SetY(35);
		    $header =  array('Sr.No.','Customer ID','Customer Name','STB No.','Last DeActive Date','Current Active Date','Delay Days');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}

	        $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $c_height=8;
	        $this->load->model('bulk/stb_renewed_after_expiry');

	        $results = $this->model_bulk_stb_renewed_after_expiry->getCustomerpdf($this->request->post);
		    foreach($results as $result){
			    $this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],8,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],8,$result['customer_unique_id'],1,0,'L',0);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[2],$c_height,$x_axis,$result['name'],22);
		    	$this->pdf->Cell($c[3],8,$result['STBNO'],1,0,'L',0);
		    	$this->pdf->Cell($c[4],8,$result["lastDeactiveDate"],1,0,'L',0);
		    	$this->pdf->Cell($c[5],8,$result['currentActiveDate'],1,0,'L',0);
		    	$this->pdf->Cell($c[6],8,$result['delay_in_days'],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;
	    	}
		    $this->pdf->Output();
		}else{
			
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	protected function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if(isset($this->data['error_dalay_period']))
			$this->data['error_dalay_period']=$this->data['error_dalay_period'];
		else
			$this->data['error_dalay_period']='';
		

		if (isset($this->request->get['dalay_period'])) {
			$url .= '&dalay_period=' . $this->request->get['dalay_period'];
			$this->data['dalay_period']=$this->request->get['dalay_period'];
		}else{
			$this->data['dalay_period']='';
		}
		$this->data['period_option']=array(
			'1 Month' =>30,
			'2 Month' =>60,
			'3 Month' =>90,
			'4 Month' =>120,
			'6 Month' =>180,
			'1 Year'  =>365,);
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stb_renewed_after_expiry', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
	   	$this->data['customers'] = array();
		$this->load->model('bulk/stb_renewed_after_expiry');
	   	 $data = array(
        	'filter_delay' 	  => $this->data['dalay_period'],
            'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit') 
        	);
   		
	if (isset($this->request->get['dalay_period']))
		{
			$total = $this->model_bulk_stb_renewed_after_expiry->getTotalCustomers($data);
			$results = $this->model_bulk_stb_renewed_after_expiry->getCustomersFilter($data);
	 		$i=0;
	    	foreach ($results as $result) {
				$i=$i+1;
				$this->data['customers'][] = array(
					'customer_id'    => $result['user_id'],
					'customer_no'    =>$result['customer_unique_id'],
					'name'           => $result['name'],
					'deactive_date'  => date($this->language->get('datetime_format'), strtotime($result['lastDeactiveDate'])),
					'date_added'     => date($this->language->get('datetime_format'), strtotime($result['currentActiveDate'])),
					'STBNO'          => $result['STBNO'],
					'delay_in_days'          => $result['delay_in_days'],
					'selected'       => isset($this->request->post['selected']) && in_array($result['STBNO'], $this->request->post['selected']),
				);
			}
		}
		else {
			$total=0;
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['entry_date'] = $this->language->get('entry_date');
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_lastDeactiveDate'] = $this->language->get('column_lastDeactiveDate');
		$this->data['column_caf'] = $this->language->get('column_caf');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_due_date'] = $this->language->get('column_due_date');

		$this->data['printPdf'] = $this->url->link('bulk/stb_renewed_after_expiry/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		if (isset($this->request->get['dalay_period'])) {
			$url .= '&dalay_period=' . $this->request->get['dalay_period'];
		}
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stb_renewed_after_expiry', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		//---------------------------
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'bulk/stb_renewed_after_expiry.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
  	/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Filter the list according to the start and end date.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retrieves the list that matches the filter condition
*/

public function filter(){
	$this->language->load('bulk/stb_renewed_after_expiry');
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/stb_renewed_after_expiry');
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){
			
			
		 }
    	$this->getList();

}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	
*/

public function validateDate(){
	if(!isset($this->request->get['filter_date_start']))
		$this->data['error_start'] = $this->language->get('error_startdate_req');
	else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_start']))
	{
    		$this->data['error_start'] = $this->language->get('error_date_format');
    }
	if(!isset($this->request->get['filter_date_end']))
		$this->data['error_end'] = $this->language->get('error_enddate_req');
	else if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$this->request->get['filter_date_end']))
	{
    		$this->data['error_end'] = $this->language->get('error_date_format');
    }
        
	return true;

}
}
?>
