<?php 
class ControllerBulkStbHistory extends Controller {

public function index() {

		$this->language->load('bulk/stbHistory');		 
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/stbHistory');
    	$this->getList();
  	}
	
 	public function printPdf(){
 			
  		if (isset($this->request->post['selected'])) {	
  			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(10);
			$this->load->model('bulk/stbHistory');

			$this->pdf->Cell(190,6,'-: STB Histroy  :-',1,0,'C',1);

		    $w = array(10,20,50,67,90,120,148,174); 
		    $c = array(10,30,17,23,30,28,26,26);
		    $this->pdf->SetY(40);

			$header =  array('Sl.No','Cusotmer Name','Cust.No','STBNO','Command','Prod/Pkg Name','Date Triggered','Exp Date');
		  	for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $data = array(
				'start' => ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit'),
				'limit' => $this->config->get('config_admin_limit')
			);

	        $results = $this->model_bulk_stbHistory->getStbHistoryDetailsForPDF();
	        $i = ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit');

		    foreach($results as $result){
		    	if($result['cmd_id']==0)
					$command = "Box Activation";
				elseif($result['cmd_id']==1)
					$command = "Box De-Activation";
				elseif($result['cmd_id']==6)
					$command = "Package Subscription";
				elseif($result['cmd_id']==7)
					$command = "Package De-Subscription";
				elseif($result['cmd_id']==10)
					$command = "Product Subscription";
				elseif($result['cmd_id']==11)
					$command = "Product De-Subscription";
				elseif($result['cmd_id']==18)
					$command = "PPV Subscription";
				elseif($result['cmd_id']==19)
					$command = "PPV De-Subscription";

				if($result['is_nvod']==1)
					$nvod='[NVOD]';
				else
					$nvod='';

				$c_height=6;
				$this->pdf->SetX(10);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[1],$c_height,$x_axis,$result["name"],20);
		    	$this->pdf->Cell($c[2],6,$result["customer_unique_id"],1,0,'L',0);
		    	$this->pdf->Cell($c[3],6,$result["cust_stbno"],1,0,'L',0);
		    	$this->pdf->Cell($c[4],6,$command,1,0,'L',0);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[5],$c_height,$x_axis,($result['Pname']==null)?'N/A':$result['Pname']." ".$nvod,20);
		    	$this->pdf->Cell($c[6],6,$result["modify_date"],1,0,'L',0);
		    	$this->pdf->Cell($c[7],6,($result['exp_date']==null)?'N/A':$result['exp_date'],1,0,'L',0);
		    	$this->pdf->Ln();
		     	$count++;
	        }	         

		    $this->pdf->Output(); 
		}else{
			$this->language->load('bulk/stbHistory');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
	
public function getList() {	 

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_stbno'])) {
			$this->data['filter_stbno'] = $this->request->get['filter_stbno'];
		} else {
			$this->data['filter_stbno'] ='';
		}

		if (isset($this->request->get['filter_command'])) {
			$this->data['filter_command'] = $this->request->get['filter_command'];
		} else {
			$this->data['filter_command'] ='';
		}

		if (isset($this->request->get['filter_stbno'])) {
			$filter_stbno = $this->request->get['filter_stbno'];
		} else {
			$filter_stbno = '';
		}

		if (isset($this->request->get['filter_command'])) {
			$filter_command = $this->request->get['filter_command'];
		} else {
			$filter_command = '';
		}

		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbHistory', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
   		
   		$this->data['printPdf'] = $this->url->link('bulk/stbHistory/printPdf', 'token=' . $this->session->data['token'] . $url.'&start='.($page - 1) * $this->config->get('config_limit_admin').'&limit='.$this->config->get('config_limit_admin'), 'SSL');

		$data = array(
			'filter_stbno'	  => $filter_stbno,	
			'filter_command'  => $filter_command,	
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		$this->data['filter_commands'] = array(
			'-1'		=> 	'',
			'0'		=>	'Box Activation', 
			'1'		=>	'Box De-Activation',
			'6'		=>	'Package Subscription', 
			'7'		=>	'Package De-Subscription', 
			'10'	=>	'Product Subscription',
			'11'	=>	'Product De-Subscription',
			'18'	=>	'PPV Subscription',
			'19'	=>	'PPV De-Subscription'
		);

		$this->data['stbHistoryLists'] = array();
		if($this->data['filter_stbno']!='' || isset($this->request->get['filter_stbno']))	{
			
			$results = $this->model_bulk_stbHistory->getStbHistoryDetails($data);
			// echo "<pre>"; print_r($results); die;
			$total 	 = sizeof($results); 
			foreach ($results as $result) {	
				if($result['cmd_id']==0)
					$command = "Box Activation";
				elseif($result['cmd_id']==1)
					$command = "Box De-Activation";
				elseif($result['cmd_id']==6)
					$command = "Package Subscription";
				elseif($result['cmd_id']==7)
					$command = "Package De-Subscription";
				elseif($result['cmd_id']==10)
					$command = "Product Subscription";
				elseif($result['cmd_id']==11)
					$command = "Product De-Subscription";
				elseif($result['cmd_id']==18)
					$command = "PPV Subscription";
				elseif($result['cmd_id']==19)
					$command = "PPV De-Subscription";

				if($result['is_nvod']==1)
					$nvod='[NVOD]';
				else
					$nvod='';
				

				$this->data['stbHistoryLists'][] = array(
				'cust_name'			=> $result['name'],
				'customer_no'		=> $result['customer_unique_id'],
				'prod_pkg_name'  	=> ($result['Pname']==null)?'N/A':$result['Pname']." ".$nvod,
				'stb_no' 			=> $result['cust_stbno'],
				'triggered_date'  	=> $result['modify_date'],
				'exp_date'  		=> ($result['exp_date']==null)?'N/A':$result['exp_date'], 
				'command' 			=> $command,
				'total'        		=> $total,
				'selected'      	=> isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
			}
		}	
		
		$this->data['heading_title'] 		= $this->language->get('heading_title');
		$this->data['column_cust_name'] 	= $this->language->get('column_cust_name');
		$this->data['column_cust_no'] 		= $this->language->get('column_cust_no');		
		$this->data['column_stbno'] 		= $this->language->get('column_stbno');
		$this->data['column_prod_pkg_name'] = $this->language->get('column_prod_pkg_name');
		$this->data['column_command_Desc']  = $this->language->get('column_command_Desc');
		$this->data['column_date_triggered']= $this->language->get('column_date_triggered');
		$this->data['column_exp_date'] 		= $this->language->get('column_exp_date');
		$this->data['button_filter'] 		= $this->language->get('button_filter');
		$this->data['entry_stbno'] 			= $this->language->get('entry_stbno');

		$this->data['text_no_results'] 		= $this->language->get('text_no_results');
		$this->data['button_invoice'] 		= $this->language->get('button_invoice');
		$this->data['token'] 				= $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		if (isset($this->request->get['filter_stbno'])) {
			$url .= '&filter_stbno=' . $this->request->get['filter_stbno'];
		}

		if (isset($this->request->get['filter_command'])) {
			$url .= '&filter_command=' . $this->request->get['filter_command'];
		}

		if (isset($this->request->get['page'])) {	
			$url .= '&filter_stbno=' . $filter_stbno.'&filter_command=' . $filter_command;		
			$this->data['printPdf'] = $this->url->link('bulk/stbHistory/printPdf', 'token=' . $this->session->data['token'].'&page='.$this->request->get['page']. $url, 'SSL');
		} else {
			$this->data['printPdf'] = $this->url->link('bulk/stbHistory/printPdf', 'token=' . $this->session->data['token'].'&page='.'1'. $url, 'SSL');
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbHistory', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/stbHistory.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
