<?php 
class ControllerBulkStbDeActiveCount extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/stbDeActiveCount');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/stbDeActiveCount');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){  
	if(isset($this->request->post['selected'])){ 
	    $this->pdf->AddPage();
	    $this->load->model('bulk/stbDeActiveCount');
	    $this->pdf->SetFillColor(232,232,232);
		$this->pdf->SetFont('times','B',10);
		$this->pdf->SetY(32);
		$this->pdf->SetX(20);
		
		$operatorName = $this->model_bulk_stbDeActiveCount->getOperatorNameById($this->request->get['filter_operator']);
		if($operatorName=='')
			$operatorName="ALL";
		
		if($this->request->get['filter_option']==1){
			$this->pdf->Cell(170,6,'-: STB DeActivation Count :-  [As on Date:-'.$this->request->get['filter_date_end'].'] [Operator:-  '.$operatorName.']' ,1,0,'C',1);
		}elseif ($this->request->get['filter_option']==2) {
			$this->pdf->Cell(170,6,'-: STB DeActivation Count As on Audit Month End:-   [Month: '.$this->request->get['filter_month'].'] [Operator :-  '.$operatorName.']' ,1,0,'C',1);
		}

		$this->pdf->SetY(40);
	    $w = array(20,40,115);
	    $c = array(20,75,75);	
	    
	    $header =  array('Sl No.','Operator Name','De-Activation Count');
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }
	    $count=1;
		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    
		$results = $this->model_bulk_stbDeActiveCount->getSTBList($this->request->get);
	    		/*$t =$results[0]['total'];
	    		$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],6,'',1,0,'L',1);
		    	$this->pdf->Cell($c[1],6,'TOTAL',1,0,'C',1);
		    	$this->pdf->Cell($c[2],6,$t,1,0,'C',1);
		    	$this->pdf->Ln();*/

		 foreach($results as $result){		    	
		    	$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],6,$result["username"],1,0,'L',0);
		    	$this->pdf->Cell($c[2],6,$result["total"],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;
		 		// $t = $t+ $result["total"];
	     }

	    ob_clean();
	    $this->pdf->Output();
		}else{
			$this->language->load('bulk/stbDeActiveCount');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/stbDeActiveCount');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }  	
  
public function getList() {	
		$this->load->model('bulk/stbDeActiveCount');
			
		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option']	= $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']	= '';
		}

		// if (isset($this->request->get['filter_date_start'])) {
		// 	$data['filter_date_start']=$this->request->get['filter_date_start'];
		// 	$this->data['filter_date_start'] = $this->request->get['filter_date_start'];
		// } else {
		// 	$this->data['filter_date_start'] = '';
		// }

		if (isset($this->request->get['filter_date_end'])) {
			$data['filter_date_end']=$this->request->get['filter_date_end'];
			$this->data['filter_date_end'] = $this->request->get['filter_date_end'];
		} else {
			$this->data['filter_date_end'] = '';
		}
		
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}
		// if (isset($this->request->get['filter_year'])) {
		// 	$filter_year = $this->request->get['filter_year'];
		// 	$this->data['filter_year']	= $this->request->get['filter_year'];
		// } else {
		// 	$filter_year = '';
		// 	$this->data['filter_year']	= '';
		// }

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator'] = $this->request->get['filter_operator'];
		} else {
			$filter_operator = '';
			$this->data['filter_operator'] = '';
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		// if (isset($this->request->get['filter_date_start'])) {
		// 	$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		// }
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		// if (isset($this->request->get['filter_year'])) {
		// 	$url .= '&filter_year=' . $this->request->get['filter_year'];
		// }

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/stbDeActiveCount/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		
   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/stbDeActiveCount', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbDeActiveCount', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

   		$operatorList = $this->model_bulk_stbDeActiveCount->getOperatorList();
		foreach ($operatorList as  $operator) {
			$this->data['operators'][] = array(
					'user_id' => $operator['user_id'],
					'username'=> $operator['username']
				);
		}
	
		$data = array(
			'filter_option'			 => $filter_option,	
			// 'filter_date_start'	     => $this->data['filter_date_start'], 
			'filter_date_end'	     => $this->data['filter_date_end'], 
			'filter_month'           => $filter_month,
			// 'filter_year' 			 => $filter_year,
			'filter_operator'   	 => $filter_operator,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total =0;
		$this->data['stb_deactive_list'] = array();
		if(isset($this->request->get['filter_option'])){
			$total = $this->model_bulk_stbDeActiveCount->getTotalSTB($data);
			$results = $this->model_bulk_stbDeActiveCount->getSTBList($data);
			$TOTAL=0;
			$this->data['stb_deactive_list'][] = array(
					'operator'          => "TOTAL",
					'total'    => $TOTAL,
					'selected'   	 => ''
				);	
			foreach ($results as $result) {			
				$this->data['stb_deactive_list'][] = array(
					'operator'          => $result['username'],
					'total'    => $result['total'],
					'selected'   	 => isset($this->request->post['selected']) && in_array($result['operator_id'], $this->request->post['selected']),
				);	
				$TOTAL=$TOTAL+$result['total'];
			}			
			$this->data['stb_deactive_list'][0]['total']=$TOTAL;
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_modifydate'] = $this->language->get('column_modifydate');
		$this->data['column_expdate'] = $this->language->get('column_expdate');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbDeActiveCount', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/stbDeActiveCount.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/stbDeActiveCount');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
