<?php    

class ControllerBulkStbBulkResendActivation extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('bulk/stbBulkResendActivation');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stbBulkResendActivation');

		$this->getUploadForm();
		
	}

	public function exportFormat(){  
		ob_clean();
    	/*********************** Export STB Bulk Activation CSV Format *****************************/
    	$results = array('SDA40000000001,'."Note:- Add 1 To 1000 STBNO Serialwise..!");
    	if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=stbBulkResendActivationSampleFormat.csv');
			$output = fopen('php://output', 'w');
			foreach ( $results as $line ) {
    			$val = explode(",", $line);
    			fputcsv($output, $val);
			}
		}
    }	

	public function stb_bulk_resend_activation(){ 
    	$this->load->model('bulk/stbBulkResendActivation');
    	$obj = new restapi();  			
    	$log_separator = "-------------------------------------\n";
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('d-m-Y H:i:s');	
		$this->language->load('sale/customer');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('commands/box_activation');
		$this->load->model('sale/customer');
		$commentcount = 0;
		$file_empty = false;
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			  if (is_uploaded_file($_FILES['filename']['tmp_name'])) {
			    $handle = fopen($_FILES['filename']['tmp_name'], "r");
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);	
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) { 
			    	$stbLen =  strlen(trim($data[0]));
			    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt",$log_separator, FILE_APPEND);
			    	$status = $this->model_bulk_stbBulkResendActivation->validateSTB(trim($data[0]));
			 		$is_active = $this->model_bulk_stbBulkResendActivation->isActive(trim($data[0]));			 		
			 		$is_blacklist = $this->model_bulk_stbBulkResendActivation->isBlacklist(trim($data[0]));
			 		$is_RMA = $this->user->isStbRMA(trim($data[0]));
			 		$lcoId  = $this->user->getOperatorIdFromStbno(trim($data[0]));
			 		$is_suspend = $this->user->isStbSuspend(trim($data[0]));
			 		$is_lco_suspend = $this->user->isLcoSuspend($lcoId);

		    		if($status && $is_active==1 && $is_blacklist==0 && $is_RMA==0 && $is_suspend==0 && $is_lco_suspend==0){
		    			$custstatus = $this->model_bulk_stbBulkResendActivation->isCustomerEnabled(trim($data[0]));
			    		if($custstatus==1){
			    			$max_active_id = $this->model_bulk_stbBulkResendActivation->getMaxActiveID(trim($status[0]["customer_id"]));
							$transaction_details = $this->model_commands_box_activation->getTransactionDetails($max_active_id);		
				     		$customer_id 		 = $transaction_details['user_id'];
				    		$user_id 			 = $transaction_details['api_user_id'];
				    		$operator_id 		 = $transaction_details['operator_id'];
				    		$target_lvl 		 = 1;
				    		$trans_id 			 = $transaction_details['tx_id'];
				    		$cmd_id 			 = $transaction_details['cmd_id'];
						  	$data 				 = "transaction_id=". $trans_id."&command_id=".$cmd_id."&target=".$user_id."&target_level=".$target_lvl;		  	
						  	$method 			 = "POST";
						  	$uri 				 = KMS_API."/Resend";		
							$hdr 				 = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
							$apiresult 			 = $obj->callAPI($method,$hdr,$uri,$data);
							$response 			 = json_decode($apiresult);
				    		$curlresponse 		= '';
				    		$error 				= true;
							$errorMsg 			= '';
							$apimessage 		= " Kms fail to enable STB";
				    		$cmd_id 			= 0;
										
							foreach ($response as $key => $value) {
						    	switch ($key) {
						    		case 'error':
						    			$error = $value;	
						    		break;
						    		case 'id':
						    			$id = $value;	
						    		break;
						    		case 'message':
						    			$apimessage = $value;	
						    		break;
						    		case 'mq_response':
						    			$curlresponse = $value;	
						    		break;
						    		default:
						    			$errorMsg = $errorMsg." ".$key.":".$value;
						    			break;
						    	}
							}
							$ack_is=-1;$nack_is=-1;
							if(!$error){
								$log_target_level = "Individual";
								$log_target = $status[0]['STBNO'];
								$resend_status = 1;
								$commandid = 0;
								if($curlresponse!="")
								$this->WriteMessageLog($id,$curlresponse,$log_target_level,$log_target,"RESEND BOX ACTIVATION",$resend_status,$commandid);
								$cust_id = $status[0]['customer_id'];
								$ack = ((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
								if($ack == 'ACK'){
									$ack_is = 1;
									$this->model_commands_box_activation->setSTBActiveDeactive(1,$cust_id,2);		
								}elseif($ack == 'NACK'){
									$nack_is = -1;
								}
								$payload = $trans_id."#".$cmd_id."#".$user_id;
								$target = 1;
								$targetdata = 0;
								$results = $this->model_commands_box_activation->addToCasOpTransanction($customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$transaction_details['exp_date'],$operator_id,$status[0]['STBNO']);
								if($ack=='ACK'){
									$msg = 'SUCCESS'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
								}else if($ack=='NACK'){
									$msg = 'FAILED: NACK RECEIVED!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
								}
							}else{
								$msg = $errorMsg.$apimessage."\n";
								file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
							}
						}else{
							$msg = 'FAILED: Customer Not Enabled!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", $status[0]['STBNO']." : ".$msg, FILE_APPEND);
						}
		    		} else	{	
		    			if($is_blacklist==1) {
		    				$msg = 'FAILED : STB BlackListed!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($is_RMA==1) {
		    				$msg = 'FAILED : STB in RMA state.!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($is_suspend==1) {
		    				$msg = 'FAILED : STB is suspended, Please resume first.!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($is_lco_suspend==1) {
		    				$msg = 'FAILED : STB Belongs To LCO Is Suspended, Please Resume LCO First.!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($is_active==0){
		    				$msg = 'FAILED : Invalid STBNO / Customer disabled-Unpaired / Box in De-Active state, Can not Resend!!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($stbLen!='14' && $stbLen==''){
		    				$msg = 'FAILED: STBNO field is empty!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}elseif($stbLen!='14'){
		    				$msg = 'FAILED: STBNO length must be 14 digit!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
		    			}else{
		    				$msg = 'FAILED!'."\n";
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", trim($data[0])." : ".$msg, FILE_APPEND);
						}
		    		}
					file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt",$log_separator, FILE_APPEND);	
				} // End while loop 
				$user_id = "_".$this->session->data['user_id'];
				$gzfile = DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.$user_id.".gz";
				$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
				gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
				gzclose($fp);

		    	unlink(DIR_ADMIN_LOGS.'/Bulk_Resend_Stb_Activation/'.$current_date.".txt");
		    	$this->session->data['success'] = "Success: Please check the log file for detail!";
			}
		}
    	
      $this->getUploadForm();
  	}  

  	public function validateFile(){
  		if (!$this->user->hasPermission('modify', 'bulk/stbBulkResendActivation')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		$this->load->model('bulk/stbBulkResendActivation');
		switch ($_FILES['filename']['error']) { 
			case UPLOAD_ERR_OK:
				$message = "";//"There is no error, the file uploaded with success";
				break;
            case UPLOAD_ERR_INI_SIZE: 
                $message = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; 
                break; 
            case UPLOAD_ERR_FORM_SIZE: 
                $message = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; 
                break; 
            case UPLOAD_ERR_PARTIAL: 
                $message = "The uploaded file was only partially uploaded"; 
                break; 
            case UPLOAD_ERR_NO_FILE: 
                $message = "No file was uploaded"; 
                break; 
            case UPLOAD_ERR_NO_TMP_DIR: 
                $message = "Missing a temporary folder"; 
                break; 
            case UPLOAD_ERR_CANT_WRITE: 
                $message = "Failed to write file to disk"; 
                break; 
            case UPLOAD_ERR_EXTENSION: 
                $message = "File upload stopped by extension"; 
                break; 
            default: 
                $message = "Unknown upload error"; 
                break; 
        }
        $mimes = array('text/csv','application/vnd.ms-excel');
		if(in_array($_FILES['filename']['type'],$mimes)){
			$lines = count(file($_FILES['filename']['tmp_name'])); 
			if( $lines > 1001)
				$message = "Can't process csv, records more than 1000!";
			elseif($_FILES['filename']['size']<2)
				$message = "Can't process csv, no records found!";
		}else{
			$message = "Accepts only .csv file!";
		}

		if(!empty($message))
			$this->error['warning'] = $message;
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}

  	public function WriteMessageLog($tx_id,$status,$log_target_level,$log_target,$command,$resend_status,$command_id){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
        // ---------------------------------------------------------------------------------------
        $log_file = fopen(DIR_LOGS."sms_stb_activation.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->user->genericLogCommandsFunc($tx_id,$status,$log_target_level,$log_target,$command_id,$resend_status);
        // ---------------------------------------------------------------------------------------
    }
  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
  		$this->language->load('bulk/stbBulkResendActivation');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbBulkResendActivation', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stb_bulk_resend_activation'] = $this->url->link('bulk/stbBulkResendActivation/stb_bulk_resend_activation', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_stb_resend_activation_log_list'] = array();
   		$total = $this->model_bulk_stbBulkResendActivation->getTotal();
		$results = $this->model_bulk_stbBulkResendActivation->getBulkRegistrationLogList($data);
		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_stb_resend_activation_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		// $total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){
			
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;
			// var_dump($this->data['status_array']);exit();
		}else{
			$this->data['status_array'] = array();
		}
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 
		
    	$this->data['cancel'] = $this->url->link('bulk/stbBulkResendActivation', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkResendActivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'bulk/stbBulkResendActivation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}



}
?>