<?php    

class ControllerBulkStbBulkDeSubscription extends Controller { 
	private $error = array();
	private $status_array = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the customer option in the dopdown list.
						It get all the customer account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer page showing all the customer in a list.
*/  
  	public function index() {
		$this->language->load('bulk/stbBulkDeSubscription');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/stbBulkDeSubscription');

		$this->getUploadForm();
		
	}

	public function exportFormat(){
		/*********************** Export STB Inventory CSV Format *****************************/
		$results = array('SDA40000000001,'.'1,', 'SDA40000000002,'.'2,', 'SDA40000000003,'.'3,',
						 'SDA40000000004,'.'4,', 'SDA40000000005,'.'5');
		if($results){
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename=stbBulkDeSubscriptionSampleFormat.csv');
			$output = fopen('php://output', 'w'); ob_clean();
			fputcsv($output, array('STB NO', 'Product/Package No'));
			foreach ( $results as $line ) {
				$val = explode(",", $line);
				fputcsv($output, $val);
			}
		}
	}

	public function stb_bulk_desubscription(){ 
    	
		$obj = new restapi();
		$this->language->load('bulk/stbBulkDeSubscription');
    	$this->load->model('bulk/stbBulkDeSubscription');  		
    	$this->document->setTitle($this->language->get('heading_title'));
	
		if (($this->request->server['REQUEST_METHOD'] == 'POST')  && $this->validateFile()) {
			$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
		  	if($ext=='csv'){
		  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name'], "r");
		  		$log_separator = "-------------------------------------\n";
				$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
				$current_date = $currDate->format('d-m-Y H:i:s');	
				file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt", $log_separator.$current_date."\n"  , FILE_APPEND);
		  		$line_no = 2;
		  		
			    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
			    	file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	
			    	
			    	if($data[0] != NULL && (sizeof($data)==2) || sizeof($data)==3) {

				    	if($data[0]!= 'STB NO' && $data[1]!='Product/Package No'){
				    		
				    		$status = $this->model_bulk_stbBulkDeSubscription->validateSTB(trim($data[0]));
				    		
				    		$is_box_blacklist = $this->model_bulk_stbBulkDeSubscription->isBlacklist(trim($data[0]));

				    		$product_status = $this->model_bulk_stbBulkDeSubscription->validateProductNo(trim($data[1]));

				    		// -----------------------------------NVOD----------------------------------------
				    		$is_nvod = $this->model_bulk_stbBulkDeSubscription->validateNvod(trim($data[1]));
				    		// -------------------------------------------------------------------------------
				    		
				    		if($is_box_blacklist==0 && $status && !$is_nvod && $product_status){
				    			
				    			$custstatus = $this->model_bulk_stbBulkDeSubscription->isCustomerEnabled(trim($data[0]));
				    			
				    			$product_id = $this->model_bulk_stbBulkDeSubscription->getPId(trim($data[1]));
				    			$isPkg = $this->model_bulk_stbBulkDeSubscription->isPackage(trim($data[1]));
				    			
				    			if($custstatus==1){
				    				$sms_customer_id = $this->model_bulk_stbBulkDeSubscription->getCustomerId(trim($data[0]));
				    				$subs_state = $this->model_bulk_stbBulkDeSubscription->isSubscriptionAvail($product_id,$sms_customer_id,$isPkg);
				    			}else{
				    				$subs_state = 0 ;
				    			}
								
					    		if($custstatus==1 && $subs_state==1){
					    			$sms_customer_id = $this->model_bulk_stbBulkDeSubscription->getCustomerId(trim($data[0]));
					    			
					    			$sms_casop_id 	= $this->model_bulk_stbBulkDeSubscription->getCasopId($sms_customer_id,$product_id,$isPkg);
					    			$transaction_details = $this->model_bulk_stbBulkDeSubscription->getTransactionDetails($sms_casop_id);
					    			$operator_id=isset($transaction_details['operator_id'])?$transaction_details['operator_id']:$this->session->data['user_id'];
					    			$target_lvl=1;
						    		$trans_id=$transaction_details['tx_id'];
						    		$cmd_id=$transaction_details['cmd_id'];
						    		$kms_product_id = $this->model_bulk_stbBulkDeSubscription->getKmsProductId($product_id);					    			

					    			$data_kms="stb_no=".trim($data[0])."&command_id=".$cmd_id."&target=".$kms_product_id."&target_level=".$target_lvl."&product_no=".trim($data[1]);	
					    			
								  	$method ="POST";
									$uri=KMS_API."/Disable";		
									$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
									$apiresult=$obj->callAPI($method,$hdr,$uri,$data_kms);	    
								    $response=json_decode($apiresult);			
								    $error=true;
								    $errorMsg='';
								    $apimessage="";

								    foreach ($response as $key => $value) {
								    	switch ($key) {
								    		case 'error':
								    			$error=$value;	
								    		break;
								    		case 'id':
								    			$id=$value;	
								    		break;
								    		case 'disble_command_id':
								    			$cmd_id=$value;	
								    		break;
								    		case 'message':
								    			$apimessage=$value;	
								    		break;
								    		case 'mq_response':
								    			$curlresponse=$value;	
								    		break;
								    		default:
								    			$errorMsg=$errorMsg." ".$key.":".$value;		
								    		break;
								    	}
									}

									$log_target_level = "Individual";
									$log_target = $data[0];

									$getPkgName = $this->model_bulk_stbBulkDeSubscription->getProductsName($product_id);
									$log_package_name = $getPkgName['name'];
									$this->WriteMessageLog($curlresponse,$log_target_level,$log_target,trim($data[1]),"PACKAGE De-SUBS");
									$ack_is=-1;$nack_is=-1;

									if(!$error)	{
										$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
										if($ack=='ACK')
										{
											$ack_is=1;
										}elseif($ack=='NACK'){
											$nack_is=-1;
										}
										$resp=explode('`', $curlresponse);
										$payload=$data[0]."#".$cmd_id."#".$kms_product_id;
										$target=1;
										$targetdata=0;
										// -------------------------------------------------------------------
										$this->model_bulk_stbBulkDeSubscription->getIdsForExpiryUpdate($transaction_details["user_id"],$transaction_details["product_id"],$sms_casop_id,$isPkg);	
										// ------------------------------------------------------------------
										$results = $this->model_bulk_stbBulkDeSubscription->addToCasOpTransanction($sms_customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$product_id,0,0,$operator_id);

										$this->model_bulk_stbBulkDeSubscription->updateExpiryFlag($transaction_details['product_id'], $transaction_details['user_id']);										
										if($ack=='ACK'){											
											$msg = 'SUCCESS'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
								      	}else if($ack=='NACK'){
											$msg = 'FAILED: NACK RECEIVED!'."\n";
											file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
										}
									}else{
										$errorMsg = $errorMsg."  ".$apimessage;
										$msg = $errorMsg;
										file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  $data[0]." : ".$msg, FILE_APPEND);
									}
								} elseif($subs_state==0) {
									$msg = 'FAILED: Package not subscribed/expired for particular STB!!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
								}else{
									$msg = 'FAILED: Customer Not Enabled!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
								}		    			
				    } else {	
			    			if($is_nvod){
			    					$msg = 'FAILED: NVOD Not Allowed!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
			    			}else if(!$product_status){
			    					$msg = 'FAILED: Invalid Product No / Product is disabled!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
			    			}else{
			    					$msg = 'FAILED: Invalid STB NO / Box not Active / Box Blacklisted!'."\n";
									file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
			    			}
				    	}
				    	// ------------ERROR LOGS---------------------
							file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",$log_separator, FILE_APPEND);	
							$user_id = "_".$this->session->data['user_id'];
							$gzfile = DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.$user_id.".gz";
							$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
							gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
							gzclose($fp);
					   	// ------------ERROR LOGS---------------------
			    		$line_no++;
			    		} // End If
			    	}			    	
			    	// -----------------------------------------------------------
			    	if(sizeof($data)<2){
			    		$msg = 'FAILED: Invalid Record!'."\n";
						file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);						
					}
			    	// ------------------------------------------------------------
			    } // End while loop	
			    if($line_no==2){
			    	$msg = 'FAILED: Invalid Record (Insufficient info entered)!'."\n";
					file_put_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt",  trim($data[0])." : ".$msg, FILE_APPEND);
					$user_id = "_".$this->session->data['user_id'];
					$gzfile = DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.$user_id.".gz";
					$fp = gzopen($gzfile, 'w9'); // w == write, 9 == highest compression
					gzwrite($fp, file_get_contents(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt", FILE_USE_INCLUDE_PATH));
					gzclose($fp);
			    }
				unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$current_date.".txt");
				unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
			} else {				// End of extension csv
				$this->error['warning']= "Warning: INVALID FILE FORMAT";
				unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
			}
			header('HTTP/1.1 301 Moved Permanently');
			header('Location: index.php?route=bulk/stbBulkDeSubscription&token='.$this->session->data['token']."&msg=success");
		}	// End of validate file
		
        $this->getUploadForm();
  	} 	// End of function stb_bulk_desubscription

  	public function validateFile(){
  		if(!sizeof($_FILES )){
  			$this->error['warning']	= "Please select .csv file for stb bulk subscription.!";
  			return false;
  		}else{

  			$ext = pathinfo(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name'], PATHINFO_EXTENSION);
			if($ext!='csv'){
				$this->error['warning']	= "Please select .csv file for stb bulk subscription.!";
  				return false;
			} else {
			  		$newloc = DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name'];
			  		move_uploaded_file($_FILES['filename']['tmp_name'], $newloc);
			  		$lines = count(file($newloc)); 
			  		
			  		$count = 0;
			  		$handle = fopen(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name'], "r");
					
					while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
						if($count==0){							
							if(isset($data[1])){
								if($data[0]!="STB NO" || $data[1]!="Product/Package No"){
									$this->error['warning'] = "Warning: Invalid file!";
									unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
									return false;
								}
							}else{
								$this->error['warning'] = "Warning: Column Missing in CSV!";
								unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
								return false;
							}

						}else{
							if($count ==1 ){
								if(strlen($data[0])==0){
									$this->error['warning'] = "Warning: Invalid file/Insufficient data!";
									unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
									return false;
								}
							}
						}
						$count++;						
					}

					if ( $count==0 || $count==1 ) {
						$this->error['warning'] = "Warning: Invalid file/Insufficient data!";
						unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
						return false;
					}

			  		if($lines > 1001){
						$this->error['warning'] = "Can't process csv, records count is more than 1000.!";
						unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']); 
						return false;
					}else {
						if($lines){					
							return true;
						}else {				
							if ($_FILES['filename']['name']=="") {
								$this->error['warning']	= "Warning: Please select .csv file for stb bulk subscription.!";
							}elseif($lines==0){
								$this->error['warning']	= "Warning: Empty File (No Records to process)!!";
								unlink(DIR_ADMIN_LOGS.'/Bulk_Stb_DeSubscription/'.$_FILES['filename']['name']);
							}
							
						}
					}
			}
		}
  	}

  	public function WriteMessageLog($status,$log_target_level,$log_target,$product_no,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command."\t\t".$subscription_name);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);
         // ------------------------------only subscription log------------------------------------
        $log_file = fopen(DIR_LOGS."subscription_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
 		
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command."-".$product_no);
        fclose($log_file);

        // -----------------------------------------------------------------------------------------
    }
  
  	protected function getUploadForm() {
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

				

  		$this->language->load('bulk/stbBulkDeSubscription');
    	$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['token'] = $this->session->data['token'];
		$url = '';
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/stbBulkDeSubscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['stb_bulk_subscription'] = $this->url->link('bulk/stbBulkDeSubscription/stb_bulk_desubscription', 'token=' . $this->session->data['token'] . $url, 'SSL');
		
		$data = array(
			'start'   => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'   => $this->config->get('config_admin_limit')
		);	
		/*=============================== Log History ===============================*/
		$this->data['bulk_stb_desubscription_log_list'] = array();
   		$total = $this->model_bulk_stbBulkDeSubscription->getTotal();
		$results = $this->model_bulk_stbBulkDeSubscription->getBulkRegistrationLogList($data);

		$count =0;
		if($results)
			foreach ($results as $result) {		
				$fileExt = substr($result['name'], -3); 
				if($fileExt=='.gz'){
					$useridwithextension = explode("_",$result['name']); 
					$userid = explode(".", $useridwithextension[1]);	
					if($this->session->data['user_id']==$userid[0]){
						$this->data['bulk_stb_desubscription_log_list'][] = array(
							'name'    => $result['name'],
							'date'         => $result['date'],
							'download_url'	=> $result['download_url']
						);	
						$count++;
					}
				}
		}
		// $total = $count;
		/*=============================== Log History ===============================*/
		if(isset($this->status_array)){	
			$this->data['status_array'] = array();
			$this->data['status_array'] =$this->status_array;			
		}else{
			$this->data['status_array'] = array();
		}
			// var_dump($this->data['status_array']);exit();		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		} 

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['error_log'])) {
			$this->data['error_log'] = $this->error['error_log'];
		} else {
			$this->data['error_log'] = '';
		} 

		if (isset($this->request->get['msg'])) {
			$this->data['success'] = "Success: File Processed, please check logs for details!!";
		} 
		
    	$this->data['cancel'] = $this->url->link('bulk/stbBulkDeSubscription', 'token=' . $this->session->data['token'] . $url, 'SSL');		
    	$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		

    	$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/stbBulkDeSubscription', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->template = 'bulk/stbBulkDeSubscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				// var_dump($this->template);exit();	
		$this->response->setOutput($this->render());
	}



}
?>