<?php 
class ControllerBulkServiceWiseTotActiveProducts extends Controller {

public function index() {

		$this->language->load('bulk/serviceWiseTotActiveProducts');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/serviceWiseTotActiveProducts');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){ 
		if (isset($this->request->post['selected']))
		{	
			if (isset($this->request->get['filter_product'])) {
				$filter_product = $this->request->get['filter_product'];
			} else {
				$filter_product = '';
			}

			$this->load->model('bulk/serviceWiseTotActiveProducts');
		    $this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);

		    if($this->request->post['selected']!=''){
		    	$this->pdf->Cell(170,6,'-: Service-Wise Total Active Packages   :- ',1,0,'C',1);
		    }
			$this->pdf->SetFont('times','B',8);
			$w = array(20,30,55,90);
		    $c = array(10,25,35,100);
		    $this->pdf->SetY(40);
		    $header =  array('Sr.No','Service Number','Service Name','Package Id');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}		
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
		      	foreach ($this->request->post['selected'] as $product_id) {
					$results = $this->model_bulk_serviceWiseTotActiveProducts->getServiceWiseTotalActiveProductsDetailsPDF($product_id);
					foreach ($results as $result) {	
						$kmsPkgIdList = $this->model_bulk_serviceWiseTotActiveProducts->getKmsPackageIdList($result['api_product_id']);
						if($kmsPkgIdList){
							$smsPkgIdList = $this->model_bulk_serviceWiseTotActiveProducts->getSmsPackageIdList(str_replace('"', '', $kmsPkgIdList));
				      		if ($smsPkgIdList) {	
						     	$this->pdf->SetX(20);
						    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
						    	$this->pdf->Cell($c[1],6,$result["service_number"],1,0,'L',0);
						    	$this->pdf->Cell($c[2],6,$result['service_name'],1,0,'L',0);
						    	$this->pdf->Cell($c[3],6,preg_replace('/[ ,]+/', ' ', trim($smsPkgIdList)),1,0,'L',0);
						    	$this->pdf->Ln();
						 		$count++;
					     	}
				     	}
				    }
	        	}
						
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/serviceWiseTotActiveProducts');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/serviceWiseTotActiveProducts');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();	
		}
    }

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_product']);
		}

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_product'])) {
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] ='';
		}
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/serviceWiseTotActiveProducts', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_product'])) {
			$data['filter_product']=$this->request->get['filter_product'];
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] = '';
		}

		if (isset($this->request->get['filter_product'])) {
			$this->session->data['filter_product'] = $this->request->get['filter_product'];
		}

		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . $this->request->get['filter_product'];
		}
		$this->data['activeProducts'] = array();
		$products = $this->model_bulk_serviceWiseTotActiveProducts->getProducts();
		foreach ($products as $product) {
			$this->data['products'][] = array(
				'product_name' =>$product['name'],
				'product_id'   =>$product['product_id'],
				);
		}

		$totalCnt 	 = $this->model_bulk_serviceWiseTotActiveProducts->getTotalServiceWiseTotalActiveProducts($data);
		if($totalCnt=='')
			$total =1;
		else
			$total = sizeof($totalCnt);
		$results = $this->model_bulk_serviceWiseTotActiveProducts->getServiceWiseTotalActiveProductsDetails($data);
		$i=0;
		foreach ($results as $result) {	
			$kmsPkgIdList = $this->model_bulk_serviceWiseTotActiveProducts->getKmsPackageIdList($result['api_product_id']);
			if($kmsPkgIdList){
				$smsPkgIdList = $this->model_bulk_serviceWiseTotActiveProducts->getSmsPackageIdList(str_replace('"', '', $kmsPkgIdList));
				$i=$i+1;
				if($smsPkgIdList) {
					$this->data['activeProducts'][] = array(
					'product_id'   		=> $result['product_id'],
					'sr_no'				=> ($page-1) * $this->config->get('config_admin_limit')+$i,
					'service_number'  	=> $result['service_number'],
					'service_name' 		=> $result['service_name'],
					'package_id' 		=> preg_replace('/[ ",]+/', ' ', trim($smsPkgIdList)), 
					'selected'      	=> isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
					);						
				}
			}
		}
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_service_num'] = $this->language->get('column_service_num');
		$this->data['column_service_name'] = $this->language->get('column_service_name');
		$this->data['column_package_id'] = $this->language->get('column_package_id');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_product'] = $this->language->get('entry_product');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/serviceWiseTotActiveProducts/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/serviceWiseTotActiveProducts', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/serviceWiseTotActiveProducts.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
