<?php 

class ControllerBulkProductModificationLogs extends Controller {

public function index() {
		$this->language->load('bulk/productModificationLogs');	
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/productModificationLogs');
    	$this->getList();
  	}

	public function broadcaster_packages(){
		$json = array();
		$this->load->model('bulk/productModificationLogs');

		$broadcaster_info = $this->model_bulk_productModificationLogs->getBroadcasterPackage($this->request->get['broadcaster_id']);

		if($broadcaster_info){
			foreach ($broadcaster_info as $value) {
				array_push($json, $value['package_name']);
			}	
		}
		$this->response->setOutput(json_encode(array_unique($json)));
	}

 	public function printPdf(){
  		if (isset($this->request->post['selected'])) {	
  			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(32);
			$this->pdf->SetX(10);
			$this->load->model('bulk/productModificationLogs');
			if (isset($this->request->get['filter_product'])) {
				$filter_product = $this->request->get['filter_product'];
			} else {
				$filter_product = null;
			}

			$this->pdf->Cell(190,6,'-: Product Modification Logs :-',1,0,'C',1);

		    $w = array(10,20,50,80,90,100,110,120,145,170,185); 
		    $c = array(10,30,30,10,10,10,10,25,25,15,10);
		    $this->pdf->SetY(40);
		    
		    $header =  array('Sl.No','Broadcaster Name','Product Name','PNo','SId','AC','LCN','Start Date','End Date','Action','Status');
		  	for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',7);
	        $count=1;
			$data = array(
				'filter_product'  => $filter_product,
				'start'           => ($this->request->get['page'] - 1) * $this->config->get('config_admin_limit'),
				'limit'           => $this->config->get('config_admin_limit')
			);

			$list = array_unique($this->request->post['selected']);
 			$product_number_list = implode(',', $list);

	        $this->data['products'] = array();
		
			// $total 	 = $this->model_bulk_productModificationLogs->getTotalProductModificationLogs($data);
			$results = $this->model_bulk_productModificationLogs->getProductModificationLog($product_number_list,$data);
			    foreach($results as $result){
					   	$this->pdf->SetX(10);
					   	$this->pdf->Cell($c[0],4,$count,1,0,'L',0);
					   	$this->pdf->Cell($c[1],4,($result['name'])?$result['name']:'No Broadcaster',1,0,'L',0);
					   	$this->pdf->Cell($c[2],4,$result["product_name"],1,0,'L',0);
					   	$this->pdf->Cell($c[3],4,$result["product_number"],1,0,'L',0);
					   	$this->pdf->Cell($c[4],4,$result['service_id'],1,0,'L',0);
					   	$this->pdf->Cell($c[5],4,$result["access_criteria"],1,0,'L',0);
					   	$this->pdf->Cell($c[6],4,$result["lcn"],1,0,'L',0);
					   	$this->pdf->Cell($c[7],4,$result["startdate"],1,0,'L',0);
					   	$this->pdf->Cell($c[8],4,($result['enddate']!='' ? $result['enddate']: "Till Date"),1,0,'L',0);
					   	$this->pdf->Cell($c[9],4,$result["action"],1,0,'L',0);
					   	$this->pdf->Cell($c[10],4,$result["status"],1,0,'L',0);
					   	$this->pdf->Ln();
					   	$count++;
				   	}
				   	$this->pdf->Ln();
		 
		    $this->pdf->Output(); 
		}else{
			$this->language->load('bulk/productModificationLogs');
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
	
public function getList() {	

		if(!isset($_GET['page'])){
			unset($this->session->data['filter_product']);
		}

		$total  = '';
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		
		if (isset($this->request->get['filter_product'])) {
			$filter_product = $this->request->get['filter_product'];
		} else {
			$filter_product = null;
		}

		/*if (isset($this->request->get['filter_product'])) {
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] ='';
		}*/
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/productModificationLogs', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'filter_product'  => $filter_product,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		if (isset($this->request->get['filter_product'])) {
			$data['filter_product']=$this->request->get['filter_product'];
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			$this->data['filter_product'] = '';
		}

		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . $this->request->get['filter_product'];
		}

		
		$this->data['AllProducts'] = array();
			$results = $this->model_bulk_productModificationLogs->getAllProducts();
			foreach ($results as $result) {				
				$this->data['AllProducts'][] = array(
					'product_name'	  => $result['name'],	
					'product_number'  => $result['model'],
				);						
			}

		$this->data['products'] = array();
		
			$total 	 = $this->model_bulk_productModificationLogs->getTotalProductModificationLogs($data);
			
			$results = $this->model_bulk_productModificationLogs->getProductModificationLogDetails($data);
			
			foreach ($results as $result) {				
				$this->data['products'][] = array(
					'product_name'	  => $result['product_name'],	
					'product_number'  => $result['product_number'],
					'action' 	      => $result['action'],
					'status' 	      => $result['status'],
					'from_date'   	  => $result['startdate'],
					'to_date'     	  => ($result['enddate']!='' ? $result['enddate']: "Till Date"),
					'lcn'  => $result['lcn'],
					'service_id' 	      => $result['service_id'],
					'access_criteria'   	  => $result['access_criteria'],
					'broadcaster_id'   	  => ($result['name'])?$result['name']:'No Broadcaster',
					'selected'   	=> isset($this->request->post['selected']) && in_array($result['product_name'], $this->request->post['selected']),
				);						
			}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_pkg_name'] = $this->language->get('column_pkg_name');
		$this->data['column_pkg_no'] = $this->language->get('column_pkg_no');		
		$this->data['column_stb_no'] = $this->language->get('column_stb_no');
		$this->data['column_subs'] = $this->language->get('column_subs');
		$this->data['column_expiry'] = $this->language->get('column_expiry');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		if (isset($this->request->get['page'])) {			
			$this->data['printPdf'] = $this->url->link('bulk/productModificationLogs/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');
		} else {
			$this->data['printPdf'] = $this->url->link('bulk/productModificationLogs/printPdf', 'token=' . $this->session->data['token'].'&page='.'1'. $url, 'SSL');
		}

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/productModificationLogs', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/productModificationLogs.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
