<?php 
class ControllerBulkProductDeSubscriptionCount extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/productDeSubscriptionCount');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/productDeSubscriptionCount');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){  
	if(isset($this->request->post['selected'])){ 
		
	    $this->pdf->AddPage();
	    $this->load->model('bulk/productDeSubscriptionCount');
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(10);
		$this->pdf->Ln();
		if($_REQUEST['option']==1 && $_REQUEST['filter_option']==''){
			$this->pdf->Cell(190,6,'-: Product DeSubscription Count :-',1,0,'C',1);
		}
		elseif($_REQUEST['filter_option']==1){
			$this->pdf->Cell(190,6,'-: Product DeSubscription Count :-   Result between:  '.$this->request->post['filter_date_start'].' TO '.$this->request->post['filter_date_end'] ,1,0,'C',1);
		}elseif ($_REQUEST['filter_option']==2) {
			$this->pdf->Cell(190,6,'-: Product DeSubscription Count :-   Result month of: '.$_REQUEST['filter_month'] ,1,0,'C',1);
		}elseif ($_REQUEST['filter_option']==3) {
			$this->pdf->Cell(190,6,'-: Product DeSubscription Count :-   Result year of:  '.$_REQUEST['filter_year'] ,1,0,'C',1);
		}
		$this->pdf->SetY(35);
	    $w = array(20,40,65,65); 
	    
	    $header =  array('Sl.No','Product.No.','Product Name','DeSubscription Count');
	    for($i = 0; $i < count($header); $i++) {
			$this->pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
		}	
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    $count=0;
	    $i=1;
	    if (isset($this->request->post['selected']))
		{
		    foreach ($this->request->post['selected'] as $product_id) { 
		        $results = $this->model_bulk_productDeSubscriptionCount->getProductDetailsForPDF($product_id,$this->request->get);
		        
		    	foreach($results as $result){
					if($result['cmd']==11){
						$data[] = array($i,$result['product_number'],$result['name'],$result['count']);
			     	}
			     	$i++;
        		}
        		$count++;
		     	
        	}
        }

	 	$column_width = $w[1];
        for ($i=0; $i < $count ; $i++) {
		
		 if($data[$i][1]=="")
	 	       	$total_string_width=55;
	 	    else
	 	       $total_string_width = $this->pdf->GetStringWidth($data[$i][1]);

	 	       $number_of_lines = ceil( $total_string_width / ($column_width) );
	 	       $line_height = 6;
	 	       $yH = ceil( $number_of_lines * $line_height ); 
	 	     
	 	  for($j=0; $j < count($header) ; $j++){ 
	 	     
	 	      if($j==0)
	 	        $this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               else if($j==2 || $j==3)
               {
               	$this->pdf->Cell($w[$j],$yH,$data[$i][$j],1,0,'L',0);
               }
               else
               {
               	$x = $this->pdf->GetX();
               	$y = $this->pdf->GetY();
	 	       $this->pdf->MultiCell($w[1], 6,$data[$i][$j],1,1,0);
	 	       $this->pdf->SetXY($x + $w[1], $y);
	 	       } 
	 	        
	 	  }

	    $this->pdf->Ln();
	    }               
	    /*$this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/ob_clean();
	    $this->pdf->Output();
		}else{
			$this->language->load('bulk/productDeSubscriptionCount');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/productDeSubscriptionCount');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }  	
  
public function getList() {	
		$this->load->model('bulk/productDeSubscriptionCount');
			
		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
			$this->data['filter_option']	= $this->request->get['filter_option'];
		} else {
			$filter_option = '';
			$this->data['filter_option']	= '';
		}

		if (isset($this->request->get['filter_date_start'])) {
			$data['filter_date_start']=$this->request->get['filter_date_start'];
			$this->data['filter_date_start'] = $this->request->get['filter_date_start'];
		} else {
			$this->data['filter_date_start'] = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$data['filter_date_end']=$this->request->get['filter_date_end'];
			$this->data['filter_date_end'] = $this->request->get['filter_date_end'];
		} else {
			$this->data['filter_date_end'] = '';
		}
		
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}
		if (isset($this->request->get['filter_year'])) {
			$filter_year = $this->request->get['filter_year'];
			$this->data['filter_year']	= $this->request->get['filter_year'];
		} else {
			$filter_year = '';
			$this->data['filter_year']	= '';
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['filter_year'])) {
			$url .= '&filter_year=' . $this->request->get['filter_year'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/productDeSubscriptionCount/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);
   		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/productDeSubscriptionCount', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
	
		$data = array(
			'filter_option'			 => $filter_option,	
			'filter_date_start'	     => $this->data['filter_date_start'], 
			'filter_date_end'	     => $this->data['filter_date_end'], 
			'filter_month'           => $filter_month,
			'filter_year' 			 => $filter_year,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total = $this->model_bulk_productDeSubscriptionCount->getTotalProductCount($data);
		$this->data['product_subs_list'] = array();
		$results = $this->model_bulk_productDeSubscriptionCount->getProductDetails($data);
		echo "<pre>";
		print_r($results);exit();
var_dump($results);exit();		
		foreach ($results as $result) {			
				$this->data['product_subs_list'][] = array(
					'product_id'	 => $result['product_id'],	
					'product_number' => $result['product_number'],
					'name'       	 => $result['name'],
					'count'          => $result['count'],
					'selected'   	 => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);								
		}			
		
		$this->data['heading_title'] 	= $this->language->get('heading_title');
		$this->data['column_id'] 		= $this->language->get('column_id');
		$this->data['column_name'] 		= $this->language->get('column_name');
		$this->data['column_count'] 	= $this->language->get('column_count');
		$this->data['text_no_results'] 	= $this->language->get('text_no_results');
		$this->data['token'] 			= $this->session->data['token'];
		$this->data['button_invoice'] 	= $this->language->get('button_invoice');
		$this->data['button_filter'] 	= $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/productDeSubscriptionCount', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/productDeSubscriptionCount.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/productDeSubscriptionCount');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
