<?php 

class ControllerBulkPPVDesubscription extends Controller {
	private $error = array();
	
	public function index() {
		$this->language->load('bulk/ppvdesubscription');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/ppvdesubscription');
		
    	$this->getList();
  	}
  	
  	public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/ppvdesubscription', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_link'] = $this->language->get('column_link');
		$this->data['button_generate'] = $this->language->get('button_generate');
		$this->data['hist_ppvdes_list'] = array();

		$data = array(
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$total = $this->model_bulk_ppvdesubscription->getTotal();
		$results = $this->model_bulk_ppvdesubscription->getZippedFiles($data);
		if($results != null)
		foreach ($results as $result) {			
			$this->data['hist_ppvdes_list'][] = array(
				
				'name'    		=> $result['name'],
				'date'         => $result['date'],
				'download_url' =>$result['download_url'],
				'user_id'	=> $result['user_id']
			);	
		}	

		if(isset($this->request->get['fliteroption']))
			$this->data['filteroption']	= $this->request->get['fliteroption'];
		else
			$this->data['filteroption']=-1;

		if(isset($this->request->get['From']))
			$this->data['From']	= $this->request->get['From'];
		else
			$this->data['From']='';
		if(isset($this->request->get['To']))
			$this->data['To']	= $this->request->get['To'];
		else
			$this->data['To']='';
		if(isset($this->request->get['month']))
			$this->data['month']	= $this->request->get['month'];
		else
			$this->data['month']=-1;
		if(isset($this->request->get['year']))
			$this->data['year']	= $this->request->get['year'];
		else
			$this->data['year']=-1;
		
		$this->data['selectoptions'] = array('1'=>'From-To', '2'=>'Monthly', '3'=>'Yearly');
		

				
		$this->data['token'] = $this->session->data['token'];
		$this->data['user_id'] = $this->session->data['user_id'];
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/ppvdesubscription', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();
		
		$this->template = 'bulk/ppvdesubscription.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

  	function generate(){
  		$this->language->load('bulk/ppvdesubscription');
		$this->document->setTitle($this->language->get('heading_title'));
  		$this->load->model('bulk/ppvdesubscription');
  		$no_of_lines = 1000;
  		if($this->request->get['filter_option']==1)
  			$total = $this->model_bulk_ppvdesubscription->getTotalHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date']);
  		else if($this->request->get['filter_option']==2)
  			$total = $this->model_bulk_ppvdesubscription->getTotalHistoricalDataMonthly($this->request->get['filter_month_date']);
  		else if($this->request->get['filter_option']==3)
  			$total = $this->model_bulk_ppvdesubscription->getTotalHistoricalDataYearly($this->request->get['filter_year_date']);
  		$no_of_files = ceil($total /$no_of_lines);
  		if(!file_exists ("bydesign"))
  			mkdir(DIR_APPLICATION."bydesign");
  		$file_index=1;
  		while ($file_index <= $no_of_files) {
  			$this->createPDF("ppvdesubscription_".$file_index,(($file_index-1)*$no_of_lines),$no_of_lines);
  			$file_index++;
  		}
// ==============FOR COMPRESSING THE FOLDER===================
	    $rootPath = realpath('bydesign');//reports/Hist_Activation
$datetime_obj = new DateTime("now", new DateTimeZone('Asia/Calcutta')); 
$file_date = $datetime_obj->format('Y-m-d H:i:s');   
		$zip = new ZipArchive();
		$user_id = '_'.$this->session->data['user_id'];
		$zipname = 'reports/Hist_PPVDeSubscription/Hist_PPVDeSub_'.$file_date.'.'.$user_id.'.zip';
		$zip->open($zipname ,  ZipArchive::CREATE | ZipArchive::OVERWRITE);
		$files = new RecursiveIteratorIterator( new RecursiveDirectoryIterator($rootPath), RecursiveIteratorIterator::LEAVES_ONLY);
		foreach ($files as $name => $file)
		{
		    // Skip directories (they would be added automatically)
		    if (!$file->isDir())
		    {
		        // Get real and relative path for current file
		        $filePath = $file->getRealPath();
		        $relativePath = substr($filePath, strlen($rootPath) + 1);

		        // Add current file to archive
		        $zip->addFile($filePath, $relativePath);
		    }
		}
		$zip->close();
		$this->deleteDirectory("bydesign");
		if($no_of_files!=0){
			$this->session->data['success'] = "Report Generated Successfully!";
			// $this->session->data['filteroption'] = $this->request->get['filter_option'];
			// $this->data['filteroption'] = $this->session->data['filteroption'];
			// unset($this->session->data['filteroption']);
		}
		else{
			$this->session->data['success']="No Records in this duration!";
		}
		// $this->session->data['success']="Report Generated Successfully!";
	}
  	
  	function createPDF($filename,$start,$limit){
  		$this->pdf = new FPDF();
  			$this->pdf->AddPage();
		    $this->load->model('report/blacklist');
		   	$this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
		    $this->pdf->SetFillColor(232,232,232);
		    $user = $this->model_report_blacklist->getUserDetails($this->session->data['user_id']);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(8);
			$this->pdf->SetX(65);
			$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
			$this->pdf->SetY(11);
			$this->pdf->SetX(65);
			$this->pdf->Cell(192,6,$user['email'],0,0,'C',0);
			$this->pdf->SetFont('times','B',8);
			$this->pdf->SetY(20);
			// $this->pdf->Cell(195,6,'-: Historical PPV Desubscription:-',1,0,'C',1);
			if($_REQUEST['filter_option']==1){
			$this->pdf->Cell(195,6,'-: Historical PPV Desubscription :-   Result between:  '.$this->request->get['filter_to_date'].' TO '.$this->request->get['filter_from_date'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==2) {
				$this->pdf->Cell(195,6,'-: Historical PPV Desubscription :-   Result of month: '.$this->request->get['filter_month_date'] ,1,0,'C',1);
			}elseif ($_REQUEST['filter_option']==3) {
				$this->pdf->Cell(195,6,'-: Historical PPV Desubscription :-   Result of year:  '.$this->request->get['filter_year_date'] ,1,0,'C',1);
			}
			$this->pdf->SetY(30);
		    $w = array(10,40,70,100,140,170);
		    $c = array(30,30,30,40,30,20);
		    $header =  array('PPV Name','Current STB No', 'Previous STB No','Customer Name','DeActivated','Operator');

		    for( $i = 0; $i < count($header) ; $i++){
			  if($i==0)
		    	$this->pdf->SetX($w[0]);
		      else
			   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
 			$this->load->model('bulk/ppvdesubscription');
 			if($this->request->get['filter_option']==1)
  				$results = $this->model_bulk_ppvdesubscription->getHistoricalDataDateWise($this->request->get['filter_to_date'],$this->request->get['filter_from_date'],$start,$limit);
  			else if($this->request->get['filter_option']==2)
  				$results = $this->model_bulk_ppvdesubscription->getHistoricalDataMonthly($this->request->get['filter_month_date'],$start,$limit);
  			else if($this->request->get['filter_option']==3)
  				$results = $this->model_bulk_ppvdesubscription->getHistoricalDataYearly($this->request->get['filter_year_date'],$start,$limit);
  			$this->pdf->Ln();
			$this->pdf->SetFont('times','',8);
			$this->pdf->SetX(20);
			$this->pdf->SetY(38);
			$temp=6;$i=1;
			    foreach($results as $result){
			    	if($result["prev_stbno"]=='0'){
			    		$result["prev_stbno"] = "NA";
			    	}
			    	if($result["STBNO"]==''){
			    		$result["STBNO"] = "NA";
			    	}
			    	$this->pdf->SetX(10);
			    	$this->pdf->Cell($c[0],6,$result["pname"],1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$result["STBNO"],1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$result["prev_stbno"],1,0,'L',0);
			    	$this->pdf->Cell($c[3],6,$result["name"],1,0,'L',0);
			    	$this->pdf->Cell($c[4],6,$result["modify_date"],1,0,'L',0);
			    	// $this->pdf->Cell($c[3],6,$result["exp_date"],1,0,'L',0);
			    	$this->pdf->Cell($c[5],6,$result["username"],1,0,'L',0);
			    	$this->pdf->Ln();
			    	$i++;
		        }


		$this->pdf->Ln();
		$this->pdf->Ln();
		$this->pdf->Ln();
		$this->pdf->Ln();   
		$this->pdf->Cell(70,6,'Date',0,0,'C',0);
		$this->pdf->Cell(130,6,'Signature',0,0,'C',0);
		$this->pdf->Ln(8);
		$this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		$this->pdf->Cell(130,6,'--------------------',0,0,'C',0);
		$this->pdf->Output('bydesign/'.$filename.'.pdf','F');
  	}
  	function deleteDirectory($dir) {
// $dir = $this->request->get['dir'];
    	// if (!file_exists($dir)) {
     //    	return true;
	    // }
	    // if (!is_dir($dir)) {
    	//     return unlink($dir);
    	// }
	    foreach (scandir($dir) as $item) {
    	    if ($item == '.' || $item == '..') {
        	    continue;
	        }else{
	        	unlink($dir."/".$item);
	    	}
    	}
    	rmdir($dir);
 	}
 }
