<?php 
  /*
@File pkgwisechannellist.php(Controller)
ADMIN pkgwisechannellist PAGE
    This class show all the A la carte wise Active Conn to it.

@Author Ravi Ranjan
@date 8th Aug. 2016
*/
class ControllerBulkPkgwiseChannelList extends Controller {

public function index() {

		$this->language->load('bulk/pkgwisechannellist');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/pkgwisechannellist');
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){ 
		if (isset($this->request->post['selected']))
		{
			$this->pdf->AddPage();
			$this->load->model('bulk/pkgwisechannellist');
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);
			$data = array(
				'filter_package' 	 => $this->request->get['filter_package'],
				'filter_broadcaster' 	 => $this->request->get['filter_broadcaster']
			);
		    if($this->request->post['selected']!=''){
		    	$pkgDetails = $this->model_bulk_pkgwisechannellist->getPackageName($this->request->get['filter_package']);
		    	$this->pdf->Cell(170,6,'-: Package Wise Channel Details   :- '.$pkgDetails['name']." - PKG ID:".$pkgDetails['pkgId'],1,0,'C',1);
		    }
			$this->pdf->SetFont('times','B',8);
		    
			$w = array(20,35,60,120,140);
		    $c = array(15,25,60,20,50);
		    $this->pdf->SetY(40);
		    
		    $header =  array('#','Product Id','Product Name','Channel Type','Broadcaster');

		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }

			$this->load->model('bulk/pkgwisechannellist');    
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;

			if(isset($this->request->get['filter_package'])&& $this->request->get['filter_package']!='')
		{
			$total 	 = $this->model_bulk_pkgwisechannellist->getTotalChannelListDetails($data);
			$results = $this->model_bulk_pkgwisechannellist->getChannelListDetails($data);
			foreach ($results as $result) {	
		    	$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],6,$result["product_id"],1,0,'L',0);
		    	$this->pdf->Cell($c[2],6,$result["name"],1,0,'L',0);
		    	$this->pdf->Cell($c[3],6,($result['product_type']==1 ? 'Paid':'FTA'),1,0,'L',0);
		    	$this->pdf->Cell($c[4],6,$result['broadcaster'],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;			
				
			}
		}	

		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/pkgwisechannellist');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/pkgwisechannellist');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();	
		}
    }

	public function countUppercase($string) {
      	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	
		$total  = '';
		if (isset($this->request->get['filter_package'])) {
			$filter_package = $this->request->get['filter_package'];
			$this->data['filter_package'] = $this->request->get['filter_package'];
		} else {
			$filter_package = '';
			$this->data['filter_package'] ='';
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$filter_broadcaster = $this->request->get['filter_broadcaster'];
			$this->data['filter_broadcaster']	= $this->request->get['filter_broadcaster'];
		} else {
			$filter_broadcaster = '0';
			$this->data['filter_broadcaster']	= '';
		}

		if (isset($this->request->get['page'])) {		
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/pkgwisechannellist', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'filter_package' 	 => $filter_package,
			'filter_broadcaster' 	 => $filter_broadcaster,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_package'])) {
			$url .= '&filter_package=' . $this->request->get['filter_package'];
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$url .= '&filter_broadcaster=' . $this->request->get['filter_broadcaster'];
		}

		$this->data['channels'] = array();
		$resultPkgs = $this->model_bulk_pkgwisechannellist->getPackages();
		$broadcasterList = $this->model_bulk_pkgwisechannellist->getBroadcasterList();
		foreach ($broadcasterList as  $broadcaster) {
			$this->data['broadcasters'][] = array(
					'broadcaster_id' => $broadcaster['broadcaster_id'],
					'name'=> $broadcaster['name']
				);
		}
		
		foreach ($resultPkgs as $package) {
			$this->data['packages'][] = array(
				'package_name' =>$package['name'],
				'package_id'   =>$package['product_id'],
				);
		}
		$this->data['channels']=array();
		$total=0;
		if(isset($this->request->get['filter_package'])&& $this->request->get['filter_package']!='')
		{
			$total 	 = $this->model_bulk_pkgwisechannellist->getTotalChannelListDetails($data);
			$results = $this->model_bulk_pkgwisechannellist->getChannelListDetails($data);
			foreach ($results as $result) {	
				$this->data['channels'][] = array(
				'product_id'  	=> $result['product_id'],
				'model'  	=> $result['model'],
				'name' 			=> $result['name'],
				'free' 			=> ($result['product_type']==1 ? 'Paid':'FTA'),
				'broadcast' 	=> $result['broadcaster'],
				'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
				
			}
		}	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_channel_name'] = $this->language->get('column_ch_name');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		$this->data['column_m1price'] = $this->language->get('column_m1price');
		$this->data['column_m3price'] = $this->language->get('column_m3price');
		$this->data['column_m6price'] = $this->language->get('column_m6price');
		$this->data['column_m9price'] = $this->language->get('column_m9price');
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/pkgwisechannellist/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/pkgwisechannellist', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/pkgwisechannellist.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
