<?php 

class ControllerBulkPairUnpairList extends Controller {
	private $error = array();

public function index() {
	$this->language->load('bulk/pair_unpair_list');
	$this->document->setTitle($this->language->get('heading_title'));
	$this->load->model('bulk/pair_unpair_list');
	$this->getList();
}

public function printPdf() {
	$this->pdf->AddPage();
    $this->load->model('bulk/pair_unpair_list');
    $this->pdf->SetFillColor(232,232,232);

	$this->pdf->SetFont('times','B',8);
	$this->pdf->SetY(25);
	$this->pdf->SetX(10);
	$this->pdf->Ln();

	$this->pdf->Cell(180,6,'-: Customer Modification List :-',1,0,'C',1);

	$this->pdf->SetY(40);
    $w = array(10,20,45,75,105,130,145,165);
    $c = array(10,25,30,30,25,15,20,25);	
    
    $header =  array('Sl No.','Customer No','STB No','Group Name','Region Name','Pin','Pairing Status.','Date.');
    for( $i = 0; $i < count($header) ; $i++){
	  if($i==0)
    	$this->pdf->SetX($w[0]);
      else
	   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
	   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
    }
    $count=1;
	$this->pdf->Ln();
    $this->pdf->SetFont('times','',8);    
    $data=array();
    if(isset($this->request->get['filter_value'])){
    	$data['filter_value'] = $this->request->get['filter_value'];
    }
    $results = $this->model_bulk_pair_unpair_list->getDetail($data);
	foreach($results as $result){	
		$c_height=6;	    	
		$this->pdf->SetX(10);
		$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		$this->pdf->Cell($c[1],6,$result["customer_no"],1,0,'L',0);
		$this->pdf->Cell($c[2],6,($result['stb_no']!='')?$result['stb_no']:'NA',1,0,'L',0);
		$x_axis=$this->pdf->getx();
		$this->pdf->vcell($c[3],$c_height,$x_axis,$result["group"],22);
		$x_axis=$this->pdf->getx();
		$this->pdf->vcell($c[4],$c_height,$x_axis,$result["region"],22);
		$this->pdf->Cell($c[5],6,$result["pin"],1,0,'L',0);
		$this->pdf->Cell($c[6],6,($result['pairing_status']==1)?'Paired':'Unpaired',1,0,'L',0);
		$this->pdf->Cell($c[7],6,$result['modify_date'],1,0,'L',0);
		$this->pdf->Ln();
		$count++;
	}
          
    /*$this->pdf->Ln(8);   
    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
    $this->pdf->Ln(8);
    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
    ob_clean();
    $this->pdf->Output();
}	

public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';		

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/pair_unpair_list', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}		
		
		$this->data['customers'] = array();
		$this->data['printPdf'] = $this->url->link('bulk/pair_unpair_list/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		$totals = $this->model_bulk_pair_unpair_list->getTotalDetails($data);
		$results = $this->model_bulk_pair_unpair_list->getDetail($data);
		
		foreach ($results as $result) {	
			$action = array();
			$actionUnapir = array();
				
			$this->data['customers'][] = array(
				'customer_no'    => $result['customer_no'],			
				'STBNO'          => ($result['stb_no']!='')?$result['stb_no']:'NA',
				'group'          => $result['group'],
				'region'          => $result['region'],
				'pin'          => $result['pin'],
				'pairing_status' => ($result['pairing_status']==1)?'Paired':'Unpaired',
				'modify_date'    => $result['modify_date']
			
			);	
		}			

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_stb'] = $this->language->get('entry_stb');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_group'] = $this->language->get('column_group');
		$this->data['column_region'] = $this->language->get('column_region');
		$this->data['column_pin'] = $this->language->get('column_pin');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_modify_date'] = $this->language->get('column_modify_date');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];		
			unset($this->session->data['warning']);
		}else if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['message'])) {
			$this->data['error_message'] = $this->error['message'];
		} else {
			$this->data['error_message'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		}else if (isset($this->error['success'])) {
			$this->data['success'] = $this->error['success'];
		}else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		$pagination->total = $totals;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/pair_unpair_list', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
				
		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->template = 'bulk/pair_unpair_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
 }
 ?> 
