<?php 

class ControllerBulkNLog extends Controller {

public function index() {
		$this->language->load('bulk/nlog');		 
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/nlog');		
    	$this->getList();
  	}

	public function printPdf() {		
 		$this->pdf->AddPage();
	    $this->load->model('bulk/nlog');
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(10);
		$this->pdf->Ln();

		$this->pdf->Cell(195,6,'-: Logs Details [Year-'.$this->request->get['selYear'].'] :-',1,0,'C',1);

		$this->pdf->SetY(40);
	   
	    $w = array(10,35,75,110,140,155,170);
	    $c = array(25,40,35,30,15,15,30);	

	    $header =  array('Target','Command','Target Level','Date Time','Status','Resend','Target No');
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }
	    $count=1;
		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);

	    if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] = '';
		}

		if (isset($this->request->get['filter_date_added'])) {
			$this->data['filter_date_added'] = $this->request->get['filter_date_added'];
		} else {
			$this->data['filter_date_added'] = '';
		}

		if (isset($this->request->get['filter_command'])) {
			$this->data['filter_command'] = $this->request->get['filter_command'];
		} else {
			$this->data['filter_command'] = '';
		}

		if (isset($this->request->get['filter_lco'])) {
			$this->data['filter_lco'] = $this->request->get['filter_lco'];
		} else {
			$this->data['filter_lco'] = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = null;
		}

		if (isset($this->request->get['filter_date_added'])) {
			$filter_date_added = $this->request->get['filter_date_added'];
		} else {
			$filter_date_added = null;
		}

		if (isset($this->request->get['filter_command'])) {
			$filter_command = $this->request->get['filter_command'];
		} else {
			$filter_command = null;
		}

		if (isset($this->request->get['filter_lco'])) {
			$filter_lco = $this->request->get['filter_lco'];
		} else {
			$filter_lco = null;
		}

		$data = array(
			'filter_lco'				=> $filter_lco,
			'filter_command'			=> $filter_command,
			'filter_value'				=> $filter_value,
			'filter_date_added'        	=> $filter_date_added			
		);
	    
	    $results = $this->model_bulk_nlog->getLogsDetailsForPDF($data,$this->request->get['selYear']);

	    $target_lvl = array( 0 => "NA" , 1 => "INDIVIDUAL" , 2 => "GLOBAL" , 3 => "REGION" , 4 => "GROUP",5 => "LCO");
	    $commands = array();
		$commandResult = $this->model_bulk_nlog->getLogsDescriptionDetails();
		foreach ($commandResult as $key => $value) {
			$commands[$value['command_id']] = $value['description'];
		}

		foreach($results as $result){		    	
			/*if($result['target_level']==1){
				$triggered_for =$this->model_bulk_nlog->getCustomerNameByStbno($result['target'],$result['operator_id']);
			}else{
				$triggered_for = 'n/a';
			}*/

			if($result['command_id']==16){
				if($result['targetNo']==0){
					$targetNo = 'Box Reboot';
				}elseif ($result['targetNo']==1){
				  	$targetNo='Msg_Id_Reset';
			    }elseif($result['targetNo']==2){
					$targetNo = 'Pin Reset';
				}elseif($result['targetNo']==3){
					$targetNo='Black List';
				}elseif($result['targetNo']==4){
					$targetNo='OSD Disable';
				}elseif($result['targetNo']==5){
					$targetNo='Factory Reset';
				}elseif($result['targetNo']==6){
					$targetNo='Network ID Reset';
				}else{
					$targetNo = 'n/a';
				}
			}elseif ($result['command_id']==23) {
				if($result['targetNo']==1){
					$targetNo = 'Suspend';
				}else{
				  	$targetNo = 'Resume';
			    }
			}else{
				if($result['targetNo']==-1){
					$targetNo = 'n/a';
				}else{
				  	$targetNo = $result['targetNo']; 
			    }
			}

			if ($result['target_level']==5){
				$target = $this->model_bulk_nlog->getLcoNameById($result['target']);
			}else{
				$target = $result['target'];
			}

			$c_height=6;
			$x_axis=$this->pdf->getx();
			$this->pdf->SetX(10);
			$this->pdf->vcell($c[0],$c_height,$x_axis,$target,23);
			$x_axis=$this->pdf->getx();
			$this->pdf->vcell($c[1],$c_height,$x_axis,$commands[$result['command_id']],25);
			/*$x_axis=$this->pdf->getx();
			$this->pdf->vcell($c[2],$c_height,$x_axis,$result['lco_name'],23);
			$x_axis=$this->pdf->getx();
			$this->pdf->vcell($c[3],$c_height,$x_axis,$triggered_for,22);*/
			$this->pdf->Cell($c[2],6,$target_lvl[$result['target_level']],1,0,'L',0);
			$this->pdf->Cell($c[3],6,$result["datetime"],1,0,'L',0);
			$this->pdf->Cell($c[4],6,$result["status"],1,0,'L',0);
			$this->pdf->Cell($c[5],6,$result["resend"]==1? "YES" : "NO",1,0,'L',0);
			// $this->pdf->Cell($c[6],6,($result['command_id']==23)?(($result['targetNo']==1)?'Suspend':'Resume'):(($result['targetNo']==-1)?'n/a':$result['targetNo']),1,0,'L',0);
			$this->pdf->Cell($c[6],6,$targetNo,1,0,'L',0);
			$this->pdf->Ln();
			
		}
              
	    /*$this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
	    ob_clean();
	    $this->pdf->Output();
  	}

public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] = '';
		}

		if(isset($this->request->get['filter_command'])) {
			$this->data['filter_command'] = $this->request->get['filter_command'];
		} else {
			$this->data['filter_command'] = '';
		}

		if(isset($this->request->get['filter_lco'])) {
			$this->data['filter_lco'] = $this->request->get['filter_lco'];
		} else {
			$this->data['filter_lco'] = '';
		}

		if (isset($this->request->get['filter_date_added'])) {
			$this->data['filter_date_added'] = $this->request->get['filter_date_added'];
		} else {
			$this->data['filter_date_added'] = '';
		}

		if (isset($this->request->get['filter_value'])) {
			$filter_value = $this->request->get['filter_value'];
		} else {
			$filter_value = null;
		}

		if(isset($this->request->get['filter_command'])) {
			$filter_command = $this->request->get['filter_command'];
		} else {
			$filter_command = null;
		}

		if(isset($this->request->get['filter_lco'])) {
			$filter_lco = $this->request->get['filter_lco'];
		} else {
			$filter_lco = null;
		}

		if (isset($this->request->get['filter_date_added'])) {
			$filter_date_added = $this->request->get['filter_date_added'];
		} else {
			$filter_date_added = null;
		}

		$url = '';
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/nlog', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

		$data = array(
			'filter_value'				=> $filter_value,
			'filter_command'			=> $filter_command,
			'filter_lco'				=> $filter_lco,
			'filter_date_added'        	=> $filter_date_added,
			'start'          			=> ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           			=> $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value'] 		= $this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] = '';
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		if (isset($this->request->get['filter_command'])) {
			$url .= '&filter_command=' . $this->request->get['filter_command'];
		}

		if (isset($this->request->get['filter_lco'])) {
			$url .= '&filter_lco=' . $this->request->get['filter_lco'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		$total = $this->model_bulk_nlog->getTotalLogs($data);
		$this->data['logs'] = array();
		$results = $this->model_bulk_nlog->getLogsDetails($data);
  
		$target_lvl = array( 0 => "NA" , 1 => "INDIVIDUAL" , 2 => "GLOBAL" , 3 => "REGION" , 4 => "GROUP",5 => "LCO");
		$commands = array();
		$commandResult = $this->model_bulk_nlog->getLogsDescriptionDetails();
		foreach ($commandResult as $key => $value) {
			$commands[$value['command_id']] = $value['description'];
		}
		
		$cmd_ids = $this->model_bulk_nlog->getLogsDescriptionDetails();
		foreach($cmd_ids as $cmdid) {
			$this->data['cmd_ids'][] = array(
				'command_id' 	=>$cmdid['command_id'],
				'description'   =>$cmdid['description'],
			);
		}

		$LcoLists = $this->model_bulk_nlog->getLcoDetails();
		foreach($LcoLists as $LcoList) {
			$this->data['LcoLists'][] = array(
				'user_id' 	 =>$LcoList['user_id'],
				'username'   =>$LcoList['username'],
				);
		}

		foreach ($results as $result) {
			// echo "<pre>"; print_r($result); die;
			/*if($result['target_level']==1){
				$triggered_for =$this->model_bulk_nlog->getCustomerNameByStbno($result['target'],$result['operator_id']);
			}else{
				$triggered_for = 'n/a';
			}*/
			
			if($result['command_id']==16){
				if($result['targetNo']==0){
					$targetNo = 'Box Reboot';
				}elseif ($result['targetNo']==1){
				  	$targetNo='Msg_Id_Reset';
			    }elseif($result['targetNo']==2){
					$targetNo = 'Pin Reset';
				}elseif($result['targetNo']==3){
					$targetNo='Black List';
				}elseif($result['targetNo']==4){
					$targetNo='OSD Disable';
				}elseif($result['targetNo']==5){
					$targetNo='Factory Reset';
				}elseif($result['targetNo']==6){
					$targetNo='Network ID Reset';
				}else{
					$targetNo = 'n/a';
				}
			}elseif ($result['command_id']==23) {
				if($result['targetNo']==1){
					$targetNo = 'Suspend';
				}else{
				  	$targetNo = 'Resume';
			    }
			}else{
				if($result['targetNo']==-1){
					$targetNo = 'n/a';
				}else{
				  	$targetNo = $result['targetNo']; 
			    }
			}
			
			if ($result['target_level']==5){
				$target = $this->model_bulk_nlog->getLcoNameById($result['target']);
			}else{
				$target = $result['target'];
			}

			$this->data['logs'][] = array(
				'id'  			=> $result['id'],
				'command_id'  	=> $commands[$result['command_id']],
				'target' 	 	=> $target,
				// 'username'		=> $result['lco_name'],
				// 'triggered_for' => $triggered_for,
				'target_level' 	=> $target_lvl[$result['target_level']],
				'datetime'		=> $result['datetime'],
				'status'		=> $result['status'],
				'resend'		=> ($result['resend']==1)? "YES" : "NO",
				'targetNo'		=> $targetNo,//($result['command_id']==23)?(($result['targetNo']==1)?'Suspend':'Resume'):(($result['targetNo']==-1)?'n/a':$result['targetNo']),
				'total'        	=> $total,
				'selected'      => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected']),
			);						
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_channel_no'] = $this->language->get('column_channel_no');
		$this->data['column_channel_name'] = $this->language->get('column_channel_name');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		
		$this->data['entry_product_no'] = $this->language->get('entry_product_no');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['text_paid'] = $this->language->get('text_paid');
		$this->data['text_fd'] = $this->language->get('text_fd');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		

		if(isset($filter_value) && isset($filter_date_added) && isset($filter_command))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_value='.$filter_value.'&filter_date_added='.$filter_date_added.'&filter_command='.$filter_command, 'SSL');
		else if(isset($filter_value) && isset($filter_command))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_value='.$filter_value.'&filter_command='.$filter_command, 'SSL');
		else if(isset($filter_date_added) && isset($filter_command))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_date_added='.$filter_date_added.'&filter_command='.$filter_command, 'SSL');
		else if( isset($filter_date_added) && isset($filter_value) )
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_command='.$filter_command.'&filter_date_added='.$filter_date_added, 'SSL');
		else if(isset($filter_value))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_value='.$filter_value, 'SSL');
		else if(isset($filter_date_added))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_date_added='.$filter_date_added, 'SSL');
		else if(isset($filter_command))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_command='.$filter_command, 'SSL');
		else if(isset($filter_lco))
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'].'&filter_lco='.$filter_lco, 'SSL');
		else
			$this->data['printPdf'] = $this->url->link('bulk/nlog/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';

		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		if (isset($this->request->get['filter_command'])) {
			$url .= '&filter_command=' . $this->request->get['filter_command'];
		}

		if (isset($this->request->get['filter_lco'])) {
			$url .= '&filter_lco=' . $this->request->get['filter_lco'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/nlog', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/nlog.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
