<?php 

class ControllerBulkLocationwiseSettopbox extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer detials along with the assigned set top box and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the set top box page
*/
public function index() {
		$this->language->load('bulk/locationwiseSettopbox');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/locationwiseSettopbox');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){ 
	if(isset($this->request->post['selected'])){ 
		if (isset($this->request->get['zone_id'])) {
			$zone_id = $this->request->get['zone_id'];
		} else {
			$zone_id = '';
		}
		if (isset($this->request->get['region_id'])) {
			$region_id = $this->request->get['region_id'];
		} else {
			$region_id = '';
		}

	    $this->pdf->AddPage();
	    $this->load->model('bulk/locationwiseSettopbox');
	    $this->pdf->SetFillColor(232,232,232);
	    $this->pdf->SetFont('times','B',10);
		$this->pdf->SetY(32);
		$this->pdf->SetX(20);
		if (!isset($this->request->get['zone_id']) && !isset($this->request->get['region_id'])) {
			$this->pdf->Cell(170,7,'-: Location wise Set Top Box And CAS :-',1,0,'C',1);
		}else{
			$location = $this->model_bulk_locationwiseSettopbox->getLocationDetails($_REQUEST['zone_id'],$_REQUEST['region_id']);
			$this->pdf->Cell(170,7,'-: Location wise Set Top Box And CAS :-  Result Zone of: '.$location['zone_name'].' AND Region: '.$location['region_name'],1,0,'C',1);
		}
		$this->pdf->SetFont('times','B',8);
		    
		$w = array(20,30,70,115,162);
	    $c = array(10,40,45,47,28);
	    $this->pdf->SetY(40);
	    $header =  array('Sr.No','Region Name','Customer Name','Address','STB NO');
	    for( $i = 0; $i < count($header) ; $i++){
		  	if($i==0)
	    		$this->pdf->SetX($w[0]);
	      	else
		   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		}	
	    $this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
        $count=1;
		/*foreach ($this->request->post['selected'] as $customer) {
				$customer_id=substr($customer,0,strpos($customer,'~'));
				$sl_no=substr($customer,strpos($customer,'~')+1);*/
				$results = $this->model_bulk_locationwiseSettopbox->getCustomerAddress($zone_id,$region_id);
				foreach($results as $result){
				$this->pdf->SetX(20);
/*		    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
		    	$this->pdf->Cell($c[1],6,$result["region_name"],1,0,'L',0);
		    	$this->pdf->Cell($c[2],6,$result["name"],1,0,'L',0);
		    	$this->pdf->Cell($c[3],6,$result["address"],1,0,'L',0);
		    	$this->pdf->Cell($c[4],6,$result["STBNO"],1,0,'L',0);*/
		    	$c_height=6;
		    	// $x_axis=$this->pdf->getx();
				$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
				// $x_axis=$this->pdf->getx();// now get current pdf x axis value
				$this->pdf->Cell($c[1],6,$result["region_name"],1,0,'L',0);
				$x_axis=$this->pdf->getx();
				$this->pdf->vcell($c[2],$c_height,$x_axis,$result["name"],25);// pass all values inside the cell 
				$x_axis=$this->pdf->getx();
				$this->pdf->vcell($c[3],$c_height,$x_axis,$result["address"],25);// pass all values inside the cell 
				// $x_axis=$this->pdf->getx();
				$this->pdf->Cell($c[4],6,$result["STBNO"],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;
			}
		// }
	 	              
	    /*$this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
	    $this->pdf->Output();
		}else{
			$this->language->load('bulk/locationwiseSettopbox');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/locationwiseSettopbox');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer details with their stb details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the customer details with their stb details as a list.
*/
public function getList() {	
		$this->load->model('bulk/locationwiseSettopbox');

		if (isset($this->request->get['zone_id'])) {
			$zone_id = $this->request->get['zone_id'];
		} else {
			$zone_id = '';
		}
		if (isset($this->request->get['region_id'])) {
			$region_id = $this->request->get['region_id'];
		} else {
			$region_id = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['zone_id'])) {
			$url .= '&zone_id=' . $this->request->get['zone_id'];
		}		

		if (isset($this->request->get['region_id'])) {
			$url .= '&region_id=' . $this->request->get['region_id'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/locationwiseSettopbox', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/locationwiseSettopbox', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);
   		//----------
   		if (isset($this->request->get['zone_id'])) {
			// $data['zone_id']=$this->request->get['zone_id'];
			$this->data['zone_id'] = $this->request->get['zone_id'];
		} else {
			$this->data['zone_id'] = '';
		}
		if (isset($this->request->get['region_id'])) {
			// $data['region_id']=$this->request->get['region_id'];
			$this->data['region_id'] = $this->request->get['region_id'];
		} else {
			$this->data['region_id'] = '';
		}
		$data = array(
			'zone_id'		  => $zone_id,
			'region_id'		  => $region_id,		
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		$this->data['zones'] = $this->model_bulk_locationwiseSettopbox->getZoneList(99);
		if (isset($this->request->get['zone_id'])) {
			$this->data['regions'] = $this->model_bulk_locationwiseSettopbox->getRegionList($this->request->get['zone_id']);
		}
		
		$total = $this->model_bulk_locationwiseSettopbox->getTotalStbAddress($data);
		$this->data['printPdf'] = $this->url->link('bulk/locationwiseSettopbox/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['customers'] = array();
		$results = $this->model_bulk_locationwiseSettopbox->getaddress($data);
		$i=0;
		foreach ($results as $result) {	
		$i=$i+1;
			$this->data['customers'][] = array(
				'customer_id'   => $result['customer_id'],
				'customer_no' 	=>($page-1) * $this->config->get('config_admin_limit')+$i,
				'install_date'	=>$result["date_added"],
				'STBNO'         => $result['STBNO'],
				'name'          => $result['name'],
				'address'       => $result['address'],
				'region_name'	=> $result['region_name'],
				'status'        => ($result['status']?'Enable':'Disabled'),
				'selected'   	=> isset($this->request->post['selected']) && in_array($result['customer_id'], $this->request->post['selected']),
			);	
		}		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_stbno'] = $this->language->get('column_stbno');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['entry_zone'] = $this->language->get('entry_zone');
		$this->data['entry_region'] = $this->language->get('entry_region');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/locationwiseSettopbox', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();

		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		
		$this->template = 'bulk/locationwiseSettopbox.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  		/*
FUNCTION NAME 		-	region
DESCRIPTION 		-	Loads the regions information form the database to a json
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the json values for the country retrieved.
*/		
	public function region() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$zone_info = $this->model_localisation_country->getZone($this->request->get['zone_id']);
		if ($zone_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'zone_id'        	=> $zone_info['zone_id'],
				'name'              => $zone_info['name'],
				'region'            => $this->model_localisation_zone->getRegionsByZoneId($this->request->get['zone_id'])
			);
		} 
		$this->response->setOutput(json_encode($json)); //var_dump($json);
	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/locationwiseSettopbox');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}
 }
?> 