<?php 
 /*
@File customer.php(Controller)
ADMIN CUSTOMER PAGE
    This class show total authorized subscribers in the store

@Author Ravi Ranjan 
@date 26th Nov. 2015
*/ 
class ControllerBulkCustomerDueForReactivation extends Controller { 
	private $error = array();
  /*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the authorized subscriber details and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  authorized subscriber page
*/
  	public function index() {
		$this->language->load('bulk/customer_due_for_reactivation');
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/customer_due_for_reactivation');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  
  	public function printPdf(){
  		$filter_region = $this->request->get['filter_region'];
  		$this->language->load('bulk/customer_due_for_reactivation');
  		if(isset($this->request->post['selected']))
  		{	$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		   	$this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(28);
			$this->pdf->SetX(20);

			$this->pdf->Cell(180,6,'-: Customer Due for Re-Activation (Duration '.$this->request->post['filter_from_date'].' to '.$this->request->post['filter_date'].') :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,30,60,90,105,135,158,174);
		    $c = array(10,30,30,15,30,23,16,26);
		    $this->pdf->SetY(35);
		    $header =  array('Sr.No.','Region Name','Operator Name','Cust. No','Customer Name','STB No','Mobile','Due Date');
		    for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
			}		

			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
	        $c_height=8;
	        $this->load->model('bulk/customer_due_for_reactivation');
	        $results = $this->model_bulk_customer_due_for_reactivation->getCustomerpdf($this->request->post,$filter_region);
		    foreach($results as $result){
	    		$this->pdf->SetX(20);
		    	$this->pdf->Cell($c[0],8,$count,1,0,'L',0);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[1],$c_height,$x_axis,$result['region_name'],22);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[2],$c_height,$x_axis,$result['username'],22);
		    	$this->pdf->Cell($c[3],8,$result['customer_unique_id'],1,0,'L',0);
		    	$x_axis=$this->pdf->getx();
		    	$this->pdf->vcell($c[4],$c_height,$x_axis,$result['name'],22);
		    	$this->pdf->Cell($c[5],8,$result['STBNO'],1,0,'L',0);
		    	$this->pdf->Cell($c[6],8,$result["telephone"],1,0,'L',0);
		    	$this->pdf->Cell($c[7],8,$result['expiry_date'],1,0,'L',0);
		    	$this->pdf->Ln();
		 		$count++;
	       	}
 
		    $this->pdf->Output();
		}else{
			
			$this->document->setTitle($this->language->get('heading_title'));
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }

       
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the authorized subscribers details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/    
  	protected function getList() {	

  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		if(isset($this->data['error_date']))
			$this->data['error_date']=$this->data['error_date'];
		else
			$this->data['error_date']='';

		if(isset($this->data['error_from_date']))
			$this->data['error_from_date']=$this->data['error_from_date'];
		else
			$this->data['error_from_date']='';
		
		$url = '';
		if (isset($this->request->get['filter_date'])) {
			$url .= '&filter_date=' . $this->request->get['filter_date'];
			$this->data['filter_date']=$this->request->get['filter_date'];
		}else{
			$this->data['filter_date']='';
		}
		if (isset($this->request->get['filter_from_date'])) {
			$url .= '&filter_from_date=' . $this->request->get['filter_from_date'];
			$this->data['filter_from_date']=$this->request->get['filter_from_date'];
		}else{
			$this->data['filter_from_date']='';
		}

		if (isset($this->request->get['filter_region'])) {
			$filter_region = $this->request->get['filter_region'];
			$this->data['filter_region']	= $this->request->get['filter_region'];
		} else {
			$filter_region = '';
			$this->data['filter_region']	='';
		}

		if (isset($this->request->get['filter_operator'])) {
			$filter_operator = $this->request->get['filter_operator'];
			$this->data['filter_operator']	= $this->request->get['filter_operator'];
		} else {
			$filter_operator = '';
			$this->data['filter_operator']	='';
		}

		//--------------
 		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/customer_due_for_reactivation', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => '::'
   		);
	   	
	   	$this->data['customers'] = array();
	   	$this->data['regions'] 	 = $this->model_bulk_customer_due_for_reactivation->getRegions();
	   	$this->data['operators'] = $this->model_bulk_customer_due_for_reactivation->getOperators();
		$this->load->model('bulk/customer_due_for_reactivation');
	   	 $data = array(
        	'filter_date' 	  => $this->data['filter_date'],
        	'filter_from_date'=> $this->data['filter_from_date'],
        	'filter_region'	  => $this->data['filter_region'],
        	'filter_operator' => $this->data['filter_operator'],
            'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit') 
        	);
   		
		if (isset($this->request->get['filter_date']) && isset($this->request->get['filter_from_date']))
		{
			$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_filter'),
			'href'      => $this->url->link('bulk/customer_due_for_reactivation', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => '::'
   			);
			$results = $this->model_bulk_customer_due_for_reactivation->getCustomersFilter($data);
			$total = $this->model_bulk_customer_due_for_reactivation->getTotalCustomersFilter($data);
	 			$i=0;
	    	foreach ($results as $result) {
				$i=$i+1;
				$this->data['customers'][] = array(
					'customer_id'    => $result['customer_id'],
					'customer_no'    => $result['customer_unique_id'],
					'telephone'      => $result["telephone"],
					'name'           => $result['name'],
					'region_name'	 => $result['region_name'],
					'username'		 => $result['username'],
					'STBNO'          => $result['STBNO'],
					'expiry_date'    => $result['expiry_date'],
					'selected'       => isset($this->request->post['selected']) && in_array($result['STBNO'], $this->request->post['selected']),
				);
			}
		}
		else {
			$total=0;
		}	
					
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['entry_date'] = $this->language->get('entry_date');
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['text_select'] = $this->language->get('text_select');	
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_caf'] = $this->language->get('column_caf');
		$this->data['column_telephone'] = $this->language->get('column_telephone');
		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['column_stb'] = $this->language->get('column_stb');
		$this->data['column_active_date'] = $this->language->get('column_active_date');
		$this->data['column_due_date'] = $this->language->get('column_due_date');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['cancel'] = $this->url->link('bulk/customer_due_for_reactivation', 'token=' . $this->session->data['token'] , 'SSL');

		$this->data['printPdf'] = $this->url->link('bulk/customer_due_for_reactivation/printPdf', 'token=' . $this->session->data['token'].'&filter_region='.$this->data['filter_region'].'&filter_operator='.$this->data['filter_operator'], 'SSL');

		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->error['warning'])){
			$this->data['error_warning']='';
		}else{
			$this->data['error_warning'] = $this->error['warning'];
		}
		
		if (isset($this->request->get['filter_date'])) {
			$url .= '&filter_date=' . $this->request->get['filter_date'];
		}
		if (isset($this->request->get['filter_from_date'])) {
			$url .= '&filter_from_date=' . $this->request->get['filter_from_date'];
		}

		if (isset($this->request->get['filter_region'])) {
			$url .= '&filter_region=' . $this->request->get['filter_region'];
		}

		if (isset($this->request->get['filter_operator'])) {
			$url .= '&filter_operator=' . $this->request->get['filter_operator'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/customer_due_for_reactivation', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		//---------------------------
		
		$this->data['sort_name'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
	    $this->data['sort_stbno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=STBNO' . $url, 'SSL');
		$this->data['sort_casno'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=CASNO' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('report/customer', 'token=' . $this->session->data['token'] . '&sort=c.date_added' . $url, 'SSL');
		
		$url = '';
		
		$this->template = 'bulk/customer_due_for_reactivation.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
  	/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Filter the list according to the start and end date.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retrieves the list that matches the filter condition
*/

public function filter(){
	$this->language->load('bulk/customer_due_for_reactivation');
		$this->document->setTitle($this->language->get('heading_title'));		
		$this->load->model('bulk/customer_due_for_reactivation');
		if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateDate()){
			
			
		}
		// var_dump($this->error);exit();
    	$this->getList();

}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	
*/

	public function validateDate(){

		/*if(isset($this->request->get['filter_region']) && $this->request->get['filter_region']=='-1'){
			$this->error['warning'] = "Please select region!";
		}*/

		if(!(isset($this->request->get['filter_date']) && isset($this->request->get['filter_from_date']))){
			$this->error['warning'] = "Both the filter dates are required!";//$this->language->
		}elseif($this->request->get['filter_date'] <= $this->request->get['filter_from_date'] ){
			$this->error['warning'] = "'From date' should not be greater than or equal to 'To date'!";//$this->language->get('error_startdate_req');	
	    }

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  

	}
}
?>