<?php 

class ControllerBulkChannelSubsAgeing extends Controller {

public function index() {

		$this->language->load('bulk/channelsubsageing');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/channelsubsageing');
    	$this->getList();
  	}

	public function printPdf(){ 

		if (isset($this->request->post['selected']))
		{
			$this->load->model('bulk/channelsubsageing');
		    $this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(20);
			
		    if($this->request->post['selected']!=''){
		    	$pkgName = $this->model_bulk_channelsubsageing->getPackageName($this->session->data['filter_product']);
		       	$pkgNo = $this->model_bulk_channelsubsageing->getPackageNo($this->session->data['filter_product']);		    	
		    	$this->pdf->Cell(170,6,'-: Ageing of the Subscribers On a Channel   :- '.$pkgName." - ".$pkgNo,1,0,'C',1);
		    }
		    $this->pdf->Ln();
			$this->pdf->SetFont('times','B',8);
		    $w = array(20,35,60,110,150);
	    	$c = array(15,25,50,40,40);	
	    	$this->pdf->SetY(40);
	    	$header =  array('Sl No.','Product No.','STB No.','Expiry Date','Ageing');
		    for( $i = 0; $i < count($header) ; $i++){
			  if($i==0)
		    	$this->pdf->SetX($w[0]);
		      else
			   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }
		    $count=1;
			$this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    $results = $this->model_bulk_channelsubsageing->getChannelsSubsPDF($this->session->data['filter_product']);
			foreach($results as $result){	
				$days = $result['duration'];	    	
			   	$this->pdf->SetX(20);
			   	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			   	$this->pdf->Cell($c[1],6,$result["model"],1,0,'L',0);
			   	$this->pdf->Cell($c[2],6,$result["STBNO"],1,0,'L',0);
			   	$this->pdf->Cell($c[3],6,$result["exp_date"],1,0,'L',0);
			   	$this->pdf->Cell($c[4],6,$days." "."days",1,0,'L',0);
			   	$this->pdf->Ln();
				$count++;
		    }
		
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/channelsubsageing');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/channelsubsageing');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();	
		}
    }

	public function countUppercase($string) {
      	return strlen(preg_replace('![^A-Z]+!', '', $string));
	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if(!isset($_GET['page'])){			
			if(isset($this->session->data['filter_product'])){
				$this->session->data['fp_pack'] = $this->session->data['filter_product'];
			}
			unset($this->session->data['filter_product']);
		}
		
		$total  = '';

		if (isset($this->request->get['filter_product'])) {
			$this->data['filter_product'] = $this->request->get['filter_product'];
		} else {
			
			$this->data['filter_product'] ='';
		}

		if (isset($this->request->get['page'])) {		
			$page = $this->request->get['page'];
			$this->data['filter_product'] = $this->session->data['fp_pack'];
			
		} else {
			$page = 1;
		}

		

		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/channelsubsageing', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_product'])) {
			$this->session->data['filter_product'] = $this->request->get['filter_product'];
		}

		if (isset($this->request->get['filter_product'])) {
			$url .= '&filter_product=' . $this->request->get['filter_product'];
		}

		$this->data['channels'] = array();
		$resultChannels = $this->model_bulk_channelsubsageing->getChannels();
		
		foreach ($resultChannels as $channel) {
			$this->data['channels'][] = array(
				'channel_name' 	=> $channel['name'],
				'product_id'   	=> $channel['product_id'],
				'p_no'   	   	=> $channel['model'],
			);
		}

		if($this->data['filter_product']!='' || isset($this->session->data['filter_product'])){
			$total 	 = $this->model_bulk_channelsubsageing->getTotalChannelsSubs($this->session->data['filter_product']);

			$results = $this->model_bulk_channelsubsageing->getChannelsSubs($this->session->data['filter_product'],$data);
			$i =0 ;
			foreach ($results as $result) {		
				$i++;	
				$days = ($result['duration']);
				$this->data['channelssubs'][] = array(
					'product_id'  	=> $result['product_id'],
					'model'  		=> $result['model'],					
					'stbno' 		=> $result['STBNO'],
					'expiry' 		=> $result['exp_date'],
					'time'       	=> $days." "."days",
					'customer_no'    =>($page - 1) * $this->config->get('config_admin_limit')+$i,
					'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
			}			
		}	
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_channel_name'] = $this->language->get('column_ch_name');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		
		$this->data['column_yearly'] = $this->language->get('column_yearly');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['entry_package'] = $this->language->get('entry_package');

		$this->data['column_address'] = $this->language->get('column_address');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');

		$this->data['printPdf'] = $this->url->link('bulk/channelsubsageing/printPdf', 'token=' . $this->session->data['token']. $url, 'SSL');

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/channelsubsageing', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');	
		$this->data['pagination'] = $pagination->render();	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/channelsubsageing.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
