<?php 
class ControllerBulkBroadcasterReport extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/broadcasterreport');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/broadcasterreport');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/

public function RegionWisePrint(){

	 $data = array(
			'filter_month'           => $this->request->post['filter_month'],
			'mode' 					 => $this->request->post['mode'],
			'filter_broadcaster' 	 => $this->request->post['filter_broadcaster'],
		);
	$this->load->model('bulk/broadcasterreport');
	$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$openingCount = $this->model_bulk_broadcasterreport->getProductDetailsOpening($data);
			$ActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsActivate($data);
			$DeActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsDeActivate($data);
			foreach ($openingCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_opening'] = $value['sms_opening'];
				$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];

				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
			}
			foreach ($ActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_activated'] = $value['sms_activated'];
				
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['pno']))
					$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];
				// if(!isset($final_count_array[$value['region_id']]['region_id']))
				// 	$final_count_array[$value['region_id']]['product_id'] = $value['product_id'];
			}
			foreach ($DeActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated'] = $value['sms_deactivated'];
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
			}
			// echo "<pre>"; echo count($final_count_array); print_r($final_count_array);die;
		}

		if (isset($this->request->get['filter_month'])) {
			foreach ($final_count_array as $key => $result) {
				$this->printPdf($key,$result);
			}
			$this->pdf->Output();

		}
}
public function printPdf($region_id,$subscriptionArray){  
	    $this->pdf->AddPage();
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(10);
		$this->pdf->Ln();
		
		$region_name = $this->model_bulk_broadcasterreport->getRegionName($region_id);
		if($this->request->get['mode']==0){
			$this->pdf->Cell(180,6,'-: Broadcaster Report (Region : '.$region_name.')(Channel Wise):-   Month :  '.$this->request->get['filter_month'],1,0,'C',1);
			$header =  array('Sl No.','Channel Name','Channel No','sms opening','sms act', 'sms deact','sms closing','sms avg');
			$w = array(10,20,70,90,110,130,150,170);
	    	$c = array(10,50,20,20,20,20,20,20);	

		}elseif($this->request->get['mode']==1){
			$this->pdf->Cell(190,6,'-: Broadcaster Report (Region : '.$region_name.')(Package Wise):-   Month :  '.$this->request->get['filter_month'],1,0,'C',1);
			$header =  array('Sl No.','Package Name','Package No','Channel Count','Sms Opening','Sms Act', 'Sms Deact','Sms Closing','Sms Avg');
			$w = array(10,20,60,80,100,120,140,160,180);
		    $c = array(10,40,20,20,20,20,20,20,20);	

		}
	    $this->pdf->SetY(35);
	    $count = 1;
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }

		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	   
				foreach ($subscriptionArray as $prod_key => $value) {
					$closing = $value["sms_opening"] + $value["sms_activated"] - $value["sms_deactivated"];
					$average = $value["sms_opening"] + ($value["sms_activated"]/2) - ($value["sms_deactivated"]/2);
			    	$this->pdf->SetX(10);
			    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$this->model_bulk_broadcasterreport->getPackageName($prod_key),1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$value["pno"],1,0,'L',0);
			    	if($this->request->get['mode']==0){
				    	$this->pdf->Cell($c[3],6,$value["sms_opening"],1,0,'L',0);
				    	$this->pdf->Cell($c[4],6,$value["sms_activated"],1,0,'L',0);
				    	$this->pdf->Cell($c[5],6,$value["sms_deactivated"],1,0,'L',0);
				    	$this->pdf->Cell($c[6],6,$closing,1,0,'L',0);
				    	$this->pdf->Cell($c[7],6,$average,1,0,'L',0);
				    }else{
				    	$this->pdf->Cell($c[3],6,$this->model_bulk_broadcasterreport->getChannelListDetails($prod_key),1,0,'L',0);
				    	$this->pdf->Cell($c[4],6,$value["sms_opening"],1,0,'L',0);
				    	$this->pdf->Cell($c[5],6,$value["sms_activated"],1,0,'L',0);
				    	$this->pdf->Cell($c[6],6,$value["sms_deactivated"],1,0,'L',0);
				    	$this->pdf->Cell($c[7],6,$closing,1,0,'L',0);
				    	$this->pdf->Cell($c[8],6,$average,1,0,'L',0);
				    }
			    	$this->pdf->Ln();
			    	$count++;
				}


		   
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);ob_clean();
	    
		
    }  	
  
public function getList() {	
		$this->load->model('bulk/broadcasterreport');
			
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}

		if (isset($this->request->get['mode'])) {
			$mode = $this->request->get['mode'];
			$this->data['mode']	= $this->request->get['mode'];
		} else {
			$mode = '';
			$this->data['mode']	= '';
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$filter_broadcaster = $this->request->get['filter_broadcaster'];
			$this->data['filter_broadcaster']	= $this->request->get['filter_broadcaster'];
		} else {
			$filter_broadcaster = '';
			$this->data['filter_broadcaster']	= '';
		}

		if(isset($this->request->get['mode']))
			$this->data['mode']	= $this->request->get['mode'];
		else
			$this->data['mode']='';

		if(isset($this->request->get['filter_broadcaster']))
			$this->data['filter_broadcaster']	= $this->request->get['filter_broadcaster'];
		else
			$this->data['filter_broadcaster']='';
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['mode'])) {
			$url .= '&mode=' . $this->request->get['mode'];
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$url .= '&filter_broadcaster=' . $this->request->get['filter_broadcaster'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/broadcasterreport/RegionWisePrint', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['modes'] = array('0'=>'Channel Wise', '1'=>'Package Wise');
   		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/broadcasterreport', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

   		$broadcasterList = $this->model_bulk_broadcasterreport->getBroadcasterList();
		foreach ($broadcasterList as  $broadcaster) {
			$this->data['broadcasters'][] = array(
					'broadcaster_id' => $broadcaster['broadcaster_id'],
					'name'=> $broadcaster['name']
				);
		}
	
		$data = array(
			'filter_month'           => $filter_month,
			'mode' 					 => $mode,
			'filter_broadcaster' 	 => $filter_broadcaster,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$this->data['product_subs_list'] = array();
		$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$openingCount = $this->model_bulk_broadcasterreport->getProductDetailsOpening($data);
			$ActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsActivate($data);
			$DeActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsDeActivate($data);
			foreach ($openingCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_opening'] = $value['sms_opening'];
				$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];

				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
			}
			foreach ($ActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_activated'] = $value['sms_activated'];
				
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['pno']))
					$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];
				// if(!isset($final_count_array[$value['region_id']]['region_id']))
				// 	$final_count_array[$value['region_id']]['product_id'] = $value['product_id'];
			}
			foreach ($DeActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated'] = $value['sms_deactivated'];
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
			}
			// echo "<pre>"; echo count($final_count_array); print_r($final_count_array);die;
		}

		$total =0 ;
		if (isset($this->request->get['filter_month'])) {
			foreach ($final_count_array as $key => $value) {
				$total += count($value);
			}
			foreach ($final_count_array as $key => $result) {
				foreach ($result as $prod_key => $value) {
					$this->data['product_subs_list'][] = array(
						'product_number' => $value['pno'],
						'region_id' 	 => $this->model_bulk_broadcasterreport->getRegionName($key),
						'product_name'	 => $this->model_bulk_broadcasterreport->getPackageName($prod_key),
						'product_count'  => $this->model_bulk_broadcasterreport->getChannelListDetails($prod_key),
						'sms_opening' 	 => $value['sms_opening'],
						'sms_activated'  => $value['sms_activated'],
						'sms_deactivated'=> $value['sms_deactivated']
					);	
				}
			}
		}			
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_region'] = $this->language->get('column_region');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_count'] = $this->language->get('column_count');
		$this->data['column_sms_opening'] = $this->language->get('column_sms_opening');
		$this->data['column_activated'] = $this->language->get('column_activated');
		$this->data['column_deactivated'] = $this->language->get('column_deactivated');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/broadcasterreport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/broadcasterreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/broadcasterreport');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
