<?php 
class ControllerBulkBroadcasterReport extends Controller {
	private $error = array();
	public function index() {
		$this->language->load('bulk/broadcasterreport');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bulk/broadcasterreport');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/

//  NOT IN USE
/*public function RegionWisePrint(){

	if(isset($this->request->get['filter_broadcaster']) || isset($this->request->get['filter_region'])){
	 $data = array(
	 		'filter_broadcaster'	 => $this->request->get['filter_broadcaster'],
	 		'filter_region'	 		 => $this->request->get['filter_region'],
			'filter_month'           => $this->request->post['filter_month'],
			'mode' 					 => $this->request->post['mode'],
		);
	}else{
		$data = array(
			'filter_month'           => $this->request->post['filter_month'],
			'mode' 					 => $this->request->post['mode'],
		);
	}
	$this->load->model('bulk/broadcasterreport');
	$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$openingCount = $this->model_bulk_broadcasterreport->getProductDetailsOpening($data);
			$ActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsActivate($data);
			$DeActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsDeActivate($data);
			foreach ($openingCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_opening'] = $value['sms_opening'];
				$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];

				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
			}
			foreach ($ActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_activated'] = $value['sms_activated'];
				
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['pno']))
					$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];
				// if(!isset($final_count_array[$value['region_id']]['region_id']))
				// 	$final_count_array[$value['region_id']]['product_id'] = $value['product_id'];
			}
			foreach ($DeActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated'] = $value['sms_deactivated'];
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
			}
			// echo "<pre>"; echo count($final_count_array); print_r($final_count_array);die;
		}

		if (isset($this->request->get['filter_month'])) {
			foreach ($final_count_array as $key => $result) {
				$this->printPdf($key,$result);
			}
			$this->pdf->Output();
		}
}*/
public function printPdf(){   
	    $this->pdf->AddPage();
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(25);
		$this->pdf->SetX(10);
		$this->pdf->Ln();

	if(isset($this->request->get['filter_broadcaster']) || isset($this->request->get['filter_region'])){
	 $data = array(
	 		'filter_broadcaster'	 => $this->request->get['filter_broadcaster'],
	 		'filter_region'	 		 => $this->request->get['filter_region'],
			'filter_month'           => $this->request->post['filter_month'],
			'mode' 					 => $this->request->post['mode'],
		);
	}else{
		$data = array(
			'filter_month'           => $this->request->post['filter_month'],
			'mode' 					 => $this->request->post['mode'],
		);
	} 
	$this->load->model('bulk/broadcasterreport');
	$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$openingCount = $this->model_bulk_broadcasterreport->getProductDetailsOpening($data);
			$ActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsActivate($data);
			$DeActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsDeActivate($data);
			foreach ($openingCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_opening'] = $value['sms_opening'];
				$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];

				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
			}
			foreach ($ActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_activated'] = $value['sms_activated'];
				
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['pno']))
					$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];
				// if(!isset($final_count_array[$value['region_id']]['region_id']))
				// 	$final_count_array[$value['region_id']]['product_id'] = $value['product_id'];
			}
			foreach ($DeActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated'] = $value['sms_deactivated'];
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
			}
			// echo "<pre>"; echo count($final_count_array); print_r($final_count_array);die;
		}
		
		if(isset($this->request->get['filter_broadcaster'])){
			$b_name = $this->model_bulk_broadcasterreport->getBroadcasterName($this->request->get['filter_broadcaster']);
		}
		if($this->request->get['mode']==0){
			$this->pdf->Cell(180,6,'-: Broadcaster Report (Broadcaster Name : '.$b_name.')(Channel Wise):-   Month :  '.$this->request->get['filter_month'],1,0,'C',1);
			
	    	$header =  array('Sl No.','Region Name','Channel Name','Channel Count','sms opening','sms act', 'sms deact','sms clos.','sms avg');
			$w = array(10,20,50,90,110,130,145,160,175);
	    	$c = array(10,30,40,20,20,15,15,15,15);

		}elseif($this->request->get['mode']==1){
			$this->pdf->Cell(190,6,'-: Broadcaster Report (Broadcaster Name : '.$b_name.')(Package Wise):-   Month :  '.$this->request->get['filter_month'],1,0,'C',1);
		    $header =  array('Sl No.','Region Name','Package Name','Channel Count','Sms Opening','Sms Act', 'Sms Deact','Sms Clos.','Sms Avg');
			$w = array(10,20,50,100,120,140,155,170,185);
		    $c = array(10,30,50,20,20,15,15,15,15);

		} 
	    $this->pdf->SetY(40);
	    $count = 1;
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }

		$this->pdf->Ln();
	    $this->pdf->SetFont('times','',8);
	    	if($this->request->get['mode']==1){	
	    		$BroadcasterChannelCount = $this->model_bulk_broadcasterreport->getChannelCount($this->request->get['filter_broadcaster']);
	   			$BCC= array();
				foreach ($BroadcasterChannelCount as $key => $value) {
					$BCC[$value['product_id']]=$value['total'];
				}
			}

				foreach ($final_count_array as $key => $result) {
					foreach ($result as $prod_key => $value) {

						if($this->request->get['mode']==1){
							if(isset($BCC[$prod_key])){
								if($BCC[$prod_key]==0){
									continue;
								}
							}else{
								continue;
							}
						}
					$closing = $value["sms_opening"] + $value["sms_activated"] - $value["sms_deactivated"];
					$average = $value["sms_opening"] + ($value["sms_activated"]/2) - ($value["sms_deactivated"]/2);
			    	$this->pdf->SetX(10);
			    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$this->model_bulk_broadcasterreport->getRegionName($key),1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$this->model_bulk_broadcasterreport->getPackageName($prod_key),1,0,'L',0);
			    	// $this->pdf->Cell($c[2],6,$value["pno"],1,0,'L',0);
			    	if($this->request->get['mode']==0){
			    		$this->pdf->Cell($c[3],6,isset($BCC[$prod_key])?$BCC[$prod_key]:0,1,0,'L',0);
				    	$this->pdf->Cell($c[4],6,$value["sms_opening"],1,0,'L',0);
				    	$this->pdf->Cell($c[5],6,$value["sms_activated"],1,0,'L',0);
				    	$this->pdf->Cell($c[6],6,$value["sms_deactivated"],1,0,'L',0);
				    	$this->pdf->Cell($c[7],6,$closing,1,0,'L',0);
				    	$this->pdf->Cell($c[8],6,floor($average),1,0,'L',0);
				    }else{
				    	// $this->pdf->Cell($c[3],6,$this->model_bulk_broadcasterreport->getChannelListDetails($prod_key),1,0,'L',0);
				    	$this->pdf->Cell($c[3],6,isset($BCC[$prod_key])?$BCC[$prod_key]:0,1,0,'L',0);
				    	$this->pdf->Cell($c[4],6,$value["sms_opening"],1,0,'L',0);
				    	$this->pdf->Cell($c[5],6,$value["sms_activated"],1,0,'L',0);
				    	$this->pdf->Cell($c[6],6,$value["sms_deactivated"],1,0,'L',0);
				    	$this->pdf->Cell($c[7],6,$closing,1,0,'L',0);
				    	$this->pdf->Cell($c[8],6,floor($average),1,0,'L',0);
				    }
			    	$this->pdf->Ln();
			    	$count++;
				}
			}
		   
	    // $this->pdf->Ln(8);   
	    // $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	   // $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    // $this->pdf->Ln(8);
	    // $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	   // $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);ob_clean();
	    $this->pdf->Output();
    }  	
  
public function getList() {	 #var_dump($this->request->get['filter_region']);
		$this->load->model('bulk/broadcasterreport');
			
		if (isset($this->request->get['filter_month'])) {
			$filter_month = $this->request->get['filter_month'];
			$this->data['filter_month']	= $this->request->get['filter_month'];
		} else {
			$filter_month = '';
			$this->data['filter_month']	='';
		}

		if (isset($this->request->get['filter_broadcaster'])) {
			$filter_broadcaster = $this->request->get['filter_broadcaster'];
			$this->data['filter_broadcaster']	= $this->request->get['filter_broadcaster'];
		} else {
			$filter_broadcaster = '';
			$this->data['filter_broadcaster']	='';
		}

		if (isset($this->request->get['filter_region'])) {
			$filter_region = $this->request->get['filter_region'];
			$this->data['filter_region']	= $this->request->get['filter_region'];
		} else {
			$filter_region = '';
			$this->data['filter_region']	='';
		}

		if (isset($this->request->get['mode'])) {
			$mode = $this->request->get['mode'];
			$this->data['mode']	= $this->request->get['mode'];
		} else {
			$mode = '';
			$this->data['mode']	= '';
		}

		if(isset($this->request->get['mode']))
			$this->data['mode']	= $this->request->get['mode'];
		else
			$this->data['mode']='';
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

		if (isset($this->request->get['filter_month'])) {
			$url .= '&filter_month=' . $this->request->get['filter_month'];
		}		

		if (isset($this->request->get['filter_broadcaster'])) {
			$url .= '&filter_broadcaster=' . $this->request->get['filter_broadcaster'];
		}

		if (isset($this->request->get['filter_region'])) {
			$url .= '&filter_region=' . $this->request->get['filter_region'];
		}

		if (isset($this->request->get['mode'])) {
			$url .= '&mode=' . $this->request->get['mode'];
		}

		$this->data['printPdf'] = $this->url->link('bulk/broadcasterreport/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['modes'] = array('1'=>'Package Wise');

   		$this->data['broadcasters'] = $this->model_bulk_broadcasterreport->getBroadcasters();
   		$this->data['regions'] 		= $this->model_bulk_broadcasterreport->getRegions();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/broadcasterreport', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);
	
		$data = array(
			'filter_month'           => $filter_month,
			'filter_broadcaster'     => $filter_broadcaster,
			'filter_region'		     => $filter_region,
			'mode' 					 => $mode,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$this->data['product_subs_list'] = array();
		$final_count_array = array();
		if (isset($this->request->get['filter_month'])) {
			$openingCount = $this->model_bulk_broadcasterreport->getProductDetailsOpening($data);
			$ActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsActivate($data);
			$DeActivateCount = $this->model_bulk_broadcasterreport->getProductDetailsDeActivate($data);
			foreach ($openingCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_opening'] = $value['sms_opening'];
				$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];

				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
			}

			foreach ($ActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_activated'] = $value['sms_activated'];
				
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['pno']))
					$final_count_array[$value['region_id']][$value['product_id']]['pno'] = $value['pno'];
				// if(!isset($final_count_array[$value['region_id']]['region_id']))
				// 	$final_count_array[$value['region_id']]['product_id'] = $value['product_id'];
			}
			foreach ($DeActivateCount as $key => $value) {
				$final_count_array[$value['region_id']][$value['product_id']]['sms_deactivated'] = $value['sms_deactivated'];
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_opening']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_opening']=0;
				if(!isset($final_count_array[$value['region_id']][$value['product_id']]['sms_activated']))
					$final_count_array[$value['region_id']][$value['product_id']]['sms_activated']=0;
			}
			// echo "<pre>"; echo count($DeActivateCount); print_r($DeActivateCount);die;
		}

		$total =0 ;
		if (isset($this->request->get['filter_month'])) {
			if($this->request->get['mode']==1){
				$BroadcasterChannelCount = $this->model_bulk_broadcasterreport->getChannelCount($this->request->get['filter_broadcaster']);
				$BCC= array();
				foreach ($BroadcasterChannelCount as $key => $value) {
					$BCC[$value['product_id']]=$value['total'];
				}			
			}
			foreach ($final_count_array as $key => $value) {
				$total += count($value);
			}
			foreach ($final_count_array as $key => $result) {
				foreach ($result as $prod_key => $value) {
					/*if(!isset($value['pno'])){
						var_dump($prod_key);
						var_dump($value);die;
					}*/
					$closing = $value["sms_opening"] + $value["sms_activated"] - $value["sms_deactivated"];
					$average = $value["sms_opening"] + ($value["sms_activated"]/2) - ($value["sms_deactivated"]/2);
					$this->data['product_subs_list'][] = array(
						// 'product_number' => $value['pno'],
						'region_id' 	 => $this->model_bulk_broadcasterreport->getRegionName($key),
						'product_name'	 => $this->model_bulk_broadcasterreport->getPackageName($prod_key),
						'total_product_count'  => $this->model_bulk_broadcasterreport->getChannelListDetails($prod_key),
						'product_count'  => isset($BCC[$prod_key])?$BCC[$prod_key]:0,
						'sms_opening' 	 => $value['sms_opening'],
						'sms_activated'  => $value['sms_activated'],
						'sms_deactivated'=> $value['sms_deactivated'],
						'closing'  		 => $closing,
						'average'		 => $average
					);	
				}
			}
		}	

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_no'] = $this->language->get('column_no');
		$this->data['column_region'] = $this->language->get('column_region');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_count'] = $this->language->get('column_count');
		$this->data['column_sms_opening'] = $this->language->get('column_sms_opening');
		$this->data['column_activated'] = $this->language->get('column_activated');
		$this->data['column_deactivated'] = $this->language->get('column_deactivated');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_filter'] = $this->language->get('button_filter');
	
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/broadcasterreport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}		
		$this->template = 'bulk/broadcasterreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	filter
DESCRIPTION 		-	Based on the filter option it retrieves the list
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the sale order list.
*/
	public function filter(){
		$this->language->load('bulk/broadcasterreport');

		$this->document->setTitle($this->language->get('heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'GET')){
		 }
		$this->getList();
	}

 }
